/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.NSProperty;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class TestSeq {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: TestSeq <dirurl> <filetoput>");
            System.exit(-1);
        }
        String dirurl = args[0];
        String filetoput = args[1];
        DialogAuthListener dal = new DialogAuthListener();
        File localfile = new File(filetoput);
        DSI dsi = new DSI(dirurl, dal);
        try {
            System.out.println("");
            System.out.println("Checkig if its a  collection");
            System.out.println("-----------------------");
            boolean iscoll = dsi.isCollection();
            System.out.println("Is collectioni? " + iscoll);
            if (iscoll) {
                String propVal;
                System.out.println("");
                System.out.println("Making collection newcol");
                System.out.println("-----------------------");
                String coll = dsi.makeCollection("newcol", true);
                System.out.println("Made collection " + coll);
                dsi.setURL(coll);
                System.out.println("");
                System.out.println("Putting data set from string");
                System.out.println("-----------------------");
                dsi.setURL(coll + "filefromstring");
                dsi.putDataSet("xxx");
                System.out.println("Did put data set");
                System.out.println("");
                System.out.println("Putting data set from file");
                System.out.println("-----------------------");
                dsi.setURL(coll + "filefromfile");
                dsi.putDataSet(localfile);
                System.out.println("Did put data set");
                System.out.println("");
                System.out.println("Adding one property");
                System.out.println("-----------------------");
                NSProperty oneProp = new NSProperty("myns", "mykey");
                dsi.putMetaData(oneProp, "some value");
                System.out.println("");
                System.out.println("Getting that property");
                System.out.println("-----------------------");
                DSIProperty dsiprop = dsi.getMetaData(oneProp);
                String onePropValue = "";
                if (dsiprop != null) {
                    onePropValue = dsiprop.getPropertyAsString();
                }
                System.out.println("Got value for one prop: " + onePropValue);
                System.out.println("");
                System.out.println("Adding a vector of properties");
                System.out.println("-----------------------");
                Hashtable<NSProperty, String> proprequest = new Hashtable<NSProperty, String>();
                proprequest.put(new NSProperty("ans", "mykey1"), "value1");
                proprequest.put(new NSProperty("bns", "mykey2"), "value2");
                proprequest.put(new NSProperty("bns", "mykey3"), "value3");
                dsi.putMetaData(proprequest);
                System.out.println("");
                System.out.println("Getting selective properties");
                System.out.println("-----------------------");
                Vector<NSProperty> getrequest = new Vector<NSProperty>();
                getrequest.add(new NSProperty("ans", "mykey1"));
                getrequest.add(new NSProperty("bns", "mykey3"));
                getrequest.add(new NSProperty("DAV:", "getlastmodified"));
                getrequest.add(new NSProperty("DAV:", "getcontentlength"));
                getrequest.add(new NSProperty("DAV:", "resourcetype"));
                getrequest.add(new NSProperty("nono:", "notfound"));
                Hashtable getresults = dsi.getMetaData(getrequest);
                Iterator it = getresults.keySet().iterator();
                while (it.hasNext()) {
                    DSIProperty prop = (DSIProperty)getresults.get(it.next());
                    propVal = prop.getPropertyAsString();
                    if (propVal.length() == 0) {
                        propVal = prop.getPropertyAsXMLString(true);
                    }
                    System.out.println(prop.getPropertyKey() + "=" + propVal);
                }
                System.out.println("");
                System.out.println("Removing property (ans,mykey1)");
                System.out.println("-----------------------");
                Vector<NSProperty> rmprops = new Vector<NSProperty>();
                NSProperty rmprop = new NSProperty("ans", "mykey1");
                rmprops.add(rmprop);
                rmprop = new NSProperty("bns", "mykey3");
                rmprops.add(rmprop);
                dsi.removeMetaData(rmprops);
                TestSeq.dumpAllMetaData(dsi);
                System.out.println("");
                System.out.println("Getting selective properties with search getMetaData");
                System.out.println("-----------------------");
                Vector<NSProperty> required = new Vector<NSProperty>();
                required.add(new NSProperty("ans", "mykey1"));
                required.add(new NSProperty("bns", "mykey3"));
                required.add(new NSProperty("DAV:", "resourcetype"));
                required.add(new NSProperty("DAV:", "getlastmodified"));
                required.add(new NSProperty("DAV:", "blarg"));
                Hashtable sresults = dsi.getMetaData(required, 1);
                Enumeration urls = sresults.keys();
                while (urls.hasMoreElements()) {
                    String url = (String)urls.nextElement();
                    System.out.println(url);
                    Hashtable props = (Hashtable)sresults.get(url);
                    for (Object tmp : props.keySet()) {
                        DSIProperty prop = (DSIProperty)props.get(tmp);
                        propVal = prop.getPropertyAsString();
                        if (propVal.length() == 0) {
                            propVal = prop.getPropertyAsXMLString(true);
                        }
                        System.out.println(prop.getPropertyKey() + "=" + propVal);
                    }
                }
                TestSeq.dumpAllMetaData(dsi);
                System.out.println("");
                System.out.println("Get the file as string" + dsi.getPath());
                System.out.println("-----------------------");
                String filecontent = dsi.getDataSetAsString();
                System.out.println("***the file:" + filecontent);
                System.out.println("");
                System.out.println("Get the file as file" + dsi.getPath());
                System.out.println("-----------------------");
                File getfile = dsi.getDataSet();
                System.out.println("*** got as file " + getfile);
                System.out.println("");
                System.out.println("Copy the file");
                System.out.println("-----------------------");
                String copiedurl = dsi.copy("copiedfile");
                System.out.println("copied to=>" + copiedurl);
                System.out.println("");
                System.out.println("Copy the file with .. notation");
                System.out.println("-----------------------");
                copiedurl = dsi.copy("../copiedfilerelative");
                System.out.println("copied to=>" + copiedurl);
                System.out.println("");
                System.out.println("Move the file with .. notation");
                System.out.println("-----------------------");
                String movedurl = dsi.move("../movedfilerelative");
                System.out.println("moved to=>" + movedurl);
                String up = dsi.moveTo("../");
                System.out.println("up is=>" + up);
                String moveto = dsi.moveTo("/Ecce/share/../users/");
                System.out.println("moveto /Ecce/share/../users/ is=>" + moveto);
                moveto = dsi.moveTo("../users/");
                System.out.println("moveto ../users/ is=>" + moveto);
            }
        }
        catch (StatusException ex) {
            System.out.println("ohoh we got an exception:" + ex.getMessage());
        }
        catch (Exception other) {
            System.out.println("ohoh we got some other exception:" + other.getMessage());
        }
        System.exit(0);
    }

    static void dumpAllMetaData(DSI dsi) throws StatusException {
        System.out.println("");
        System.out.println("Getting all properties");
        System.out.println("-----------------------");
        Hashtable allresults = dsi.getMetaData();
        Iterator allit = allresults.keySet().iterator();
        while (allit.hasNext()) {
            DSIProperty prop = (DSIProperty)allresults.get(allit.next());
            String propVal = prop.getPropertyAsString();
            if (propVal.length() == 0) {
                propVal = prop.getPropertyAsXMLString(true);
            }
            System.out.println(prop.getPropertyKey() + "=" + propVal);
        }
    }
}

