% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMatrixMult.r
\name{genMatrixMult}
\alias{genMatrixMult}
\title{Generalized matrix multiplication}
\usage{
genMatrixMult(A, B, FUNelement = "*", FUNsummary = sum)
}
\arguments{
\item{A}{The first matrix.}

\item{B}{The second matrix.}

\item{FUNelement}{Element-wise operator.}

\item{FUNsummary}{Summary function.}
}
\value{
A character vector or matrix.
}
\description{
Computes a generalized matrix multiplication, where sum and product functions (elemet-wise and summary functions) can be replaced by arbitrary functions.
}
\examples{
# Operations can be anything
x <- matrix(letters[1:8], ncol = 2)
y <- matrix(1:10, nrow = 2)

genMatrixMult(x, y, FUNelement = paste,
FUNsummary = function(x) paste(x, collapse = "|"))

# Binary logic
set.seed(1)
x <- matrix(rbinom(8, size = 1, prob = 0.5) == 1, ncol = 2)
y <- matrix(rbinom(10, size = 1, prob = 0.5) == 1, nrow = 2)
genMatrixMult(x, y, FUNelement = "*", FUNsummary = any)

}
\seealso{
\code{\link{matmult}}
}
\author{
\enc{Aleš Žiberna}{Ales Ziberna}
}
\keyword{algebra}
\keyword{array}
