% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova.R
\name{tidy.TukeyHSD}
\alias{tidy.TukeyHSD}
\title{Tidy a(n) TukeyHSD object}
\usage{
\method{tidy}{TukeyHSD}(x, ...)
}
\arguments{
\item{x}{A \code{TukeyHSD} object return from \code{\link[stats:TukeyHSD]{stats::TukeyHSD()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

fm1 <- aov(breaks ~ wool + tension, data = warpbreaks)
thsd <- TukeyHSD(fm1, "tension", ordered = TRUE)
tidy(thsd)

# may include comparisons on multiple terms
fm2 <- aov(mpg ~ as.factor(gear) * as.factor(cyl), data = mtcars)
tidy(TukeyHSD(fm2))
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:TukeyHSD]{stats::TukeyHSD()}}

Other anova tidiers: 
\code{\link{glance.anova}()},
\code{\link{glance.aov}()},
\code{\link{tidy.anova}()},
\code{\link{tidy.aov}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{adj.p.value}{P-value adjusted for multiple comparisons.}
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{contrast}{Levels being compared.}
  \item{estimate}{The estimated value of the regression term.}
  \item{null.value}{Value to which the estimate is compared.}
  \item{term}{The name of the regression term.}

}
