---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              notation des vecteurs, notation vectorielle, vecteur, flèches
---

# Comment obtenir la notation vectorielle ?

## La notation avec les flèches

### Avec les commandes de base

La flèche marquant le vecteur est une des formes d'accentuation mathématique 
(mentionnées à la question 
"[](/4_domaines_specialises/mathematiques/structures/les_accents_en_mode_mathematique)")
connue de LaTeX. Elle s'obtient, comme le montre l'exemple suivant :
- avec la commande `\vec` lorsqu'elle concerne un unique caractère ;
- avec la commande `\overrightarrow` lorsqu'elle concerne plusieurs caractères.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Le vecteur $\vec{u}$ sera nommé $\overrightarrow{AB}$.
\end{document}
```


### Avec l'extension <ctanpkg:mathtools> 

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) permet de définir 
ses propres flèches notamment pour régler leur hauteur par rapport aux lettres
qu'elles surmontent. En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage[matrix,arrow]{xy}

  \newcommand{\xyflecheverladroite}%
             {\mbox{\xymatrix{%
              *{\hphantom{OM}}\ar[]+L;[]+R%
             }}}

  \newcommand{\ra}[1]{%
    \mathchoice%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\displaystyle #1}}
       \ar[]+L;[]+R}}}{\displaystyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\textstyle #1}}
       \ar[]+L;[]+R}}}{\textstyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\scriptstyle #1}}
       \ar[]+L;[]+R}}}{\scriptstyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\scriptscriptstyle #1}}
       \ar[]+L;[]+R}}}{\scriptscriptstyle #1}%
    }}

  % Pour changer la distance de la flèche,
  % on peut procéder ainsi :
  % \renewcommand{\ra}[1]
  % {\overset{\raisebox{-1pt}{\mbox{\xymatrix{*{%
  % \hphantom{#1}} \ar[]+L;[]+R}}}}{#1}}

\begin{document}
\[ 
  \ra{OM}  \neq \ra{OM_i}  \neq \ra{OM}_{\ra{OM}_{\ra{OM}}}
\]
\end{document}
```


## La notation avec les composantes du vecteur

### Avec l'extension <ctanpkg:mathtools> 

:::{todo} Compléter avec le même exemple que ci-dessous
:::

### Avec l'extension <ctanpkg:vector>

L'extension <ctanpkg:vector>, de Nick Efford, date de 1994. Elle met 
à disposition quelques commandes permettant d'obtenir des mises en forme
de vecteur souvent utilisées en physique et des commandes automatiques 
d'énumération des coordonnées. 

Par exemple :

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{vector}

\begin{document}
$(\irvec[4]x)$

$\bvec{y} = \left[ \cvec{y}{0}{3} \right]$
\end{document}
```

Notez que cette extension doit être installée manuellement (raison 
pour laquelle son résultat n'est pas affiché ici). Il faut récupérer les
fichiers `vector.ins` et `vector.dtx`, puis exécuter la commande suivante 
dans le dossier où vous avez placé ces fichiers.

```bash
latex vector.ins
```

Le fichier `vector.sty` ainsi obtenu doit être placé dans le même dossier
que votre fichier `.tex`. Ce dernier pourra alors être compilé normalement.
Notez d'ailleurs que le code de l'extension est assez court (44 lignes de 
code) et pourrait être assez simplement reporté dans le code 
de votre propre document.

Ce type d'installation et de fichier est évoqué à la question 
"[](/1_generalites/documentation/documents/documents_extensions/fichiers_sources_dtx)".


## Avec l'extension <ctanpkg:easyvector>

L'extension <ctanpkg:easyvector> permet de définir des vecteurs 
suivant une syntaxe de type langage C.

:::{todo} Ajouter un exemple
:::
