#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Edna & Harvey: Harvey's New Eyes
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240823.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='edna-and-harvey-harveys-new-eyes'
GAME_NAME='Edna & Harvey: Harvey’s New Eyes'

ARCHIVE_BASE_0_NAME='gog_edna_harvey_harvey_s_new_eyes_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='fa6f7fd271fe63bbe71e3190e0596546'
ARCHIVE_BASE_0_SIZE='990000'
ARCHIVE_BASE_0_VERSION='3.0.0442-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/edna_harvey_harveys_new_eyes'

VISIONAIRE_NAME='harvey'

CONTENT_PATH_DEFAULT='data/noarch/game'

APP_MAIN_ICON='../support/icon.png'

PKG_BIN_ARCH='64'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
