// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: wincodec_private_generated.h
//---------------------------------------------------------------------------

#pragma once

BEGIN_MILFLAGENUM( MilBitmapLock )
    Read = WICBitmapLockRead,
    Write = WICBitmapLockWrite,
END_MILFLAGENUM

BEGIN_MILENUM( MilBitmapInterpolationMode )
    //
    // Nearest Neighbor filtering. Also known as nearest pixel or nearest point 
    // sampling.
    //
    NearestNeighbor = WICBitmapInterpolationModeNearestNeighbor,

    //
    // Linear filtering.
    //
    Linear = WICBitmapInterpolationModeLinear,

    //
    // Cubic filtering. May include linear pre-filtering or decimation.
    //
    Cubic = WICBitmapInterpolationModeCubic,

    Fant = WICBitmapInterpolationModeFant,

    //
    // Trilinear filtering.  Not available in WICBitmapInterpolation modes.
    //
    TriLinear,

    //
    // Anisotropic filtering.  Not available in WICBitmapInterpolation modes.
    // Anisotropic Filtering implies trilinear filtering with higher quality
    // sampling.
    //
    Anisotropic,

    Last,
END_MILENUM

BEGIN_MILENUM( MilBitmapAlphaChannelOption )
    UseAlpha = WICBitmapUseAlpha,
    UsePremultipliedAlpha = WICBitmapUsePremultipliedAlpha,
    IgnoreAlpha = WICBitmapIgnoreAlpha,
END_MILENUM

BEGIN_MILENUM( MilBitmapDitherType )
    None = WICBitmapDitherTypeNone,

    //
    // Solid color - picks the nearest matching color with no attempt to
    // halftone or dither. May be used on an arbitrary palette.
    //
    Solid = WICBitmapDitherTypeSolid,


    //
    // Ordered dithers and spiral dithers must be used with a fixed palette or
    // a fixed palette translation.
    // NOTE: DitherOrdered4x4 is unique in that it may apply to 16bpp
    // conversions also.
    //

    Ordered4x4 = WICBitmapDitherTypeOrdered4x4,
    Ordered8x8 = WICBitmapDitherTypeOrdered8x8,
    Ordered16x16 = WICBitmapDitherTypeOrdered16x16,
    Spiral4x4 = WICBitmapDitherTypeSpiral4x4,
    Spiral8x8 = WICBitmapDitherTypeSpiral8x8,
    DualSpiral4x4 = WICBitmapDitherTypeDualSpiral4x4,
    DualSpiral8x8 = WICBitmapDitherTypeDualSpiral8x8,


    //
    // Error diffusion. May be used with any palette.
    //
    ErrorDiffusion = WICBitmapDitherTypeErrorDiffusion,
END_MILENUM

BEGIN_MILENUM( MilBitmapPaletteType )
    //
    // Arbitrary custom palette provided by caller.
    //
    Custom = WICBitmapPaletteTypeCustom,

    //
    // Optimal palette generated using a median-cut algorithm.
    //
    MedianCut = WICBitmapPaletteTypeMedianCut,

    //
    // Black and white palette.
    //
    FixedBW = WICBitmapPaletteTypeFixedBW,


    //
    // Symmetric halftone palettes.
    // Each of these halftone palettes will be a superset of the system palette.
    // E.g. Halftone8 will have it's 8-color on-off primaries and the 16 system
    // colors added. With duplicates removed, that leaves 16 colors.
    //


    //
    // 8-color, on-off primaries
    //
    FixedHalftone8 = WICBitmapPaletteTypeFixedHalftone8,

    //
    // 3 intensity levels of each color
    //
    FixedHalftone27 = WICBitmapPaletteTypeFixedHalftone27,

    //
    // 4 intensity levels of each color
    //
    FixedHalftone64 = WICBitmapPaletteTypeFixedHalftone64,

    //
    // 5 intensity levels of each color
    //
    FixedHalftone125 = WICBitmapPaletteTypeFixedHalftone125,

    //
    // 6 intensity levels of each color
    //
    FixedHalftone216 = WICBitmapPaletteTypeFixedHalftone216,

    //
    // convenient web palette, same as FixedHalftone216
    //
    FixedWebPalette = WICBitmapPaletteTypeFixedWebPalette,


    //
    // Assymetric halftone palettes.
    // These are somewhat less useful than the symmetric ones, but are
    // included for completeness. These do not include all of the system
    // colors.
    //


    //
    // 6-red, 7-green, 6-blue intensities
    //
    FixedHalftone252 = WICBitmapPaletteTypeFixedHalftone252,

    //
    // 8-red, 8-green, 4-blue intensities
    //
    FixedHalftone256 = WICBitmapPaletteTypeFixedHalftone256,


    //
    // 4 shades of gray
    //
    FixedGray4 = WICBitmapPaletteTypeFixedGray4,

    //
    // 16 shades of gray
    //
    FixedGray16 = WICBitmapPaletteTypeFixedGray16,

    //
    // 256 shades of gray
    //
    FixedGray256 = WICBitmapPaletteTypeFixedGray256,
END_MILENUM

BEGIN_MILENUM( MilPixelFormat )
    //
    // Undefined or unspecified pixel format
    //

    DontCare = 0x00,
    Undefined = DontCare,


    //
    // Indexed formats
    //

    Indexed1bpp = 0x01,
    Indexed2bpp = 0x02,
    Indexed4bpp = 0x03,
    Indexed8bpp = 0x04,


    BlackWhite = 0x05,
    Gray2bpp = 0x06,
    Gray4bpp = 0x07,
    Gray8bpp = 0x08,


    //
    // sRGB formats (gamma is approx. 2.2)
    // For a full definition, see the sRGB spec
    //


    //
    // 16bpp format
    //
    BGR16bpp555 = 0x09,

    //
    // 16bpp format
    //
    BGR16bpp565 = 0x0A,

    //
    // 16bpp format
    //
    Gray16bpp = 0x0B,

    //
    // 24bpp format
    //
    BGR24bpp = 0x0C,

    //
    // 24bpp format
    //
    RGB24bpp = 0x0D,

    //
    // 32bpp format
    //
    BGR32bpp = 0x0E,

    //
    // 32bpp format
    //
    BGRA32bpp = 0x0F,

    //
    // 32bpp format
    //
    PBGRA32bpp = 0x10,

    //
    // 32bpp format
    //
    Gray32bppFloat = 0x11,

    //
    // 48bpp format
    //
    RGB48bppFixedPoint = 0x12,


    //
    // scRGB formats. Gamma is 1.0
    // For a full definition, see the scRGB spec
    //


    //
    // 16bpp format
    //
    Gray16bppFixedPoint = 0x13,

    //
    // 32bpp format
    //
    BGR32bpp101010 = 0x14,

    //
    // 48bpp format
    //
    RGB48bpp = 0x15,

    //
    // 64bpp format
    //
    RGBA64bpp = 0x16,

    //
    // 64bpp format
    //
    PRGBA64bpp = 0x17,

    //
    // 96bpp format
    //
    BGR96bppFixedPoint = 0x18,

    //
    // Floating point scRGB format
    //
    RGBA128bppFloat = 0x19,

    //
    // Floating point scRGB format
    //
    PRGBA128bppFloat = 0x1A,

    //
    // Floating point scRGB format
    //
    RGB128bppFloat = 0x1B,


    //
    // EXTENDED FORMATS
    //

    CMYK32bpp = 0x1C,
    RGBA64bppFixedPoint = 0x1D,
    RGBA128bppFixedPoint = 0x1E,
    CMYK64bpp = 0x1F,
    CMYKAlpha40bpp = 0x2C,
    CMYKAlpha80bpp = 0x2D,
END_MILENUM


