---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, syntaxe,  
              citer une URL, adresses web dans la bibliographie,  
              référence à un site web, citer un site web
---

# Comment citer une URL avec BibTeX ?

Par défaut, il n'y a pas de champ permettant d'indiquer les URL dans les styles
BibTeX standards, bien qu'Oren Patashnik (l'auteur de BibTeX) envisage 
d'en développer un la version BibTeX 1.0, qui reste à venir 
depuis de nombreuses années.

L'information réelle qui doit être disponible dans une citation d'une URL 
est normalement guidée par la [norme ISO690](wpfr:ISO_690). 
Les techniques présentées ci-dessous *ne satisfont pas* à toutes les exigences
de cette norme mais elles offrent une réponse aux besoins immédiats 
des utilisateurs.

:::{todo} Ajouter des exemples.
:::


## En utilisant un autre champ

En attendant de nouveaux développements de BibTeX, la technique 
la plus simple est d'utiliser le champ `howpublished` de la fonction `@misc`
des styles standards. De façon similaire, il est possible d'utiliser 
le champ `note`.

```bibtex
@misc{...,
  ... = "...",
  howpublished = "\url{https://...}"
}
```

Il est recommandé d'utiliser l'extension <ctanpkg:url> ou <ctanpkg:hyperref>
dans ce contexte (vous pouvez consulter sur ce point la question 
"[](/3_composition/texte/mots/mettre_en_forme_des_url_et_des_adresses_electroniques)").
En effet, BibTeX a l'habitude de diviser les lignes qu'il considère comme 
trop longues (78 caractères) : s'il n'y a pas de caractère espace à utiliser 
comme point d'arrêt naturel, BibTeX insérera un caractère `%` 
bien que ce dernier soit un caractère acceptable dans une URL. Les extensions
<ctanpkg:url> et <ctanpkg:hyperref> détectent cette structure 
"`%`--fin-de-ligne" dans les URL et la suppriment. Vous pouvez aussi scinder
l'URL directement.

```bibtex
@misc{...,
  ...  = "...",
  note = "\url{ftp://ftp.fdn.org/pub/CTAN/macros/
               latex/contrib/supported/koma-script/
               contrib/adrconv/}"
}
```


## En utilisant certains styles bibliographiques

Une approche alternative consiste à remplacer les styles standard de BibTeX
par des styles disposant du champ URL. En voici quelques uns :

- les styles <ctanpkg:natbib> ([plainnat](ctanpkg:natbib), 
  [unsrtnat](ctanpkg:natbib) et [abbrvnat](ctanpkg:natbib)), variantes 
  des styles standards à utiliser principalement avec <ctanpkg:natbib> 
  lui-même. Ils permettent bien d'obtenir le champ URL ainsi que
  quelques autres champs "modernes". L'extension <ctanpkg:custom-bib>, 
  du même auteur, est également capable de générer des styles 
  répondant à cette question ;
- l'ensemble <ctanpkg:babelbib> qui propose des styles pour des 
  bibliographies multilingues (évoqués en question 
  "[](/3_composition/annexes/bibliographie/style_bst/bibliographies_internationales)"). 
  Il fournit également un ensemble d'équivalents aux styles standard 
  qui disposent du champ URL ;
- des styles plus modernes tels que ceux de l'extension <ctanpkg:harvard>.
  Les styles de bibliographie <ctanpkg:harvard> incluent tous un champ `url`
  dans leur spécification. Toutefois, la composition proposée n'est pas 
  très bien considérée (bien qu'elle reconnaisse et utilise 
  les commandes `LaTeX2HTML` si elles sont disponibles, pour créer 
  des hyperliens).


## En constituant son propre style bibliographique

Il est aussi possible d'ajouter un type d'entrée pour citer des pages Web
(adapté d'une solution de M. Moreau). Ceci peut se faire par exemple 
en recopiant le style de base, en changeant son nom et en ajoutant 
les lignes suivantes. Ces lignes ne doivent pas être placées au début 
du fichier, parce qu'il faut que les fonctions utilisées soient définies
auparavant) :

```text
FUNCTION {format.url}
{ url empty$
    {""}
    {"\texttt{" url "}" * * }
  if$
}

FUNCTION {pageweb}
{ output.bibitem
  format.authors output
  format.title "title" output.check
  new.block
  institution "institution" output.check
  format.date output
  new.block
  format.url "URL output.check
  newblock
  note output
  fin.entry
}
```

De cette façon, une entrée `@pageweb` peut être ajoutée :
- avec les champs obligatoires `title`, `institution` et `url` ; 
- avec les champs facultatifs `author`, `month`, `year` et `note`.


:::{sources}
- [URLs in BibTeX bibliographies](faquk:FAQ-citeURL)
:::