/*
 * desc-rtnl.c - rtnetlink message descriptions
 *
 * Descriptions of rtnetlink messages and attributes for pretty print.
 */

#include <linux/rtnetlink.h>

#include "../internal.h"
#include "prettymsg.h"

static const struct pretty_nla_desc __link_desc[] = {
	NLATTR_DESC_INVALID(IFLA_UNSPEC),
	NLATTR_DESC_BINARY(IFLA_ADDRESS),
	NLATTR_DESC_BINARY(IFLA_BROADCAST),
	NLATTR_DESC_STRING(IFLA_IFNAME),
	NLATTR_DESC_U32(IFLA_MTU),
	NLATTR_DESC_U32(IFLA_LINK),
	NLATTR_DESC_STRING(IFLA_QDISC),
	NLATTR_DESC_BINARY(IFLA_STATS),
	NLATTR_DESC_INVALID(IFLA_COST),
	NLATTR_DESC_INVALID(IFLA_PRIORITY),
	NLATTR_DESC_U32(IFLA_MASTER),
	NLATTR_DESC_BINARY(IFLA_WIRELESS),
	NLATTR_DESC_NESTED_NODESC(IFLA_PROTINFO),
	NLATTR_DESC_U32(IFLA_TXQLEN),
	NLATTR_DESC_BINARY(IFLA_MAP),
	NLATTR_DESC_U32(IFLA_WEIGHT),
	NLATTR_DESC_U8(IFLA_OPERSTATE),
	NLATTR_DESC_U8(IFLA_LINKMODE),
	NLATTR_DESC_NESTED_NODESC(IFLA_LINKINFO),
	NLATTR_DESC_U32(IFLA_NET_NS_PID),
	NLATTR_DESC_STRING(IFLA_IFALIAS),
	NLATTR_DESC_U32(IFLA_NUM_VF),
	NLATTR_DESC_NESTED_NODESC(IFLA_VFINFO_LIST),
	NLATTR_DESC_BINARY(IFLA_STATS64),
	NLATTR_DESC_NESTED_NODESC(IFLA_VF_PORTS),
	NLATTR_DESC_NESTED_NODESC(IFLA_PORT_SELF),
	NLATTR_DESC_NESTED_NODESC(IFLA_AF_SPEC),
	NLATTR_DESC_U32(IFLA_GROUP),
	NLATTR_DESC_U32(IFLA_NET_NS_FD),
	NLATTR_DESC_U32(IFLA_EXT_MASK),
	NLATTR_DESC_U32(IFLA_PROMISCUITY),
	NLATTR_DESC_U32(IFLA_NUM_TX_QUEUES),
	NLATTR_DESC_U32(IFLA_NUM_RX_QUEUES),
	NLATTR_DESC_U8(IFLA_CARRIER),
	NLATTR_DESC_BINARY(IFLA_PHYS_PORT_ID),
	NLATTR_DESC_U32(IFLA_CARRIER_CHANGES),
	NLATTR_DESC_BINARY(IFLA_PHYS_SWITCH_ID),
	NLATTR_DESC_S32(IFLA_LINK_NETNSID),
	NLATTR_DESC_STRING(IFLA_PHYS_PORT_NAME),
	NLATTR_DESC_U8(IFLA_PROTO_DOWN),
	NLATTR_DESC_U32(IFLA_GSO_MAX_SEGS),
	NLATTR_DESC_U32(IFLA_GSO_MAX_SIZE),
	NLATTR_DESC_BINARY(IFLA_PAD),
	NLATTR_DESC_U32(IFLA_XDP),
	NLATTR_DESC_U32(IFLA_EVENT),
	NLATTR_DESC_S32(IFLA_NEW_NETNSID),
	NLATTR_DESC_S32(IFLA_IF_NETNSID),
	NLATTR_DESC_U32(IFLA_CARRIER_UP_COUNT),
	NLATTR_DESC_U32(IFLA_CARRIER_DOWN_COUNT),
	NLATTR_DESC_S32(IFLA_NEW_IFINDEX),
	NLATTR_DESC_U32(IFLA_MIN_MTU),
	NLATTR_DESC_U32(IFLA_MAX_MTU),
	NLATTR_DESC_NESTED_NODESC(IFLA_PROP_LIST),
	NLATTR_DESC_STRING(IFLA_ALT_IFNAME),
	NLATTR_DESC_BINARY(IFLA_PERM_ADDRESS),
};

const struct pretty_nlmsg_desc rtnl_msg_desc[] = {
	NLMSG_DESC(RTM_NEWLINK, link),
	NLMSG_DESC(RTM_DELLINK, link),
	NLMSG_DESC(RTM_GETLINK, link),
	NLMSG_DESC(RTM_SETLINK, link),
};

const unsigned int rtnl_msg_n_desc = ARRAY_SIZE(rtnl_msg_desc);

#define RTNL_MSGHDR_LEN(_name, _struct) \
	[((RTM_ ## _name) - RTM_BASE) / 4] = sizeof(struct _struct)
#define RTNL_MSGHDR_NOLEN(_name) \
	[((RTM_ ## _name) - RTM_BASE) / 4] = USHRT_MAX

const unsigned short rtnl_msghdr_lengths[] = {
	RTNL_MSGHDR_LEN(NEWLINK, ifinfomsg),
	RTNL_MSGHDR_LEN(NEWADDR, ifaddrmsg),
	RTNL_MSGHDR_LEN(NEWROUTE, rtmsg),
	RTNL_MSGHDR_LEN(NEWNEIGH, ndmsg),
	RTNL_MSGHDR_LEN(NEWRULE, rtmsg),
	RTNL_MSGHDR_LEN(NEWQDISC, tcmsg),
	RTNL_MSGHDR_LEN(NEWTCLASS, tcmsg),
	RTNL_MSGHDR_LEN(NEWTFILTER, tcmsg),
	RTNL_MSGHDR_LEN(NEWACTION, tcamsg),
};

const unsigned int rtnl_msghdr_n_len = ARRAY_SIZE(rtnl_msghdr_lengths);
