// Code generated by smithy-go-codegen DO NOT EDIT.

package resourcegroups

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/resourcegroups/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Attaches a service configuration to the specified group. This occurs
// asynchronously, and can take time to complete. You can use GetGroupConfiguration
// to check the status of the update. Minimum permissions To run this command, you
// must have the following permissions:
//
// * resource-groups:PutGroupConfiguration
func (c *Client) PutGroupConfiguration(ctx context.Context, params *PutGroupConfigurationInput, optFns ...func(*Options)) (*PutGroupConfigurationOutput, error) {
	if params == nil {
		params = &PutGroupConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutGroupConfiguration", params, optFns, c.addOperationPutGroupConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutGroupConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutGroupConfigurationInput struct {

	// The new configuration to associate with the specified group. A configuration
	// associates the resource group with an AWS service and specifies how the service
	// can interact with the resources in the group. A configuration is an array of
	// GroupConfigurationItem elements. For information about the syntax of a service
	// configuration, see Service configurations for resource groups
	// (https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html). A resource
	// group can contain either a Configuration or a ResourceQuery, but not both.
	Configuration []types.GroupConfigurationItem

	// The name or ARN of the resource group with the configuration that you want to
	// update.
	Group *string

	noSmithyDocumentSerde
}

type PutGroupConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutGroupConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutGroupConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutGroupConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutGroupConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutGroupConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutGroupConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "resource-groups",
		OperationName: "PutGroupConfiguration",
	}
}
