// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Refreshes the cached inventory of objects for the specified file share. This
// operation finds objects in the Amazon S3 bucket that were added, removed, or
// replaced since the gateway last listed the bucket's contents and cached the
// results. This operation does not import files into the S3 File Gateway cache
// storage. It only updates the cached inventory to reflect changes in the
// inventory of the objects in the S3 bucket. This operation is only supported in
// the S3 File Gateway types. You can subscribe to be notified through an Amazon
// CloudWatch event when your RefreshCache operation completes. For more
// information, see Getting notified about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the Storage Gateway User Guide. This operation is Only supported for S3 File
// Gateways. When this API is called, it only initiates the refresh operation. When
// the API call completes and returns a success code, it doesn't necessarily mean
// that the file refresh has completed. You should use the refresh-complete
// notification to determine that the operation has completed before you check for
// new files on the gateway file share. You can subscribe to be notified through a
// CloudWatch event when your RefreshCache operation completes. Throttle limit:
// This API is asynchronous, so the gateway will accept no more than two refreshes
// at any time. We recommend using the refresh-complete CloudWatch event
// notification before issuing additional requests. For more information, see
// Getting notified about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the Storage Gateway User Guide.
//   - Wait at least 60 seconds between consecutive RefreshCache API requests.
//   - If you invoke the RefreshCache API when two requests are already being
//     processed, any new request will cause an InvalidGatewayRequestException error
//     because too many requests were sent to the server.
//
// The S3 bucket name does not need to be included when entering the list of
// folders in the FolderList parameter. For more information, see Getting notified
// about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the Storage Gateway User Guide.
func (c *Client) RefreshCache(ctx context.Context, params *RefreshCacheInput, optFns ...func(*Options)) (*RefreshCacheOutput, error) {
	if params == nil {
		params = &RefreshCacheInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RefreshCache", params, optFns, c.addOperationRefreshCacheMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RefreshCacheOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// RefreshCacheInput
type RefreshCacheInput struct {

	// The Amazon Resource Name (ARN) of the file share you want to refresh.
	//
	// This member is required.
	FileShareARN *string

	// A comma-separated list of the paths of folders to refresh in the cache. The
	// default is [ "/" ]. The default refreshes objects and folders at the root of the
	// Amazon S3 bucket. If Recursive is set to true , the entire S3 bucket that the
	// file share has access to is refreshed.
	FolderList []string

	// A value that specifies whether to recursively refresh folders in the cache. The
	// refresh includes folders that were in the cache the last time the gateway listed
	// the folder's contents. If this value set to true , each folder that is listed in
	// FolderList is recursively updated. Otherwise, subfolders listed in FolderList
	// are not refreshed. Only objects that are in folders listed directly under
	// FolderList are found and used for the update. The default is true . Valid
	// Values: true | false
	Recursive *bool

	noSmithyDocumentSerde
}

// RefreshCacheOutput
type RefreshCacheOutput struct {

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string

	// The randomly generated ID of the notification that was sent. This ID is in UUID
	// format.
	NotificationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRefreshCacheMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRefreshCache{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRefreshCache{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RefreshCache"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRefreshCacheValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRefreshCache(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRefreshCache(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RefreshCache",
	}
}
