// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpBatchCreatePartition struct {
}

func (*awsAwsjson11_serializeOpBatchCreatePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchCreatePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreatePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchCreatePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchCreatePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchDeleteConnection struct {
}

func (*awsAwsjson11_serializeOpBatchDeleteConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchDeleteConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchDeleteConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchDeleteConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchDeletePartition struct {
}

func (*awsAwsjson11_serializeOpBatchDeletePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchDeletePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeletePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchDeletePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchDeletePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchDeleteTable struct {
}

func (*awsAwsjson11_serializeOpBatchDeleteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchDeleteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchDeleteTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchDeleteTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchDeleteTableVersion struct {
}

func (*awsAwsjson11_serializeOpBatchDeleteTableVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchDeleteTableVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteTableVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchDeleteTableVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchDeleteTableVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetBlueprints struct {
}

func (*awsAwsjson11_serializeOpBatchGetBlueprints) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetBlueprints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetBlueprintsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetBlueprints")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetBlueprintsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetCrawlers struct {
}

func (*awsAwsjson11_serializeOpBatchGetCrawlers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetCrawlers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetCrawlersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetCrawlers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetCrawlersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetCustomEntityTypes struct {
}

func (*awsAwsjson11_serializeOpBatchGetCustomEntityTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetCustomEntityTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetCustomEntityTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetCustomEntityTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetCustomEntityTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetDataQualityResult struct {
}

func (*awsAwsjson11_serializeOpBatchGetDataQualityResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetDataQualityResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetDataQualityResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetDataQualityResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetDataQualityResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetDevEndpoints struct {
}

func (*awsAwsjson11_serializeOpBatchGetDevEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetDevEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetDevEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetDevEndpoints")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetDevEndpointsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetJobs struct {
}

func (*awsAwsjson11_serializeOpBatchGetJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetPartition struct {
}

func (*awsAwsjson11_serializeOpBatchGetPartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetPartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetPartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetPartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetPartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetTableOptimizer struct {
}

func (*awsAwsjson11_serializeOpBatchGetTableOptimizer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetTableOptimizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetTableOptimizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetTableOptimizer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetTableOptimizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetTriggers struct {
}

func (*awsAwsjson11_serializeOpBatchGetTriggers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetTriggers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetTriggersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetTriggers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetTriggersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchGetWorkflows struct {
}

func (*awsAwsjson11_serializeOpBatchGetWorkflows) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchGetWorkflows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetWorkflowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchGetWorkflows")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchGetWorkflowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchStopJobRun struct {
}

func (*awsAwsjson11_serializeOpBatchStopJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchStopJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchStopJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchStopJobRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchStopJobRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpBatchUpdatePartition struct {
}

func (*awsAwsjson11_serializeOpBatchUpdatePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpBatchUpdatePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdatePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.BatchUpdatePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentBatchUpdatePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelDataQualityRuleRecommendationRun struct {
}

func (*awsAwsjson11_serializeOpCancelDataQualityRuleRecommendationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelDataQualityRuleRecommendationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelDataQualityRuleRecommendationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CancelDataQualityRuleRecommendationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelDataQualityRuleRecommendationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelDataQualityRulesetEvaluationRun struct {
}

func (*awsAwsjson11_serializeOpCancelDataQualityRulesetEvaluationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelDataQualityRulesetEvaluationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelDataQualityRulesetEvaluationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CancelDataQualityRulesetEvaluationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelDataQualityRulesetEvaluationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelMLTaskRun struct {
}

func (*awsAwsjson11_serializeOpCancelMLTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelMLTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelMLTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CancelMLTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelMLTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelStatement struct {
}

func (*awsAwsjson11_serializeOpCancelStatement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelStatement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelStatementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CancelStatement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelStatementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCheckSchemaVersionValidity struct {
}

func (*awsAwsjson11_serializeOpCheckSchemaVersionValidity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCheckSchemaVersionValidity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CheckSchemaVersionValidityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CheckSchemaVersionValidity")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCheckSchemaVersionValidityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateBlueprint struct {
}

func (*awsAwsjson11_serializeOpCreateBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateBlueprint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateClassifier struct {
}

func (*awsAwsjson11_serializeOpCreateClassifier) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateClassifier) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClassifierInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateClassifier")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateClassifierInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateConnection struct {
}

func (*awsAwsjson11_serializeOpCreateConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCrawler struct {
}

func (*awsAwsjson11_serializeOpCreateCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCustomEntityType struct {
}

func (*awsAwsjson11_serializeOpCreateCustomEntityType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCustomEntityType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomEntityTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateCustomEntityType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCustomEntityTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDatabase struct {
}

func (*awsAwsjson11_serializeOpCreateDatabase) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDatabase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDatabaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateDatabase")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDatabaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataQualityRuleset struct {
}

func (*awsAwsjson11_serializeOpCreateDataQualityRuleset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataQualityRuleset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataQualityRulesetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateDataQualityRuleset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataQualityRulesetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDevEndpoint struct {
}

func (*awsAwsjson11_serializeOpCreateDevEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDevEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDevEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateDevEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDevEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateJob struct {
}

func (*awsAwsjson11_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateMLTransform struct {
}

func (*awsAwsjson11_serializeOpCreateMLTransform) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateMLTransform) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMLTransformInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateMLTransform")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateMLTransformInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePartition struct {
}

func (*awsAwsjson11_serializeOpCreatePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreatePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePartitionIndex struct {
}

func (*awsAwsjson11_serializeOpCreatePartitionIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePartitionIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePartitionIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreatePartitionIndex")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePartitionIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateRegistry struct {
}

func (*awsAwsjson11_serializeOpCreateRegistry) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateRegistry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRegistryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateRegistry")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateRegistryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateSchema struct {
}

func (*awsAwsjson11_serializeOpCreateSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateScript struct {
}

func (*awsAwsjson11_serializeOpCreateScript) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateScript) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateScriptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateScript")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateScriptInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpCreateSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateSession struct {
}

func (*awsAwsjson11_serializeOpCreateSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateTable struct {
}

func (*awsAwsjson11_serializeOpCreateTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateTableOptimizer struct {
}

func (*awsAwsjson11_serializeOpCreateTableOptimizer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateTableOptimizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTableOptimizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateTableOptimizer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateTableOptimizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateTrigger struct {
}

func (*awsAwsjson11_serializeOpCreateTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUsageProfile struct {
}

func (*awsAwsjson11_serializeOpCreateUsageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUsageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUsageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateUsageProfile")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUsageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUserDefinedFunction struct {
}

func (*awsAwsjson11_serializeOpCreateUserDefinedFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUserDefinedFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserDefinedFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateUserDefinedFunction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUserDefinedFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateWorkflow struct {
}

func (*awsAwsjson11_serializeOpCreateWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.CreateWorkflow")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateWorkflowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteBlueprint struct {
}

func (*awsAwsjson11_serializeOpDeleteBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteBlueprint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteClassifier struct {
}

func (*awsAwsjson11_serializeOpDeleteClassifier) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteClassifier) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClassifierInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteClassifier")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteClassifierInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteColumnStatisticsForPartition struct {
}

func (*awsAwsjson11_serializeOpDeleteColumnStatisticsForPartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteColumnStatisticsForPartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteColumnStatisticsForPartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteColumnStatisticsForPartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteColumnStatisticsForPartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteColumnStatisticsForTable struct {
}

func (*awsAwsjson11_serializeOpDeleteColumnStatisticsForTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteColumnStatisticsForTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteColumnStatisticsForTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteColumnStatisticsForTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteColumnStatisticsForTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteConnection struct {
}

func (*awsAwsjson11_serializeOpDeleteConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCrawler struct {
}

func (*awsAwsjson11_serializeOpDeleteCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCustomEntityType struct {
}

func (*awsAwsjson11_serializeOpDeleteCustomEntityType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCustomEntityType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomEntityTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteCustomEntityType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCustomEntityTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDatabase struct {
}

func (*awsAwsjson11_serializeOpDeleteDatabase) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDatabase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatabaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteDatabase")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDatabaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDataQualityRuleset struct {
}

func (*awsAwsjson11_serializeOpDeleteDataQualityRuleset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDataQualityRuleset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataQualityRulesetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteDataQualityRuleset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDataQualityRulesetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDevEndpoint struct {
}

func (*awsAwsjson11_serializeOpDeleteDevEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDevEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDevEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteDevEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDevEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteJob struct {
}

func (*awsAwsjson11_serializeOpDeleteJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMLTransform struct {
}

func (*awsAwsjson11_serializeOpDeleteMLTransform) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMLTransform) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMLTransformInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteMLTransform")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMLTransformInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePartition struct {
}

func (*awsAwsjson11_serializeOpDeletePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeletePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePartitionIndex struct {
}

func (*awsAwsjson11_serializeOpDeletePartitionIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePartitionIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePartitionIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeletePartitionIndex")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePartitionIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteRegistry struct {
}

func (*awsAwsjson11_serializeOpDeleteRegistry) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteRegistry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRegistryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteRegistry")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteRegistryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteResourcePolicy struct {
}

func (*awsAwsjson11_serializeOpDeleteResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSchema struct {
}

func (*awsAwsjson11_serializeOpDeleteSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSchemaVersions struct {
}

func (*awsAwsjson11_serializeOpDeleteSchemaVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSchemaVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSchemaVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteSchemaVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSchemaVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSession struct {
}

func (*awsAwsjson11_serializeOpDeleteSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTable struct {
}

func (*awsAwsjson11_serializeOpDeleteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTableOptimizer struct {
}

func (*awsAwsjson11_serializeOpDeleteTableOptimizer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTableOptimizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTableOptimizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteTableOptimizer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTableOptimizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTableVersion struct {
}

func (*awsAwsjson11_serializeOpDeleteTableVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTableVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTableVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteTableVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTableVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTrigger struct {
}

func (*awsAwsjson11_serializeOpDeleteTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUsageProfile struct {
}

func (*awsAwsjson11_serializeOpDeleteUsageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUsageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUsageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteUsageProfile")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUsageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUserDefinedFunction struct {
}

func (*awsAwsjson11_serializeOpDeleteUserDefinedFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUserDefinedFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserDefinedFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteUserDefinedFunction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserDefinedFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteWorkflow struct {
}

func (*awsAwsjson11_serializeOpDeleteWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.DeleteWorkflow")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteWorkflowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetBlueprint struct {
}

func (*awsAwsjson11_serializeOpGetBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetBlueprint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetBlueprintRun struct {
}

func (*awsAwsjson11_serializeOpGetBlueprintRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetBlueprintRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlueprintRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetBlueprintRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetBlueprintRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetBlueprintRuns struct {
}

func (*awsAwsjson11_serializeOpGetBlueprintRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetBlueprintRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlueprintRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetBlueprintRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetBlueprintRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCatalogImportStatus struct {
}

func (*awsAwsjson11_serializeOpGetCatalogImportStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCatalogImportStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCatalogImportStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetCatalogImportStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCatalogImportStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetClassifier struct {
}

func (*awsAwsjson11_serializeOpGetClassifier) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetClassifier) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetClassifierInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetClassifier")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetClassifierInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetClassifiers struct {
}

func (*awsAwsjson11_serializeOpGetClassifiers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetClassifiers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetClassifiersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetClassifiers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetClassifiersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetColumnStatisticsForPartition struct {
}

func (*awsAwsjson11_serializeOpGetColumnStatisticsForPartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetColumnStatisticsForPartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetColumnStatisticsForPartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetColumnStatisticsForPartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetColumnStatisticsForPartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetColumnStatisticsForTable struct {
}

func (*awsAwsjson11_serializeOpGetColumnStatisticsForTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetColumnStatisticsForTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetColumnStatisticsForTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetColumnStatisticsForTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetColumnStatisticsForTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetColumnStatisticsTaskRun struct {
}

func (*awsAwsjson11_serializeOpGetColumnStatisticsTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetColumnStatisticsTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetColumnStatisticsTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetColumnStatisticsTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetColumnStatisticsTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetColumnStatisticsTaskRuns struct {
}

func (*awsAwsjson11_serializeOpGetColumnStatisticsTaskRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetColumnStatisticsTaskRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetColumnStatisticsTaskRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetColumnStatisticsTaskRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetColumnStatisticsTaskRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetConnection struct {
}

func (*awsAwsjson11_serializeOpGetConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetConnections struct {
}

func (*awsAwsjson11_serializeOpGetConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetConnections")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetConnectionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCrawler struct {
}

func (*awsAwsjson11_serializeOpGetCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCrawlerMetrics struct {
}

func (*awsAwsjson11_serializeOpGetCrawlerMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCrawlerMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCrawlerMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetCrawlerMetrics")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCrawlerMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCrawlers struct {
}

func (*awsAwsjson11_serializeOpGetCrawlers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCrawlers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCrawlersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetCrawlers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCrawlersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCustomEntityType struct {
}

func (*awsAwsjson11_serializeOpGetCustomEntityType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCustomEntityType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCustomEntityTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetCustomEntityType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCustomEntityTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDatabase struct {
}

func (*awsAwsjson11_serializeOpGetDatabase) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDatabase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDatabaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDatabase")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDatabaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDatabases struct {
}

func (*awsAwsjson11_serializeOpGetDatabases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDatabases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDatabasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDatabases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDatabasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataCatalogEncryptionSettings struct {
}

func (*awsAwsjson11_serializeOpGetDataCatalogEncryptionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataCatalogEncryptionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataCatalogEncryptionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataCatalogEncryptionSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataCatalogEncryptionSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataflowGraph struct {
}

func (*awsAwsjson11_serializeOpGetDataflowGraph) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataflowGraph) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataflowGraphInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataflowGraph")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataflowGraphInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataQualityResult struct {
}

func (*awsAwsjson11_serializeOpGetDataQualityResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataQualityResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataQualityResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataQualityResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataQualityResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataQualityRuleRecommendationRun struct {
}

func (*awsAwsjson11_serializeOpGetDataQualityRuleRecommendationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataQualityRuleRecommendationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataQualityRuleRecommendationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataQualityRuleRecommendationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataQualityRuleRecommendationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataQualityRuleset struct {
}

func (*awsAwsjson11_serializeOpGetDataQualityRuleset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataQualityRuleset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataQualityRulesetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataQualityRuleset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataQualityRulesetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataQualityRulesetEvaluationRun struct {
}

func (*awsAwsjson11_serializeOpGetDataQualityRulesetEvaluationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataQualityRulesetEvaluationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataQualityRulesetEvaluationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDataQualityRulesetEvaluationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataQualityRulesetEvaluationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDevEndpoint struct {
}

func (*awsAwsjson11_serializeOpGetDevEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDevEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDevEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDevEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDevEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDevEndpoints struct {
}

func (*awsAwsjson11_serializeOpGetDevEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDevEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDevEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetDevEndpoints")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDevEndpointsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJob struct {
}

func (*awsAwsjson11_serializeOpGetJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobBookmark struct {
}

func (*awsAwsjson11_serializeOpGetJobBookmark) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobBookmark) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobBookmarkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetJobBookmark")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobBookmarkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobRun struct {
}

func (*awsAwsjson11_serializeOpGetJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetJobRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobRuns struct {
}

func (*awsAwsjson11_serializeOpGetJobRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetJobRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobs struct {
}

func (*awsAwsjson11_serializeOpGetJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMapping struct {
}

func (*awsAwsjson11_serializeOpGetMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetMapping")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMLTaskRun struct {
}

func (*awsAwsjson11_serializeOpGetMLTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMLTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetMLTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMLTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMLTaskRuns struct {
}

func (*awsAwsjson11_serializeOpGetMLTaskRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMLTaskRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLTaskRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetMLTaskRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMLTaskRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMLTransform struct {
}

func (*awsAwsjson11_serializeOpGetMLTransform) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMLTransform) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLTransformInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetMLTransform")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMLTransformInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMLTransforms struct {
}

func (*awsAwsjson11_serializeOpGetMLTransforms) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMLTransforms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLTransformsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetMLTransforms")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMLTransformsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPartition struct {
}

func (*awsAwsjson11_serializeOpGetPartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetPartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPartitionIndexes struct {
}

func (*awsAwsjson11_serializeOpGetPartitionIndexes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPartitionIndexes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPartitionIndexesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetPartitionIndexes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPartitionIndexesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPartitions struct {
}

func (*awsAwsjson11_serializeOpGetPartitions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPartitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPartitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetPartitions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPartitionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPlan struct {
}

func (*awsAwsjson11_serializeOpGetPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetPlan")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPlanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetRegistry struct {
}

func (*awsAwsjson11_serializeOpGetRegistry) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetRegistry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRegistryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetRegistry")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetRegistryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetResourcePolicies struct {
}

func (*awsAwsjson11_serializeOpGetResourcePolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetResourcePolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResourcePoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetResourcePolicies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetResourcePoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetResourcePolicy struct {
}

func (*awsAwsjson11_serializeOpGetResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSchema struct {
}

func (*awsAwsjson11_serializeOpGetSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSchemaByDefinition struct {
}

func (*awsAwsjson11_serializeOpGetSchemaByDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSchemaByDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaByDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSchemaByDefinition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSchemaByDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSchemaVersion struct {
}

func (*awsAwsjson11_serializeOpGetSchemaVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSchemaVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSchemaVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSchemaVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSchemaVersionsDiff struct {
}

func (*awsAwsjson11_serializeOpGetSchemaVersionsDiff) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSchemaVersionsDiff) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaVersionsDiffInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSchemaVersionsDiff")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSchemaVersionsDiffInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpGetSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSecurityConfigurations struct {
}

func (*awsAwsjson11_serializeOpGetSecurityConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSecurityConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSecurityConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSecurityConfigurations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSecurityConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSession struct {
}

func (*awsAwsjson11_serializeOpGetSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetStatement struct {
}

func (*awsAwsjson11_serializeOpGetStatement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetStatement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStatementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetStatement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetStatementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTable struct {
}

func (*awsAwsjson11_serializeOpGetTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTableOptimizer struct {
}

func (*awsAwsjson11_serializeOpGetTableOptimizer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTableOptimizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTableOptimizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTableOptimizer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTableOptimizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTables struct {
}

func (*awsAwsjson11_serializeOpGetTables) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTables")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTablesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTableVersion struct {
}

func (*awsAwsjson11_serializeOpGetTableVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTableVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTableVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTableVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTableVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTableVersions struct {
}

func (*awsAwsjson11_serializeOpGetTableVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTableVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTableVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTableVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTableVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTags struct {
}

func (*awsAwsjson11_serializeOpGetTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTrigger struct {
}

func (*awsAwsjson11_serializeOpGetTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTriggers struct {
}

func (*awsAwsjson11_serializeOpGetTriggers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTriggers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTriggersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetTriggers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTriggersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUnfilteredPartitionMetadata struct {
}

func (*awsAwsjson11_serializeOpGetUnfilteredPartitionMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUnfilteredPartitionMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUnfilteredPartitionMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUnfilteredPartitionMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUnfilteredPartitionMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUnfilteredPartitionsMetadata struct {
}

func (*awsAwsjson11_serializeOpGetUnfilteredPartitionsMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUnfilteredPartitionsMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUnfilteredPartitionsMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUnfilteredPartitionsMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUnfilteredPartitionsMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUnfilteredTableMetadata struct {
}

func (*awsAwsjson11_serializeOpGetUnfilteredTableMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUnfilteredTableMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUnfilteredTableMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUnfilteredTableMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUnfilteredTableMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUsageProfile struct {
}

func (*awsAwsjson11_serializeOpGetUsageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUsageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUsageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUsageProfile")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUsageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUserDefinedFunction struct {
}

func (*awsAwsjson11_serializeOpGetUserDefinedFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUserDefinedFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserDefinedFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUserDefinedFunction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUserDefinedFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUserDefinedFunctions struct {
}

func (*awsAwsjson11_serializeOpGetUserDefinedFunctions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUserDefinedFunctions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserDefinedFunctionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetUserDefinedFunctions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUserDefinedFunctionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWorkflow struct {
}

func (*awsAwsjson11_serializeOpGetWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetWorkflow")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWorkflowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWorkflowRun struct {
}

func (*awsAwsjson11_serializeOpGetWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetWorkflowRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWorkflowRunProperties struct {
}

func (*awsAwsjson11_serializeOpGetWorkflowRunProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWorkflowRunProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowRunPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetWorkflowRunProperties")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWorkflowRunPropertiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWorkflowRuns struct {
}

func (*awsAwsjson11_serializeOpGetWorkflowRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWorkflowRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.GetWorkflowRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWorkflowRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpImportCatalogToGlue struct {
}

func (*awsAwsjson11_serializeOpImportCatalogToGlue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpImportCatalogToGlue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportCatalogToGlueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ImportCatalogToGlue")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentImportCatalogToGlueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListBlueprints struct {
}

func (*awsAwsjson11_serializeOpListBlueprints) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListBlueprints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBlueprintsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListBlueprints")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListBlueprintsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListColumnStatisticsTaskRuns struct {
}

func (*awsAwsjson11_serializeOpListColumnStatisticsTaskRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListColumnStatisticsTaskRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListColumnStatisticsTaskRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListColumnStatisticsTaskRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListColumnStatisticsTaskRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCrawlers struct {
}

func (*awsAwsjson11_serializeOpListCrawlers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCrawlers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCrawlersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListCrawlers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCrawlersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCrawls struct {
}

func (*awsAwsjson11_serializeOpListCrawls) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCrawls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCrawlsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListCrawls")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCrawlsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCustomEntityTypes struct {
}

func (*awsAwsjson11_serializeOpListCustomEntityTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCustomEntityTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomEntityTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListCustomEntityTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCustomEntityTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDataQualityResults struct {
}

func (*awsAwsjson11_serializeOpListDataQualityResults) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDataQualityResults) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataQualityResultsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListDataQualityResults")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDataQualityResultsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDataQualityRuleRecommendationRuns struct {
}

func (*awsAwsjson11_serializeOpListDataQualityRuleRecommendationRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDataQualityRuleRecommendationRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataQualityRuleRecommendationRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListDataQualityRuleRecommendationRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDataQualityRuleRecommendationRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDataQualityRulesetEvaluationRuns struct {
}

func (*awsAwsjson11_serializeOpListDataQualityRulesetEvaluationRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDataQualityRulesetEvaluationRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataQualityRulesetEvaluationRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListDataQualityRulesetEvaluationRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDataQualityRulesetEvaluationRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDataQualityRulesets struct {
}

func (*awsAwsjson11_serializeOpListDataQualityRulesets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDataQualityRulesets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataQualityRulesetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListDataQualityRulesets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDataQualityRulesetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDevEndpoints struct {
}

func (*awsAwsjson11_serializeOpListDevEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDevEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDevEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListDevEndpoints")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDevEndpointsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListJobs struct {
}

func (*awsAwsjson11_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMLTransforms struct {
}

func (*awsAwsjson11_serializeOpListMLTransforms) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMLTransforms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMLTransformsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListMLTransforms")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMLTransformsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListRegistries struct {
}

func (*awsAwsjson11_serializeOpListRegistries) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListRegistries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRegistriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListRegistries")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListRegistriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSchemas struct {
}

func (*awsAwsjson11_serializeOpListSchemas) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSchemas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSchemasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListSchemas")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListSchemasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSchemaVersions struct {
}

func (*awsAwsjson11_serializeOpListSchemaVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSchemaVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSchemaVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListSchemaVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListSchemaVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSessions struct {
}

func (*awsAwsjson11_serializeOpListSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListSessions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListStatements struct {
}

func (*awsAwsjson11_serializeOpListStatements) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListStatements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStatementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListStatements")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListStatementsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTableOptimizerRuns struct {
}

func (*awsAwsjson11_serializeOpListTableOptimizerRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTableOptimizerRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTableOptimizerRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListTableOptimizerRuns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTableOptimizerRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTriggers struct {
}

func (*awsAwsjson11_serializeOpListTriggers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTriggers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTriggersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListTriggers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTriggersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUsageProfiles struct {
}

func (*awsAwsjson11_serializeOpListUsageProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUsageProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsageProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListUsageProfiles")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUsageProfilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListWorkflows struct {
}

func (*awsAwsjson11_serializeOpListWorkflows) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListWorkflows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkflowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ListWorkflows")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListWorkflowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutDataCatalogEncryptionSettings struct {
}

func (*awsAwsjson11_serializeOpPutDataCatalogEncryptionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutDataCatalogEncryptionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDataCatalogEncryptionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.PutDataCatalogEncryptionSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutDataCatalogEncryptionSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutResourcePolicy struct {
}

func (*awsAwsjson11_serializeOpPutResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.PutResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutSchemaVersionMetadata struct {
}

func (*awsAwsjson11_serializeOpPutSchemaVersionMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutSchemaVersionMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutSchemaVersionMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.PutSchemaVersionMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutSchemaVersionMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutWorkflowRunProperties struct {
}

func (*awsAwsjson11_serializeOpPutWorkflowRunProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutWorkflowRunProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutWorkflowRunPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.PutWorkflowRunProperties")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutWorkflowRunPropertiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpQuerySchemaVersionMetadata struct {
}

func (*awsAwsjson11_serializeOpQuerySchemaVersionMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpQuerySchemaVersionMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*QuerySchemaVersionMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.QuerySchemaVersionMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentQuerySchemaVersionMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRegisterSchemaVersion struct {
}

func (*awsAwsjson11_serializeOpRegisterSchemaVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRegisterSchemaVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterSchemaVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.RegisterSchemaVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRegisterSchemaVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRemoveSchemaVersionMetadata struct {
}

func (*awsAwsjson11_serializeOpRemoveSchemaVersionMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRemoveSchemaVersionMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveSchemaVersionMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.RemoveSchemaVersionMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRemoveSchemaVersionMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpResetJobBookmark struct {
}

func (*awsAwsjson11_serializeOpResetJobBookmark) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpResetJobBookmark) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetJobBookmarkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ResetJobBookmark")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentResetJobBookmarkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpResumeWorkflowRun struct {
}

func (*awsAwsjson11_serializeOpResumeWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpResumeWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResumeWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.ResumeWorkflowRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentResumeWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRunStatement struct {
}

func (*awsAwsjson11_serializeOpRunStatement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRunStatement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunStatementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.RunStatement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRunStatementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSearchTables struct {
}

func (*awsAwsjson11_serializeOpSearchTables) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSearchTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.SearchTables")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSearchTablesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartBlueprintRun struct {
}

func (*awsAwsjson11_serializeOpStartBlueprintRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartBlueprintRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartBlueprintRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartBlueprintRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartBlueprintRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartColumnStatisticsTaskRun struct {
}

func (*awsAwsjson11_serializeOpStartColumnStatisticsTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartColumnStatisticsTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartColumnStatisticsTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartColumnStatisticsTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartColumnStatisticsTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartCrawler struct {
}

func (*awsAwsjson11_serializeOpStartCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartCrawlerSchedule struct {
}

func (*awsAwsjson11_serializeOpStartCrawlerSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartCrawlerSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCrawlerScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartCrawlerSchedule")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartCrawlerScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartDataQualityRuleRecommendationRun struct {
}

func (*awsAwsjson11_serializeOpStartDataQualityRuleRecommendationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartDataQualityRuleRecommendationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDataQualityRuleRecommendationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartDataQualityRuleRecommendationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartDataQualityRuleRecommendationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartDataQualityRulesetEvaluationRun struct {
}

func (*awsAwsjson11_serializeOpStartDataQualityRulesetEvaluationRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartDataQualityRulesetEvaluationRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDataQualityRulesetEvaluationRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartDataQualityRulesetEvaluationRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartDataQualityRulesetEvaluationRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartExportLabelsTaskRun struct {
}

func (*awsAwsjson11_serializeOpStartExportLabelsTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartExportLabelsTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartExportLabelsTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartExportLabelsTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartExportLabelsTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartImportLabelsTaskRun struct {
}

func (*awsAwsjson11_serializeOpStartImportLabelsTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartImportLabelsTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartImportLabelsTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartImportLabelsTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartImportLabelsTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartJobRun struct {
}

func (*awsAwsjson11_serializeOpStartJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartJobRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartJobRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMLEvaluationTaskRun struct {
}

func (*awsAwsjson11_serializeOpStartMLEvaluationTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMLEvaluationTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMLEvaluationTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartMLEvaluationTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMLEvaluationTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMLLabelingSetGenerationTaskRun struct {
}

func (*awsAwsjson11_serializeOpStartMLLabelingSetGenerationTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMLLabelingSetGenerationTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMLLabelingSetGenerationTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartMLLabelingSetGenerationTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMLLabelingSetGenerationTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartTrigger struct {
}

func (*awsAwsjson11_serializeOpStartTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartWorkflowRun struct {
}

func (*awsAwsjson11_serializeOpStartWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StartWorkflowRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopColumnStatisticsTaskRun struct {
}

func (*awsAwsjson11_serializeOpStopColumnStatisticsTaskRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopColumnStatisticsTaskRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopColumnStatisticsTaskRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopColumnStatisticsTaskRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopColumnStatisticsTaskRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopCrawler struct {
}

func (*awsAwsjson11_serializeOpStopCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopCrawlerSchedule struct {
}

func (*awsAwsjson11_serializeOpStopCrawlerSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopCrawlerSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopCrawlerScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopCrawlerSchedule")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopCrawlerScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopSession struct {
}

func (*awsAwsjson11_serializeOpStopSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopTrigger struct {
}

func (*awsAwsjson11_serializeOpStopTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopWorkflowRun struct {
}

func (*awsAwsjson11_serializeOpStopWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.StopWorkflowRun")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateBlueprint struct {
}

func (*awsAwsjson11_serializeOpUpdateBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateBlueprint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateClassifier struct {
}

func (*awsAwsjson11_serializeOpUpdateClassifier) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateClassifier) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClassifierInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateClassifier")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateClassifierInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateColumnStatisticsForPartition struct {
}

func (*awsAwsjson11_serializeOpUpdateColumnStatisticsForPartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateColumnStatisticsForPartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateColumnStatisticsForPartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateColumnStatisticsForPartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateColumnStatisticsForPartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateColumnStatisticsForTable struct {
}

func (*awsAwsjson11_serializeOpUpdateColumnStatisticsForTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateColumnStatisticsForTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateColumnStatisticsForTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateColumnStatisticsForTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateColumnStatisticsForTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateConnection struct {
}

func (*awsAwsjson11_serializeOpUpdateConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCrawler struct {
}

func (*awsAwsjson11_serializeOpUpdateCrawler) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCrawler) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCrawlerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateCrawler")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateCrawlerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCrawlerSchedule struct {
}

func (*awsAwsjson11_serializeOpUpdateCrawlerSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCrawlerSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCrawlerScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateCrawlerSchedule")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateCrawlerScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDatabase struct {
}

func (*awsAwsjson11_serializeOpUpdateDatabase) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDatabase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDatabaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateDatabase")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDatabaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDataQualityRuleset struct {
}

func (*awsAwsjson11_serializeOpUpdateDataQualityRuleset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDataQualityRuleset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataQualityRulesetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateDataQualityRuleset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDataQualityRulesetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDevEndpoint struct {
}

func (*awsAwsjson11_serializeOpUpdateDevEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDevEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDevEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateDevEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDevEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateJob struct {
}

func (*awsAwsjson11_serializeOpUpdateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateJobFromSourceControl struct {
}

func (*awsAwsjson11_serializeOpUpdateJobFromSourceControl) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateJobFromSourceControl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobFromSourceControlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateJobFromSourceControl")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateJobFromSourceControlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateMLTransform struct {
}

func (*awsAwsjson11_serializeOpUpdateMLTransform) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateMLTransform) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMLTransformInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateMLTransform")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateMLTransformInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdatePartition struct {
}

func (*awsAwsjson11_serializeOpUpdatePartition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdatePartition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePartitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdatePartition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdatePartitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateRegistry struct {
}

func (*awsAwsjson11_serializeOpUpdateRegistry) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateRegistry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRegistryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateRegistry")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateRegistryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateSchema struct {
}

func (*awsAwsjson11_serializeOpUpdateSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateSourceControlFromJob struct {
}

func (*awsAwsjson11_serializeOpUpdateSourceControlFromJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateSourceControlFromJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSourceControlFromJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateSourceControlFromJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateSourceControlFromJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateTable struct {
}

func (*awsAwsjson11_serializeOpUpdateTable) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateTable")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateTableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateTableOptimizer struct {
}

func (*awsAwsjson11_serializeOpUpdateTableOptimizer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateTableOptimizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTableOptimizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateTableOptimizer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateTableOptimizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateTrigger struct {
}

func (*awsAwsjson11_serializeOpUpdateTrigger) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateTrigger) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTriggerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateTrigger")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateTriggerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUsageProfile struct {
}

func (*awsAwsjson11_serializeOpUpdateUsageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUsageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUsageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateUsageProfile")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUsageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUserDefinedFunction struct {
}

func (*awsAwsjson11_serializeOpUpdateUserDefinedFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUserDefinedFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserDefinedFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateUserDefinedFunction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUserDefinedFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateWorkflow struct {
}

func (*awsAwsjson11_serializeOpUpdateWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSGlue.UpdateWorkflow")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateWorkflowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAction(v *types.Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arguments != nil {
		ok := object.Key("Arguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.Arguments, ok); err != nil {
			return err
		}
	}

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.NotificationProperty != nil {
		ok := object.Key("NotificationProperty")
		if err := awsAwsjson11_serializeDocumentNotificationProperty(v.NotificationProperty, ok); err != nil {
			return err
		}
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionList(v []types.Action, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAdditionalContextMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAdditionalOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAdditionalPlanOptionsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAggregate(v *types.Aggregate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aggs != nil {
		ok := object.Key("Aggs")
		if err := awsAwsjson11_serializeDocumentAggregateOperations(v.Aggs, ok); err != nil {
			return err
		}
	}

	if v.Groups != nil {
		ok := object.Key("Groups")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.Groups, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAggregateOperation(v *types.AggregateOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggFunc) > 0 {
		ok := object.Key("AggFunc")
		ok.String(string(v.AggFunc))
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Column, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAggregateOperations(v []types.AggregateOperation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAggregateOperation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAllowedValuesStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAmazonRedshiftAdvancedOption(v *types.AmazonRedshiftAdvancedOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonRedshiftAdvancedOptions(v []types.AmazonRedshiftAdvancedOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftAdvancedOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAmazonRedshiftNodeData(v *types.AmazonRedshiftNodeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessType != nil {
		ok := object.Key("AccessType")
		ok.String(*v.AccessType)
	}

	if v.Action != nil {
		ok := object.Key("Action")
		ok.String(*v.Action)
	}

	if v.AdvancedOptions != nil {
		ok := object.Key("AdvancedOptions")
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftAdvancedOptions(v.AdvancedOptions, ok); err != nil {
			return err
		}
	}

	if v.CatalogDatabase != nil {
		ok := object.Key("CatalogDatabase")
		if err := awsAwsjson11_serializeDocumentOption(v.CatalogDatabase, ok); err != nil {
			return err
		}
	}

	if v.CatalogRedshiftSchema != nil {
		ok := object.Key("CatalogRedshiftSchema")
		ok.String(*v.CatalogRedshiftSchema)
	}

	if v.CatalogRedshiftTable != nil {
		ok := object.Key("CatalogRedshiftTable")
		ok.String(*v.CatalogRedshiftTable)
	}

	if v.CatalogTable != nil {
		ok := object.Key("CatalogTable")
		if err := awsAwsjson11_serializeDocumentOption(v.CatalogTable, ok); err != nil {
			return err
		}
	}

	if v.Connection != nil {
		ok := object.Key("Connection")
		if err := awsAwsjson11_serializeDocumentOption(v.Connection, ok); err != nil {
			return err
		}
	}

	if v.CrawlerConnection != nil {
		ok := object.Key("CrawlerConnection")
		ok.String(*v.CrawlerConnection)
	}

	if v.IamRole != nil {
		ok := object.Key("IamRole")
		if err := awsAwsjson11_serializeDocumentOption(v.IamRole, ok); err != nil {
			return err
		}
	}

	if v.MergeAction != nil {
		ok := object.Key("MergeAction")
		ok.String(*v.MergeAction)
	}

	if v.MergeClause != nil {
		ok := object.Key("MergeClause")
		ok.String(*v.MergeClause)
	}

	if v.MergeWhenMatched != nil {
		ok := object.Key("MergeWhenMatched")
		ok.String(*v.MergeWhenMatched)
	}

	if v.MergeWhenNotMatched != nil {
		ok := object.Key("MergeWhenNotMatched")
		ok.String(*v.MergeWhenNotMatched)
	}

	if v.PostAction != nil {
		ok := object.Key("PostAction")
		ok.String(*v.PostAction)
	}

	if v.PreAction != nil {
		ok := object.Key("PreAction")
		ok.String(*v.PreAction)
	}

	if v.SampleQuery != nil {
		ok := object.Key("SampleQuery")
		ok.String(*v.SampleQuery)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		if err := awsAwsjson11_serializeDocumentOption(v.Schema, ok); err != nil {
			return err
		}
	}

	if v.SelectedColumns != nil {
		ok := object.Key("SelectedColumns")
		if err := awsAwsjson11_serializeDocumentOptionList(v.SelectedColumns, ok); err != nil {
			return err
		}
	}

	if v.SourceType != nil {
		ok := object.Key("SourceType")
		ok.String(*v.SourceType)
	}

	if v.StagingTable != nil {
		ok := object.Key("StagingTable")
		ok.String(*v.StagingTable)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		if err := awsAwsjson11_serializeDocumentOption(v.Table, ok); err != nil {
			return err
		}
	}

	if v.TablePrefix != nil {
		ok := object.Key("TablePrefix")
		ok.String(*v.TablePrefix)
	}

	if v.TableSchema != nil {
		ok := object.Key("TableSchema")
		if err := awsAwsjson11_serializeDocumentOptionList(v.TableSchema, ok); err != nil {
			return err
		}
	}

	if v.TempDir != nil {
		ok := object.Key("TempDir")
		ok.String(*v.TempDir)
	}

	if v.Upsert {
		ok := object.Key("Upsert")
		ok.Boolean(v.Upsert)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonRedshiftSource(v *types.AmazonRedshiftSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftNodeData(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonRedshiftTarget(v *types.AmazonRedshiftTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftNodeData(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplyMapping(v *types.ApplyMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Mapping != nil {
		ok := object.Key("Mapping")
		if err := awsAwsjson11_serializeDocumentMappings(v.Mapping, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAthenaConnectorSource(v *types.AthenaConnectorSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.ConnectionTable != nil {
		ok := object.Key("ConnectionTable")
		ok.String(*v.ConnectionTable)
	}

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.ConnectorName != nil {
		ok := object.Key("ConnectorName")
		ok.String(*v.ConnectorName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.SchemaName != nil {
		ok := object.Key("SchemaName")
		ok.String(*v.SchemaName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAuditColumnNamesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAuditContext(v *types.AuditContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalAuditContext != nil {
		ok := object.Key("AdditionalAuditContext")
		ok.String(*v.AdditionalAuditContext)
	}

	if v.AllColumnsRequested != nil {
		ok := object.Key("AllColumnsRequested")
		ok.Boolean(*v.AllColumnsRequested)
	}

	if v.RequestedColumns != nil {
		ok := object.Key("RequestedColumns")
		if err := awsAwsjson11_serializeDocumentAuditColumnNamesList(v.RequestedColumns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAuthenticationConfigurationInput(v *types.AuthenticationConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("AuthenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.OAuth2Properties != nil {
		ok := object.Key("OAuth2Properties")
		if err := awsAwsjson11_serializeDocumentOAuth2PropertiesInput(v.OAuth2Properties, ok); err != nil {
			return err
		}
	}

	if v.SecretArn != nil {
		ok := object.Key("SecretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAuthorizationCodeProperties(v *types.AuthorizationCodeProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationCode != nil {
		ok := object.Key("AuthorizationCode")
		ok.String(*v.AuthorizationCode)
	}

	if v.RedirectUri != nil {
		ok := object.Key("RedirectUri")
		ok.String(*v.RedirectUri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBasicCatalogTarget(v *types.BasicCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBatchDeletePartitionValueList(v []types.PartitionValueList, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPartitionValueList(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchDeleteTableNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchDeleteTableVersionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchGetBlueprintNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchGetPartitionValueList(v []types.PartitionValueList, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPartitionValueList(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchGetTableOptimizerEntries(v []types.BatchGetTableOptimizerEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentBatchGetTableOptimizerEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchGetTableOptimizerEntry(v *types.BatchGetTableOptimizerEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("catalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentBatchStopJobRunJobRunIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentBatchUpdatePartitionRequestEntry(v *types.BatchUpdatePartitionRequestEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PartitionInput != nil {
		ok := object.Key("PartitionInput")
		if err := awsAwsjson11_serializeDocumentPartitionInput(v.PartitionInput, ok); err != nil {
			return err
		}
	}

	if v.PartitionValueList != nil {
		ok := object.Key("PartitionValueList")
		if err := awsAwsjson11_serializeDocumentBoundedPartitionValueList(v.PartitionValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBatchUpdatePartitionRequestEntryList(v []types.BatchUpdatePartitionRequestEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentBatchUpdatePartitionRequestEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentBinaryColumnStatisticsData(v *types.BinaryColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("AverageLength")
		switch {
		case math.IsNaN(v.AverageLength):
			ok.String("NaN")

		case math.IsInf(v.AverageLength, 1):
			ok.String("Infinity")

		case math.IsInf(v.AverageLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.AverageLength)

		}
	}

	{
		ok := object.Key("MaximumLength")
		ok.Long(v.MaximumLength)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBooleanColumnStatisticsData(v *types.BooleanColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("NumberOfFalses")
		ok.Long(v.NumberOfFalses)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	{
		ok := object.Key("NumberOfTrues")
		ok.Long(v.NumberOfTrues)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBoundedPartitionValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCatalogDeltaSource(v *types.CatalogDeltaSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalDeltaOptions != nil {
		ok := object.Key("AdditionalDeltaOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalDeltaOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogEntries(v []types.CatalogEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCatalogEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCatalogEntry(v *types.CatalogEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogHudiSource(v *types.CatalogHudiSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalHudiOptions != nil {
		ok := object.Key("AdditionalHudiOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalHudiOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogKafkaSource(v *types.CatalogKafkaSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.DataPreviewOptions != nil {
		ok := object.Key("DataPreviewOptions")
		if err := awsAwsjson11_serializeDocumentStreamingDataPreviewOptions(v.DataPreviewOptions, ok); err != nil {
			return err
		}
	}

	if v.DetectSchema != nil {
		ok := object.Key("DetectSchema")
		ok.Boolean(*v.DetectSchema)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StreamingOptions != nil {
		ok := object.Key("StreamingOptions")
		if err := awsAwsjson11_serializeDocumentKafkaStreamingSourceOptions(v.StreamingOptions, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.WindowSize != nil {
		ok := object.Key("WindowSize")
		ok.Integer(*v.WindowSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogKinesisSource(v *types.CatalogKinesisSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.DataPreviewOptions != nil {
		ok := object.Key("DataPreviewOptions")
		if err := awsAwsjson11_serializeDocumentStreamingDataPreviewOptions(v.DataPreviewOptions, ok); err != nil {
			return err
		}
	}

	if v.DetectSchema != nil {
		ok := object.Key("DetectSchema")
		ok.Boolean(*v.DetectSchema)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StreamingOptions != nil {
		ok := object.Key("StreamingOptions")
		if err := awsAwsjson11_serializeDocumentKinesisStreamingSourceOptions(v.StreamingOptions, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.WindowSize != nil {
		ok := object.Key("WindowSize")
		ok.Integer(*v.WindowSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogSchemaChangePolicy(v *types.CatalogSchemaChangePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableUpdateCatalog != nil {
		ok := object.Key("EnableUpdateCatalog")
		ok.Boolean(*v.EnableUpdateCatalog)
	}

	if len(v.UpdateBehavior) > 0 {
		ok := object.Key("UpdateBehavior")
		ok.String(string(v.UpdateBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogSource(v *types.CatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogTablesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCatalogTarget(v *types.CatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DlqEventQueueArn != nil {
		ok := object.Key("DlqEventQueueArn")
		ok.String(*v.DlqEventQueueArn)
	}

	if v.EventQueueArn != nil {
		ok := object.Key("EventQueueArn")
		ok.String(*v.EventQueueArn)
	}

	if v.Tables != nil {
		ok := object.Key("Tables")
		if err := awsAwsjson11_serializeDocumentCatalogTablesList(v.Tables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogTargetList(v []types.CatalogTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCatalogTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentClassifierNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchEncryption(v *types.CloudWatchEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CloudWatchEncryptionMode) > 0 {
		ok := object.Key("CloudWatchEncryptionMode")
		ok.String(string(v.CloudWatchEncryptionMode))
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeGenConfigurationNode(v *types.CodeGenConfigurationNode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aggregate != nil {
		ok := object.Key("Aggregate")
		if err := awsAwsjson11_serializeDocumentAggregate(v.Aggregate, ok); err != nil {
			return err
		}
	}

	if v.AmazonRedshiftSource != nil {
		ok := object.Key("AmazonRedshiftSource")
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftSource(v.AmazonRedshiftSource, ok); err != nil {
			return err
		}
	}

	if v.AmazonRedshiftTarget != nil {
		ok := object.Key("AmazonRedshiftTarget")
		if err := awsAwsjson11_serializeDocumentAmazonRedshiftTarget(v.AmazonRedshiftTarget, ok); err != nil {
			return err
		}
	}

	if v.ApplyMapping != nil {
		ok := object.Key("ApplyMapping")
		if err := awsAwsjson11_serializeDocumentApplyMapping(v.ApplyMapping, ok); err != nil {
			return err
		}
	}

	if v.AthenaConnectorSource != nil {
		ok := object.Key("AthenaConnectorSource")
		if err := awsAwsjson11_serializeDocumentAthenaConnectorSource(v.AthenaConnectorSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogDeltaSource != nil {
		ok := object.Key("CatalogDeltaSource")
		if err := awsAwsjson11_serializeDocumentCatalogDeltaSource(v.CatalogDeltaSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogHudiSource != nil {
		ok := object.Key("CatalogHudiSource")
		if err := awsAwsjson11_serializeDocumentCatalogHudiSource(v.CatalogHudiSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogKafkaSource != nil {
		ok := object.Key("CatalogKafkaSource")
		if err := awsAwsjson11_serializeDocumentCatalogKafkaSource(v.CatalogKafkaSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogKinesisSource != nil {
		ok := object.Key("CatalogKinesisSource")
		if err := awsAwsjson11_serializeDocumentCatalogKinesisSource(v.CatalogKinesisSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogSource != nil {
		ok := object.Key("CatalogSource")
		if err := awsAwsjson11_serializeDocumentCatalogSource(v.CatalogSource, ok); err != nil {
			return err
		}
	}

	if v.CatalogTarget != nil {
		ok := object.Key("CatalogTarget")
		if err := awsAwsjson11_serializeDocumentBasicCatalogTarget(v.CatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.ConnectorDataSource != nil {
		ok := object.Key("ConnectorDataSource")
		if err := awsAwsjson11_serializeDocumentConnectorDataSource(v.ConnectorDataSource, ok); err != nil {
			return err
		}
	}

	if v.ConnectorDataTarget != nil {
		ok := object.Key("ConnectorDataTarget")
		if err := awsAwsjson11_serializeDocumentConnectorDataTarget(v.ConnectorDataTarget, ok); err != nil {
			return err
		}
	}

	if v.CustomCode != nil {
		ok := object.Key("CustomCode")
		if err := awsAwsjson11_serializeDocumentCustomCode(v.CustomCode, ok); err != nil {
			return err
		}
	}

	if v.DirectJDBCSource != nil {
		ok := object.Key("DirectJDBCSource")
		if err := awsAwsjson11_serializeDocumentDirectJDBCSource(v.DirectJDBCSource, ok); err != nil {
			return err
		}
	}

	if v.DirectKafkaSource != nil {
		ok := object.Key("DirectKafkaSource")
		if err := awsAwsjson11_serializeDocumentDirectKafkaSource(v.DirectKafkaSource, ok); err != nil {
			return err
		}
	}

	if v.DirectKinesisSource != nil {
		ok := object.Key("DirectKinesisSource")
		if err := awsAwsjson11_serializeDocumentDirectKinesisSource(v.DirectKinesisSource, ok); err != nil {
			return err
		}
	}

	if v.DropDuplicates != nil {
		ok := object.Key("DropDuplicates")
		if err := awsAwsjson11_serializeDocumentDropDuplicates(v.DropDuplicates, ok); err != nil {
			return err
		}
	}

	if v.DropFields != nil {
		ok := object.Key("DropFields")
		if err := awsAwsjson11_serializeDocumentDropFields(v.DropFields, ok); err != nil {
			return err
		}
	}

	if v.DropNullFields != nil {
		ok := object.Key("DropNullFields")
		if err := awsAwsjson11_serializeDocumentDropNullFields(v.DropNullFields, ok); err != nil {
			return err
		}
	}

	if v.DynamicTransform != nil {
		ok := object.Key("DynamicTransform")
		if err := awsAwsjson11_serializeDocumentDynamicTransform(v.DynamicTransform, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBCatalogSource != nil {
		ok := object.Key("DynamoDBCatalogSource")
		if err := awsAwsjson11_serializeDocumentDynamoDBCatalogSource(v.DynamoDBCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.EvaluateDataQuality != nil {
		ok := object.Key("EvaluateDataQuality")
		if err := awsAwsjson11_serializeDocumentEvaluateDataQuality(v.EvaluateDataQuality, ok); err != nil {
			return err
		}
	}

	if v.EvaluateDataQualityMultiFrame != nil {
		ok := object.Key("EvaluateDataQualityMultiFrame")
		if err := awsAwsjson11_serializeDocumentEvaluateDataQualityMultiFrame(v.EvaluateDataQualityMultiFrame, ok); err != nil {
			return err
		}
	}

	if v.FillMissingValues != nil {
		ok := object.Key("FillMissingValues")
		if err := awsAwsjson11_serializeDocumentFillMissingValues(v.FillMissingValues, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.GovernedCatalogSource != nil {
		ok := object.Key("GovernedCatalogSource")
		if err := awsAwsjson11_serializeDocumentGovernedCatalogSource(v.GovernedCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.GovernedCatalogTarget != nil {
		ok := object.Key("GovernedCatalogTarget")
		if err := awsAwsjson11_serializeDocumentGovernedCatalogTarget(v.GovernedCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.JDBCConnectorSource != nil {
		ok := object.Key("JDBCConnectorSource")
		if err := awsAwsjson11_serializeDocumentJDBCConnectorSource(v.JDBCConnectorSource, ok); err != nil {
			return err
		}
	}

	if v.JDBCConnectorTarget != nil {
		ok := object.Key("JDBCConnectorTarget")
		if err := awsAwsjson11_serializeDocumentJDBCConnectorTarget(v.JDBCConnectorTarget, ok); err != nil {
			return err
		}
	}

	if v.Join != nil {
		ok := object.Key("Join")
		if err := awsAwsjson11_serializeDocumentJoin(v.Join, ok); err != nil {
			return err
		}
	}

	if v.Merge != nil {
		ok := object.Key("Merge")
		if err := awsAwsjson11_serializeDocumentMerge(v.Merge, ok); err != nil {
			return err
		}
	}

	if v.MicrosoftSQLServerCatalogSource != nil {
		ok := object.Key("MicrosoftSQLServerCatalogSource")
		if err := awsAwsjson11_serializeDocumentMicrosoftSQLServerCatalogSource(v.MicrosoftSQLServerCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.MicrosoftSQLServerCatalogTarget != nil {
		ok := object.Key("MicrosoftSQLServerCatalogTarget")
		if err := awsAwsjson11_serializeDocumentMicrosoftSQLServerCatalogTarget(v.MicrosoftSQLServerCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.MySQLCatalogSource != nil {
		ok := object.Key("MySQLCatalogSource")
		if err := awsAwsjson11_serializeDocumentMySQLCatalogSource(v.MySQLCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.MySQLCatalogTarget != nil {
		ok := object.Key("MySQLCatalogTarget")
		if err := awsAwsjson11_serializeDocumentMySQLCatalogTarget(v.MySQLCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.OracleSQLCatalogSource != nil {
		ok := object.Key("OracleSQLCatalogSource")
		if err := awsAwsjson11_serializeDocumentOracleSQLCatalogSource(v.OracleSQLCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.OracleSQLCatalogTarget != nil {
		ok := object.Key("OracleSQLCatalogTarget")
		if err := awsAwsjson11_serializeDocumentOracleSQLCatalogTarget(v.OracleSQLCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.PIIDetection != nil {
		ok := object.Key("PIIDetection")
		if err := awsAwsjson11_serializeDocumentPIIDetection(v.PIIDetection, ok); err != nil {
			return err
		}
	}

	if v.PostgreSQLCatalogSource != nil {
		ok := object.Key("PostgreSQLCatalogSource")
		if err := awsAwsjson11_serializeDocumentPostgreSQLCatalogSource(v.PostgreSQLCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.PostgreSQLCatalogTarget != nil {
		ok := object.Key("PostgreSQLCatalogTarget")
		if err := awsAwsjson11_serializeDocumentPostgreSQLCatalogTarget(v.PostgreSQLCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.Recipe != nil {
		ok := object.Key("Recipe")
		if err := awsAwsjson11_serializeDocumentRecipe(v.Recipe, ok); err != nil {
			return err
		}
	}

	if v.RedshiftSource != nil {
		ok := object.Key("RedshiftSource")
		if err := awsAwsjson11_serializeDocumentRedshiftSource(v.RedshiftSource, ok); err != nil {
			return err
		}
	}

	if v.RedshiftTarget != nil {
		ok := object.Key("RedshiftTarget")
		if err := awsAwsjson11_serializeDocumentRedshiftTarget(v.RedshiftTarget, ok); err != nil {
			return err
		}
	}

	if v.RelationalCatalogSource != nil {
		ok := object.Key("RelationalCatalogSource")
		if err := awsAwsjson11_serializeDocumentRelationalCatalogSource(v.RelationalCatalogSource, ok); err != nil {
			return err
		}
	}

	if v.RenameField != nil {
		ok := object.Key("RenameField")
		if err := awsAwsjson11_serializeDocumentRenameField(v.RenameField, ok); err != nil {
			return err
		}
	}

	if v.S3CatalogDeltaSource != nil {
		ok := object.Key("S3CatalogDeltaSource")
		if err := awsAwsjson11_serializeDocumentS3CatalogDeltaSource(v.S3CatalogDeltaSource, ok); err != nil {
			return err
		}
	}

	if v.S3CatalogHudiSource != nil {
		ok := object.Key("S3CatalogHudiSource")
		if err := awsAwsjson11_serializeDocumentS3CatalogHudiSource(v.S3CatalogHudiSource, ok); err != nil {
			return err
		}
	}

	if v.S3CatalogSource != nil {
		ok := object.Key("S3CatalogSource")
		if err := awsAwsjson11_serializeDocumentS3CatalogSource(v.S3CatalogSource, ok); err != nil {
			return err
		}
	}

	if v.S3CatalogTarget != nil {
		ok := object.Key("S3CatalogTarget")
		if err := awsAwsjson11_serializeDocumentS3CatalogTarget(v.S3CatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.S3CsvSource != nil {
		ok := object.Key("S3CsvSource")
		if err := awsAwsjson11_serializeDocumentS3CsvSource(v.S3CsvSource, ok); err != nil {
			return err
		}
	}

	if v.S3DeltaCatalogTarget != nil {
		ok := object.Key("S3DeltaCatalogTarget")
		if err := awsAwsjson11_serializeDocumentS3DeltaCatalogTarget(v.S3DeltaCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.S3DeltaDirectTarget != nil {
		ok := object.Key("S3DeltaDirectTarget")
		if err := awsAwsjson11_serializeDocumentS3DeltaDirectTarget(v.S3DeltaDirectTarget, ok); err != nil {
			return err
		}
	}

	if v.S3DeltaSource != nil {
		ok := object.Key("S3DeltaSource")
		if err := awsAwsjson11_serializeDocumentS3DeltaSource(v.S3DeltaSource, ok); err != nil {
			return err
		}
	}

	if v.S3DirectTarget != nil {
		ok := object.Key("S3DirectTarget")
		if err := awsAwsjson11_serializeDocumentS3DirectTarget(v.S3DirectTarget, ok); err != nil {
			return err
		}
	}

	if v.S3GlueParquetTarget != nil {
		ok := object.Key("S3GlueParquetTarget")
		if err := awsAwsjson11_serializeDocumentS3GlueParquetTarget(v.S3GlueParquetTarget, ok); err != nil {
			return err
		}
	}

	if v.S3HudiCatalogTarget != nil {
		ok := object.Key("S3HudiCatalogTarget")
		if err := awsAwsjson11_serializeDocumentS3HudiCatalogTarget(v.S3HudiCatalogTarget, ok); err != nil {
			return err
		}
	}

	if v.S3HudiDirectTarget != nil {
		ok := object.Key("S3HudiDirectTarget")
		if err := awsAwsjson11_serializeDocumentS3HudiDirectTarget(v.S3HudiDirectTarget, ok); err != nil {
			return err
		}
	}

	if v.S3HudiSource != nil {
		ok := object.Key("S3HudiSource")
		if err := awsAwsjson11_serializeDocumentS3HudiSource(v.S3HudiSource, ok); err != nil {
			return err
		}
	}

	if v.S3JsonSource != nil {
		ok := object.Key("S3JsonSource")
		if err := awsAwsjson11_serializeDocumentS3JsonSource(v.S3JsonSource, ok); err != nil {
			return err
		}
	}

	if v.S3ParquetSource != nil {
		ok := object.Key("S3ParquetSource")
		if err := awsAwsjson11_serializeDocumentS3ParquetSource(v.S3ParquetSource, ok); err != nil {
			return err
		}
	}

	if v.SelectFields != nil {
		ok := object.Key("SelectFields")
		if err := awsAwsjson11_serializeDocumentSelectFields(v.SelectFields, ok); err != nil {
			return err
		}
	}

	if v.SelectFromCollection != nil {
		ok := object.Key("SelectFromCollection")
		if err := awsAwsjson11_serializeDocumentSelectFromCollection(v.SelectFromCollection, ok); err != nil {
			return err
		}
	}

	if v.SnowflakeSource != nil {
		ok := object.Key("SnowflakeSource")
		if err := awsAwsjson11_serializeDocumentSnowflakeSource(v.SnowflakeSource, ok); err != nil {
			return err
		}
	}

	if v.SnowflakeTarget != nil {
		ok := object.Key("SnowflakeTarget")
		if err := awsAwsjson11_serializeDocumentSnowflakeTarget(v.SnowflakeTarget, ok); err != nil {
			return err
		}
	}

	if v.SparkConnectorSource != nil {
		ok := object.Key("SparkConnectorSource")
		if err := awsAwsjson11_serializeDocumentSparkConnectorSource(v.SparkConnectorSource, ok); err != nil {
			return err
		}
	}

	if v.SparkConnectorTarget != nil {
		ok := object.Key("SparkConnectorTarget")
		if err := awsAwsjson11_serializeDocumentSparkConnectorTarget(v.SparkConnectorTarget, ok); err != nil {
			return err
		}
	}

	if v.SparkSQL != nil {
		ok := object.Key("SparkSQL")
		if err := awsAwsjson11_serializeDocumentSparkSQL(v.SparkSQL, ok); err != nil {
			return err
		}
	}

	if v.Spigot != nil {
		ok := object.Key("Spigot")
		if err := awsAwsjson11_serializeDocumentSpigot(v.Spigot, ok); err != nil {
			return err
		}
	}

	if v.SplitFields != nil {
		ok := object.Key("SplitFields")
		if err := awsAwsjson11_serializeDocumentSplitFields(v.SplitFields, ok); err != nil {
			return err
		}
	}

	if v.Union != nil {
		ok := object.Key("Union")
		if err := awsAwsjson11_serializeDocumentUnion(v.Union, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeGenConfigurationNodes(v map[string]types.CodeGenConfigurationNode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentCodeGenConfigurationNode(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCodeGenEdge(v *types.CodeGenEdge, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	if v.TargetParameter != nil {
		ok := object.Key("TargetParameter")
		ok.String(*v.TargetParameter)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeGenNode(v *types.CodeGenNode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Args != nil {
		ok := object.Key("Args")
		if err := awsAwsjson11_serializeDocumentCodeGenNodeArgs(v.Args, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LineNumber != 0 {
		ok := object.Key("LineNumber")
		ok.Integer(v.LineNumber)
	}

	if v.NodeType != nil {
		ok := object.Key("NodeType")
		ok.String(*v.NodeType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeGenNodeArg(v *types.CodeGenNodeArg, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Param {
		ok := object.Key("Param")
		ok.Boolean(v.Param)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeGenNodeArgs(v []types.CodeGenNodeArg, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCodeGenNodeArg(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentColumn(v *types.Column, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("Comment")
		ok.String(*v.Comment)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsAwsjson11_serializeDocumentColumnList(v []types.Column, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentColumnNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentColumnStatistics(v *types.ColumnStatistics, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyzedTime != nil {
		ok := object.Key("AnalyzedTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.AnalyzedTime))
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.ColumnType != nil {
		ok := object.Key("ColumnType")
		ok.String(*v.ColumnType)
	}

	if v.StatisticsData != nil {
		ok := object.Key("StatisticsData")
		if err := awsAwsjson11_serializeDocumentColumnStatisticsData(v.StatisticsData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentColumnStatisticsData(v *types.ColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinaryColumnStatisticsData != nil {
		ok := object.Key("BinaryColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentBinaryColumnStatisticsData(v.BinaryColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.BooleanColumnStatisticsData != nil {
		ok := object.Key("BooleanColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentBooleanColumnStatisticsData(v.BooleanColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.DateColumnStatisticsData != nil {
		ok := object.Key("DateColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentDateColumnStatisticsData(v.DateColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.DecimalColumnStatisticsData != nil {
		ok := object.Key("DecimalColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentDecimalColumnStatisticsData(v.DecimalColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.DoubleColumnStatisticsData != nil {
		ok := object.Key("DoubleColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentDoubleColumnStatisticsData(v.DoubleColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.LongColumnStatisticsData != nil {
		ok := object.Key("LongColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentLongColumnStatisticsData(v.LongColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if v.StringColumnStatisticsData != nil {
		ok := object.Key("StringColumnStatisticsData")
		if err := awsAwsjson11_serializeDocumentStringColumnStatisticsData(v.StringColumnStatisticsData, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentColumnValueStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	if len(v.CrawlState) > 0 {
		ok := object.Key("CrawlState")
		ok.String(string(v.CrawlState))
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if len(v.LogicalOperator) > 0 {
		ok := object.Key("LogicalOperator")
		ok.String(string(v.LogicalOperator))
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	return nil
}

func awsAwsjson11_serializeDocumentConditionExpression(v *types.ConditionExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("Condition")
		ok.String(*v.Condition)
	}

	if v.TargetColumn != nil {
		ok := object.Key("TargetColumn")
		ok.String(*v.TargetColumn)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentConditionExpressionList(v []types.ConditionExpression, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentConditionExpression(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentConditionList(v []types.Condition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentConfigurationMap(v map[string]types.ConfigurationObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentConfigurationObject(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentConfigurationObject(v *types.ConfigurationObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedValues != nil {
		ok := object.Key("AllowedValues")
		if err := awsAwsjson11_serializeDocumentAllowedValuesStringList(v.AllowedValues, ok); err != nil {
			return err
		}
	}

	if v.DefaultValue != nil {
		ok := object.Key("DefaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.MaxValue != nil {
		ok := object.Key("MaxValue")
		ok.String(*v.MaxValue)
	}

	if v.MinValue != nil {
		ok := object.Key("MinValue")
		ok.String(*v.MinValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectionInput(v *types.ConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("AuthenticationConfiguration")
		if err := awsAwsjson11_serializeDocumentAuthenticationConfigurationInput(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ConnectionProperties != nil {
		ok := object.Key("ConnectionProperties")
		if err := awsAwsjson11_serializeDocumentConnectionProperties(v.ConnectionProperties, ok); err != nil {
			return err
		}
	}

	if len(v.ConnectionType) > 0 {
		ok := object.Key("ConnectionType")
		ok.String(string(v.ConnectionType))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.MatchCriteria != nil {
		ok := object.Key("MatchCriteria")
		if err := awsAwsjson11_serializeDocumentMatchCriteria(v.MatchCriteria, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PhysicalConnectionRequirements != nil {
		ok := object.Key("PhysicalConnectionRequirements")
		if err := awsAwsjson11_serializeDocumentPhysicalConnectionRequirements(v.PhysicalConnectionRequirements, ok); err != nil {
			return err
		}
	}

	if v.ValidateCredentials {
		ok := object.Key("ValidateCredentials")
		ok.Boolean(v.ValidateCredentials)
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectionPasswordEncryption(v *types.ConnectionPasswordEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsKmsKeyId != nil {
		ok := object.Key("AwsKmsKeyId")
		ok.String(*v.AwsKmsKeyId)
	}

	{
		ok := object.Key("ReturnConnectionPasswordEncrypted")
		ok.Boolean(v.ReturnConnectionPasswordEncrypted)
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectionProperties(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentConnectionsList(v *types.ConnectionsList, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Connections != nil {
		ok := object.Key("Connections")
		if err := awsAwsjson11_serializeDocumentOrchestrationStringList(v.Connections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectorDataSource(v *types.ConnectorDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentConnectorOptions(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectorDataTarget(v *types.ConnectorDataTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentConnectorOptions(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectorOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentContextWords(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCrawlerNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCrawlerTargets(v *types.CrawlerTargets, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogTargets != nil {
		ok := object.Key("CatalogTargets")
		if err := awsAwsjson11_serializeDocumentCatalogTargetList(v.CatalogTargets, ok); err != nil {
			return err
		}
	}

	if v.DeltaTargets != nil {
		ok := object.Key("DeltaTargets")
		if err := awsAwsjson11_serializeDocumentDeltaTargetList(v.DeltaTargets, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBTargets != nil {
		ok := object.Key("DynamoDBTargets")
		if err := awsAwsjson11_serializeDocumentDynamoDBTargetList(v.DynamoDBTargets, ok); err != nil {
			return err
		}
	}

	if v.HudiTargets != nil {
		ok := object.Key("HudiTargets")
		if err := awsAwsjson11_serializeDocumentHudiTargetList(v.HudiTargets, ok); err != nil {
			return err
		}
	}

	if v.IcebergTargets != nil {
		ok := object.Key("IcebergTargets")
		if err := awsAwsjson11_serializeDocumentIcebergTargetList(v.IcebergTargets, ok); err != nil {
			return err
		}
	}

	if v.JdbcTargets != nil {
		ok := object.Key("JdbcTargets")
		if err := awsAwsjson11_serializeDocumentJdbcTargetList(v.JdbcTargets, ok); err != nil {
			return err
		}
	}

	if v.MongoDBTargets != nil {
		ok := object.Key("MongoDBTargets")
		if err := awsAwsjson11_serializeDocumentMongoDBTargetList(v.MongoDBTargets, ok); err != nil {
			return err
		}
	}

	if v.S3Targets != nil {
		ok := object.Key("S3Targets")
		if err := awsAwsjson11_serializeDocumentS3TargetList(v.S3Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCrawlsFilter(v *types.CrawlsFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FieldName) > 0 {
		ok := object.Key("FieldName")
		ok.String(string(v.FieldName))
	}

	if v.FieldValue != nil {
		ok := object.Key("FieldValue")
		ok.String(*v.FieldValue)
	}

	if len(v.FilterOperator) > 0 {
		ok := object.Key("FilterOperator")
		ok.String(string(v.FilterOperator))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCrawlsFilterList(v []types.CrawlsFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCrawlsFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCreateCsvClassifierRequest(v *types.CreateCsvClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowSingleColumn != nil {
		ok := object.Key("AllowSingleColumn")
		ok.Boolean(*v.AllowSingleColumn)
	}

	if len(v.ContainsHeader) > 0 {
		ok := object.Key("ContainsHeader")
		ok.String(string(v.ContainsHeader))
	}

	if v.CustomDatatypeConfigured != nil {
		ok := object.Key("CustomDatatypeConfigured")
		ok.Boolean(*v.CustomDatatypeConfigured)
	}

	if v.CustomDatatypes != nil {
		ok := object.Key("CustomDatatypes")
		if err := awsAwsjson11_serializeDocumentCustomDatatypes(v.CustomDatatypes, ok); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DisableValueTrimming != nil {
		ok := object.Key("DisableValueTrimming")
		ok.Boolean(*v.DisableValueTrimming)
	}

	if v.Header != nil {
		ok := object.Key("Header")
		if err := awsAwsjson11_serializeDocumentCsvHeader(v.Header, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QuoteSymbol != nil {
		ok := object.Key("QuoteSymbol")
		ok.String(*v.QuoteSymbol)
	}

	if len(v.Serde) > 0 {
		ok := object.Key("Serde")
		ok.String(string(v.Serde))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateGrokClassifierRequest(v *types.CreateGrokClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.CustomPatterns != nil {
		ok := object.Key("CustomPatterns")
		ok.String(*v.CustomPatterns)
	}

	if v.GrokPattern != nil {
		ok := object.Key("GrokPattern")
		ok.String(*v.GrokPattern)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateJsonClassifierRequest(v *types.CreateJsonClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonPath != nil {
		ok := object.Key("JsonPath")
		ok.String(*v.JsonPath)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateXMLClassifierRequest(v *types.CreateXMLClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RowTag != nil {
		ok := object.Key("RowTag")
		ok.String(*v.RowTag)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCsvHeader(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomCode(v *types.CustomCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClassName != nil {
		ok := object.Key("ClassName")
		ok.String(*v.ClassName)
	}

	if v.Code != nil {
		ok := object.Key("Code")
		ok.String(*v.Code)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentManyInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomDatatypes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomEntityTypeNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDagEdges(v []types.CodeGenEdge, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCodeGenEdge(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDagNodes(v []types.CodeGenNode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCodeGenNode(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDatabaseAttributesList(v []types.DatabaseAttributes, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDatabaseIdentifier(v *types.DatabaseIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDatabaseInput(v *types.DatabaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreateTableDefaultPermissions != nil {
		ok := object.Key("CreateTableDefaultPermissions")
		if err := awsAwsjson11_serializeDocumentPrincipalPermissionsList(v.CreateTableDefaultPermissions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FederatedDatabase != nil {
		ok := object.Key("FederatedDatabase")
		if err := awsAwsjson11_serializeDocumentFederatedDatabase(v.FederatedDatabase, ok); err != nil {
			return err
		}
	}

	if v.LocationUri != nil {
		ok := object.Key("LocationUri")
		ok.String(*v.LocationUri)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.TargetDatabase != nil {
		ok := object.Key("TargetDatabase")
		if err := awsAwsjson11_serializeDocumentDatabaseIdentifier(v.TargetDatabase, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataCatalogEncryptionSettings(v *types.DataCatalogEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionPasswordEncryption != nil {
		ok := object.Key("ConnectionPasswordEncryption")
		if err := awsAwsjson11_serializeDocumentConnectionPasswordEncryption(v.ConnectionPasswordEncryption, ok); err != nil {
			return err
		}
	}

	if v.EncryptionAtRest != nil {
		ok := object.Key("EncryptionAtRest")
		if err := awsAwsjson11_serializeDocumentEncryptionAtRest(v.EncryptionAtRest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataLakePrincipal(v *types.DataLakePrincipal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataLakePrincipalIdentifier != nil {
		ok := object.Key("DataLakePrincipalIdentifier")
		ok.String(*v.DataLakePrincipalIdentifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityEvaluationRunAdditionalRunOptions(v *types.DataQualityEvaluationRunAdditionalRunOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchMetricsEnabled != nil {
		ok := object.Key("CloudWatchMetricsEnabled")
		ok.Boolean(*v.CloudWatchMetricsEnabled)
	}

	if len(v.CompositeRuleEvaluationMethod) > 0 {
		ok := object.Key("CompositeRuleEvaluationMethod")
		ok.String(string(v.CompositeRuleEvaluationMethod))
	}

	if v.ResultsS3Prefix != nil {
		ok := object.Key("ResultsS3Prefix")
		ok.String(*v.ResultsS3Prefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityResultFilterCriteria(v *types.DataQualityResultFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		if err := awsAwsjson11_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.JobRunId != nil {
		ok := object.Key("JobRunId")
		ok.String(*v.JobRunId)
	}

	if v.StartedAfter != nil {
		ok := object.Key("StartedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedAfter))
	}

	if v.StartedBefore != nil {
		ok := object.Key("StartedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedBefore))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityResultIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDataQualityRuleRecommendationRunFilter(v *types.DataQualityRuleRecommendationRunFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		if err := awsAwsjson11_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.StartedAfter != nil {
		ok := object.Key("StartedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedAfter))
	}

	if v.StartedBefore != nil {
		ok := object.Key("StartedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedBefore))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityRulesetEvaluationRunFilter(v *types.DataQualityRulesetEvaluationRunFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		if err := awsAwsjson11_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.StartedAfter != nil {
		ok := object.Key("StartedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedAfter))
	}

	if v.StartedBefore != nil {
		ok := object.Key("StartedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedBefore))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityRulesetFilterCriteria(v *types.DataQualityRulesetFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedAfter != nil {
		ok := object.Key("CreatedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedAfter))
	}

	if v.CreatedBefore != nil {
		ok := object.Key("CreatedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedBefore))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LastModifiedAfter != nil {
		ok := object.Key("LastModifiedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastModifiedAfter))
	}

	if v.LastModifiedBefore != nil {
		ok := object.Key("LastModifiedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastModifiedBefore))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TargetTable != nil {
		ok := object.Key("TargetTable")
		if err := awsAwsjson11_serializeDocumentDataQualityTargetTable(v.TargetTable, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataQualityTargetTable(v *types.DataQualityTargetTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataSource(v *types.DataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlueTable != nil {
		ok := object.Key("GlueTable")
		if err := awsAwsjson11_serializeDocumentGlueTable(v.GlueTable, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataSourceMap(v map[string]types.DataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentDataSource(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDatatype(v *types.Datatype, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Label != nil {
		ok := object.Key("Label")
		ok.String(*v.Label)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDateColumnStatisticsData(v *types.DateColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumValue != nil {
		ok := object.Key("MaximumValue")
		ok.Double(smithytime.FormatEpochSeconds(*v.MaximumValue))
	}

	if v.MinimumValue != nil {
		ok := object.Key("MinimumValue")
		ok.Double(smithytime.FormatEpochSeconds(*v.MinimumValue))
	}

	{
		ok := object.Key("NumberOfDistinctValues")
		ok.Long(v.NumberOfDistinctValues)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDecimalColumnStatisticsData(v *types.DecimalColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumValue != nil {
		ok := object.Key("MaximumValue")
		if err := awsAwsjson11_serializeDocumentDecimalNumber(v.MaximumValue, ok); err != nil {
			return err
		}
	}

	if v.MinimumValue != nil {
		ok := object.Key("MinimumValue")
		if err := awsAwsjson11_serializeDocumentDecimalNumber(v.MinimumValue, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("NumberOfDistinctValues")
		ok.Long(v.NumberOfDistinctValues)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDecimalNumber(v *types.DecimalNumber, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Scale")
		ok.Integer(v.Scale)
	}

	if v.UnscaledValue != nil {
		ok := object.Key("UnscaledValue")
		ok.Base64EncodeBytes(v.UnscaledValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeleteConnectionNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeltaTarget(v *types.DeltaTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.CreateNativeDeltaTable != nil {
		ok := object.Key("CreateNativeDeltaTable")
		ok.Boolean(*v.CreateNativeDeltaTable)
	}

	if v.DeltaTables != nil {
		ok := object.Key("DeltaTables")
		if err := awsAwsjson11_serializeDocumentPathList(v.DeltaTables, ok); err != nil {
			return err
		}
	}

	if v.WriteManifest != nil {
		ok := object.Key("WriteManifest")
		ok.Boolean(*v.WriteManifest)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeltaTargetList(v []types.DeltaTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDeltaTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDevEndpointCustomLibraries(v *types.DevEndpointCustomLibraries, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExtraJarsS3Path != nil {
		ok := object.Key("ExtraJarsS3Path")
		ok.String(*v.ExtraJarsS3Path)
	}

	if v.ExtraPythonLibsS3Path != nil {
		ok := object.Key("ExtraPythonLibsS3Path")
		ok.String(*v.ExtraPythonLibsS3Path)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDevEndpointNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDirectJDBCSource(v *types.DirectJDBCSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if len(v.ConnectionType) > 0 {
		ok := object.Key("ConnectionType")
		ok.String(string(v.ConnectionType))
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RedshiftTmpDir != nil {
		ok := object.Key("RedshiftTmpDir")
		ok.String(*v.RedshiftTmpDir)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDirectKafkaSource(v *types.DirectKafkaSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPreviewOptions != nil {
		ok := object.Key("DataPreviewOptions")
		if err := awsAwsjson11_serializeDocumentStreamingDataPreviewOptions(v.DataPreviewOptions, ok); err != nil {
			return err
		}
	}

	if v.DetectSchema != nil {
		ok := object.Key("DetectSchema")
		ok.Boolean(*v.DetectSchema)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StreamingOptions != nil {
		ok := object.Key("StreamingOptions")
		if err := awsAwsjson11_serializeDocumentKafkaStreamingSourceOptions(v.StreamingOptions, ok); err != nil {
			return err
		}
	}

	if v.WindowSize != nil {
		ok := object.Key("WindowSize")
		ok.Integer(*v.WindowSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDirectKinesisSource(v *types.DirectKinesisSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPreviewOptions != nil {
		ok := object.Key("DataPreviewOptions")
		if err := awsAwsjson11_serializeDocumentStreamingDataPreviewOptions(v.DataPreviewOptions, ok); err != nil {
			return err
		}
	}

	if v.DetectSchema != nil {
		ok := object.Key("DetectSchema")
		ok.Boolean(*v.DetectSchema)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StreamingOptions != nil {
		ok := object.Key("StreamingOptions")
		if err := awsAwsjson11_serializeDocumentKinesisStreamingSourceOptions(v.StreamingOptions, ok); err != nil {
			return err
		}
	}

	if v.WindowSize != nil {
		ok := object.Key("WindowSize")
		ok.Integer(*v.WindowSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDirectSchemaChangePolicy(v *types.DirectSchemaChangePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.EnableUpdateCatalog != nil {
		ok := object.Key("EnableUpdateCatalog")
		ok.Boolean(*v.EnableUpdateCatalog)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if len(v.UpdateBehavior) > 0 {
		ok := object.Key("UpdateBehavior")
		ok.String(string(v.UpdateBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDoubleColumnStatisticsData(v *types.DoubleColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumValue != 0 {
		ok := object.Key("MaximumValue")
		switch {
		case math.IsNaN(v.MaximumValue):
			ok.String("NaN")

		case math.IsInf(v.MaximumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MaximumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MaximumValue)

		}
	}

	if v.MinimumValue != 0 {
		ok := object.Key("MinimumValue")
		switch {
		case math.IsNaN(v.MinimumValue):
			ok.String("NaN")

		case math.IsInf(v.MinimumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MinimumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MinimumValue)

		}
	}

	{
		ok := object.Key("NumberOfDistinctValues")
		ok.Long(v.NumberOfDistinctValues)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDQAdditionalOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDQDLAliases(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDQResultsPublishingOptions(v *types.DQResultsPublishingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchMetricsEnabled != nil {
		ok := object.Key("CloudWatchMetricsEnabled")
		ok.Boolean(*v.CloudWatchMetricsEnabled)
	}

	if v.EvaluationContext != nil {
		ok := object.Key("EvaluationContext")
		ok.String(*v.EvaluationContext)
	}

	if v.ResultsPublishingEnabled != nil {
		ok := object.Key("ResultsPublishingEnabled")
		ok.Boolean(*v.ResultsPublishingEnabled)
	}

	if v.ResultsS3Prefix != nil {
		ok := object.Key("ResultsS3Prefix")
		ok.String(*v.ResultsS3Prefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDQStopJobOnFailureOptions(v *types.DQStopJobOnFailureOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StopJobOnFailureTiming) > 0 {
		ok := object.Key("StopJobOnFailureTiming")
		ok.String(string(v.StopJobOnFailureTiming))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDropDuplicates(v *types.DropDuplicates, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsAwsjson11_serializeDocumentLimitedPathList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDropFields(v *types.DropFields, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDropNullFields(v *types.DropNullFields, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NullCheckBoxList != nil {
		ok := object.Key("NullCheckBoxList")
		if err := awsAwsjson11_serializeDocumentNullCheckBoxList(v.NullCheckBoxList, ok); err != nil {
			return err
		}
	}

	if v.NullTextList != nil {
		ok := object.Key("NullTextList")
		if err := awsAwsjson11_serializeDocumentNullValueFields(v.NullTextList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDynamicTransform(v *types.DynamicTransform, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentTransformConfigParameterList(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.TransformName != nil {
		ok := object.Key("TransformName")
		ok.String(*v.TransformName)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDynamoDBCatalogSource(v *types.DynamoDBCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDynamoDBTarget(v *types.DynamoDBTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.ScanAll != nil {
		ok := object.Key("scanAll")
		ok.Boolean(*v.ScanAll)
	}

	if v.ScanRate != nil {
		ok := object.Key("scanRate")
		switch {
		case math.IsNaN(*v.ScanRate):
			ok.String("NaN")

		case math.IsInf(*v.ScanRate, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ScanRate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ScanRate)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDynamoDBTargetList(v []types.DynamoDBTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDynamoDBTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEnableAdditionalMetadata(v []types.JdbcMetadataEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentEnclosedInStringProperties(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEnclosedInStringPropertiesMinOne(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEncryptionAtRest(v *types.EncryptionAtRest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CatalogEncryptionMode) > 0 {
		ok := object.Key("CatalogEncryptionMode")
		ok.String(string(v.CatalogEncryptionMode))
	}

	if v.CatalogEncryptionServiceRole != nil {
		ok := object.Key("CatalogEncryptionServiceRole")
		ok.String(*v.CatalogEncryptionServiceRole)
	}

	if v.SseAwsKmsKeyId != nil {
		ok := object.Key("SseAwsKmsKeyId")
		ok.String(*v.SseAwsKmsKeyId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchEncryption != nil {
		ok := object.Key("CloudWatchEncryption")
		if err := awsAwsjson11_serializeDocumentCloudWatchEncryption(v.CloudWatchEncryption, ok); err != nil {
			return err
		}
	}

	if v.JobBookmarksEncryption != nil {
		ok := object.Key("JobBookmarksEncryption")
		if err := awsAwsjson11_serializeDocumentJobBookmarksEncryption(v.JobBookmarksEncryption, ok); err != nil {
			return err
		}
	}

	if v.S3Encryption != nil {
		ok := object.Key("S3Encryption")
		if err := awsAwsjson11_serializeDocumentS3EncryptionList(v.S3Encryption, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEvaluateDataQuality(v *types.EvaluateDataQuality, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Output) > 0 {
		ok := object.Key("Output")
		ok.String(string(v.Output))
	}

	if v.PublishingOptions != nil {
		ok := object.Key("PublishingOptions")
		if err := awsAwsjson11_serializeDocumentDQResultsPublishingOptions(v.PublishingOptions, ok); err != nil {
			return err
		}
	}

	if v.Ruleset != nil {
		ok := object.Key("Ruleset")
		ok.String(*v.Ruleset)
	}

	if v.StopJobOnFailureOptions != nil {
		ok := object.Key("StopJobOnFailureOptions")
		if err := awsAwsjson11_serializeDocumentDQStopJobOnFailureOptions(v.StopJobOnFailureOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEvaluateDataQualityMultiFrame(v *types.EvaluateDataQualityMultiFrame, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalDataSources != nil {
		ok := object.Key("AdditionalDataSources")
		if err := awsAwsjson11_serializeDocumentDQDLAliases(v.AdditionalDataSources, ok); err != nil {
			return err
		}
	}

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentDQAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentManyInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PublishingOptions != nil {
		ok := object.Key("PublishingOptions")
		if err := awsAwsjson11_serializeDocumentDQResultsPublishingOptions(v.PublishingOptions, ok); err != nil {
			return err
		}
	}

	if v.Ruleset != nil {
		ok := object.Key("Ruleset")
		ok.String(*v.Ruleset)
	}

	if v.StopJobOnFailureOptions != nil {
		ok := object.Key("StopJobOnFailureOptions")
		if err := awsAwsjson11_serializeDocumentDQStopJobOnFailureOptions(v.StopJobOnFailureOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventBatchingCondition(v *types.EventBatchingCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.BatchWindow != nil {
		ok := object.Key("BatchWindow")
		ok.Integer(*v.BatchWindow)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExecutionProperty(v *types.ExecutionProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxConcurrentRuns != 0 {
		ok := object.Key("MaxConcurrentRuns")
		ok.Integer(v.MaxConcurrentRuns)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFederatedDatabase(v *types.FederatedDatabase, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFillMissingValues(v *types.FillMissingValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilledPath != nil {
		ok := object.Key("FilledPath")
		ok.String(*v.FilledPath)
	}

	if v.ImputedPath != nil {
		ok := object.Key("ImputedPath")
		ok.String(*v.ImputedPath)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentFilterExpressions(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if len(v.LogicalOperator) > 0 {
		ok := object.Key("LogicalOperator")
		ok.String(string(v.LogicalOperator))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilterExpression(v *types.FilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Negated != nil {
		ok := object.Key("Negated")
		ok.Boolean(*v.Negated)
	}

	if len(v.Operation) > 0 {
		ok := object.Key("Operation")
		ok.String(string(v.Operation))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilterExpressions(v []types.FilterExpression, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFilterExpression(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFilterValue(v *types.FilterValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilterValues(v []types.FilterValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFilterValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFindMatchesParameters(v *types.FindMatchesParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccuracyCostTradeoff != nil {
		ok := object.Key("AccuracyCostTradeoff")
		switch {
		case math.IsNaN(*v.AccuracyCostTradeoff):
			ok.String("NaN")

		case math.IsInf(*v.AccuracyCostTradeoff, 1):
			ok.String("Infinity")

		case math.IsInf(*v.AccuracyCostTradeoff, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.AccuracyCostTradeoff)

		}
	}

	if v.EnforceProvidedLabels != nil {
		ok := object.Key("EnforceProvidedLabels")
		ok.Boolean(*v.EnforceProvidedLabels)
	}

	if v.PrecisionRecallTradeoff != nil {
		ok := object.Key("PrecisionRecallTradeoff")
		switch {
		case math.IsNaN(*v.PrecisionRecallTradeoff):
			ok.String("NaN")

		case math.IsInf(*v.PrecisionRecallTradeoff, 1):
			ok.String("Infinity")

		case math.IsInf(*v.PrecisionRecallTradeoff, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.PrecisionRecallTradeoff)

		}
	}

	if v.PrimaryKeyColumnName != nil {
		ok := object.Key("PrimaryKeyColumnName")
		ok.String(*v.PrimaryKeyColumnName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGenericMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGetColumnNamesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGetConnectionsFilter(v *types.GetConnectionsFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConnectionType) > 0 {
		ok := object.Key("ConnectionType")
		ok.String(string(v.ConnectionType))
	}

	if v.MatchCriteria != nil {
		ok := object.Key("MatchCriteria")
		if err := awsAwsjson11_serializeDocumentMatchCriteria(v.MatchCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueSchema(v *types.GlueSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsAwsjson11_serializeDocumentGlueStudioSchemaColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueSchemas(v []types.GlueSchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGlueSchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGlueStudioPathList(v [][]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGlueStudioSchemaColumn(v *types.GlueStudioSchemaColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueStudioSchemaColumnList(v []types.GlueStudioSchemaColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGlueStudioSchemaColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGlueTable(v *types.GlueTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentGlueTableAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueTableAdditionalOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGlueTables(v []types.GlueTable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGlueTable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGovernedCatalogSource(v *types.GovernedCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3SourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionPredicate != nil {
		ok := object.Key("PartitionPredicate")
		ok.String(*v.PartitionPredicate)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGovernedCatalogTarget(v *types.GovernedCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentCatalogSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHudiTarget(v *types.HudiTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentPathList(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.MaximumTraversalDepth != nil {
		ok := object.Key("MaximumTraversalDepth")
		ok.Integer(*v.MaximumTraversalDepth)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentPathList(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHudiTargetList(v []types.HudiTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentHudiTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentIcebergInput(v *types.IcebergInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MetadataOperation) > 0 {
		ok := object.Key("MetadataOperation")
		ok.String(string(v.MetadataOperation))
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentIcebergTarget(v *types.IcebergTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentPathList(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.MaximumTraversalDepth != nil {
		ok := object.Key("MaximumTraversalDepth")
		ok.Integer(*v.MaximumTraversalDepth)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentPathList(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentIcebergTargetList(v []types.IcebergTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentIcebergTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJDBCConnectorOptions(v *types.JDBCConnectorOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataTypeMapping != nil {
		ok := object.Key("DataTypeMapping")
		if err := awsAwsjson11_serializeDocumentJDBCDataTypeMapping(v.DataTypeMapping, ok); err != nil {
			return err
		}
	}

	if v.FilterPredicate != nil {
		ok := object.Key("FilterPredicate")
		ok.String(*v.FilterPredicate)
	}

	if v.JobBookmarkKeys != nil {
		ok := object.Key("JobBookmarkKeys")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.JobBookmarkKeys, ok); err != nil {
			return err
		}
	}

	if v.JobBookmarkKeysSortOrder != nil {
		ok := object.Key("JobBookmarkKeysSortOrder")
		ok.String(*v.JobBookmarkKeysSortOrder)
	}

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		ok.Long(*v.LowerBound)
	}

	if v.NumPartitions != nil {
		ok := object.Key("NumPartitions")
		ok.Long(*v.NumPartitions)
	}

	if v.PartitionColumn != nil {
		ok := object.Key("PartitionColumn")
		ok.String(*v.PartitionColumn)
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		ok.Long(*v.UpperBound)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJDBCConnectorSource(v *types.JDBCConnectorSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentJDBCConnectorOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.ConnectionTable != nil {
		ok := object.Key("ConnectionTable")
		ok.String(*v.ConnectionTable)
	}

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.ConnectorName != nil {
		ok := object.Key("ConnectorName")
		ok.String(*v.ConnectorName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Query != nil {
		ok := object.Key("Query")
		ok.String(*v.Query)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJDBCConnectorTarget(v *types.JDBCConnectorTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.ConnectionTable != nil {
		ok := object.Key("ConnectionTable")
		ok.String(*v.ConnectionTable)
	}

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.ConnectorName != nil {
		ok := object.Key("ConnectorName")
		ok.String(*v.ConnectorName)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentJDBCDataTypeMapping(v map[string]types.GlueRecordType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(string(v[key]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentJdbcTarget(v *types.JdbcTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.EnableAdditionalMetadata != nil {
		ok := object.Key("EnableAdditionalMetadata")
		if err := awsAwsjson11_serializeDocumentEnableAdditionalMetadata(v.EnableAdditionalMetadata, ok); err != nil {
			return err
		}
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentPathList(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJdbcTargetList(v []types.JdbcTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentJdbcTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJobBookmarksEncryption(v *types.JobBookmarksEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.JobBookmarksEncryptionMode) > 0 {
		ok := object.Key("JobBookmarksEncryptionMode")
		ok.String(string(v.JobBookmarksEncryptionMode))
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJobCommand(v *types.JobCommand, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PythonVersion != nil {
		ok := object.Key("PythonVersion")
		ok.String(*v.PythonVersion)
	}

	if v.Runtime != nil {
		ok := object.Key("Runtime")
		ok.String(*v.Runtime)
	}

	if v.ScriptLocation != nil {
		ok := object.Key("ScriptLocation")
		ok.String(*v.ScriptLocation)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJobNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentJobUpdate(v *types.JobUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedCapacity != 0 {
		ok := object.Key("AllocatedCapacity")
		ok.Integer(v.AllocatedCapacity)
	}

	if v.CodeGenConfigurationNodes != nil {
		ok := object.Key("CodeGenConfigurationNodes")
		if err := awsAwsjson11_serializeDocumentCodeGenConfigurationNodes(v.CodeGenConfigurationNodes, ok); err != nil {
			return err
		}
	}

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsAwsjson11_serializeDocumentJobCommand(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Connections != nil {
		ok := object.Key("Connections")
		if err := awsAwsjson11_serializeDocumentConnectionsList(v.Connections, ok); err != nil {
			return err
		}
	}

	if v.DefaultArguments != nil {
		ok := object.Key("DefaultArguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.DefaultArguments, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.ExecutionClass) > 0 {
		ok := object.Key("ExecutionClass")
		ok.String(string(v.ExecutionClass))
	}

	if v.ExecutionProperty != nil {
		ok := object.Key("ExecutionProperty")
		if err := awsAwsjson11_serializeDocumentExecutionProperty(v.ExecutionProperty, ok); err != nil {
			return err
		}
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if len(v.JobMode) > 0 {
		ok := object.Key("JobMode")
		ok.String(string(v.JobMode))
	}

	if v.LogUri != nil {
		ok := object.Key("LogUri")
		ok.String(*v.LogUri)
	}

	if v.MaintenanceWindow != nil {
		ok := object.Key("MaintenanceWindow")
		ok.String(*v.MaintenanceWindow)
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.MaxRetries != 0 {
		ok := object.Key("MaxRetries")
		ok.Integer(v.MaxRetries)
	}

	if v.NonOverridableArguments != nil {
		ok := object.Key("NonOverridableArguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.NonOverridableArguments, ok); err != nil {
			return err
		}
	}

	if v.NotificationProperty != nil {
		ok := object.Key("NotificationProperty")
		if err := awsAwsjson11_serializeDocumentNotificationProperty(v.NotificationProperty, ok); err != nil {
			return err
		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.SourceControlDetails != nil {
		ok := object.Key("SourceControlDetails")
		if err := awsAwsjson11_serializeDocumentSourceControlDetails(v.SourceControlDetails, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentJoin(v *types.Join, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsAwsjson11_serializeDocumentJoinColumns(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentTwoInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if len(v.JoinType) > 0 {
		ok := object.Key("JoinType")
		ok.String(string(v.JoinType))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJoinColumn(v *types.JoinColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.From != nil {
		ok := object.Key("From")
		ok.String(*v.From)
	}

	if v.Keys != nil {
		ok := object.Key("Keys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.Keys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentJoinColumns(v []types.JoinColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentJoinColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentKafkaStreamingSourceOptions(v *types.KafkaStreamingSourceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddRecordTimestamp != nil {
		ok := object.Key("AddRecordTimestamp")
		ok.String(*v.AddRecordTimestamp)
	}

	if v.Assign != nil {
		ok := object.Key("Assign")
		ok.String(*v.Assign)
	}

	if v.BootstrapServers != nil {
		ok := object.Key("BootstrapServers")
		ok.String(*v.BootstrapServers)
	}

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.EmitConsumerLagMetrics != nil {
		ok := object.Key("EmitConsumerLagMetrics")
		ok.String(*v.EmitConsumerLagMetrics)
	}

	if v.EndingOffsets != nil {
		ok := object.Key("EndingOffsets")
		ok.String(*v.EndingOffsets)
	}

	if v.IncludeHeaders != nil {
		ok := object.Key("IncludeHeaders")
		ok.Boolean(*v.IncludeHeaders)
	}

	if v.MaxOffsetsPerTrigger != nil {
		ok := object.Key("MaxOffsetsPerTrigger")
		ok.Long(*v.MaxOffsetsPerTrigger)
	}

	if v.MinPartitions != nil {
		ok := object.Key("MinPartitions")
		ok.Integer(*v.MinPartitions)
	}

	if v.NumRetries != nil {
		ok := object.Key("NumRetries")
		ok.Integer(*v.NumRetries)
	}

	if v.PollTimeoutMs != nil {
		ok := object.Key("PollTimeoutMs")
		ok.Long(*v.PollTimeoutMs)
	}

	if v.RetryIntervalMs != nil {
		ok := object.Key("RetryIntervalMs")
		ok.Long(*v.RetryIntervalMs)
	}

	if v.SecurityProtocol != nil {
		ok := object.Key("SecurityProtocol")
		ok.String(*v.SecurityProtocol)
	}

	if v.StartingOffsets != nil {
		ok := object.Key("StartingOffsets")
		ok.String(*v.StartingOffsets)
	}

	if v.StartingTimestamp != nil {
		ok := object.Key("StartingTimestamp")
		ok.String(smithytime.FormatDateTime(*v.StartingTimestamp))
	}

	if v.SubscribePattern != nil {
		ok := object.Key("SubscribePattern")
		ok.String(*v.SubscribePattern)
	}

	if v.TopicName != nil {
		ok := object.Key("TopicName")
		ok.String(*v.TopicName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamingSourceOptions(v *types.KinesisStreamingSourceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddIdleTimeBetweenReads != nil {
		ok := object.Key("AddIdleTimeBetweenReads")
		ok.Boolean(*v.AddIdleTimeBetweenReads)
	}

	if v.AddRecordTimestamp != nil {
		ok := object.Key("AddRecordTimestamp")
		ok.String(*v.AddRecordTimestamp)
	}

	if v.AvoidEmptyBatches != nil {
		ok := object.Key("AvoidEmptyBatches")
		ok.Boolean(*v.AvoidEmptyBatches)
	}

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DescribeShardInterval != nil {
		ok := object.Key("DescribeShardInterval")
		ok.Long(*v.DescribeShardInterval)
	}

	if v.EmitConsumerLagMetrics != nil {
		ok := object.Key("EmitConsumerLagMetrics")
		ok.String(*v.EmitConsumerLagMetrics)
	}

	if v.EndpointUrl != nil {
		ok := object.Key("EndpointUrl")
		ok.String(*v.EndpointUrl)
	}

	if v.IdleTimeBetweenReadsInMs != nil {
		ok := object.Key("IdleTimeBetweenReadsInMs")
		ok.Long(*v.IdleTimeBetweenReadsInMs)
	}

	if v.MaxFetchRecordsPerShard != nil {
		ok := object.Key("MaxFetchRecordsPerShard")
		ok.Long(*v.MaxFetchRecordsPerShard)
	}

	if v.MaxFetchTimeInMs != nil {
		ok := object.Key("MaxFetchTimeInMs")
		ok.Long(*v.MaxFetchTimeInMs)
	}

	if v.MaxRecordPerRead != nil {
		ok := object.Key("MaxRecordPerRead")
		ok.Long(*v.MaxRecordPerRead)
	}

	if v.MaxRetryIntervalMs != nil {
		ok := object.Key("MaxRetryIntervalMs")
		ok.Long(*v.MaxRetryIntervalMs)
	}

	if v.NumRetries != nil {
		ok := object.Key("NumRetries")
		ok.Integer(*v.NumRetries)
	}

	if v.RetryIntervalMs != nil {
		ok := object.Key("RetryIntervalMs")
		ok.Long(*v.RetryIntervalMs)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.RoleSessionName != nil {
		ok := object.Key("RoleSessionName")
		ok.String(*v.RoleSessionName)
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	if v.StartingTimestamp != nil {
		ok := object.Key("StartingTimestamp")
		ok.String(smithytime.FormatDateTime(*v.StartingTimestamp))
	}

	if v.StreamArn != nil {
		ok := object.Key("StreamArn")
		ok.String(*v.StreamArn)
	}

	if v.StreamName != nil {
		ok := object.Key("StreamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLakeFormationConfiguration(v *types.LakeFormationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("AccountId")
		ok.String(*v.AccountId)
	}

	if v.UseLakeFormationCredentials != nil {
		ok := object.Key("UseLakeFormationCredentials")
		ok.Boolean(*v.UseLakeFormationCredentials)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLimitedPathList(v [][]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson11_serializeDocumentLimitedStringList(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLimitedStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLineageConfiguration(v *types.LineageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CrawlerLineageSettings) > 0 {
		ok := object.Key("CrawlerLineageSettings")
		ok.String(string(v.CrawlerLineageSettings))
	}

	return nil
}

func awsAwsjson11_serializeDocumentLocation(v *types.Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamoDB != nil {
		ok := object.Key("DynamoDB")
		if err := awsAwsjson11_serializeDocumentCodeGenNodeArgs(v.DynamoDB, ok); err != nil {
			return err
		}
	}

	if v.Jdbc != nil {
		ok := object.Key("Jdbc")
		if err := awsAwsjson11_serializeDocumentCodeGenNodeArgs(v.Jdbc, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsAwsjson11_serializeDocumentCodeGenNodeArgs(v.S3, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentLocationMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLocationStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLongColumnStatisticsData(v *types.LongColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumValue != 0 {
		ok := object.Key("MaximumValue")
		ok.Long(v.MaximumValue)
	}

	if v.MinimumValue != 0 {
		ok := object.Key("MinimumValue")
		ok.Long(v.MinimumValue)
	}

	{
		ok := object.Key("NumberOfDistinctValues")
		ok.Long(v.NumberOfDistinctValues)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentManyInputs(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMapping(v *types.Mapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("Children")
		if err := awsAwsjson11_serializeDocumentMappings(v.Children, ok); err != nil {
			return err
		}
	}

	if v.Dropped != nil {
		ok := object.Key("Dropped")
		ok.Boolean(*v.Dropped)
	}

	if v.FromPath != nil {
		ok := object.Key("FromPath")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.FromPath, ok); err != nil {
			return err
		}
	}

	if v.FromType != nil {
		ok := object.Key("FromType")
		ok.String(*v.FromType)
	}

	if v.ToKey != nil {
		ok := object.Key("ToKey")
		ok.String(*v.ToKey)
	}

	if v.ToType != nil {
		ok := object.Key("ToType")
		ok.String(*v.ToType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMappingEntry(v *types.MappingEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourcePath != nil {
		ok := object.Key("SourcePath")
		ok.String(*v.SourcePath)
	}

	if v.SourceTable != nil {
		ok := object.Key("SourceTable")
		ok.String(*v.SourceTable)
	}

	if v.SourceType != nil {
		ok := object.Key("SourceType")
		ok.String(*v.SourceType)
	}

	if v.TargetPath != nil {
		ok := object.Key("TargetPath")
		ok.String(*v.TargetPath)
	}

	if v.TargetTable != nil {
		ok := object.Key("TargetTable")
		ok.String(*v.TargetTable)
	}

	if v.TargetType != nil {
		ok := object.Key("TargetType")
		ok.String(*v.TargetType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMappingList(v []types.MappingEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMappingEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMappings(v []types.Mapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMapValue(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMatchCriteria(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMerge(v *types.Merge, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentTwoInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PrimaryKeys != nil {
		ok := object.Key("PrimaryKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PrimaryKeys, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMetadataKeyValuePair(v *types.MetadataKeyValuePair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetadataKey != nil {
		ok := object.Key("MetadataKey")
		ok.String(*v.MetadataKey)
	}

	if v.MetadataValue != nil {
		ok := object.Key("MetadataValue")
		ok.String(*v.MetadataValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMetadataList(v []types.MetadataKeyValuePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMetadataKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMicrosoftSQLServerCatalogSource(v *types.MicrosoftSQLServerCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMicrosoftSQLServerCatalogTarget(v *types.MicrosoftSQLServerCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMLUserDataEncryption(v *types.MLUserDataEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if len(v.MlUserDataEncryptionMode) > 0 {
		ok := object.Key("MlUserDataEncryptionMode")
		ok.String(string(v.MlUserDataEncryptionMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentMongoDBTarget(v *types.MongoDBTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.ScanAll != nil {
		ok := object.Key("ScanAll")
		ok.Boolean(*v.ScanAll)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMongoDBTargetList(v []types.MongoDBTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMongoDBTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMySQLCatalogSource(v *types.MySQLCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMySQLCatalogTarget(v *types.MySQLCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNameStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentNodeIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentNotificationProperty(v *types.NotificationProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NotifyDelayAfter != nil {
		ok := object.Key("NotifyDelayAfter")
		ok.Integer(*v.NotifyDelayAfter)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNullCheckBoxList(v *types.NullCheckBoxList, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsEmpty != nil {
		ok := object.Key("IsEmpty")
		ok.Boolean(*v.IsEmpty)
	}

	if v.IsNegOne != nil {
		ok := object.Key("IsNegOne")
		ok.Boolean(*v.IsNegOne)
	}

	if v.IsNullString != nil {
		ok := object.Key("IsNullString")
		ok.Boolean(*v.IsNullString)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNullValueField(v *types.NullValueField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Datatype != nil {
		ok := object.Key("Datatype")
		if err := awsAwsjson11_serializeDocumentDatatype(v.Datatype, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNullValueFields(v []types.NullValueField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentNullValueField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOAuth2ClientApplication(v *types.OAuth2ClientApplication, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AWSManagedClientApplicationReference != nil {
		ok := object.Key("AWSManagedClientApplicationReference")
		ok.String(*v.AWSManagedClientApplicationReference)
	}

	if v.UserManagedClientApplicationClientId != nil {
		ok := object.Key("UserManagedClientApplicationClientId")
		ok.String(*v.UserManagedClientApplicationClientId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOAuth2PropertiesInput(v *types.OAuth2PropertiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationCodeProperties != nil {
		ok := object.Key("AuthorizationCodeProperties")
		if err := awsAwsjson11_serializeDocumentAuthorizationCodeProperties(v.AuthorizationCodeProperties, ok); err != nil {
			return err
		}
	}

	if v.OAuth2ClientApplication != nil {
		ok := object.Key("OAuth2ClientApplication")
		if err := awsAwsjson11_serializeDocumentOAuth2ClientApplication(v.OAuth2ClientApplication, ok); err != nil {
			return err
		}
	}

	if len(v.OAuth2GrantType) > 0 {
		ok := object.Key("OAuth2GrantType")
		ok.String(string(v.OAuth2GrantType))
	}

	if v.TokenUrl != nil {
		ok := object.Key("TokenUrl")
		ok.String(*v.TokenUrl)
	}

	if v.TokenUrlParametersMap != nil {
		ok := object.Key("TokenUrlParametersMap")
		if err := awsAwsjson11_serializeDocumentTokenUrlParametersMap(v.TokenUrlParametersMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOneInput(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOpenTableFormatInput(v *types.OpenTableFormatInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IcebergInput != nil {
		ok := object.Key("IcebergInput")
		if err := awsAwsjson11_serializeDocumentIcebergInput(v.IcebergInput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOption(v *types.Option, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Label != nil {
		ok := object.Key("Label")
		ok.String(*v.Label)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOptionList(v []types.Option, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOracleSQLCatalogSource(v *types.OracleSQLCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOracleSQLCatalogTarget(v *types.OracleSQLCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOrchestrationArgumentsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOrchestrationStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOrder(v *types.Order, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		ok.String(*v.Column)
	}

	{
		ok := object.Key("SortOrder")
		ok.Integer(v.SortOrder)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOrderList(v []types.Order, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOrder(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPartitionIndex(v *types.PartitionIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.Keys != nil {
		ok := object.Key("Keys")
		if err := awsAwsjson11_serializeDocumentKeyList(v.Keys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPartitionIndexList(v []types.PartitionIndex, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPartitionIndex(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPartitionInput(v *types.PartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastAccessTime != nil {
		ok := object.Key("LastAccessTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastAccessTime))
	}

	if v.LastAnalyzedTime != nil {
		ok := object.Key("LastAnalyzedTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastAnalyzedTime))
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.StorageDescriptor != nil {
		ok := object.Key("StorageDescriptor")
		if err := awsAwsjson11_serializeDocumentStorageDescriptor(v.StorageDescriptor, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPartitionInputList(v []types.PartitionInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPartitionInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPartitionValueList(v *types.PartitionValueList, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPermissionList(v []types.Permission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentPermissionTypeList(v []types.PermissionType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentPhysicalConnectionRequirements(v *types.PhysicalConnectionRequirements, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.SecurityGroupIdList != nil {
		ok := object.Key("SecurityGroupIdList")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIdList(v.SecurityGroupIdList, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPIIDetection(v *types.PIIDetection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityTypesToDetect != nil {
		ok := object.Key("EntityTypesToDetect")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.EntityTypesToDetect, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.MaskValue != nil {
		ok := object.Key("MaskValue")
		ok.String(*v.MaskValue)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputColumnName != nil {
		ok := object.Key("OutputColumnName")
		ok.String(*v.OutputColumnName)
	}

	if len(v.PiiType) > 0 {
		ok := object.Key("PiiType")
		ok.String(string(v.PiiType))
	}

	if v.SampleFraction != nil {
		ok := object.Key("SampleFraction")
		switch {
		case math.IsNaN(*v.SampleFraction):
			ok.String("NaN")

		case math.IsInf(*v.SampleFraction, 1):
			ok.String("Infinity")

		case math.IsInf(*v.SampleFraction, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.SampleFraction)

		}
	}

	if v.ThresholdFraction != nil {
		ok := object.Key("ThresholdFraction")
		switch {
		case math.IsNaN(*v.ThresholdFraction):
			ok.String("NaN")

		case math.IsInf(*v.ThresholdFraction, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThresholdFraction, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThresholdFraction)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPostgreSQLCatalogSource(v *types.PostgreSQLCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPostgreSQLCatalogTarget(v *types.PostgreSQLCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPredicate(v *types.Predicate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Conditions != nil {
		ok := object.Key("Conditions")
		if err := awsAwsjson11_serializeDocumentConditionList(v.Conditions, ok); err != nil {
			return err
		}
	}

	if len(v.Logical) > 0 {
		ok := object.Key("Logical")
		ok.String(string(v.Logical))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPrincipalPermissions(v *types.PrincipalPermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsAwsjson11_serializeDocumentPermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		if err := awsAwsjson11_serializeDocumentDataLakePrincipal(v.Principal, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPrincipalPermissionsList(v []types.PrincipalPermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPrincipalPermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentProfileConfiguration(v *types.ProfileConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobConfiguration != nil {
		ok := object.Key("JobConfiguration")
		if err := awsAwsjson11_serializeDocumentConfigurationMap(v.JobConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SessionConfiguration != nil {
		ok := object.Key("SessionConfiguration")
		if err := awsAwsjson11_serializeDocumentConfigurationMap(v.SessionConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPropertyPredicate(v *types.PropertyPredicate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparator) > 0 {
		ok := object.Key("Comparator")
		ok.String(string(v.Comparator))
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPublicKeysList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentQuerySessionContext(v *types.QuerySessionContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalContext != nil {
		ok := object.Key("AdditionalContext")
		if err := awsAwsjson11_serializeDocumentAdditionalContextMap(v.AdditionalContext, ok); err != nil {
			return err
		}
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.QueryAuthorizationId != nil {
		ok := object.Key("QueryAuthorizationId")
		ok.String(*v.QueryAuthorizationId)
	}

	if v.QueryId != nil {
		ok := object.Key("QueryId")
		ok.String(*v.QueryId)
	}

	if v.QueryStartTime != nil {
		ok := object.Key("QueryStartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryStartTime))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecipe(v *types.Recipe, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecipeReference != nil {
		ok := object.Key("RecipeReference")
		if err := awsAwsjson11_serializeDocumentRecipeReference(v.RecipeReference, ok); err != nil {
			return err
		}
	}

	if v.RecipeSteps != nil {
		ok := object.Key("RecipeSteps")
		if err := awsAwsjson11_serializeDocumentRecipeSteps(v.RecipeSteps, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecipeAction(v *types.RecipeAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operation != nil {
		ok := object.Key("Operation")
		ok.String(*v.Operation)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParameterMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecipeReference(v *types.RecipeReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecipeArn != nil {
		ok := object.Key("RecipeArn")
		ok.String(*v.RecipeArn)
	}

	if v.RecipeVersion != nil {
		ok := object.Key("RecipeVersion")
		ok.String(*v.RecipeVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecipeStep(v *types.RecipeStep, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsAwsjson11_serializeDocumentRecipeAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.ConditionExpressions != nil {
		ok := object.Key("ConditionExpressions")
		if err := awsAwsjson11_serializeDocumentConditionExpressionList(v.ConditionExpressions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecipeSteps(v []types.RecipeStep, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRecipeStep(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecrawlPolicy(v *types.RecrawlPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RecrawlBehavior) > 0 {
		ok := object.Key("RecrawlBehavior")
		ok.String(string(v.RecrawlBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftSource(v *types.RedshiftSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RedshiftTmpDir != nil {
		ok := object.Key("RedshiftTmpDir")
		ok.String(*v.RedshiftTmpDir)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.TmpDirIAMRole != nil {
		ok := object.Key("TmpDirIAMRole")
		ok.String(*v.TmpDirIAMRole)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftTarget(v *types.RedshiftTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RedshiftTmpDir != nil {
		ok := object.Key("RedshiftTmpDir")
		ok.String(*v.RedshiftTmpDir)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.TmpDirIAMRole != nil {
		ok := object.Key("TmpDirIAMRole")
		ok.String(*v.TmpDirIAMRole)
	}

	if v.UpsertRedshiftOptions != nil {
		ok := object.Key("UpsertRedshiftOptions")
		if err := awsAwsjson11_serializeDocumentUpsertRedshiftTargetOptions(v.UpsertRedshiftOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegistryId(v *types.RegistryId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistryArn != nil {
		ok := object.Key("RegistryArn")
		ok.String(*v.RegistryArn)
	}

	if v.RegistryName != nil {
		ok := object.Key("RegistryName")
		ok.String(*v.RegistryName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRelationalCatalogSource(v *types.RelationalCatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRenameField(v *types.RenameField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SourcePath != nil {
		ok := object.Key("SourcePath")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.SourcePath, ok); err != nil {
			return err
		}
	}

	if v.TargetPath != nil {
		ok := object.Key("TargetPath")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.TargetPath, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceUri(v *types.ResourceUri, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.Uri != nil {
		ok := object.Key("Uri")
		ok.String(*v.Uri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceUriList(v []types.ResourceUri, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentResourceUri(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRulesetNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3CatalogDeltaSource(v *types.S3CatalogDeltaSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalDeltaOptions != nil {
		ok := object.Key("AdditionalDeltaOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalDeltaOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3CatalogHudiSource(v *types.S3CatalogHudiSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalHudiOptions != nil {
		ok := object.Key("AdditionalHudiOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalHudiOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3CatalogSource(v *types.S3CatalogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3SourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionPredicate != nil {
		ok := object.Key("PartitionPredicate")
		ok.String(*v.PartitionPredicate)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3CatalogTarget(v *types.S3CatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentCatalogSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3CsvSource(v *types.S3CsvSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionType) > 0 {
		ok := object.Key("CompressionType")
		ok.String(string(v.CompressionType))
	}

	if v.Escaper != nil {
		ok := object.Key("Escaper")
		ok.String(*v.Escaper)
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.GroupFiles != nil {
		ok := object.Key("GroupFiles")
		ok.String(*v.GroupFiles)
	}

	if v.GroupSize != nil {
		ok := object.Key("GroupSize")
		ok.String(*v.GroupSize)
	}

	if v.MaxBand != nil {
		ok := object.Key("MaxBand")
		ok.Integer(*v.MaxBand)
	}

	if v.MaxFilesInBand != nil {
		ok := object.Key("MaxFilesInBand")
		ok.Integer(*v.MaxFilesInBand)
	}

	if v.Multiline != nil {
		ok := object.Key("Multiline")
		ok.Boolean(*v.Multiline)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OptimizePerformance {
		ok := object.Key("OptimizePerformance")
		ok.Boolean(v.OptimizePerformance)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Paths, ok); err != nil {
			return err
		}
	}

	if len(v.QuoteChar) > 0 {
		ok := object.Key("QuoteChar")
		ok.String(string(v.QuoteChar))
	}

	if v.Recurse != nil {
		ok := object.Key("Recurse")
		ok.Boolean(*v.Recurse)
	}

	if len(v.Separator) > 0 {
		ok := object.Key("Separator")
		ok.String(string(v.Separator))
	}

	if v.SkipFirst != nil {
		ok := object.Key("SkipFirst")
		ok.Boolean(*v.SkipFirst)
	}

	if v.WithHeader != nil {
		ok := object.Key("WithHeader")
		ok.Boolean(*v.WithHeader)
	}

	if v.WriteHeader != nil {
		ok := object.Key("WriteHeader")
		ok.Boolean(*v.WriteHeader)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DeltaCatalogTarget(v *types.S3DeltaCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentCatalogSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DeltaDirectTarget(v *types.S3DeltaDirectTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if len(v.Compression) > 0 {
		ok := object.Key("Compression")
		ok.String(string(v.Compression))
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentDirectSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DeltaSource(v *types.S3DeltaSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalDeltaOptions != nil {
		ok := object.Key("AdditionalDeltaOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalDeltaOptions, ok); err != nil {
			return err
		}
	}

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v *types.S3DirectSourceAdditionalOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundedFiles != nil {
		ok := object.Key("BoundedFiles")
		ok.Long(*v.BoundedFiles)
	}

	if v.BoundedSize != nil {
		ok := object.Key("BoundedSize")
		ok.Long(*v.BoundedSize)
	}

	if v.EnableSamplePath != nil {
		ok := object.Key("EnableSamplePath")
		ok.Boolean(*v.EnableSamplePath)
	}

	if v.SamplePath != nil {
		ok := object.Key("SamplePath")
		ok.String(*v.SamplePath)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DirectTarget(v *types.S3DirectTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Compression != nil {
		ok := object.Key("Compression")
		ok.String(*v.Compression)
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentDirectSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Encryption(v *types.S3Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if len(v.S3EncryptionMode) > 0 {
		ok := object.Key("S3EncryptionMode")
		ok.String(string(v.S3EncryptionMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3EncryptionList(v []types.S3Encryption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentS3Encryption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3GlueParquetTarget(v *types.S3GlueParquetTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Compression) > 0 {
		ok := object.Key("Compression")
		ok.String(string(v.Compression))
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentDirectSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3HudiCatalogTarget(v *types.S3HudiCatalogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentCatalogSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3HudiDirectTarget(v *types.S3HudiDirectTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if len(v.Compression) > 0 {
		ok := object.Key("Compression")
		ok.String(string(v.Compression))
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentDirectSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3HudiSource(v *types.S3HudiSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalHudiOptions != nil {
		ok := object.Key("AdditionalHudiOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalHudiOptions, ok); err != nil {
			return err
		}
	}

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3JsonSource(v *types.S3JsonSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionType) > 0 {
		ok := object.Key("CompressionType")
		ok.String(string(v.CompressionType))
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.GroupFiles != nil {
		ok := object.Key("GroupFiles")
		ok.String(*v.GroupFiles)
	}

	if v.GroupSize != nil {
		ok := object.Key("GroupSize")
		ok.String(*v.GroupSize)
	}

	if v.JsonPath != nil {
		ok := object.Key("JsonPath")
		ok.String(*v.JsonPath)
	}

	if v.MaxBand != nil {
		ok := object.Key("MaxBand")
		ok.Integer(*v.MaxBand)
	}

	if v.MaxFilesInBand != nil {
		ok := object.Key("MaxFilesInBand")
		ok.Integer(*v.MaxFilesInBand)
	}

	if v.Multiline != nil {
		ok := object.Key("Multiline")
		ok.Boolean(*v.Multiline)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Paths, ok); err != nil {
			return err
		}
	}

	if v.Recurse != nil {
		ok := object.Key("Recurse")
		ok.Boolean(*v.Recurse)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ParquetSource(v *types.S3ParquetSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentS3DirectSourceAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionType) > 0 {
		ok := object.Key("CompressionType")
		ok.String(string(v.CompressionType))
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.GroupFiles != nil {
		ok := object.Key("GroupFiles")
		ok.String(*v.GroupFiles)
	}

	if v.GroupSize != nil {
		ok := object.Key("GroupSize")
		ok.String(*v.GroupSize)
	}

	if v.MaxBand != nil {
		ok := object.Key("MaxBand")
		ok.Integer(*v.MaxBand)
	}

	if v.MaxFilesInBand != nil {
		ok := object.Key("MaxFilesInBand")
		ok.Integer(*v.MaxFilesInBand)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Paths, ok); err != nil {
			return err
		}
	}

	if v.Recurse != nil {
		ok := object.Key("Recurse")
		ok.Boolean(*v.Recurse)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3SourceAdditionalOptions(v *types.S3SourceAdditionalOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundedFiles != nil {
		ok := object.Key("BoundedFiles")
		ok.Long(*v.BoundedFiles)
	}

	if v.BoundedSize != nil {
		ok := object.Key("BoundedSize")
		ok.Long(*v.BoundedSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Target(v *types.S3Target, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.DlqEventQueueArn != nil {
		ok := object.Key("DlqEventQueueArn")
		ok.String(*v.DlqEventQueueArn)
	}

	if v.EventQueueArn != nil {
		ok := object.Key("EventQueueArn")
		ok.String(*v.EventQueueArn)
	}

	if v.Exclusions != nil {
		ok := object.Key("Exclusions")
		if err := awsAwsjson11_serializeDocumentPathList(v.Exclusions, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SampleSize != nil {
		ok := object.Key("SampleSize")
		ok.Integer(*v.SampleSize)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3TargetList(v []types.S3Target, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentS3Target(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSchemaChangePolicy(v *types.SchemaChangePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeleteBehavior) > 0 {
		ok := object.Key("DeleteBehavior")
		ok.String(string(v.DeleteBehavior))
	}

	if len(v.UpdateBehavior) > 0 {
		ok := object.Key("UpdateBehavior")
		ok.String(string(v.UpdateBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaColumn(v *types.SchemaColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataType != nil {
		ok := object.Key("DataType")
		ok.String(*v.DataType)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaId(v *types.SchemaId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistryName != nil {
		ok := object.Key("RegistryName")
		ok.String(*v.RegistryName)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	if v.SchemaName != nil {
		ok := object.Key("SchemaName")
		ok.String(*v.SchemaName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaReference(v *types.SchemaReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionId != nil {
		ok := object.Key("SchemaVersionId")
		ok.String(*v.SchemaVersionId)
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		ok.Long(*v.SchemaVersionNumber)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaVersionNumber(v *types.SchemaVersionNumber, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LatestVersion {
		ok := object.Key("LatestVersion")
		ok.Boolean(v.LatestVersion)
	}

	if v.VersionNumber != nil {
		ok := object.Key("VersionNumber")
		ok.Long(*v.VersionNumber)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSearchPropertyPredicates(v []types.PropertyPredicate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPropertyPredicate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSegment(v *types.Segment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("SegmentNumber")
		ok.Integer(v.SegmentNumber)
	}

	if v.TotalSegments != nil {
		ok := object.Key("TotalSegments")
		ok.Integer(*v.TotalSegments)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSelectFields(v *types.SelectFields, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSelectFromCollection(v *types.SelectFromCollection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Index")
		ok.Integer(v.Index)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSerDeInfo(v *types.SerDeInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SerializationLibrary != nil {
		ok := object.Key("SerializationLibrary")
		ok.String(*v.SerializationLibrary)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSessionCommand(v *types.SessionCommand, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PythonVersion != nil {
		ok := object.Key("PythonVersion")
		ok.String(*v.PythonVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSkewedInfo(v *types.SkewedInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SkewedColumnNames != nil {
		ok := object.Key("SkewedColumnNames")
		if err := awsAwsjson11_serializeDocumentNameStringList(v.SkewedColumnNames, ok); err != nil {
			return err
		}
	}

	if v.SkewedColumnValueLocationMaps != nil {
		ok := object.Key("SkewedColumnValueLocationMaps")
		if err := awsAwsjson11_serializeDocumentLocationMap(v.SkewedColumnValueLocationMaps, ok); err != nil {
			return err
		}
	}

	if v.SkewedColumnValues != nil {
		ok := object.Key("SkewedColumnValues")
		if err := awsAwsjson11_serializeDocumentColumnValueStringList(v.SkewedColumnValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeNodeData(v *types.SnowflakeNodeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		ok.String(*v.Action)
	}

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.AutoPushdown {
		ok := object.Key("AutoPushdown")
		ok.Boolean(v.AutoPushdown)
	}

	if v.Connection != nil {
		ok := object.Key("Connection")
		if err := awsAwsjson11_serializeDocumentOption(v.Connection, ok); err != nil {
			return err
		}
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.IamRole != nil {
		ok := object.Key("IamRole")
		if err := awsAwsjson11_serializeDocumentOption(v.IamRole, ok); err != nil {
			return err
		}
	}

	if v.MergeAction != nil {
		ok := object.Key("MergeAction")
		ok.String(*v.MergeAction)
	}

	if v.MergeClause != nil {
		ok := object.Key("MergeClause")
		ok.String(*v.MergeClause)
	}

	if v.MergeWhenMatched != nil {
		ok := object.Key("MergeWhenMatched")
		ok.String(*v.MergeWhenMatched)
	}

	if v.MergeWhenNotMatched != nil {
		ok := object.Key("MergeWhenNotMatched")
		ok.String(*v.MergeWhenNotMatched)
	}

	if v.PostAction != nil {
		ok := object.Key("PostAction")
		ok.String(*v.PostAction)
	}

	if v.PreAction != nil {
		ok := object.Key("PreAction")
		ok.String(*v.PreAction)
	}

	if v.SampleQuery != nil {
		ok := object.Key("SampleQuery")
		ok.String(*v.SampleQuery)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		ok.String(*v.Schema)
	}

	if v.SelectedColumns != nil {
		ok := object.Key("SelectedColumns")
		if err := awsAwsjson11_serializeDocumentOptionList(v.SelectedColumns, ok); err != nil {
			return err
		}
	}

	if v.SourceType != nil {
		ok := object.Key("SourceType")
		ok.String(*v.SourceType)
	}

	if v.StagingTable != nil {
		ok := object.Key("StagingTable")
		ok.String(*v.StagingTable)
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.TableSchema != nil {
		ok := object.Key("TableSchema")
		if err := awsAwsjson11_serializeDocumentOptionList(v.TableSchema, ok); err != nil {
			return err
		}
	}

	if v.TempDir != nil {
		ok := object.Key("TempDir")
		ok.String(*v.TempDir)
	}

	if v.Upsert {
		ok := object.Key("Upsert")
		ok.Boolean(v.Upsert)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeSource(v *types.SnowflakeSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentSnowflakeNodeData(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeTarget(v *types.SnowflakeTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsAwsjson11_serializeDocumentSnowflakeNodeData(v.Data, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSortCriteria(v []types.SortCriterion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSortCriterion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSortCriterion(v *types.SortCriterion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldName != nil {
		ok := object.Key("FieldName")
		ok.String(*v.FieldName)
	}

	if len(v.Sort) > 0 {
		ok := object.Key("Sort")
		ok.String(string(v.Sort))
	}

	return nil
}

func awsAwsjson11_serializeDocumentSourceControlDetails(v *types.SourceControlDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthStrategy) > 0 {
		ok := object.Key("AuthStrategy")
		ok.String(string(v.AuthStrategy))
	}

	if v.AuthToken != nil {
		ok := object.Key("AuthToken")
		ok.String(*v.AuthToken)
	}

	if v.Branch != nil {
		ok := object.Key("Branch")
		ok.String(*v.Branch)
	}

	if v.Folder != nil {
		ok := object.Key("Folder")
		ok.String(*v.Folder)
	}

	if v.LastCommitId != nil {
		ok := object.Key("LastCommitId")
		ok.String(*v.LastCommitId)
	}

	if v.Owner != nil {
		ok := object.Key("Owner")
		ok.String(*v.Owner)
	}

	if len(v.Provider) > 0 {
		ok := object.Key("Provider")
		ok.String(string(v.Provider))
	}

	if v.Repository != nil {
		ok := object.Key("Repository")
		ok.String(*v.Repository)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSparkConnectorSource(v *types.SparkConnectorSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.ConnectorName != nil {
		ok := object.Key("ConnectorName")
		ok.String(*v.ConnectorName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSparkConnectorTarget(v *types.SparkConnectorTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOptions != nil {
		ok := object.Key("AdditionalOptions")
		if err := awsAwsjson11_serializeDocumentAdditionalOptions(v.AdditionalOptions, ok); err != nil {
			return err
		}
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.ConnectionType != nil {
		ok := object.Key("ConnectionType")
		ok.String(*v.ConnectionType)
	}

	if v.ConnectorName != nil {
		ok := object.Key("ConnectorName")
		ok.String(*v.ConnectorName)
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSparkSQL(v *types.SparkSQL, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentManyInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputSchemas != nil {
		ok := object.Key("OutputSchemas")
		if err := awsAwsjson11_serializeDocumentGlueSchemas(v.OutputSchemas, ok); err != nil {
			return err
		}
	}

	if v.SqlAliases != nil {
		ok := object.Key("SqlAliases")
		if err := awsAwsjson11_serializeDocumentSqlAliases(v.SqlAliases, ok); err != nil {
			return err
		}
	}

	if v.SqlQuery != nil {
		ok := object.Key("SqlQuery")
		ok.String(*v.SqlQuery)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSpigot(v *types.Spigot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.Prob != nil {
		ok := object.Key("Prob")
		switch {
		case math.IsNaN(*v.Prob):
			ok.String("NaN")

		case math.IsInf(*v.Prob, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Prob, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Prob)

		}
	}

	if v.Topk != nil {
		ok := object.Key("Topk")
		ok.Integer(*v.Topk)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSplitFields(v *types.SplitFields, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentOneInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentGlueStudioPathList(v.Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlAlias(v *types.SqlAlias, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Alias != nil {
		ok := object.Key("Alias")
		ok.String(*v.Alias)
	}

	if v.From != nil {
		ok := object.Key("From")
		ok.String(*v.From)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlAliases(v []types.SqlAlias, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSqlAlias(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStorageDescriptor(v *types.StorageDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalLocations != nil {
		ok := object.Key("AdditionalLocations")
		if err := awsAwsjson11_serializeDocumentLocationStringList(v.AdditionalLocations, ok); err != nil {
			return err
		}
	}

	if v.BucketColumns != nil {
		ok := object.Key("BucketColumns")
		if err := awsAwsjson11_serializeDocumentNameStringList(v.BucketColumns, ok); err != nil {
			return err
		}
	}

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsAwsjson11_serializeDocumentColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Compressed {
		ok := object.Key("Compressed")
		ok.Boolean(v.Compressed)
	}

	if v.InputFormat != nil {
		ok := object.Key("InputFormat")
		ok.String(*v.InputFormat)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NumberOfBuckets != 0 {
		ok := object.Key("NumberOfBuckets")
		ok.Integer(v.NumberOfBuckets)
	}

	if v.OutputFormat != nil {
		ok := object.Key("OutputFormat")
		ok.String(*v.OutputFormat)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SchemaReference != nil {
		ok := object.Key("SchemaReference")
		if err := awsAwsjson11_serializeDocumentSchemaReference(v.SchemaReference, ok); err != nil {
			return err
		}
	}

	if v.SerdeInfo != nil {
		ok := object.Key("SerdeInfo")
		if err := awsAwsjson11_serializeDocumentSerDeInfo(v.SerdeInfo, ok); err != nil {
			return err
		}
	}

	if v.SkewedInfo != nil {
		ok := object.Key("SkewedInfo")
		if err := awsAwsjson11_serializeDocumentSkewedInfo(v.SkewedInfo, ok); err != nil {
			return err
		}
	}

	if v.SortColumns != nil {
		ok := object.Key("SortColumns")
		if err := awsAwsjson11_serializeDocumentOrderList(v.SortColumns, ok); err != nil {
			return err
		}
	}

	if v.StoredAsSubDirectories {
		ok := object.Key("StoredAsSubDirectories")
		ok.Boolean(v.StoredAsSubDirectories)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamingDataPreviewOptions(v *types.StreamingDataPreviewOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PollingTime != nil {
		ok := object.Key("PollingTime")
		ok.Long(*v.PollingTime)
	}

	if v.RecordPollingLimit != nil {
		ok := object.Key("RecordPollingLimit")
		ok.Long(*v.RecordPollingLimit)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStringColumnStatisticsData(v *types.StringColumnStatisticsData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("AverageLength")
		switch {
		case math.IsNaN(v.AverageLength):
			ok.String("NaN")

		case math.IsInf(v.AverageLength, 1):
			ok.String("Infinity")

		case math.IsInf(v.AverageLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.AverageLength)

		}
	}

	{
		ok := object.Key("MaximumLength")
		ok.Long(v.MaximumLength)
	}

	{
		ok := object.Key("NumberOfDistinctValues")
		ok.Long(v.NumberOfDistinctValues)
	}

	{
		ok := object.Key("NumberOfNulls")
		ok.Long(v.NumberOfNulls)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSupportedDialect(v *types.SupportedDialect, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Dialect) > 0 {
		ok := object.Key("Dialect")
		ok.String(string(v.Dialect))
	}

	if v.DialectVersion != nil {
		ok := object.Key("DialectVersion")
		ok.String(*v.DialectVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTableIdentifier(v *types.TableIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTableInput(v *types.TableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LastAccessTime != nil {
		ok := object.Key("LastAccessTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastAccessTime))
	}

	if v.LastAnalyzedTime != nil {
		ok := object.Key("LastAnalyzedTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastAnalyzedTime))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Owner != nil {
		ok := object.Key("Owner")
		ok.String(*v.Owner)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.PartitionKeys != nil {
		ok := object.Key("PartitionKeys")
		if err := awsAwsjson11_serializeDocumentColumnList(v.PartitionKeys, ok); err != nil {
			return err
		}
	}

	if v.Retention != 0 {
		ok := object.Key("Retention")
		ok.Integer(v.Retention)
	}

	if v.StorageDescriptor != nil {
		ok := object.Key("StorageDescriptor")
		if err := awsAwsjson11_serializeDocumentStorageDescriptor(v.StorageDescriptor, ok); err != nil {
			return err
		}
	}

	if v.TableType != nil {
		ok := object.Key("TableType")
		ok.String(*v.TableType)
	}

	if v.TargetTable != nil {
		ok := object.Key("TargetTable")
		if err := awsAwsjson11_serializeDocumentTableIdentifier(v.TargetTable, ok); err != nil {
			return err
		}
	}

	if v.ViewDefinition != nil {
		ok := object.Key("ViewDefinition")
		if err := awsAwsjson11_serializeDocumentViewDefinitionInput(v.ViewDefinition, ok); err != nil {
			return err
		}
	}

	if v.ViewExpandedText != nil {
		ok := object.Key("ViewExpandedText")
		ok.String(*v.ViewExpandedText)
	}

	if v.ViewOriginalText != nil {
		ok := object.Key("ViewOriginalText")
		ok.String(*v.ViewOriginalText)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTableOptimizerConfiguration(v *types.TableOptimizerConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeysList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskRunFilterCriteria(v *types.TaskRunFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StartedAfter != nil {
		ok := object.Key("StartedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedAfter))
	}

	if v.StartedBefore != nil {
		ok := object.Key("StartedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartedBefore))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if len(v.TaskRunType) > 0 {
		ok := object.Key("TaskRunType")
		ok.String(string(v.TaskRunType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTaskRunSortCriteria(v *types.TaskRunSortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Column) > 0 {
		ok := object.Key("Column")
		ok.String(string(v.Column))
	}

	if len(v.SortDirection) > 0 {
		ok := object.Key("SortDirection")
		ok.String(string(v.SortDirection))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTokenUrlParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTransformConfigParameter(v *types.TransformConfigParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsOptional != nil {
		ok := object.Key("IsOptional")
		ok.Boolean(*v.IsOptional)
	}

	if len(v.ListType) > 0 {
		ok := object.Key("ListType")
		ok.String(string(v.ListType))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.ValidationMessage != nil {
		ok := object.Key("ValidationMessage")
		ok.String(*v.ValidationMessage)
	}

	if v.ValidationRule != nil {
		ok := object.Key("ValidationRule")
		ok.String(*v.ValidationRule)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringProperties(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTransformConfigParameterList(v []types.TransformConfigParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTransformConfigParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTransformEncryption(v *types.TransformEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MlUserDataEncryption != nil {
		ok := object.Key("MlUserDataEncryption")
		if err := awsAwsjson11_serializeDocumentMLUserDataEncryption(v.MlUserDataEncryption, ok); err != nil {
			return err
		}
	}

	if v.TaskRunSecurityConfigurationName != nil {
		ok := object.Key("TaskRunSecurityConfigurationName")
		ok.String(*v.TaskRunSecurityConfigurationName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTransformFilterCriteria(v *types.TransformFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedAfter != nil {
		ok := object.Key("CreatedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedAfter))
	}

	if v.CreatedBefore != nil {
		ok := object.Key("CreatedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedBefore))
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if v.LastModifiedAfter != nil {
		ok := object.Key("LastModifiedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastModifiedAfter))
	}

	if v.LastModifiedBefore != nil {
		ok := object.Key("LastModifiedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastModifiedBefore))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		if err := awsAwsjson11_serializeDocumentTransformSchema(v.Schema, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if len(v.TransformType) > 0 {
		ok := object.Key("TransformType")
		ok.String(string(v.TransformType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTransformParameters(v *types.TransformParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FindMatchesParameters != nil {
		ok := object.Key("FindMatchesParameters")
		if err := awsAwsjson11_serializeDocumentFindMatchesParameters(v.FindMatchesParameters, ok); err != nil {
			return err
		}
	}

	if len(v.TransformType) > 0 {
		ok := object.Key("TransformType")
		ok.String(string(v.TransformType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTransformSchema(v []types.SchemaColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSchemaColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTransformSortCriteria(v *types.TransformSortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Column) > 0 {
		ok := object.Key("Column")
		ok.String(string(v.Column))
	}

	if len(v.SortDirection) > 0 {
		ok := object.Key("SortDirection")
		ok.String(string(v.SortDirection))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTriggerNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTriggerUpdate(v *types.TriggerUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EventBatchingCondition != nil {
		ok := object.Key("EventBatchingCondition")
		if err := awsAwsjson11_serializeDocumentEventBatchingCondition(v.EventBatchingCondition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Predicate != nil {
		ok := object.Key("Predicate")
		if err := awsAwsjson11_serializeDocumentPredicate(v.Predicate, ok); err != nil {
			return err
		}
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		ok.String(*v.Schedule)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTwoInputs(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentUnion(v *types.Union, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentTwoInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.UnionType) > 0 {
		ok := object.Key("UnionType")
		ok.String(string(v.UnionType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateColumnStatisticsList(v []types.ColumnStatistics, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentColumnStatistics(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentUpdateCsvClassifierRequest(v *types.UpdateCsvClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowSingleColumn != nil {
		ok := object.Key("AllowSingleColumn")
		ok.Boolean(*v.AllowSingleColumn)
	}

	if len(v.ContainsHeader) > 0 {
		ok := object.Key("ContainsHeader")
		ok.String(string(v.ContainsHeader))
	}

	if v.CustomDatatypeConfigured != nil {
		ok := object.Key("CustomDatatypeConfigured")
		ok.Boolean(*v.CustomDatatypeConfigured)
	}

	if v.CustomDatatypes != nil {
		ok := object.Key("CustomDatatypes")
		if err := awsAwsjson11_serializeDocumentCustomDatatypes(v.CustomDatatypes, ok); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DisableValueTrimming != nil {
		ok := object.Key("DisableValueTrimming")
		ok.Boolean(*v.DisableValueTrimming)
	}

	if v.Header != nil {
		ok := object.Key("Header")
		if err := awsAwsjson11_serializeDocumentCsvHeader(v.Header, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QuoteSymbol != nil {
		ok := object.Key("QuoteSymbol")
		ok.String(*v.QuoteSymbol)
	}

	if len(v.Serde) > 0 {
		ok := object.Key("Serde")
		ok.String(string(v.Serde))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateGrokClassifierRequest(v *types.UpdateGrokClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.CustomPatterns != nil {
		ok := object.Key("CustomPatterns")
		ok.String(*v.CustomPatterns)
	}

	if v.GrokPattern != nil {
		ok := object.Key("GrokPattern")
		ok.String(*v.GrokPattern)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateJsonClassifierRequest(v *types.UpdateJsonClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonPath != nil {
		ok := object.Key("JsonPath")
		ok.String(*v.JsonPath)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateXMLClassifierRequest(v *types.UpdateXMLClassifierRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RowTag != nil {
		ok := object.Key("RowTag")
		ok.String(*v.RowTag)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpsertRedshiftTargetOptions(v *types.UpsertRedshiftTargetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	if v.TableLocation != nil {
		ok := object.Key("TableLocation")
		ok.String(*v.TableLocation)
	}

	if v.UpsertKeys != nil {
		ok := object.Key("UpsertKeys")
		if err := awsAwsjson11_serializeDocumentEnclosedInStringPropertiesMinOne(v.UpsertKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserDefinedFunctionInput(v *types.UserDefinedFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClassName != nil {
		ok := object.Key("ClassName")
		ok.String(*v.ClassName)
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.OwnerName != nil {
		ok := object.Key("OwnerName")
		ok.String(*v.OwnerName)
	}

	if len(v.OwnerType) > 0 {
		ok := object.Key("OwnerType")
		ok.String(string(v.OwnerType))
	}

	if v.ResourceUris != nil {
		ok := object.Key("ResourceUris")
		if err := awsAwsjson11_serializeDocumentResourceUriList(v.ResourceUris, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentValueStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentViewDefinitionInput(v *types.ViewDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definer != nil {
		ok := object.Key("Definer")
		ok.String(*v.Definer)
	}

	if v.IsProtected != nil {
		ok := object.Key("IsProtected")
		ok.Boolean(*v.IsProtected)
	}

	if v.Representations != nil {
		ok := object.Key("Representations")
		if err := awsAwsjson11_serializeDocumentViewRepresentationInputList(v.Representations, ok); err != nil {
			return err
		}
	}

	if v.SubObjects != nil {
		ok := object.Key("SubObjects")
		if err := awsAwsjson11_serializeDocumentViewSubObjectsList(v.SubObjects, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentViewRepresentationInput(v *types.ViewRepresentationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Dialect) > 0 {
		ok := object.Key("Dialect")
		ok.String(string(v.Dialect))
	}

	if v.DialectVersion != nil {
		ok := object.Key("DialectVersion")
		ok.String(*v.DialectVersion)
	}

	if v.ValidationConnection != nil {
		ok := object.Key("ValidationConnection")
		ok.String(*v.ValidationConnection)
	}

	if v.ViewExpandedText != nil {
		ok := object.Key("ViewExpandedText")
		ok.String(*v.ViewExpandedText)
	}

	if v.ViewOriginalText != nil {
		ok := object.Key("ViewOriginalText")
		ok.String(*v.ViewOriginalText)
	}

	return nil
}

func awsAwsjson11_serializeDocumentViewRepresentationInputList(v []types.ViewRepresentationInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentViewRepresentationInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentViewSubObjectsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentWorkflowNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentWorkflowRunProperties(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentBatchCreatePartitionInput(v *BatchCreatePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionInputList != nil {
		ok := object.Key("PartitionInputList")
		if err := awsAwsjson11_serializeDocumentPartitionInputList(v.PartitionInputList, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchDeleteConnectionInput(v *BatchDeleteConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ConnectionNameList != nil {
		ok := object.Key("ConnectionNameList")
		if err := awsAwsjson11_serializeDocumentDeleteConnectionNameList(v.ConnectionNameList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchDeletePartitionInput(v *BatchDeletePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionsToDelete != nil {
		ok := object.Key("PartitionsToDelete")
		if err := awsAwsjson11_serializeDocumentBatchDeletePartitionValueList(v.PartitionsToDelete, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchDeleteTableInput(v *BatchDeleteTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TablesToDelete != nil {
		ok := object.Key("TablesToDelete")
		if err := awsAwsjson11_serializeDocumentBatchDeleteTableNameList(v.TablesToDelete, ok); err != nil {
			return err
		}
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchDeleteTableVersionInput(v *BatchDeleteTableVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VersionIds != nil {
		ok := object.Key("VersionIds")
		if err := awsAwsjson11_serializeDocumentBatchDeleteTableVersionList(v.VersionIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetBlueprintsInput(v *BatchGetBlueprintsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeBlueprint != nil {
		ok := object.Key("IncludeBlueprint")
		ok.Boolean(*v.IncludeBlueprint)
	}

	if v.IncludeParameterSpec != nil {
		ok := object.Key("IncludeParameterSpec")
		ok.Boolean(*v.IncludeParameterSpec)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentBatchGetBlueprintNames(v.Names, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetCrawlersInput(v *BatchGetCrawlersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerNames != nil {
		ok := object.Key("CrawlerNames")
		if err := awsAwsjson11_serializeDocumentCrawlerNameList(v.CrawlerNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetCustomEntityTypesInput(v *BatchGetCustomEntityTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentCustomEntityTypeNames(v.Names, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetDataQualityResultInput(v *BatchGetDataQualityResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResultIds != nil {
		ok := object.Key("ResultIds")
		if err := awsAwsjson11_serializeDocumentDataQualityResultIds(v.ResultIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetDevEndpointsInput(v *BatchGetDevEndpointsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DevEndpointNames != nil {
		ok := object.Key("DevEndpointNames")
		if err := awsAwsjson11_serializeDocumentDevEndpointNames(v.DevEndpointNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetJobsInput(v *BatchGetJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobNames != nil {
		ok := object.Key("JobNames")
		if err := awsAwsjson11_serializeDocumentJobNameList(v.JobNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetPartitionInput(v *BatchGetPartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionsToGet != nil {
		ok := object.Key("PartitionsToGet")
		if err := awsAwsjson11_serializeDocumentBatchGetPartitionValueList(v.PartitionsToGet, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetTableOptimizerInput(v *BatchGetTableOptimizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entries != nil {
		ok := object.Key("Entries")
		if err := awsAwsjson11_serializeDocumentBatchGetTableOptimizerEntries(v.Entries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetTriggersInput(v *BatchGetTriggersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TriggerNames != nil {
		ok := object.Key("TriggerNames")
		if err := awsAwsjson11_serializeDocumentTriggerNameList(v.TriggerNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchGetWorkflowsInput(v *BatchGetWorkflowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeGraph != nil {
		ok := object.Key("IncludeGraph")
		ok.Boolean(*v.IncludeGraph)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentWorkflowNames(v.Names, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchStopJobRunInput(v *BatchStopJobRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.JobRunIds != nil {
		ok := object.Key("JobRunIds")
		if err := awsAwsjson11_serializeDocumentBatchStopJobRunJobRunIdList(v.JobRunIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentBatchUpdatePartitionInput(v *BatchUpdatePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Entries != nil {
		ok := object.Key("Entries")
		if err := awsAwsjson11_serializeDocumentBatchUpdatePartitionRequestEntryList(v.Entries, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelDataQualityRuleRecommendationRunInput(v *CancelDataQualityRuleRecommendationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelDataQualityRulesetEvaluationRunInput(v *CancelDataQualityRulesetEvaluationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelMLTaskRunInput(v *CancelMLTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TaskRunId != nil {
		ok := object.Key("TaskRunId")
		ok.String(*v.TaskRunId)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelStatementInput(v *CancelStatementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Id")
		ok.Integer(v.Id)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.SessionId != nil {
		ok := object.Key("SessionId")
		ok.String(*v.SessionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCheckSchemaVersionValidityInput(v *CheckSchemaVersionValidityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataFormat) > 0 {
		ok := object.Key("DataFormat")
		ok.String(string(v.DataFormat))
	}

	if v.SchemaDefinition != nil {
		ok := object.Key("SchemaDefinition")
		ok.String(*v.SchemaDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateBlueprintInput(v *CreateBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintLocation != nil {
		ok := object.Key("BlueprintLocation")
		ok.String(*v.BlueprintLocation)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateClassifierInput(v *CreateClassifierInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CsvClassifier != nil {
		ok := object.Key("CsvClassifier")
		if err := awsAwsjson11_serializeDocumentCreateCsvClassifierRequest(v.CsvClassifier, ok); err != nil {
			return err
		}
	}

	if v.GrokClassifier != nil {
		ok := object.Key("GrokClassifier")
		if err := awsAwsjson11_serializeDocumentCreateGrokClassifierRequest(v.GrokClassifier, ok); err != nil {
			return err
		}
	}

	if v.JsonClassifier != nil {
		ok := object.Key("JsonClassifier")
		if err := awsAwsjson11_serializeDocumentCreateJsonClassifierRequest(v.JsonClassifier, ok); err != nil {
			return err
		}
	}

	if v.XMLClassifier != nil {
		ok := object.Key("XMLClassifier")
		if err := awsAwsjson11_serializeDocumentCreateXMLClassifierRequest(v.XMLClassifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateConnectionInput(v *CreateConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ConnectionInput != nil {
		ok := object.Key("ConnectionInput")
		if err := awsAwsjson11_serializeDocumentConnectionInput(v.ConnectionInput, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCrawlerInput(v *CreateCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classifiers != nil {
		ok := object.Key("Classifiers")
		if err := awsAwsjson11_serializeDocumentClassifierNameList(v.Classifiers, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		ok.String(*v.Configuration)
	}

	if v.CrawlerSecurityConfiguration != nil {
		ok := object.Key("CrawlerSecurityConfiguration")
		ok.String(*v.CrawlerSecurityConfiguration)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LakeFormationConfiguration != nil {
		ok := object.Key("LakeFormationConfiguration")
		if err := awsAwsjson11_serializeDocumentLakeFormationConfiguration(v.LakeFormationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LineageConfiguration != nil {
		ok := object.Key("LineageConfiguration")
		if err := awsAwsjson11_serializeDocumentLineageConfiguration(v.LineageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecrawlPolicy != nil {
		ok := object.Key("RecrawlPolicy")
		if err := awsAwsjson11_serializeDocumentRecrawlPolicy(v.RecrawlPolicy, ok); err != nil {
			return err
		}
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		ok.String(*v.Schedule)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.TablePrefix != nil {
		ok := object.Key("TablePrefix")
		ok.String(*v.TablePrefix)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Targets != nil {
		ok := object.Key("Targets")
		if err := awsAwsjson11_serializeDocumentCrawlerTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCustomEntityTypeInput(v *CreateCustomEntityTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContextWords != nil {
		ok := object.Key("ContextWords")
		if err := awsAwsjson11_serializeDocumentContextWords(v.ContextWords, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RegexString != nil {
		ok := object.Key("RegexString")
		ok.String(*v.RegexString)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDatabaseInput(v *CreateDatabaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseInput != nil {
		ok := object.Key("DatabaseInput")
		if err := awsAwsjson11_serializeDocumentDatabaseInput(v.DatabaseInput, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataQualityRulesetInput(v *CreateDataQualityRulesetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Ruleset != nil {
		ok := object.Key("Ruleset")
		ok.String(*v.Ruleset)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TargetTable != nil {
		ok := object.Key("TargetTable")
		if err := awsAwsjson11_serializeDocumentDataQualityTargetTable(v.TargetTable, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDevEndpointInput(v *CreateDevEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arguments != nil {
		ok := object.Key("Arguments")
		if err := awsAwsjson11_serializeDocumentMapValue(v.Arguments, ok); err != nil {
			return err
		}
	}

	if v.EndpointName != nil {
		ok := object.Key("EndpointName")
		ok.String(*v.EndpointName)
	}

	if v.ExtraJarsS3Path != nil {
		ok := object.Key("ExtraJarsS3Path")
		ok.String(*v.ExtraJarsS3Path)
	}

	if v.ExtraPythonLibsS3Path != nil {
		ok := object.Key("ExtraPythonLibsS3Path")
		ok.String(*v.ExtraPythonLibsS3Path)
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if v.NumberOfNodes != 0 {
		ok := object.Key("NumberOfNodes")
		ok.Integer(v.NumberOfNodes)
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.PublicKey != nil {
		ok := object.Key("PublicKey")
		ok.String(*v.PublicKey)
	}

	if v.PublicKeys != nil {
		ok := object.Key("PublicKeys")
		if err := awsAwsjson11_serializeDocumentPublicKeysList(v.PublicKeys, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedCapacity != 0 {
		ok := object.Key("AllocatedCapacity")
		ok.Integer(v.AllocatedCapacity)
	}

	if v.CodeGenConfigurationNodes != nil {
		ok := object.Key("CodeGenConfigurationNodes")
		if err := awsAwsjson11_serializeDocumentCodeGenConfigurationNodes(v.CodeGenConfigurationNodes, ok); err != nil {
			return err
		}
	}

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsAwsjson11_serializeDocumentJobCommand(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Connections != nil {
		ok := object.Key("Connections")
		if err := awsAwsjson11_serializeDocumentConnectionsList(v.Connections, ok); err != nil {
			return err
		}
	}

	if v.DefaultArguments != nil {
		ok := object.Key("DefaultArguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.DefaultArguments, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.ExecutionClass) > 0 {
		ok := object.Key("ExecutionClass")
		ok.String(string(v.ExecutionClass))
	}

	if v.ExecutionProperty != nil {
		ok := object.Key("ExecutionProperty")
		if err := awsAwsjson11_serializeDocumentExecutionProperty(v.ExecutionProperty, ok); err != nil {
			return err
		}
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if len(v.JobMode) > 0 {
		ok := object.Key("JobMode")
		ok.String(string(v.JobMode))
	}

	if v.LogUri != nil {
		ok := object.Key("LogUri")
		ok.String(*v.LogUri)
	}

	if v.MaintenanceWindow != nil {
		ok := object.Key("MaintenanceWindow")
		ok.String(*v.MaintenanceWindow)
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.MaxRetries != 0 {
		ok := object.Key("MaxRetries")
		ok.Integer(v.MaxRetries)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NonOverridableArguments != nil {
		ok := object.Key("NonOverridableArguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.NonOverridableArguments, ok); err != nil {
			return err
		}
	}

	if v.NotificationProperty != nil {
		ok := object.Key("NotificationProperty")
		if err := awsAwsjson11_serializeDocumentNotificationProperty(v.NotificationProperty, ok); err != nil {
			return err
		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.SourceControlDetails != nil {
		ok := object.Key("SourceControlDetails")
		if err := awsAwsjson11_serializeDocumentSourceControlDetails(v.SourceControlDetails, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateMLTransformInput(v *CreateMLTransformInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if v.InputRecordTables != nil {
		ok := object.Key("InputRecordTables")
		if err := awsAwsjson11_serializeDocumentGlueTables(v.InputRecordTables, ok); err != nil {
			return err
		}
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.MaxRetries != nil {
		ok := object.Key("MaxRetries")
		ok.Integer(*v.MaxRetries)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentTransformParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if v.TransformEncryption != nil {
		ok := object.Key("TransformEncryption")
		if err := awsAwsjson11_serializeDocumentTransformEncryption(v.TransformEncryption, ok); err != nil {
			return err
		}
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePartitionIndexInput(v *CreatePartitionIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionIndex != nil {
		ok := object.Key("PartitionIndex")
		if err := awsAwsjson11_serializeDocumentPartitionIndex(v.PartitionIndex, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePartitionInput(v *CreatePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionInput != nil {
		ok := object.Key("PartitionInput")
		if err := awsAwsjson11_serializeDocumentPartitionInput(v.PartitionInput, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateRegistryInput(v *CreateRegistryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.RegistryName != nil {
		ok := object.Key("RegistryName")
		ok.String(*v.RegistryName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateSchemaInput(v *CreateSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Compatibility) > 0 {
		ok := object.Key("Compatibility")
		ok.String(string(v.Compatibility))
	}

	if len(v.DataFormat) > 0 {
		ok := object.Key("DataFormat")
		ok.String(string(v.DataFormat))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		if err := awsAwsjson11_serializeDocumentRegistryId(v.RegistryId, ok); err != nil {
			return err
		}
	}

	if v.SchemaDefinition != nil {
		ok := object.Key("SchemaDefinition")
		ok.String(*v.SchemaDefinition)
	}

	if v.SchemaName != nil {
		ok := object.Key("SchemaName")
		ok.String(*v.SchemaName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateScriptInput(v *CreateScriptInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DagEdges != nil {
		ok := object.Key("DagEdges")
		if err := awsAwsjson11_serializeDocumentDagEdges(v.DagEdges, ok); err != nil {
			return err
		}
	}

	if v.DagNodes != nil {
		ok := object.Key("DagNodes")
		if err := awsAwsjson11_serializeDocumentDagNodes(v.DagNodes, ok); err != nil {
			return err
		}
	}

	if len(v.Language) > 0 {
		ok := object.Key("Language")
		ok.String(string(v.Language))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateSecurityConfigurationInput(v *CreateSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateSessionInput(v *CreateSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsAwsjson11_serializeDocumentSessionCommand(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Connections != nil {
		ok := object.Key("Connections")
		if err := awsAwsjson11_serializeDocumentConnectionsList(v.Connections, ok); err != nil {
			return err
		}
	}

	if v.DefaultArguments != nil {
		ok := object.Key("DefaultArguments")
		if err := awsAwsjson11_serializeDocumentOrchestrationArgumentsMap(v.DefaultArguments, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.IdleTimeout != nil {
		ok := object.Key("IdleTimeout")
		ok.Integer(*v.IdleTimeout)
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateTableInput(v *CreateTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.OpenTableFormatInput != nil {
		ok := object.Key("OpenTableFormatInput")
		if err := awsAwsjson11_serializeDocumentOpenTableFormatInput(v.OpenTableFormatInput, ok); err != nil {
			return err
		}
	}

	if v.PartitionIndexes != nil {
		ok := object.Key("PartitionIndexes")
		if err := awsAwsjson11_serializeDocumentPartitionIndexList(v.PartitionIndexes, ok); err != nil {
			return err
		}
	}

	if v.TableInput != nil {
		ok := object.Key("TableInput")
		if err := awsAwsjson11_serializeDocumentTableInput(v.TableInput, ok); err != nil {
			return err
		}
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateTableOptimizerInput(v *CreateTableOptimizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.TableOptimizerConfiguration != nil {
		ok := object.Key("TableOptimizerConfiguration")
		if err := awsAwsjson11_serializeDocumentTableOptimizerConfiguration(v.TableOptimizerConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateTriggerInput(v *CreateTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EventBatchingCondition != nil {
		ok := object.Key("EventBatchingCondition")
		if err := awsAwsjson11_serializeDocumentEventBatchingCondition(v.EventBatchingCondition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Predicate != nil {
		ok := object.Key("Predicate")
		if err := awsAwsjson11_serializeDocumentPredicate(v.Predicate, ok); err != nil {
			return err
		}
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		ok.String(*v.Schedule)
	}

	if v.StartOnCreation {
		ok := object.Key("StartOnCreation")
		ok.Boolean(v.StartOnCreation)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.WorkflowName != nil {
		ok := object.Key("WorkflowName")
		ok.String(*v.WorkflowName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUsageProfileInput(v *CreateUsageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsAwsjson11_serializeDocumentProfileConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUserDefinedFunctionInput(v *CreateUserDefinedFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.FunctionInput != nil {
		ok := object.Key("FunctionInput")
		if err := awsAwsjson11_serializeDocumentUserDefinedFunctionInput(v.FunctionInput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateWorkflowInput(v *CreateWorkflowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultRunProperties != nil {
		ok := object.Key("DefaultRunProperties")
		if err := awsAwsjson11_serializeDocumentWorkflowRunProperties(v.DefaultRunProperties, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.MaxConcurrentRuns != nil {
		ok := object.Key("MaxConcurrentRuns")
		ok.Integer(*v.MaxConcurrentRuns)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteBlueprintInput(v *DeleteBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteClassifierInput(v *DeleteClassifierInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteColumnStatisticsForPartitionInput(v *DeleteColumnStatisticsForPartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteColumnStatisticsForTableInput(v *DeleteColumnStatisticsForTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteConnectionInput(v *DeleteConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ConnectionName != nil {
		ok := object.Key("ConnectionName")
		ok.String(*v.ConnectionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCrawlerInput(v *DeleteCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCustomEntityTypeInput(v *DeleteCustomEntityTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDatabaseInput(v *DeleteDatabaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDataQualityRulesetInput(v *DeleteDataQualityRulesetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDevEndpointInput(v *DeleteDevEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndpointName != nil {
		ok := object.Key("EndpointName")
		ok.String(*v.EndpointName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteJobInput(v *DeleteJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMLTransformInput(v *DeleteMLTransformInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePartitionIndexInput(v *DeletePartitionIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePartitionInput(v *DeletePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteRegistryInput(v *DeleteRegistryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		if err := awsAwsjson11_serializeDocumentRegistryId(v.RegistryId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteResourcePolicyInput(v *DeleteResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyHashCondition != nil {
		ok := object.Key("PolicyHashCondition")
		ok.String(*v.PolicyHashCondition)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSchemaInput(v *DeleteSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSchemaVersionsInput(v *DeleteSchemaVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.Versions != nil {
		ok := object.Key("Versions")
		ok.String(*v.Versions)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSecurityConfigurationInput(v *DeleteSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSessionInput(v *DeleteSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTableInput(v *DeleteTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTableOptimizerInput(v *DeleteTableOptimizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTableVersionInput(v *DeleteTableVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTriggerInput(v *DeleteTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUsageProfileInput(v *DeleteUsageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserDefinedFunctionInput(v *DeleteUserDefinedFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteWorkflowInput(v *DeleteWorkflowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetBlueprintInput(v *GetBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeBlueprint != nil {
		ok := object.Key("IncludeBlueprint")
		ok.Boolean(*v.IncludeBlueprint)
	}

	if v.IncludeParameterSpec != nil {
		ok := object.Key("IncludeParameterSpec")
		ok.Boolean(*v.IncludeParameterSpec)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetBlueprintRunInput(v *GetBlueprintRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintName != nil {
		ok := object.Key("BlueprintName")
		ok.String(*v.BlueprintName)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetBlueprintRunsInput(v *GetBlueprintRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintName != nil {
		ok := object.Key("BlueprintName")
		ok.String(*v.BlueprintName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCatalogImportStatusInput(v *GetCatalogImportStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetClassifierInput(v *GetClassifierInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetClassifiersInput(v *GetClassifiersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetColumnStatisticsForPartitionInput(v *GetColumnStatisticsForPartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnNames != nil {
		ok := object.Key("ColumnNames")
		if err := awsAwsjson11_serializeDocumentGetColumnNamesList(v.ColumnNames, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetColumnStatisticsForTableInput(v *GetColumnStatisticsForTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnNames != nil {
		ok := object.Key("ColumnNames")
		if err := awsAwsjson11_serializeDocumentGetColumnNamesList(v.ColumnNames, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetColumnStatisticsTaskRunInput(v *GetColumnStatisticsTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnStatisticsTaskRunId != nil {
		ok := object.Key("ColumnStatisticsTaskRunId")
		ok.String(*v.ColumnStatisticsTaskRunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetColumnStatisticsTaskRunsInput(v *GetColumnStatisticsTaskRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetConnectionInput(v *GetConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.HidePassword {
		ok := object.Key("HidePassword")
		ok.Boolean(v.HidePassword)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetConnectionsInput(v *GetConnectionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentGetConnectionsFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.HidePassword {
		ok := object.Key("HidePassword")
		ok.Boolean(v.HidePassword)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCrawlerInput(v *GetCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCrawlerMetricsInput(v *GetCrawlerMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerNameList != nil {
		ok := object.Key("CrawlerNameList")
		if err := awsAwsjson11_serializeDocumentCrawlerNameList(v.CrawlerNameList, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCrawlersInput(v *GetCrawlersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCustomEntityTypeInput(v *GetCustomEntityTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDatabaseInput(v *GetDatabaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDatabasesInput(v *GetDatabasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributesToGet != nil {
		ok := object.Key("AttributesToGet")
		if err := awsAwsjson11_serializeDocumentDatabaseAttributesList(v.AttributesToGet, ok); err != nil {
			return err
		}
	}

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ResourceShareType) > 0 {
		ok := object.Key("ResourceShareType")
		ok.String(string(v.ResourceShareType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataCatalogEncryptionSettingsInput(v *GetDataCatalogEncryptionSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataflowGraphInput(v *GetDataflowGraphInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PythonScript != nil {
		ok := object.Key("PythonScript")
		ok.String(*v.PythonScript)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataQualityResultInput(v *GetDataQualityResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResultId != nil {
		ok := object.Key("ResultId")
		ok.String(*v.ResultId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataQualityRuleRecommendationRunInput(v *GetDataQualityRuleRecommendationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataQualityRulesetEvaluationRunInput(v *GetDataQualityRulesetEvaluationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataQualityRulesetInput(v *GetDataQualityRulesetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDevEndpointInput(v *GetDevEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndpointName != nil {
		ok := object.Key("EndpointName")
		ok.String(*v.EndpointName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDevEndpointsInput(v *GetDevEndpointsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobBookmarkInput(v *GetJobBookmarkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobInput(v *GetJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobRunInput(v *GetJobRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.PredecessorsIncluded {
		ok := object.Key("PredecessorsIncluded")
		ok.Boolean(v.PredecessorsIncluded)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobRunsInput(v *GetJobRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobsInput(v *GetJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMappingInput(v *GetMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsAwsjson11_serializeDocumentLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Sinks != nil {
		ok := object.Key("Sinks")
		if err := awsAwsjson11_serializeDocumentCatalogEntries(v.Sinks, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsAwsjson11_serializeDocumentCatalogEntry(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMLTaskRunInput(v *GetMLTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TaskRunId != nil {
		ok := object.Key("TaskRunId")
		ok.String(*v.TaskRunId)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMLTaskRunsInput(v *GetMLTaskRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentTaskRunFilterCriteria(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Sort != nil {
		ok := object.Key("Sort")
		if err := awsAwsjson11_serializeDocumentTaskRunSortCriteria(v.Sort, ok); err != nil {
			return err
		}
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMLTransformInput(v *GetMLTransformInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMLTransformsInput(v *GetMLTransformsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentTransformFilterCriteria(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Sort != nil {
		ok := object.Key("Sort")
		if err := awsAwsjson11_serializeDocumentTransformSortCriteria(v.Sort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPartitionIndexesInput(v *GetPartitionIndexesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPartitionInput(v *GetPartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPartitionsInput(v *GetPartitionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.ExcludeColumnSchema != nil {
		ok := object.Key("ExcludeColumnSchema")
		ok.Boolean(*v.ExcludeColumnSchema)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.QueryAsOfTime != nil {
		ok := object.Key("QueryAsOfTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryAsOfTime))
	}

	if v.Segment != nil {
		ok := object.Key("Segment")
		if err := awsAwsjson11_serializeDocumentSegment(v.Segment, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPlanInput(v *GetPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalPlanOptionsMap != nil {
		ok := object.Key("AdditionalPlanOptionsMap")
		if err := awsAwsjson11_serializeDocumentAdditionalPlanOptionsMap(v.AdditionalPlanOptionsMap, ok); err != nil {
			return err
		}
	}

	if len(v.Language) > 0 {
		ok := object.Key("Language")
		ok.String(string(v.Language))
	}

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsAwsjson11_serializeDocumentLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Mapping != nil {
		ok := object.Key("Mapping")
		if err := awsAwsjson11_serializeDocumentMappingList(v.Mapping, ok); err != nil {
			return err
		}
	}

	if v.Sinks != nil {
		ok := object.Key("Sinks")
		if err := awsAwsjson11_serializeDocumentCatalogEntries(v.Sinks, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsAwsjson11_serializeDocumentCatalogEntry(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetRegistryInput(v *GetRegistryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		if err := awsAwsjson11_serializeDocumentRegistryId(v.RegistryId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetResourcePoliciesInput(v *GetResourcePoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetResourcePolicyInput(v *GetResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSchemaByDefinitionInput(v *GetSchemaByDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaDefinition != nil {
		ok := object.Key("SchemaDefinition")
		ok.String(*v.SchemaDefinition)
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSchemaInput(v *GetSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSchemaVersionInput(v *GetSchemaVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionId != nil {
		ok := object.Key("SchemaVersionId")
		ok.String(*v.SchemaVersionId)
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSchemaVersionsDiffInput(v *GetSchemaVersionsDiffInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirstSchemaVersionNumber != nil {
		ok := object.Key("FirstSchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.FirstSchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	if len(v.SchemaDiffType) > 0 {
		ok := object.Key("SchemaDiffType")
		ok.String(string(v.SchemaDiffType))
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SecondSchemaVersionNumber != nil {
		ok := object.Key("SecondSchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SecondSchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSecurityConfigurationInput(v *GetSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSecurityConfigurationsInput(v *GetSecurityConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSessionInput(v *GetSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetStatementInput(v *GetStatementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Id")
		ok.Integer(v.Id)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.SessionId != nil {
		ok := object.Key("SessionId")
		ok.String(*v.SessionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTableInput(v *GetTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QueryAsOfTime != nil {
		ok := object.Key("QueryAsOfTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryAsOfTime))
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTableOptimizerInput(v *GetTableOptimizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTablesInput(v *GetTablesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.QueryAsOfTime != nil {
		ok := object.Key("QueryAsOfTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryAsOfTime))
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTableVersionInput(v *GetTableVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTableVersionsInput(v *GetTableVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTagsInput(v *GetTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTriggerInput(v *GetTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTriggersInput(v *GetTriggersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DependentJobName != nil {
		ok := object.Key("DependentJobName")
		ok.String(*v.DependentJobName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUnfilteredPartitionMetadataInput(v *GetUnfilteredPartitionMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditContext != nil {
		ok := object.Key("AuditContext")
		if err := awsAwsjson11_serializeDocumentAuditContext(v.AuditContext, ok); err != nil {
			return err
		}
	}

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.QuerySessionContext != nil {
		ok := object.Key("QuerySessionContext")
		if err := awsAwsjson11_serializeDocumentQuerySessionContext(v.QuerySessionContext, ok); err != nil {
			return err
		}
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.SupportedPermissionTypes != nil {
		ok := object.Key("SupportedPermissionTypes")
		if err := awsAwsjson11_serializeDocumentPermissionTypeList(v.SupportedPermissionTypes, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUnfilteredPartitionsMetadataInput(v *GetUnfilteredPartitionsMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditContext != nil {
		ok := object.Key("AuditContext")
		if err := awsAwsjson11_serializeDocumentAuditContext(v.AuditContext, ok); err != nil {
			return err
		}
	}

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.QuerySessionContext != nil {
		ok := object.Key("QuerySessionContext")
		if err := awsAwsjson11_serializeDocumentQuerySessionContext(v.QuerySessionContext, ok); err != nil {
			return err
		}
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.Segment != nil {
		ok := object.Key("Segment")
		if err := awsAwsjson11_serializeDocumentSegment(v.Segment, ok); err != nil {
			return err
		}
	}

	if v.SupportedPermissionTypes != nil {
		ok := object.Key("SupportedPermissionTypes")
		if err := awsAwsjson11_serializeDocumentPermissionTypeList(v.SupportedPermissionTypes, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUnfilteredTableMetadataInput(v *GetUnfilteredTableMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditContext != nil {
		ok := object.Key("AuditContext")
		if err := awsAwsjson11_serializeDocumentAuditContext(v.AuditContext, ok); err != nil {
			return err
		}
	}

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParentResourceArn != nil {
		ok := object.Key("ParentResourceArn")
		ok.String(*v.ParentResourceArn)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsAwsjson11_serializeDocumentPermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.QuerySessionContext != nil {
		ok := object.Key("QuerySessionContext")
		if err := awsAwsjson11_serializeDocumentQuerySessionContext(v.QuerySessionContext, ok); err != nil {
			return err
		}
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.RootResourceArn != nil {
		ok := object.Key("RootResourceArn")
		ok.String(*v.RootResourceArn)
	}

	if v.SupportedDialect != nil {
		ok := object.Key("SupportedDialect")
		if err := awsAwsjson11_serializeDocumentSupportedDialect(v.SupportedDialect, ok); err != nil {
			return err
		}
	}

	if v.SupportedPermissionTypes != nil {
		ok := object.Key("SupportedPermissionTypes")
		if err := awsAwsjson11_serializeDocumentPermissionTypeList(v.SupportedPermissionTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUsageProfileInput(v *GetUsageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUserDefinedFunctionInput(v *GetUserDefinedFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUserDefinedFunctionsInput(v *GetUserDefinedFunctionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Pattern != nil {
		ok := object.Key("Pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWorkflowInput(v *GetWorkflowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeGraph != nil {
		ok := object.Key("IncludeGraph")
		ok.Boolean(*v.IncludeGraph)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWorkflowRunInput(v *GetWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeGraph != nil {
		ok := object.Key("IncludeGraph")
		ok.Boolean(*v.IncludeGraph)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWorkflowRunPropertiesInput(v *GetWorkflowRunPropertiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWorkflowRunsInput(v *GetWorkflowRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeGraph != nil {
		ok := object.Key("IncludeGraph")
		ok.Boolean(*v.IncludeGraph)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentImportCatalogToGlueInput(v *ImportCatalogToGlueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListBlueprintsInput(v *ListBlueprintsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListColumnStatisticsTaskRunsInput(v *ListColumnStatisticsTaskRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCrawlersInput(v *ListCrawlersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCrawlsInput(v *ListCrawlsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentCrawlsFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCustomEntityTypesInput(v *ListCustomEntityTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDataQualityResultsInput(v *ListDataQualityResultsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentDataQualityResultFilterCriteria(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDataQualityRuleRecommendationRunsInput(v *ListDataQualityRuleRecommendationRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentDataQualityRuleRecommendationRunFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDataQualityRulesetEvaluationRunsInput(v *ListDataQualityRulesetEvaluationRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentDataQualityRulesetEvaluationRunFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDataQualityRulesetsInput(v *ListDataQualityRulesetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentDataQualityRulesetFilterCriteria(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDevEndpointsInput(v *ListDevEndpointsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListJobsInput(v *ListJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMLTransformsInput(v *ListMLTransformsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsAwsjson11_serializeDocumentTransformFilterCriteria(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Sort != nil {
		ok := object.Key("Sort")
		if err := awsAwsjson11_serializeDocumentTransformSortCriteria(v.Sort, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListRegistriesInput(v *ListRegistriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListSchemasInput(v *ListSchemasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		if err := awsAwsjson11_serializeDocumentRegistryId(v.RegistryId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListSchemaVersionsInput(v *ListSchemaVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListSessionsInput(v *ListSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListStatementsInput(v *ListStatementsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.SessionId != nil {
		ok := object.Key("SessionId")
		ok.String(*v.SessionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTableOptimizerRunsInput(v *ListTableOptimizerRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTriggersInput(v *ListTriggersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DependentJobName != nil {
		ok := object.Key("DependentJobName")
		ok.String(*v.DependentJobName)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUsageProfilesInput(v *ListUsageProfilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListWorkflowsInput(v *ListWorkflowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutDataCatalogEncryptionSettingsInput(v *PutDataCatalogEncryptionSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DataCatalogEncryptionSettings != nil {
		ok := object.Key("DataCatalogEncryptionSettings")
		if err := awsAwsjson11_serializeDocumentDataCatalogEncryptionSettings(v.DataCatalogEncryptionSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutResourcePolicyInput(v *PutResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EnableHybrid) > 0 {
		ok := object.Key("EnableHybrid")
		ok.String(string(v.EnableHybrid))
	}

	if len(v.PolicyExistsCondition) > 0 {
		ok := object.Key("PolicyExistsCondition")
		ok.String(string(v.PolicyExistsCondition))
	}

	if v.PolicyHashCondition != nil {
		ok := object.Key("PolicyHashCondition")
		ok.String(*v.PolicyHashCondition)
	}

	if v.PolicyInJson != nil {
		ok := object.Key("PolicyInJson")
		ok.String(*v.PolicyInJson)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutSchemaVersionMetadataInput(v *PutSchemaVersionMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetadataKeyValue != nil {
		ok := object.Key("MetadataKeyValue")
		if err := awsAwsjson11_serializeDocumentMetadataKeyValuePair(v.MetadataKeyValue, ok); err != nil {
			return err
		}
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionId != nil {
		ok := object.Key("SchemaVersionId")
		ok.String(*v.SchemaVersionId)
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutWorkflowRunPropertiesInput(v *PutWorkflowRunPropertiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	if v.RunProperties != nil {
		ok := object.Key("RunProperties")
		if err := awsAwsjson11_serializeDocumentWorkflowRunProperties(v.RunProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentQuerySchemaVersionMetadataInput(v *QuerySchemaVersionMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.MetadataList != nil {
		ok := object.Key("MetadataList")
		if err := awsAwsjson11_serializeDocumentMetadataList(v.MetadataList, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionId != nil {
		ok := object.Key("SchemaVersionId")
		ok.String(*v.SchemaVersionId)
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRegisterSchemaVersionInput(v *RegisterSchemaVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaDefinition != nil {
		ok := object.Key("SchemaDefinition")
		ok.String(*v.SchemaDefinition)
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRemoveSchemaVersionMetadataInput(v *RemoveSchemaVersionMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetadataKeyValue != nil {
		ok := object.Key("MetadataKeyValue")
		if err := awsAwsjson11_serializeDocumentMetadataKeyValuePair(v.MetadataKeyValue, ok); err != nil {
			return err
		}
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionId != nil {
		ok := object.Key("SchemaVersionId")
		ok.String(*v.SchemaVersionId)
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentResetJobBookmarkInput(v *ResetJobBookmarkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentResumeWorkflowRunInput(v *ResumeWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NodeIds != nil {
		ok := object.Key("NodeIds")
		if err := awsAwsjson11_serializeDocumentNodeIdList(v.NodeIds, ok); err != nil {
			return err
		}
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRunStatementInput(v *RunStatementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("Code")
		ok.String(*v.Code)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	if v.SessionId != nil {
		ok := object.Key("SessionId")
		ok.String(*v.SessionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSearchTablesInput(v *SearchTablesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentSearchPropertyPredicates(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ResourceShareType) > 0 {
		ok := object.Key("ResourceShareType")
		ok.String(string(v.ResourceShareType))
	}

	if v.SearchText != nil {
		ok := object.Key("SearchText")
		ok.String(*v.SearchText)
	}

	if v.SortCriteria != nil {
		ok := object.Key("SortCriteria")
		if err := awsAwsjson11_serializeDocumentSortCriteria(v.SortCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartBlueprintRunInput(v *StartBlueprintRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintName != nil {
		ok := object.Key("BlueprintName")
		ok.String(*v.BlueprintName)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		ok.String(*v.Parameters)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartColumnStatisticsTaskRunInput(v *StartColumnStatisticsTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogID != nil {
		ok := object.Key("CatalogID")
		ok.String(*v.CatalogID)
	}

	if v.ColumnNameList != nil {
		ok := object.Key("ColumnNameList")
		if err := awsAwsjson11_serializeDocumentColumnNameList(v.ColumnNameList, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.SampleSize != 0 {
		ok := object.Key("SampleSize")
		switch {
		case math.IsNaN(v.SampleSize):
			ok.String("NaN")

		case math.IsInf(v.SampleSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.SampleSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SampleSize)

		}
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartCrawlerInput(v *StartCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartCrawlerScheduleInput(v *StartCrawlerScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartDataQualityRuleRecommendationRunInput(v *StartDataQualityRuleRecommendationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.CreatedRulesetName != nil {
		ok := object.Key("CreatedRulesetName")
		ok.String(*v.CreatedRulesetName)
	}

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		if err := awsAwsjson11_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartDataQualityRulesetEvaluationRunInput(v *StartDataQualityRulesetEvaluationRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalDataSources != nil {
		ok := object.Key("AdditionalDataSources")
		if err := awsAwsjson11_serializeDocumentDataSourceMap(v.AdditionalDataSources, ok); err != nil {
			return err
		}
	}

	if v.AdditionalRunOptions != nil {
		ok := object.Key("AdditionalRunOptions")
		if err := awsAwsjson11_serializeDocumentDataQualityEvaluationRunAdditionalRunOptions(v.AdditionalRunOptions, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		if err := awsAwsjson11_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.RulesetNames != nil {
		ok := object.Key("RulesetNames")
		if err := awsAwsjson11_serializeDocumentRulesetNames(v.RulesetNames, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartExportLabelsTaskRunInput(v *StartExportLabelsTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutputS3Path != nil {
		ok := object.Key("OutputS3Path")
		ok.String(*v.OutputS3Path)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartImportLabelsTaskRunInput(v *StartImportLabelsTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputS3Path != nil {
		ok := object.Key("InputS3Path")
		ok.String(*v.InputS3Path)
	}

	if v.ReplaceAllLabels {
		ok := object.Key("ReplaceAllLabels")
		ok.Boolean(v.ReplaceAllLabels)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartJobRunInput(v *StartJobRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedCapacity != 0 {
		ok := object.Key("AllocatedCapacity")
		ok.Integer(v.AllocatedCapacity)
	}

	if v.Arguments != nil {
		ok := object.Key("Arguments")
		if err := awsAwsjson11_serializeDocumentGenericMap(v.Arguments, ok); err != nil {
			return err
		}
	}

	if len(v.ExecutionClass) > 0 {
		ok := object.Key("ExecutionClass")
		ok.String(string(v.ExecutionClass))
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.JobRunId != nil {
		ok := object.Key("JobRunId")
		ok.String(*v.JobRunId)
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.NotificationProperty != nil {
		ok := object.Key("NotificationProperty")
		if err := awsAwsjson11_serializeDocumentNotificationProperty(v.NotificationProperty, ok); err != nil {
			return err
		}
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMLEvaluationTaskRunInput(v *StartMLEvaluationTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMLLabelingSetGenerationTaskRunInput(v *StartMLLabelingSetGenerationTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutputS3Path != nil {
		ok := object.Key("OutputS3Path")
		ok.String(*v.OutputS3Path)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartTriggerInput(v *StartTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartWorkflowRunInput(v *StartWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RunProperties != nil {
		ok := object.Key("RunProperties")
		if err := awsAwsjson11_serializeDocumentWorkflowRunProperties(v.RunProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopColumnStatisticsTaskRunInput(v *StopColumnStatisticsTaskRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopCrawlerInput(v *StopCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopCrawlerScheduleInput(v *StopCrawlerScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopSessionInput(v *StopSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.RequestOrigin != nil {
		ok := object.Key("RequestOrigin")
		ok.String(*v.RequestOrigin)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopTriggerInput(v *StopTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopWorkflowRunInput(v *StopWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RunId != nil {
		ok := object.Key("RunId")
		ok.String(*v.RunId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagsToAdd != nil {
		ok := object.Key("TagsToAdd")
		if err := awsAwsjson11_serializeDocumentTagsMap(v.TagsToAdd, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagsToRemove != nil {
		ok := object.Key("TagsToRemove")
		if err := awsAwsjson11_serializeDocumentTagKeysList(v.TagsToRemove, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateBlueprintInput(v *UpdateBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintLocation != nil {
		ok := object.Key("BlueprintLocation")
		ok.String(*v.BlueprintLocation)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateClassifierInput(v *UpdateClassifierInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CsvClassifier != nil {
		ok := object.Key("CsvClassifier")
		if err := awsAwsjson11_serializeDocumentUpdateCsvClassifierRequest(v.CsvClassifier, ok); err != nil {
			return err
		}
	}

	if v.GrokClassifier != nil {
		ok := object.Key("GrokClassifier")
		if err := awsAwsjson11_serializeDocumentUpdateGrokClassifierRequest(v.GrokClassifier, ok); err != nil {
			return err
		}
	}

	if v.JsonClassifier != nil {
		ok := object.Key("JsonClassifier")
		if err := awsAwsjson11_serializeDocumentUpdateJsonClassifierRequest(v.JsonClassifier, ok); err != nil {
			return err
		}
	}

	if v.XMLClassifier != nil {
		ok := object.Key("XMLClassifier")
		if err := awsAwsjson11_serializeDocumentUpdateXMLClassifierRequest(v.XMLClassifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateColumnStatisticsForPartitionInput(v *UpdateColumnStatisticsForPartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnStatisticsList != nil {
		ok := object.Key("ColumnStatisticsList")
		if err := awsAwsjson11_serializeDocumentUpdateColumnStatisticsList(v.ColumnStatisticsList, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionValues != nil {
		ok := object.Key("PartitionValues")
		if err := awsAwsjson11_serializeDocumentValueStringList(v.PartitionValues, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateColumnStatisticsForTableInput(v *UpdateColumnStatisticsForTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ColumnStatisticsList != nil {
		ok := object.Key("ColumnStatisticsList")
		if err := awsAwsjson11_serializeDocumentUpdateColumnStatisticsList(v.ColumnStatisticsList, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateConnectionInput(v *UpdateConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.ConnectionInput != nil {
		ok := object.Key("ConnectionInput")
		if err := awsAwsjson11_serializeDocumentConnectionInput(v.ConnectionInput, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateCrawlerInput(v *UpdateCrawlerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classifiers != nil {
		ok := object.Key("Classifiers")
		if err := awsAwsjson11_serializeDocumentClassifierNameList(v.Classifiers, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		ok.String(*v.Configuration)
	}

	if v.CrawlerSecurityConfiguration != nil {
		ok := object.Key("CrawlerSecurityConfiguration")
		ok.String(*v.CrawlerSecurityConfiguration)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LakeFormationConfiguration != nil {
		ok := object.Key("LakeFormationConfiguration")
		if err := awsAwsjson11_serializeDocumentLakeFormationConfiguration(v.LakeFormationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LineageConfiguration != nil {
		ok := object.Key("LineageConfiguration")
		if err := awsAwsjson11_serializeDocumentLineageConfiguration(v.LineageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecrawlPolicy != nil {
		ok := object.Key("RecrawlPolicy")
		if err := awsAwsjson11_serializeDocumentRecrawlPolicy(v.RecrawlPolicy, ok); err != nil {
			return err
		}
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		ok.String(*v.Schedule)
	}

	if v.SchemaChangePolicy != nil {
		ok := object.Key("SchemaChangePolicy")
		if err := awsAwsjson11_serializeDocumentSchemaChangePolicy(v.SchemaChangePolicy, ok); err != nil {
			return err
		}
	}

	if v.TablePrefix != nil {
		ok := object.Key("TablePrefix")
		ok.String(*v.TablePrefix)
	}

	if v.Targets != nil {
		ok := object.Key("Targets")
		if err := awsAwsjson11_serializeDocumentCrawlerTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateCrawlerScheduleInput(v *UpdateCrawlerScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrawlerName != nil {
		ok := object.Key("CrawlerName")
		ok.String(*v.CrawlerName)
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		ok.String(*v.Schedule)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDatabaseInput(v *UpdateDatabaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseInput != nil {
		ok := object.Key("DatabaseInput")
		if err := awsAwsjson11_serializeDocumentDatabaseInput(v.DatabaseInput, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDataQualityRulesetInput(v *UpdateDataQualityRulesetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Ruleset != nil {
		ok := object.Key("Ruleset")
		ok.String(*v.Ruleset)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDevEndpointInput(v *UpdateDevEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddArguments != nil {
		ok := object.Key("AddArguments")
		if err := awsAwsjson11_serializeDocumentMapValue(v.AddArguments, ok); err != nil {
			return err
		}
	}

	if v.AddPublicKeys != nil {
		ok := object.Key("AddPublicKeys")
		if err := awsAwsjson11_serializeDocumentPublicKeysList(v.AddPublicKeys, ok); err != nil {
			return err
		}
	}

	if v.CustomLibraries != nil {
		ok := object.Key("CustomLibraries")
		if err := awsAwsjson11_serializeDocumentDevEndpointCustomLibraries(v.CustomLibraries, ok); err != nil {
			return err
		}
	}

	if v.DeleteArguments != nil {
		ok := object.Key("DeleteArguments")
		if err := awsAwsjson11_serializeDocumentStringList(v.DeleteArguments, ok); err != nil {
			return err
		}
	}

	if v.DeletePublicKeys != nil {
		ok := object.Key("DeletePublicKeys")
		if err := awsAwsjson11_serializeDocumentPublicKeysList(v.DeletePublicKeys, ok); err != nil {
			return err
		}
	}

	if v.EndpointName != nil {
		ok := object.Key("EndpointName")
		ok.String(*v.EndpointName)
	}

	if v.PublicKey != nil {
		ok := object.Key("PublicKey")
		ok.String(*v.PublicKey)
	}

	if v.UpdateEtlLibraries {
		ok := object.Key("UpdateEtlLibraries")
		ok.Boolean(v.UpdateEtlLibraries)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateJobFromSourceControlInput(v *UpdateJobFromSourceControlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthStrategy) > 0 {
		ok := object.Key("AuthStrategy")
		ok.String(string(v.AuthStrategy))
	}

	if v.AuthToken != nil {
		ok := object.Key("AuthToken")
		ok.String(*v.AuthToken)
	}

	if v.BranchName != nil {
		ok := object.Key("BranchName")
		ok.String(*v.BranchName)
	}

	if v.CommitId != nil {
		ok := object.Key("CommitId")
		ok.String(*v.CommitId)
	}

	if v.Folder != nil {
		ok := object.Key("Folder")
		ok.String(*v.Folder)
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if len(v.Provider) > 0 {
		ok := object.Key("Provider")
		ok.String(string(v.Provider))
	}

	if v.RepositoryName != nil {
		ok := object.Key("RepositoryName")
		ok.String(*v.RepositoryName)
	}

	if v.RepositoryOwner != nil {
		ok := object.Key("RepositoryOwner")
		ok.String(*v.RepositoryOwner)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateJobInput(v *UpdateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.JobUpdate != nil {
		ok := object.Key("JobUpdate")
		if err := awsAwsjson11_serializeDocumentJobUpdate(v.JobUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateMLTransformInput(v *UpdateMLTransformInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GlueVersion != nil {
		ok := object.Key("GlueVersion")
		ok.String(*v.GlueVersion)
	}

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		switch {
		case math.IsNaN(*v.MaxCapacity):
			ok.String("NaN")

		case math.IsInf(*v.MaxCapacity, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MaxCapacity, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MaxCapacity)

		}
	}

	if v.MaxRetries != nil {
		ok := object.Key("MaxRetries")
		ok.Integer(*v.MaxRetries)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NumberOfWorkers != nil {
		ok := object.Key("NumberOfWorkers")
		ok.Integer(*v.NumberOfWorkers)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentTransformParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if v.TransformId != nil {
		ok := object.Key("TransformId")
		ok.String(*v.TransformId)
	}

	if len(v.WorkerType) > 0 {
		ok := object.Key("WorkerType")
		ok.String(string(v.WorkerType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdatePartitionInput(v *UpdatePartitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.PartitionInput != nil {
		ok := object.Key("PartitionInput")
		if err := awsAwsjson11_serializeDocumentPartitionInput(v.PartitionInput, ok); err != nil {
			return err
		}
	}

	if v.PartitionValueList != nil {
		ok := object.Key("PartitionValueList")
		if err := awsAwsjson11_serializeDocumentBoundedPartitionValueList(v.PartitionValueList, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateRegistryInput(v *UpdateRegistryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		if err := awsAwsjson11_serializeDocumentRegistryId(v.RegistryId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateSchemaInput(v *UpdateSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Compatibility) > 0 {
		ok := object.Key("Compatibility")
		ok.String(string(v.Compatibility))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.SchemaId != nil {
		ok := object.Key("SchemaId")
		if err := awsAwsjson11_serializeDocumentSchemaId(v.SchemaId, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersionNumber != nil {
		ok := object.Key("SchemaVersionNumber")
		if err := awsAwsjson11_serializeDocumentSchemaVersionNumber(v.SchemaVersionNumber, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateSourceControlFromJobInput(v *UpdateSourceControlFromJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthStrategy) > 0 {
		ok := object.Key("AuthStrategy")
		ok.String(string(v.AuthStrategy))
	}

	if v.AuthToken != nil {
		ok := object.Key("AuthToken")
		ok.String(*v.AuthToken)
	}

	if v.BranchName != nil {
		ok := object.Key("BranchName")
		ok.String(*v.BranchName)
	}

	if v.CommitId != nil {
		ok := object.Key("CommitId")
		ok.String(*v.CommitId)
	}

	if v.Folder != nil {
		ok := object.Key("Folder")
		ok.String(*v.Folder)
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if len(v.Provider) > 0 {
		ok := object.Key("Provider")
		ok.String(string(v.Provider))
	}

	if v.RepositoryName != nil {
		ok := object.Key("RepositoryName")
		ok.String(*v.RepositoryName)
	}

	if v.RepositoryOwner != nil {
		ok := object.Key("RepositoryOwner")
		ok.String(*v.RepositoryOwner)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateTableInput(v *UpdateTableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Force {
		ok := object.Key("Force")
		ok.Boolean(v.Force)
	}

	if v.SkipArchive != nil {
		ok := object.Key("SkipArchive")
		ok.Boolean(*v.SkipArchive)
	}

	if v.TableInput != nil {
		ok := object.Key("TableInput")
		if err := awsAwsjson11_serializeDocumentTableInput(v.TableInput, ok); err != nil {
			return err
		}
	}

	if v.TransactionId != nil {
		ok := object.Key("TransactionId")
		ok.String(*v.TransactionId)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	if len(v.ViewUpdateAction) > 0 {
		ok := object.Key("ViewUpdateAction")
		ok.String(string(v.ViewUpdateAction))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateTableOptimizerInput(v *UpdateTableOptimizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.TableOptimizerConfiguration != nil {
		ok := object.Key("TableOptimizerConfiguration")
		if err := awsAwsjson11_serializeDocumentTableOptimizerConfiguration(v.TableOptimizerConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateTriggerInput(v *UpdateTriggerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TriggerUpdate != nil {
		ok := object.Key("TriggerUpdate")
		if err := awsAwsjson11_serializeDocumentTriggerUpdate(v.TriggerUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUsageProfileInput(v *UpdateUsageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsAwsjson11_serializeDocumentProfileConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUserDefinedFunctionInput(v *UpdateUserDefinedFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.FunctionInput != nil {
		ok := object.Key("FunctionInput")
		if err := awsAwsjson11_serializeDocumentUserDefinedFunctionInput(v.FunctionInput, ok); err != nil {
			return err
		}
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateWorkflowInput(v *UpdateWorkflowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultRunProperties != nil {
		ok := object.Key("DefaultRunProperties")
		if err := awsAwsjson11_serializeDocumentWorkflowRunProperties(v.DefaultRunProperties, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.MaxConcurrentRuns != nil {
		ok := object.Key("MaxConcurrentRuns")
		ok.Integer(*v.MaxConcurrentRuns)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}
