// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3outposts

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointRequest method.
//	req, resp := client.CreateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/CreateEndpoint
func (c *S3Outposts) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/S3Outposts/CreateEndpoint",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon S3 on Outposts.
//
// Creates an endpoint and associates it with the specified Outpost.
//
// It can take up to 5 minutes for this action to finish.
//
// Related actions include:
//
//   - DeleteEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html)
//
//   - ListEndpoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_ListEndpoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an exception with the internal server.
//
//   - ValidationException
//     There was an exception validating this data.
//
//   - AccessDeniedException
//     Access was denied for this action.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - OutpostOfflineException
//     The service link connection to your Outposts home Region is down. Check your
//     connection and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/CreateEndpoint
func (c *S3Outposts) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointRequest method.
//	req, resp := client.DeleteEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/DeleteEndpoint
func (c *S3Outposts) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/S3Outposts/DeleteEndpoint",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon S3 on Outposts.
//
// Deletes an endpoint.
//
// It can take up to 5 minutes for this action to finish.
//
// Related actions include:
//
//   - CreateEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html)
//
//   - ListEndpoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_ListEndpoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an exception with the internal server.
//
//   - AccessDeniedException
//     Access was denied for this action.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ValidationException
//     There was an exception validating this data.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - OutpostOfflineException
//     The service link connection to your Outposts home Region is down. Check your
//     connection and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/DeleteEndpoint
func (c *S3Outposts) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEndpointsRequest method.
//	req, resp := client.ListEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListEndpoints
func (c *S3Outposts) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/S3Outposts/ListEndpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon S3 on Outposts.
//
// Lists endpoints associated with the specified Outpost.
//
// Related actions include:
//
//   - CreateEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html)
//
//   - DeleteEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation ListEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an exception with the internal server.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     Access was denied for this action.
//
//   - ValidationException
//     There was an exception validating this data.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListEndpoints
func (c *S3Outposts) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEndpoints operation.
//	pageNum := 0
//	err := client.ListEndpointsPages(params,
//	    func(page *s3outposts.ListEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Outposts) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOutpostsWithS3 = "ListOutpostsWithS3"

// ListOutpostsWithS3Request generates a "aws/request.Request" representing the
// client's request for the ListOutpostsWithS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutpostsWithS3 for more information on using the ListOutpostsWithS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOutpostsWithS3Request method.
//	req, resp := client.ListOutpostsWithS3Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListOutpostsWithS3
func (c *S3Outposts) ListOutpostsWithS3Request(input *ListOutpostsWithS3Input) (req *request.Request, output *ListOutpostsWithS3Output) {
	op := &request.Operation{
		Name:       opListOutpostsWithS3,
		HTTPMethod: "GET",
		HTTPPath:   "/S3Outposts/ListOutpostsWithS3",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOutpostsWithS3Input{}
	}

	output = &ListOutpostsWithS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutpostsWithS3 API operation for Amazon S3 on Outposts.
//
// Lists the Outposts with S3 on Outposts capacity for your Amazon Web Services
// account. Includes S3 on Outposts that you have access to as the Outposts
// owner, or as a shared user from Resource Access Manager (RAM).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation ListOutpostsWithS3 for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an exception with the internal server.
//
//   - AccessDeniedException
//     Access was denied for this action.
//
//   - ValidationException
//     There was an exception validating this data.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListOutpostsWithS3
func (c *S3Outposts) ListOutpostsWithS3(input *ListOutpostsWithS3Input) (*ListOutpostsWithS3Output, error) {
	req, out := c.ListOutpostsWithS3Request(input)
	return out, req.Send()
}

// ListOutpostsWithS3WithContext is the same as ListOutpostsWithS3 with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutpostsWithS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListOutpostsWithS3WithContext(ctx aws.Context, input *ListOutpostsWithS3Input, opts ...request.Option) (*ListOutpostsWithS3Output, error) {
	req, out := c.ListOutpostsWithS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOutpostsWithS3Pages iterates over the pages of a ListOutpostsWithS3 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOutpostsWithS3 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOutpostsWithS3 operation.
//	pageNum := 0
//	err := client.ListOutpostsWithS3Pages(params,
//	    func(page *s3outposts.ListOutpostsWithS3Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Outposts) ListOutpostsWithS3Pages(input *ListOutpostsWithS3Input, fn func(*ListOutpostsWithS3Output, bool) bool) error {
	return c.ListOutpostsWithS3PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOutpostsWithS3PagesWithContext same as ListOutpostsWithS3Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListOutpostsWithS3PagesWithContext(ctx aws.Context, input *ListOutpostsWithS3Input, fn func(*ListOutpostsWithS3Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOutpostsWithS3Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOutpostsWithS3Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOutpostsWithS3Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSharedEndpoints = "ListSharedEndpoints"

// ListSharedEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListSharedEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSharedEndpoints for more information on using the ListSharedEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSharedEndpointsRequest method.
//	req, resp := client.ListSharedEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListSharedEndpoints
func (c *S3Outposts) ListSharedEndpointsRequest(input *ListSharedEndpointsInput) (req *request.Request, output *ListSharedEndpointsOutput) {
	op := &request.Operation{
		Name:       opListSharedEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/S3Outposts/ListSharedEndpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSharedEndpointsInput{}
	}

	output = &ListSharedEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSharedEndpoints API operation for Amazon S3 on Outposts.
//
// Lists all endpoints associated with an Outpost that has been shared by Amazon
// Web Services Resource Access Manager (RAM).
//
// Related actions include:
//
//   - CreateEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html)
//
//   - DeleteEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation ListSharedEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an exception with the internal server.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     Access was denied for this action.
//
//   - ValidationException
//     There was an exception validating this data.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListSharedEndpoints
func (c *S3Outposts) ListSharedEndpoints(input *ListSharedEndpointsInput) (*ListSharedEndpointsOutput, error) {
	req, out := c.ListSharedEndpointsRequest(input)
	return out, req.Send()
}

// ListSharedEndpointsWithContext is the same as ListSharedEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListSharedEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListSharedEndpointsWithContext(ctx aws.Context, input *ListSharedEndpointsInput, opts ...request.Option) (*ListSharedEndpointsOutput, error) {
	req, out := c.ListSharedEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSharedEndpointsPages iterates over the pages of a ListSharedEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSharedEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSharedEndpoints operation.
//	pageNum := 0
//	err := client.ListSharedEndpointsPages(params,
//	    func(page *s3outposts.ListSharedEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Outposts) ListSharedEndpointsPages(input *ListSharedEndpointsInput, fn func(*ListSharedEndpointsOutput, bool) bool) error {
	return c.ListSharedEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSharedEndpointsPagesWithContext same as ListSharedEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListSharedEndpointsPagesWithContext(ctx aws.Context, input *ListSharedEndpointsInput, fn func(*ListSharedEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSharedEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSharedEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSharedEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// Access was denied for this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict with this action, and it could not be completed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The type of access for the network connectivity for the Amazon S3 on Outposts
	// endpoint. To use the Amazon Web Services VPC, choose Private. To use the
	// endpoint with an on-premises network, choose CustomerOwnedIp. If you choose
	// CustomerOwnedIp, you must also provide the customer-owned IP address pool
	// (CoIP pool).
	//
	// Private is the default access type value.
	AccessType *string `type:"string" enum:"EndpointAccessType"`

	// The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint.
	// IP addresses are allocated from this pool for the endpoint.
	CustomerOwnedIpv4Pool *string `type:"string"`

	// The ID of the Outposts.
	//
	// OutpostId is a required field
	OutpostId *string `type:"string" required:"true"`

	// The ID of the security group to use with the endpoint.
	//
	// SecurityGroupId is a required field
	SecurityGroupId *string `type:"string" required:"true"`

	// The ID of the subnet in the selected VPC. The endpoint subnet must belong
	// to the Outpost that has Amazon S3 on Outposts provisioned.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.SecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupId"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessType sets the AccessType field's value.
func (s *CreateEndpointInput) SetAccessType(v string) *CreateEndpointInput {
	s.AccessType = &v
	return s
}

// SetCustomerOwnedIpv4Pool sets the CustomerOwnedIpv4Pool field's value.
func (s *CreateEndpointInput) SetCustomerOwnedIpv4Pool(v string) *CreateEndpointInput {
	s.CustomerOwnedIpv4Pool = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *CreateEndpointInput) SetOutpostId(v string) *CreateEndpointInput {
	s.OutpostId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *CreateEndpointInput) SetSecurityGroupId(v string) *CreateEndpointInput {
	s.SecurityGroupId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateEndpointInput) SetSubnetId(v string) *CreateEndpointInput {
	s.SubnetId = &v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	EndpointArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the endpoint.
	//
	// EndpointId is a required field
	EndpointId *string `location:"querystring" locationName:"endpointId" type:"string" required:"true"`

	// The ID of the Outposts.
	//
	// OutpostId is a required field
	OutpostId *string `location:"querystring" locationName:"outpostId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeleteEndpointInput) SetEndpointId(v string) *DeleteEndpointInput {
	s.EndpointId = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *DeleteEndpointInput) SetOutpostId(v string) *DeleteEndpointInput {
	s.OutpostId = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// Amazon S3 on Outposts Access Points simplify managing data access at scale
// for shared datasets in S3 on Outposts. S3 on Outposts uses endpoints to connect
// to Outposts buckets so that you can perform actions within your virtual private
// cloud (VPC). For more information, see Accessing S3 on Outposts using VPC-only
// access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/WorkingWithS3Outposts.html)
// in the Amazon Simple Storage Service User Guide.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The type of connectivity used to access the Amazon S3 on Outposts endpoint.
	AccessType *string `type:"string" enum:"EndpointAccessType"`

	// The VPC CIDR committed by this endpoint.
	CidrBlock *string `type:"string"`

	// The time the endpoint was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ID of the customer-owned IPv4 address pool used for the endpoint.
	CustomerOwnedIpv4Pool *string `type:"string"`

	// The Amazon Resource Name (ARN) of the endpoint.
	EndpointArn *string `type:"string"`

	// The failure reason, if any, for a create or delete endpoint operation.
	FailedReason *FailedReason `type:"structure"`

	// The network interface of the endpoint.
	NetworkInterfaces []*NetworkInterface `type:"list"`

	// The ID of the Outposts.
	OutpostsId *string `type:"string"`

	// The ID of the security group used for the endpoint.
	SecurityGroupId *string `type:"string"`

	// The status of the endpoint.
	Status *string `type:"string" enum:"EndpointStatus"`

	// The ID of the subnet used for the endpoint.
	SubnetId *string `type:"string"`

	// The ID of the VPC used for the endpoint.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAccessType sets the AccessType field's value.
func (s *Endpoint) SetAccessType(v string) *Endpoint {
	s.AccessType = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *Endpoint) SetCidrBlock(v string) *Endpoint {
	s.CidrBlock = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Endpoint) SetCreationTime(v time.Time) *Endpoint {
	s.CreationTime = &v
	return s
}

// SetCustomerOwnedIpv4Pool sets the CustomerOwnedIpv4Pool field's value.
func (s *Endpoint) SetCustomerOwnedIpv4Pool(v string) *Endpoint {
	s.CustomerOwnedIpv4Pool = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// SetFailedReason sets the FailedReason field's value.
func (s *Endpoint) SetFailedReason(v *FailedReason) *Endpoint {
	s.FailedReason = v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *Endpoint) SetNetworkInterfaces(v []*NetworkInterface) *Endpoint {
	s.NetworkInterfaces = v
	return s
}

// SetOutpostsId sets the OutpostsId field's value.
func (s *Endpoint) SetOutpostsId(v string) *Endpoint {
	s.OutpostsId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *Endpoint) SetSecurityGroupId(v string) *Endpoint {
	s.SecurityGroupId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Endpoint) SetStatus(v string) *Endpoint {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Endpoint) SetSubnetId(v string) *Endpoint {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Endpoint) SetVpcId(v string) *Endpoint {
	s.VpcId = &v
	return s
}

// The failure reason, if any, for a create or delete endpoint operation.
type FailedReason struct {
	_ struct{} `type:"structure"`

	// The failure code, if any, for a create or delete endpoint operation.
	ErrorCode *string `type:"string"`

	// Additional error details describing the endpoint failure and recommended
	// action.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedReason) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedReason) SetErrorCode(v string) *FailedReason {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FailedReason) SetMessage(v string) *FailedReason {
	s.Message = &v
	return s
}

// There was an exception with the internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of endpoints that will be returned in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If a previous response from this operation included a NextToken value, provide
	// that value here to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The list of endpoints associated with the specified Outpost.
	Endpoints []*Endpoint `type:"list"`

	// If the number of endpoints associated with the specified Outpost exceeds
	// MaxResults, you can include this value in subsequent calls to this operation
	// to retrieve more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointsOutput) SetEndpoints(v []*Endpoint) *ListEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListOutpostsWithS3Input struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of Outposts to return. The limit is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// When you can get additional results from the ListOutpostsWithS3 call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional Outposts.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostsWithS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostsWithS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutpostsWithS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutpostsWithS3Input"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOutpostsWithS3Input) SetMaxResults(v int64) *ListOutpostsWithS3Input {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsWithS3Input) SetNextToken(v string) *ListOutpostsWithS3Input {
	s.NextToken = &v
	return s
}

type ListOutpostsWithS3Output struct {
	_ struct{} `type:"structure"`

	// Returns a token that you can use to call ListOutpostsWithS3 again and receive
	// additional results, if there are any.
	NextToken *string `min:"1" type:"string"`

	// Returns the list of Outposts that have the following characteristics:
	//
	//    * outposts that have S3 provisioned
	//
	//    * outposts that are Active (not pending any provisioning nor decommissioned)
	//
	//    * outposts to which the the calling Amazon Web Services account has access
	Outposts []*Outpost `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostsWithS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostsWithS3Output) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsWithS3Output) SetNextToken(v string) *ListOutpostsWithS3Output {
	s.NextToken = &v
	return s
}

// SetOutposts sets the Outposts field's value.
func (s *ListOutpostsWithS3Output) SetOutposts(v []*Outpost) *ListOutpostsWithS3Output {
	s.Outposts = v
	return s
}

type ListSharedEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of endpoints that will be returned in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If a previous response from this operation included a NextToken value, you
	// can provide that value here to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the Amazon Web Services Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"querystring" locationName:"outpostId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharedEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharedEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSharedEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSharedEndpointsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSharedEndpointsInput) SetMaxResults(v int64) *ListSharedEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSharedEndpointsInput) SetNextToken(v string) *ListSharedEndpointsInput {
	s.NextToken = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *ListSharedEndpointsInput) SetOutpostId(v string) *ListSharedEndpointsInput {
	s.OutpostId = &v
	return s
}

type ListSharedEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The list of endpoints associated with the specified Outpost that have been
	// shared by Amazon Web Services Resource Access Manager (RAM).
	Endpoints []*Endpoint `type:"list"`

	// If the number of endpoints associated with the specified Outpost exceeds
	// MaxResults, you can include this value in subsequent calls to this operation
	// to retrieve more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharedEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharedEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListSharedEndpointsOutput) SetEndpoints(v []*Endpoint) *ListSharedEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSharedEndpointsOutput) SetNextToken(v string) *ListSharedEndpointsOutput {
	s.NextToken = &v
	return s
}

// The container for the network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID for the network interface.
	NetworkInterfaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// Contains the details for the Outpost object.
type Outpost struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 capacity of the outpost in bytes.
	CapacityInBytes *int64 `type:"long"`

	// Specifies the unique Amazon Resource Name (ARN) for the outpost.
	OutpostArn *string `type:"string"`

	// Specifies the unique identifier for the outpost.
	OutpostId *string `type:"string"`

	// Returns the Amazon Web Services account ID of the outpost owner. Useful for
	// comparing owned versus shared outposts.
	OwnerId *string `type:"string"`

	// Specifies the unique S3 on Outposts ARN for use with Resource Access Manager
	// (RAM).
	S3OutpostArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Outpost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Outpost) GoString() string {
	return s.String()
}

// SetCapacityInBytes sets the CapacityInBytes field's value.
func (s *Outpost) SetCapacityInBytes(v int64) *Outpost {
	s.CapacityInBytes = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *Outpost) SetOutpostArn(v string) *Outpost {
	s.OutpostArn = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *Outpost) SetOutpostId(v string) *Outpost {
	s.OutpostId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Outpost) SetOwnerId(v string) *Outpost {
	s.OwnerId = &v
	return s
}

// SetS3OutpostArn sets the S3OutpostArn field's value.
func (s *Outpost) SetS3OutpostArn(v string) *Outpost {
	s.S3OutpostArn = &v
	return s
}

// The service link connection to your Outposts home Region is down. Check your
// connection and try again.
type OutpostOfflineException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostOfflineException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostOfflineException) GoString() string {
	return s.String()
}

func newErrorOutpostOfflineException(v protocol.ResponseMetadata) error {
	return &OutpostOfflineException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OutpostOfflineException) Code() string {
	return "OutpostOfflineException"
}

// Message returns the exception's message.
func (s *OutpostOfflineException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OutpostOfflineException) OrigErr() error {
	return nil
}

func (s *OutpostOfflineException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OutpostOfflineException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OutpostOfflineException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was an exception validating this data.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// EndpointAccessTypePrivate is a EndpointAccessType enum value
	EndpointAccessTypePrivate = "Private"

	// EndpointAccessTypeCustomerOwnedIp is a EndpointAccessType enum value
	EndpointAccessTypeCustomerOwnedIp = "CustomerOwnedIp"
)

// EndpointAccessType_Values returns all elements of the EndpointAccessType enum
func EndpointAccessType_Values() []string {
	return []string{
		EndpointAccessTypePrivate,
		EndpointAccessTypeCustomerOwnedIp,
	}
}

const (
	// EndpointStatusPending is a EndpointStatus enum value
	EndpointStatusPending = "Pending"

	// EndpointStatusAvailable is a EndpointStatus enum value
	EndpointStatusAvailable = "Available"

	// EndpointStatusDeleting is a EndpointStatus enum value
	EndpointStatusDeleting = "Deleting"

	// EndpointStatusCreateFailed is a EndpointStatus enum value
	EndpointStatusCreateFailed = "Create_Failed"

	// EndpointStatusDeleteFailed is a EndpointStatus enum value
	EndpointStatusDeleteFailed = "Delete_Failed"
)

// EndpointStatus_Values returns all elements of the EndpointStatus enum
func EndpointStatus_Values() []string {
	return []string{
		EndpointStatusPending,
		EndpointStatusAvailable,
		EndpointStatusDeleting,
		EndpointStatusCreateFailed,
		EndpointStatusDeleteFailed,
	}
}
