// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: jwt_ecdsa.proto

package jwt_ecdsa_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// See https://datatracker.ietf.org/doc/html/rfc7518#section-3.4
type JwtEcdsaAlgorithm int32

const (
	JwtEcdsaAlgorithm_ES_UNKNOWN JwtEcdsaAlgorithm = 0
	JwtEcdsaAlgorithm_ES256      JwtEcdsaAlgorithm = 1 // ECDSA using P-256 and SHA-256
	JwtEcdsaAlgorithm_ES384      JwtEcdsaAlgorithm = 2 // ECDSA using P-384 and SHA-384
	JwtEcdsaAlgorithm_ES512      JwtEcdsaAlgorithm = 3 // ECDSA using P-521 and SHA-512
)

// Enum value maps for JwtEcdsaAlgorithm.
var (
	JwtEcdsaAlgorithm_name = map[int32]string{
		0: "ES_UNKNOWN",
		1: "ES256",
		2: "ES384",
		3: "ES512",
	}
	JwtEcdsaAlgorithm_value = map[string]int32{
		"ES_UNKNOWN": 0,
		"ES256":      1,
		"ES384":      2,
		"ES512":      3,
	}
)

func (x JwtEcdsaAlgorithm) Enum() *JwtEcdsaAlgorithm {
	p := new(JwtEcdsaAlgorithm)
	*p = x
	return p
}

func (x JwtEcdsaAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JwtEcdsaAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_jwt_ecdsa_proto_enumTypes[0].Descriptor()
}

func (JwtEcdsaAlgorithm) Type() protoreflect.EnumType {
	return &file_jwt_ecdsa_proto_enumTypes[0]
}

func (x JwtEcdsaAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JwtEcdsaAlgorithm.Descriptor instead.
func (JwtEcdsaAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_jwt_ecdsa_proto_rawDescGZIP(), []int{0}
}

// key_type: type.googleapis.com/google.crypto.tink.JwtEcdsaPublicKey
type JwtEcdsaPublicKey struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Version   uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm JwtEcdsaAlgorithm      `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtEcdsaAlgorithm" json:"algorithm,omitempty"`
	// Affine coordinates of the public key in big-endian representation. The
	// public key is a point (x, y) on the curve defined by algorithm.
	X             []byte                       `protobuf:"bytes,3,opt,name=x,proto3" json:"x,omitempty"`
	Y             []byte                       `protobuf:"bytes,4,opt,name=y,proto3" json:"y,omitempty"`
	CustomKid     *JwtEcdsaPublicKey_CustomKid `protobuf:"bytes,5,opt,name=custom_kid,json=customKid,proto3" json:"custom_kid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtEcdsaPublicKey) Reset() {
	*x = JwtEcdsaPublicKey{}
	mi := &file_jwt_ecdsa_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtEcdsaPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtEcdsaPublicKey) ProtoMessage() {}

func (x *JwtEcdsaPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_ecdsa_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtEcdsaPublicKey.ProtoReflect.Descriptor instead.
func (*JwtEcdsaPublicKey) Descriptor() ([]byte, []int) {
	return file_jwt_ecdsa_proto_rawDescGZIP(), []int{0}
}

func (x *JwtEcdsaPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtEcdsaPublicKey) GetAlgorithm() JwtEcdsaAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtEcdsaAlgorithm_ES_UNKNOWN
}

func (x *JwtEcdsaPublicKey) GetX() []byte {
	if x != nil {
		return x.X
	}
	return nil
}

func (x *JwtEcdsaPublicKey) GetY() []byte {
	if x != nil {
		return x.Y
	}
	return nil
}

func (x *JwtEcdsaPublicKey) GetCustomKid() *JwtEcdsaPublicKey_CustomKid {
	if x != nil {
		return x.CustomKid
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.JwtEcdsaPrivateKey
type JwtEcdsaPrivateKey struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Version   uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	PublicKey *JwtEcdsaPublicKey     `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Unsigned big integer in bigendian representation.
	KeyValue      []byte `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype and debug_redact.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtEcdsaPrivateKey) Reset() {
	*x = JwtEcdsaPrivateKey{}
	mi := &file_jwt_ecdsa_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtEcdsaPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtEcdsaPrivateKey) ProtoMessage() {}

func (x *JwtEcdsaPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_ecdsa_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtEcdsaPrivateKey.ProtoReflect.Descriptor instead.
func (*JwtEcdsaPrivateKey) Descriptor() ([]byte, []int) {
	return file_jwt_ecdsa_proto_rawDescGZIP(), []int{1}
}

func (x *JwtEcdsaPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtEcdsaPrivateKey) GetPublicKey() *JwtEcdsaPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *JwtEcdsaPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

type JwtEcdsaKeyFormat struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm     JwtEcdsaAlgorithm      `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtEcdsaAlgorithm" json:"algorithm,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtEcdsaKeyFormat) Reset() {
	*x = JwtEcdsaKeyFormat{}
	mi := &file_jwt_ecdsa_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtEcdsaKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtEcdsaKeyFormat) ProtoMessage() {}

func (x *JwtEcdsaKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_ecdsa_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtEcdsaKeyFormat.ProtoReflect.Descriptor instead.
func (*JwtEcdsaKeyFormat) Descriptor() ([]byte, []int) {
	return file_jwt_ecdsa_proto_rawDescGZIP(), []int{2}
}

func (x *JwtEcdsaKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtEcdsaKeyFormat) GetAlgorithm() JwtEcdsaAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtEcdsaAlgorithm_ES_UNKNOWN
}

// Optional, custom kid header value to be used with "RAW" keys.
// "TINK" keys with this value set will be rejected.
type JwtEcdsaPublicKey_CustomKid struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         string                 `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtEcdsaPublicKey_CustomKid) Reset() {
	*x = JwtEcdsaPublicKey_CustomKid{}
	mi := &file_jwt_ecdsa_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtEcdsaPublicKey_CustomKid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtEcdsaPublicKey_CustomKid) ProtoMessage() {}

func (x *JwtEcdsaPublicKey_CustomKid) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_ecdsa_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtEcdsaPublicKey_CustomKid.ProtoReflect.Descriptor instead.
func (*JwtEcdsaPublicKey_CustomKid) Descriptor() ([]byte, []int) {
	return file_jwt_ecdsa_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtEcdsaPublicKey_CustomKid) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_jwt_ecdsa_proto protoreflect.FileDescriptor

const file_jwt_ecdsa_proto_rawDesc = "" +
	"\n" +
	"\x0fjwt_ecdsa.proto\x12\x12google.crypto.tink\"\x81\x02\n" +
	"\x11JwtEcdsaPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12C\n" +
	"\talgorithm\x18\x02 \x01(\x0e2%.google.crypto.tink.JwtEcdsaAlgorithmR\talgorithm\x12\f\n" +
	"\x01x\x18\x03 \x01(\fR\x01x\x12\f\n" +
	"\x01y\x18\x04 \x01(\fR\x01y\x12N\n" +
	"\n" +
	"custom_kid\x18\x05 \x01(\v2/.google.crypto.tink.JwtEcdsaPublicKey.CustomKidR\tcustomKid\x1a!\n" +
	"\tCustomKid\x12\x14\n" +
	"\x05value\x18\x01 \x01(\tR\x05value\"\x91\x01\n" +
	"\x12JwtEcdsaPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12D\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2%.google.crypto.tink.JwtEcdsaPublicKeyR\tpublicKey\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValue\"r\n" +
	"\x11JwtEcdsaKeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12C\n" +
	"\talgorithm\x18\x02 \x01(\x0e2%.google.crypto.tink.JwtEcdsaAlgorithmR\talgorithm*D\n" +
	"\x11JwtEcdsaAlgorithm\x12\x0e\n" +
	"\n" +
	"ES_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ES256\x10\x01\x12\t\n" +
	"\x05ES384\x10\x02\x12\t\n" +
	"\x05ES512\x10\x03B\\\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z:github.com/tink-crypto/tink-go/v2/proto/jwt_ecdsa_go_protob\x06proto3"

var (
	file_jwt_ecdsa_proto_rawDescOnce sync.Once
	file_jwt_ecdsa_proto_rawDescData []byte
)

func file_jwt_ecdsa_proto_rawDescGZIP() []byte {
	file_jwt_ecdsa_proto_rawDescOnce.Do(func() {
		file_jwt_ecdsa_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_jwt_ecdsa_proto_rawDesc), len(file_jwt_ecdsa_proto_rawDesc)))
	})
	return file_jwt_ecdsa_proto_rawDescData
}

var file_jwt_ecdsa_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_jwt_ecdsa_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_jwt_ecdsa_proto_goTypes = []any{
	(JwtEcdsaAlgorithm)(0),              // 0: google.crypto.tink.JwtEcdsaAlgorithm
	(*JwtEcdsaPublicKey)(nil),           // 1: google.crypto.tink.JwtEcdsaPublicKey
	(*JwtEcdsaPrivateKey)(nil),          // 2: google.crypto.tink.JwtEcdsaPrivateKey
	(*JwtEcdsaKeyFormat)(nil),           // 3: google.crypto.tink.JwtEcdsaKeyFormat
	(*JwtEcdsaPublicKey_CustomKid)(nil), // 4: google.crypto.tink.JwtEcdsaPublicKey.CustomKid
}
var file_jwt_ecdsa_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.JwtEcdsaPublicKey.algorithm:type_name -> google.crypto.tink.JwtEcdsaAlgorithm
	4, // 1: google.crypto.tink.JwtEcdsaPublicKey.custom_kid:type_name -> google.crypto.tink.JwtEcdsaPublicKey.CustomKid
	1, // 2: google.crypto.tink.JwtEcdsaPrivateKey.public_key:type_name -> google.crypto.tink.JwtEcdsaPublicKey
	0, // 3: google.crypto.tink.JwtEcdsaKeyFormat.algorithm:type_name -> google.crypto.tink.JwtEcdsaAlgorithm
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_jwt_ecdsa_proto_init() }
func file_jwt_ecdsa_proto_init() {
	if File_jwt_ecdsa_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_jwt_ecdsa_proto_rawDesc), len(file_jwt_ecdsa_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_jwt_ecdsa_proto_goTypes,
		DependencyIndexes: file_jwt_ecdsa_proto_depIdxs,
		EnumInfos:         file_jwt_ecdsa_proto_enumTypes,
		MessageInfos:      file_jwt_ecdsa_proto_msgTypes,
	}.Build()
	File_jwt_ecdsa_proto = out.File
	file_jwt_ecdsa_proto_goTypes = nil
	file_jwt_ecdsa_proto_depIdxs = nil
}
