
// copicatreplay2_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  6.000000
 // --table_div  9.124721
 // --table_op  2.000000

struct tablecopicatreplay2 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicatreplay2_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicatreplay2&() const { return *(tablecopicatreplay2*)this; }
};

 static tablecopicatreplay2_imp<2048> copicatreplay2_table __rt_data = {
	0,-0.833333,682.333,2048, {
	0.000000000000,-0.000757812579,-0.001515162001,-0.002272048429,-0.003028472031,
	-0.003784432974,-0.004539931424,-0.005294967551,-0.006049541521,-0.006803653502,
	-0.007557303661,-0.008310492168,-0.009063219188,-0.009815484892,-0.010567289446,
	-0.011318633020,-0.012069515781,-0.012819937898,-0.013569899540,-0.014319400876,
	-0.015068442074,-0.015817023303,-0.016565144732,-0.017312806530,-0.018060008867,
	-0.018806751912,-0.019553035834,-0.020298860803,-0.021044226988,-0.021789134560,
	-0.022533583687,-0.023277574540,-0.024021107289,-0.024764182103,-0.025506799154,
	-0.026248958611,-0.026990660645,-0.027731905426,-0.028472693125,-0.029213023913,
	-0.029952897960,-0.030692315437,-0.031431276515,-0.032169781365,-0.032907830158,
	-0.033645423066,-0.034382560260,-0.035119241911,-0.035855468191,-0.036591239271,
	-0.037326555323,-0.038061416519,-0.038795823031,-0.039529775031,-0.040263272690,
	-0.040996316181,-0.041728905676,-0.042461041348,-0.043192723369,-0.043923951911,
	-0.044654727147,-0.045385049250,-0.046114918392,-0.046844334746,-0.047573298486,
	-0.048301809784,-0.049029868813,-0.049757475747,-0.050484630758,-0.051211334021,
	-0.051937585708,-0.052663385994,-0.053388735051,-0.054113633054,-0.054838080176,
	-0.055562076592,-0.056285622474,-0.057008717998,-0.057731363337,-0.058453558665,
	-0.059175304158,-0.059896599988,-0.060617446331,-0.061337843362,-0.062057791254,
	-0.062777290182,-0.063496340322,-0.064214941847,-0.064933094934,-0.065650799757,
	-0.066368056491,-0.067084865311,-0.067801226392,-0.068517139911,-0.069232606041,
	-0.069947624960,-0.070662196841,-0.071376321862,-0.072090000197,-0.072803232022,
	-0.073516017514,-0.074228356848,-0.074940250200,-0.075651697747,-0.076362699663,
	-0.077073256127,-0.077783367313,-0.078493033399,-0.079202254561,-0.079911030974,
	-0.080619362817,-0.081327250266,-0.082034693497,-0.082741692687,-0.083448248013,
	-0.084154359652,-0.084860027781,-0.085565252577,-0.086270034218,-0.086974372880,
	-0.087678268741,-0.088381721978,-0.089084732769,-0.089787301292,-0.090489427723,
	-0.091191112240,-0.091892355022,-0.092593156246,-0.093293516090,-0.093993434731,
	-0.094692912348,-0.095391949120,-0.096090545223,-0.096788700836,-0.097486416138,
	-0.098183691306,-0.098880526520,-0.099576921957,-0.100272877796,-0.100968394217,
	-0.101663471396,-0.102358109514,-0.103052308748,-0.103746069278,-0.104439391283,
	-0.105132274941,-0.105824720432,-0.106516727935,-0.107208297628,-0.107899429692,
	-0.108590124305,-0.109280381647,-0.109970201896,-0.110659585233,-0.111348531838,
	-0.112037041888,-0.112725115566,-0.113412753049,-0.114099954518,-0.114786720152,
	-0.115473050132,-0.116158944637,-0.116844403848,-0.117529427944,-0.118214017105,
	-0.118898171512,-0.119581891345,-0.120265176784,-0.120948028010,-0.121630445203,
	-0.122312428543,-0.122993978210,-0.123675094387,-0.124355777252,-0.125036026987,
	-0.125715843772,-0.126395227788,-0.127074179217,-0.127752698238,-0.128430785033,
	-0.129108439784,-0.129785662669,-0.130462453872,-0.131138813573,-0.131814741954,
	-0.132490239195,-0.133165305477,-0.133839940983,-0.134514145894,-0.135187920391,
	-0.135861264655,-0.136534178869,-0.137206663213,-0.137878717870,-0.138550343021,
	-0.139221538848,-0.139892305533,-0.140562643257,-0.141232552202,-0.141902032552,
	-0.142571084486,-0.143239708188,-0.143907903840,-0.144575671623,-0.145243011721,
	-0.145909924314,-0.146576409586,-0.147242467719,-0.147908098895,-0.148573303296,
	-0.149238081106,-0.149902432506,-0.150566357679,-0.151229856808,-0.151892930075,
	-0.152555577664,-0.153217799756,-0.153879596535,-0.154540968183,-0.155201914884,
	-0.155862436820,-0.156522534173,-0.157182207129,-0.157841455868,-0.158500280574,
	-0.159158681431,-0.159816658622,-0.160474212329,-0.161131342736,-0.161788050027,
	-0.162444334384,-0.163100195991,-0.163755635031,-0.164410651689,-0.165065246147,
	-0.165719418588,-0.166373169197,-0.167026498157,-0.167679405652,-0.168331891865,
	-0.168983956980,-0.169635601181,-0.170286824652,-0.170937627576,-0.171588010137,
	-0.172237972520,-0.172887514908,-0.173536637485,-0.174185340435,-0.174833623943,
	-0.175481488191,-0.176128933366,-0.176775959650,-0.177422567227,-0.178068756283,
	-0.178714527001,-0.179359879566,-0.180004814162,-0.180649330973,-0.181293430183,
	-0.181937111978,-0.182580376542,-0.183223224058,-0.183865654712,-0.184507668689,
	-0.185149266172,-0.185790447347,-0.186431212397,-0.187071561509,-0.187711494866,
	-0.188351012654,-0.188990115056,-0.189628802259,-0.190267074446,-0.190904931802,
	-0.191542374514,-0.192179402765,-0.192816016740,-0.193452216624,-0.194088002603,
	-0.194723374862,-0.195358333585,-0.195992878958,-0.196627011166,-0.197260730394,
	-0.197894036827,-0.198526930651,-0.199159412050,-0.199791481210,-0.200423138317,
	-0.201054383555,-0.201685217110,-0.202315639168,-0.202945649913,-0.203575249532,
	-0.204204438209,-0.204833216130,-0.205461583481,-0.206089540448,-0.206717087215,
	-0.207344223968,-0.207970950894,-0.208597268177,-0.209223176004,-0.209848674559,
	-0.210473764029,-0.211098444600,-0.211722716456,-0.212346579785,-0.212970034772,
	-0.213593081602,-0.214215720461,-0.214837951536,-0.215459775012,-0.216081191075,
	-0.216702199911,-0.217322801706,-0.217942996645,-0.218562784916,-0.219182166704,
	-0.219801142195,-0.220419711574,-0.221037875029,-0.221655632745,-0.222272984909,
	-0.222889931706,-0.223506473322,-0.224122609944,-0.224738341759,-0.225353668951,
	-0.225968591708,-0.226583110215,-0.227197224659,-0.227810935227,-0.228424242104,
	-0.229037145476,-0.229649645531,-0.230261742455,-0.230873436433,-0.231484727652,
	-0.232095616299,-0.232706102560,-0.233316186621,-0.233925868670,-0.234535148891,
	-0.235144027473,-0.235752504601,-0.236360580461,-0.236968255241,-0.237575529127,
	-0.238182402305,-0.238788874963,-0.239394947285,-0.240000619460,-0.240605891674,
	-0.241210764113,-0.241815236964,-0.242419310414,-0.243022984649,-0.243626259856,
	-0.244229136221,-0.244831613932,-0.245433693175,-0.246035374137,-0.246636657004,
	-0.247237541963,-0.247838029201,-0.248438118905,-0.249037811262,-0.249637106457,
	-0.250236004679,-0.250834506114,-0.251432610948,-0.252030319369,-0.252627631563,
	-0.253224547717,-0.253821068018,-0.254417192653,-0.255012921808,-0.255608255672,
	-0.256203194429,-0.256797738269,-0.257391887376,-0.257985641938,-0.258579002143,
	-0.259171968177,-0.259764540226,-0.260356718478,-0.260948503121,-0.261539894340,
	-0.262130892322,-0.262721497255,-0.263311709326,-0.263901528722,-0.264490955629,
	-0.265079990235,-0.265668632726,-0.266256883290,-0.266844742114,-0.267432209384,
	-0.268019285287,-0.268605970011,-0.269192263743,-0.269778166670,-0.270363678978,
	-0.270948800855,-0.271533532487,-0.272117874063,-0.272701825768,-0.273285387790,
	-0.273868560316,-0.274451343533,-0.275033737628,-0.275615742788,-0.276197359200,
	-0.276778587052,-0.277359426530,-0.277939877821,-0.278519941112,-0.279099616591,
	-0.279678904444,-0.280257804859,-0.280836318023,-0.281414444122,-0.281992183344,
	-0.282569535876,-0.283146501905,-0.283723081618,-0.284299275202,-0.284875082844,
	-0.285450504732,-0.286025541052,-0.286600191991,-0.287174457736,-0.287748338475,
	-0.288321834395,-0.288894945682,-0.289467672524,-0.290040015107,-0.290611973620,
	-0.291183548248,-0.291754739179,-0.292325546600,-0.292895970698,-0.293466011661,
	-0.294035669674,-0.294604944925,-0.295173837602,-0.295742347890,-0.296310475978,
	-0.296878222052,-0.297445586300,-0.298012568907,-0.298579170062,-0.299145389951,
	-0.299711228762,-0.300276686681,-0.300841763895,-0.301406460591,-0.301970776956,
	-0.302534713178,-0.303098269443,-0.303661445938,-0.304224242850,-0.304786660366,
	-0.305348698673,-0.305910357958,-0.306471638408,-0.307032540210,-0.307593063550,
	-0.308153208616,-0.308712975594,-0.309272364672,-0.309831376036,-0.310390009873,
	-0.310948266371,-0.311506145715,-0.312063648093,-0.312620773691,-0.313177522697,
	-0.313733895297,-0.314289891679,-0.314845512028,-0.315400756532,-0.315955625377,
	-0.316510118751,-0.317064236840,-0.317617979830,-0.318171347909,-0.318724341263,
	-0.319276960080,-0.319829204545,-0.320381074846,-0.320932571168,-0.321483693700,
	-0.322034442627,-0.322584818137,-0.323134820415,-0.323684449648,-0.324233706024,
	-0.324782589729,-0.325331100949,-0.325879239871,-0.326427006682,-0.326974401567,
	-0.327521424714,-0.328068076310,-0.328614356540,-0.329160265592,-0.329705803651,
	-0.330250970905,-0.330795767540,-0.331340193741,-0.331884249697,-0.332427935592,
	-0.332971251614,-0.333514197949,-0.334056774784,-0.334598982304,-0.335140820696,
	-0.335682290147,-0.336223390843,-0.336764122970,-0.337304486714,-0.337844482262,
	-0.338384109800,-0.338923369514,-0.339462261591,-0.340000786216,-0.340538943577,
	-0.341076733858,-0.341614157247,-0.342151213930,-0.342687904092,-0.343224227920,
	-0.343760185600,-0.344295777318,-0.344831003260,-0.345365863612,-0.345900358561,
	-0.346434488291,-0.346968252990,-0.347501652844,-0.348034688037,-0.348567358756,
	-0.349099665188,-0.349631607518,-0.350163185931,-0.350694400615,-0.351225251754,
	-0.351755739535,-0.352285864143,-0.352815625764,-0.353345024584,-0.353874060789,
	-0.354402734564,-0.354931046095,-0.355458995569,-0.355986583170,-0.356513809084,
	-0.357040673497,-0.357567176595,-0.358093318563,-0.358619099587,-0.359144519851,
	-0.359669579543,-0.360194278847,-0.360718617949,-0.361242597035,-0.361766216289,
	-0.362289475897,-0.362812376045,-0.363334916918,-0.363857098702,-0.364378921581,
	-0.364900385742,-0.365421491369,-0.365942238647,-0.366462627763,-0.366982658901,
	-0.367502332246,-0.368021647984,-0.368540606299,-0.369059207378,-0.369577451404,
	-0.370095338564,-0.370612869042,-0.371130043023,-0.371646860693,-0.372163322235,
	-0.372679427837,-0.373195177681,-0.373710571953,-0.374225610839,-0.374740294522,
	-0.375254623189,-0.375768597023,-0.376282216209,-0.376795480933,-0.377308391378,
	-0.377820947731,-0.378333150175,-0.378844998894,-0.379356494075,-0.379867635901,
	-0.380378424557,-0.380888860228,-0.381398943097,-0.381908673351,-0.382418051172,
	-0.382927076746,-0.383435750257,-0.383944071890,-0.384452041828,-0.384959660256,
	-0.385466927360,-0.385973843322,-0.386480408327,-0.386986622559,-0.387492486203,
	-0.387997999443,-0.388503162463,-0.389007975447,-0.389512438579,-0.390016552044,
	-0.390520316025,-0.391023730706,-0.391526796271,-0.392029512906,-0.392531880792,
	-0.393033900114,-0.393535571057,-0.394036893804,-0.394537868538,-0.395038495444,
	-0.395538774705,-0.396038706506,-0.396538291029,-0.397037528459,-0.397536418979,
	-0.398034962772,-0.398533160023,-0.399031010915,-0.399528515631,-0.400025674355,
	-0.400522487270,-0.401018954560,-0.401515076408,-0.402010852998,-0.402506284513,
	-0.403001371136,-0.403496113050,-0.403990510440,-0.404484563487,-0.404978272375,
	-0.405471637288,-0.405964658408,-0.406457335918,-0.406949670002,-0.407441660843,
	-0.407933308623,-0.408424613525,-0.408915575734,-0.409406195430,-0.409896472798,
	-0.410386408019,-0.410876001278,-0.411365252756,-0.411854162636,-0.412342731102,
	-0.412830958335,-0.413318844518,-0.413806389835,-0.414293594467,-0.414780458596,
	-0.415266982407,-0.415753166080,-0.416239009798,-0.416724513745,-0.417209678101,
	-0.417694503050,-0.418178988773,-0.418663135454,-0.419146943274,-0.419630412415,
	-0.420113543060,-0.420596335390,-0.421078789588,-0.421560905836,-0.422042684315,
	-0.422524125209,-0.423005228698,-0.423485994964,-0.423966424190,-0.424446516557,
	-0.424926272248,-0.425405691443,-0.425884774325,-0.426363521075,-0.426841931875,
	-0.427320006906,-0.427797746351,-0.428275150390,-0.428752219205,-0.429228952978,
	-0.429705351890,-0.430181416122,-0.430657145856,-0.431132541273,-0.431607602554,
	-0.432082329881,-0.432556723435,-0.433030783397,-0.433504509948,-0.433977903269,
	-0.434450963541,-0.434923690946,-0.435396085664,-0.435868147876,-0.436339877763,
	-0.436811275507,-0.437282341287,-0.437753075284,-0.438223477680,-0.438693548655,
	-0.439163288389,-0.439632697064,-0.440101774860,-0.440570521957,-0.441038938536,
	-0.441507024778,-0.441974780863,-0.442442206971,-0.442909303282,-0.443376069978,
	-0.443842507238,-0.444308615242,-0.444774394171,-0.445239844205,-0.445704965523,
	-0.446169758307,-0.446634222736,-0.447098358990,-0.447562167249,-0.448025647693,
	-0.448488800501,-0.448951625855,-0.449414123932,-0.449876294914,-0.450338138980,
	-0.450799656309,-0.451260847082,-0.451721711477,-0.452182249675,-0.452642461855,
	-0.453102348195,-0.453561908877,-0.454021144079,-0.454480053980,-0.454938638759,
	-0.455396898597,-0.455854833672,-0.456312444164,-0.456769730251,-0.457226692112,
	-0.457683329927,-0.458139643875,-0.458595634134,-0.459051300884,-0.459506644303,
	-0.459961664570,-0.460416361865,-0.460870736365,-0.461324788249,-0.461778517697,
	-0.462231924886,-0.462685009996,-0.463137773204,-0.463590214690,-0.464042334631,
	-0.464494133207,-0.464945610595,-0.465396766974,-0.465847602522,-0.466298117417,
	-0.466748311837,-0.467198185962,-0.467647739967,-0.468096974033,-0.468545888336,
	-0.468994483055,-0.469442758368,-0.469890714452,-0.470338351485,-0.470785669646,
	-0.471232669111,-0.471679350058,-0.472125712666,-0.472571757112,-0.473017483572,
	-0.473462892226,-0.473907983250,-0.474352756821,-0.474797213118,-0.475241352317,
	-0.475685174595,-0.476128680130,-0.476571869100,-0.477014741680,-0.477457298049,
	-0.477899538384,-0.478341462860,-0.478783071656,-0.479224364948,-0.479665342913,
	-0.480106005729,-0.480546353570,-0.480986386616,-0.481426105041,-0.481865509023,
	-0.482304598738,-0.482743374363,-0.483181836075,-0.483619984049,-0.484057818463,
	-0.484495339492,-0.484932547313,-0.485369442102,-0.485806024035,-0.486242293289,
	-0.486678250039,-0.487113894462,-0.487549226734,-0.487984247030,-0.488418955527,
	-0.488853352401,-0.489287437826,-0.489721211980,-0.490154675037,-0.490587827174,
	-0.491020668566,-0.491453199389,-0.491885419818,-0.492317330029,-0.492748930197,
	-0.493180220497,-0.493611201105,-0.494041872197,-0.494472233947,-0.494902286531,
	-0.495332030123,-0.495761464900,-0.496190591035,-0.496619408704,-0.497047918082,
	-0.497476119344,-0.497904012665,-0.498331598219,-0.498758876182,-0.499185846727,
	-0.499612510030,-0.500038866265,-0.500464915607,-0.500890658230,-0.501316094309,
	-0.501741224018,-0.502166047532,-0.502590565024,-0.503014776670,-0.503438682643,
	-0.503862283117,-0.504285578267,-0.504708568266,-0.505131253289,-0.505553633509,
	-0.505975709101,-0.506397480239,-0.506818947095,-0.507240109844,-0.507660968660,
	-0.508081523716,-0.508501775186,-0.508921723244,-0.509341368062,-0.509760709815,
	-0.510179748675,-0.510598484816,-0.511016918412,-0.511435049636,-0.511852878660,
	-0.512270405658,-0.512687630803,-0.513104554269,-0.513521176227,-0.513937496851,
	-0.514353516315,-0.514769234790,-0.515184652449,-0.515599769466,-0.516014586012,
	-0.516429102261,-0.516843318385,-0.517257234557,-0.517670850949,-0.518084167733,
	-0.518497185082,-0.518909903168,-0.519322322164,-0.519734442241,-0.520146263572,
	-0.520557786329,-0.520969010683,-0.521379936808,-0.521790564874,-0.522200895054,
	-0.522610927520,-0.523020662443,-0.523430099995,-0.523839240348,-0.524248083673,
	-0.524656630142,-0.525064879926,-0.525472833197,-0.525880490127,-0.526287850886,
	-0.526694915646,-0.527101684578,-0.527508157854,-0.527914335644,-0.528320218120,
	-0.528725805452,-0.529131097812,-0.529536095371,-0.529940798299,-0.530345206767,
	-0.530749320946,-0.531153141007,-0.531556667120,-0.531959899457,-0.532362838186,
	-0.532765483480,-0.533167835508,-0.533569894441,-0.533971660449,-0.534373133702,
	-0.534774314371,-0.535175202625,-0.535575798636,-0.535976102573,-0.536376114605,
	-0.536775834903,-0.537175263637,-0.537574400977,-0.537973247092,-0.538371802152,
	-0.538770066327,-0.539168039786,-0.539565722699,-0.539963115236,-0.540360217565,
	-0.540757029857,-0.541153552281,-0.541549785005,-0.541945728199,-0.542341382033,
	-0.542736746675,-0.543131822294,-0.543526609060,-0.543921107142,-0.544315316707,
	-0.544709237926,-0.545102870967,-0.545496215998,-0.545889273189,-0.546282042707,
	-0.546674524722,-0.547066719402,-0.547458626915,-0.547850247431,-0.548241581116,
	-0.548632628139,-0.549023388670,-0.549413862874,-0.549804050922,-0.550193952981,
	-0.550583569219,-0.550972899803,-0.551361944902,-0.551750704684,-0.552139179316,
	-0.552527368966,-0.552915273801,-0.553302893990,-0.553690229700,-0.554077281097,
	-0.554464048351,-0.554850531628,-0.555236731094,-0.555622646919,-0.556008279268,
	-0.556393628309,-0.556778694209,-0.557163477136,-0.557547977255,-0.557932194734,
	-0.558316129740,-0.558699782439,-0.559083152998,-0.559466241585,-0.559849048365,
	-0.560231573505,-0.560613817171,-0.560995779531,-0.561377460750,-0.561758860995,
	-0.562139980432,-0.562520819227,-0.562901377547,-0.563281655557,-0.563661653424,
	-0.564041371313,-0.564420809390,-0.564799967822,-0.565178846774,-0.565557446411,
	-0.565935766901,-0.566313808407,-0.566691571096,-0.567069055133,-0.567446260684,
	-0.567823187914,-0.568199836989,-0.568576208073,-0.568952301332,-0.569328116932,
	-0.569703655036,-0.570078915810,-0.570453899420,-0.570828606030,-0.571203035805,
	-0.571577188910,-0.571951065509,-0.572324665767,-0.572697989850,-0.573071037921,
	-0.573443810144,-0.573816306685,-0.574188527708,-0.574560473377,-0.574932143857,
	-0.575303539311,-0.575674659904,-0.576045505799,-0.576416077162,-0.576786374155,
	-0.577156396943,-0.577526145690,-0.577895620559,-0.578264821715,-0.578633749320,
	-0.579002403539,-0.579370784535,-0.579738892471,-0.580106727512,-0.580474289819,
	-0.580841579558,-0.581208596890,-0.581575341980,-0.581941814989,-0.582308016082,
	-0.582673945422,-0.583039603170,-0.583404989491,-0.583770104547,-0.584134948501,
	-0.584499521516,-0.584863823753,-0.585227855377,-0.585591616549,-0.585955107431,
	-0.586318328187,-0.586681278979,-0.587043959968,-0.587406371318,-0.587768513189,
	-0.588130385746,-0.588491989148,-0.588853323560,-0.589214389141,-0.589575186055,
	-0.589935714463,-0.590295974526,-0.590655966407,-0.591015690268,-0.591375146269,
	-0.591734334572,-0.592093255339,-0.592451908731,-0.592810294909,-0.593168414035,
	-0.593526266269,-0.593883851774,-0.594241170709,-0.594598223237,-0.594955009518,
	-0.595311529712,-0.595667783981,-0.596023772486,-0.596379495387,-0.596734952845,
	-0.597090145020,-0.597445072073,-0.597799734164,-0.598154131455,-0.598508264104,
	-0.598862132273,-0.599215736122,-0.599569075810,-0.599922151499,-0.600274963347,
	-0.600627511515,-0.600979796163,-0.601331817451,-0.601683575538,-0.602035070584,
	-0.602386302749,-0.602737272193,-0.603087979074,-0.603438423553,-0.603788605789,
	-0.604138525941,-0.604488184169,-0.604837580631,-0.605186715487,-0.605535588896,
	-0.605884201018,-0.606232552010,-0.606580642032,-0.606928471243,-0.607276039802,
	-0.607623347866,-0.607970395596,-0.608317183150,-0.608663710685,-0.609009978361,
	-0.609355986336,-0.609701734769,-0.610047223817,-0.610392453639,-0.610737424393,
	-0.611082136238,-0.611426589330,-0.611770783829,-0.612114719892,-0.612458397677,
	-0.612801817341,-0.613144979043,-0.613487882940,-0.613830529190,-0.614172917951,
	-0.614515049379,-0.614856923632,-0.615198540868,-0.615539901244,-0.615881004916,
	-0.616221852043,-0.616562442781,-0.616902777288,-0.617242855720,-0.617582678234,
	-0.617922244987,-0.618261556137,-0.618600611839,-0.618939412250,-0.619277957527,
	-0.619616247826,-0.619954283304,-0.620292064118,-0.620629590423,-0.620966862376,
	-0.621303880133,-0.621640643850,-0.621977153684,-0.622313409790,-0.622649412324,
	-0.622985161443,-0.623320657302,-0.623655900057,-0.623990889863,-0.624325626876,
	-0.624660111252,-0.624994343147,-0.625328322715,-0.625662050113,-0.625995525495,
	-0.626328749016,-0.626661720833,-0.626994441100,-0.627326909972,-0.627659127604,
	-0.627991094151,-0.628322809768,-0.628654274610,-0.628985488832,-0.629316452588,
	-0.629647166033,-0.629977629321,-0.630307842607,-0.630637806046,-0.630967519791,
	-0.631296983998,-0.631626198819,-0.631955164411,-0.632283880926,-0.632612348518,
	-0.632940567342,-0.633268537552,-0.633596259302,-0.633923732744,-0.634250958034,
	-0.634577935324,-0.634904664768,-0.635231146520,-0.635557380733,-0.635883367561,
	-0.636209107158,-0.636534599675,-0.636859845267,-0.637184844086,-0.637509596286,
	-0.637834102021,-0.638158361441,-0.638482374702,-0.638806141955,-0.639129663353,
	-0.639452939049,-0.639775969196,-0.640098753945,-0.640421293451,-0.640743587864,
	-0.641065637339,-0.641387442025,-0.641709002077,-0.642030317647,-0.642351388885,
	-0.642672215945,-0.642992798979,-0.643313138138,-0.643633233574,-0.643953085439,
	-0.644272693884,-0.644592059063,-0.644911181125,-0.645230060223,-0.645548696508,
	-0.645867090131,-0.646185241244,-0.646503149999,-0.646820816545,-0.647138241035,
	-0.647455423620,-0.647772364450,-0.648089063677,-0.648405521451,-0.648721737923,
	-0.649037713245,-0.649353447566,-0.649668941038,-0.649984193810,-0.650299206034,
	-0.650613977860,-0.650928509438,-0.651242800919,-0.651556852452,-0.651870664188,
	-0.652184236278,-0.652497568871,-0.652810662116,-0.653123516165,-0.653436131167,
	-0.653748507271,-0.654060644628,-0.654372543387,-0.654684203698,-0.654995625710,
	-0.655306809572,-0.655617755435,-0.655928463447,-0.656238933757,-0.656549166516,
	-0.656859161871,-0.657168919973,-0.657478440970,-0.657787725011,-0.658096772244,
	-0.658405582820,-0.658714156886,-0.659022494591,-0.659330596083,-0.659638461513,
	-0.659946091027,-0.660253484774,-0.660560642902,-0.660867565561,-0.661174252898,
	-0.661480705061,-0.661786922198,-0.662092904458,-0.662398651988,-0.662704164936,
	-0.663009443450,-0.663314487679,-0.663619297768,-0.663923873867,-0.664228216123,
	-0.664532324683,-0.664836199694,-0.665139841305,-0.665443249662,-0.665746424913,
	-0.666049367204,-0.666352076683,-0.666654553498,-0.666956797794,-0.667258809719,
	-0.667560589419,-0.667862137043,-0.668163452735,-0.668464536643,-0.668765388914,
	-0.669066009693,-0.669366399128,-0.669666557365,-0.669966484550,-0.670266180829,
	-0.670565646349,-0.670864881256,-0.671163885695,-0.671462659813,-0.671761203756,
	-0.672059517669,-0.672357601699,-0.672655455991,-0.672953080690,-0.673250475943,
	-0.673547641895,-0.673844578691,-0.674141286477,-0.674437765398,-0.674734015599,
	-0.675030037226,-0.675325830424,-0.675621395337,-0.675916732112,-0.676211840892,
	-0.676506721822,-0.676801375048,-0.677095800714,-0.677389998966,-0.677683969946,
	-0.677977713801,-0.678271230674,-0.678564520710,-0.678857584054,-0.679150420849,
	-0.679443031239,-0.679735415370,-0.680027573385,-0.680319505427,-0.680611211642,
	-0.680902692173,-0.681193947163,-0.681484976757,-0.681775781098,-0.682066360330,
	-0.682356714596,-0.682646844040,-0.682936748805,-0.683226429035,-0.683515884873,
	-0.683805116462,-0.684094123946,-0.684382907466,-0.684671467168,-0.684959803192,
	-0.685247915683,-0.685535804784,-0.685823470636,-0.686110913383,-0.686398133167,
	-0.686685130130,-0.686971904417,-0.687258456168,-0.687544785526,-0.687830892633,
	-0.688116777633,-0.688402440666,-0.688687881875,-0.688973101402,-0.689258099390,
	-0.689542875979,-0.689827431312,-0.690111765530,-0.690395878776,-0.690679771190,
	-0.690963442915,-0.691246894092,-0.691530124863,-0.691813135368,-0.692095925749,
	-0.692378496148,-0.692660846705,-0.692942977562,-0.693224888860,-0.693506580740,
	-0.693788053342,-0.694069306807,-0.694350341277,-0.694631156892,-0.694911753792,
	-0.695192132119,-0.695472292013,-0.695752233613,-0.696031957061,-0.696311462498,
	-0.696590750062,-0.696869819895,-0.697148672136,-0.697427306926,-0.697705724404,
	-0.697983924711,-0.698261907986,-0.698539674369,-0.698817224000,-0.699094557019,
	-0.699371673565,-0.699648573777,-0.699925257796,-0.700201725760,-0.700477977809,
	-0.700754014082,-0.701029834718,-0.701305439857,-0.701580829637,-0.701856004197,
	-0.702130963678,-0.702405708216,-0.702680237952,-0.702954553023,-0.703228653569,
	-0.703502539728,-0.703776211639,-0.704049669439,-0.704322913269,-0.704595943265,
	-0.704868759566,-0.705141362311,-0.705413751637,-0.705685927683,-0.705957890586,
	-0.706229640485,-0.706501177517,-0.706772501821,-0.707043613533,-0.707314512792,
	-0.707585199735,-0.707855674500,-0.708125937224,-0.708395988045,-0.708665827100,
	-0.708935454526,-0.709204870461,-0.709474075041,-0.709743068404,-0.710011850687,
	-0.710280422027,-0.710548782560,-0.710816932423,-0.711084871754,-0.711352600688,
	-0.711620119363,-0.711887427915,-0.712154526481,-0.712421415196,-0.712688094198,
	-0.712954563622,-0.713220823605,-0.713486874283,-0.713752715792,-0.714018348268,
	-0.714283771847,-0.714548986665,-0.714813992857,-0.715078790560,-0.715343379910,
	-0.715607761041,-0.715871934089,-0.716135899190,-0.716399656480,-0.716663206093,
	-0.716926548165,-0.717189682832,-0.717452610227,-0.717715330487,-0.717977843747,
	-0.718240150141,-0.718502249804,-0.718764142872,-0.719025829478,-0.719287309758,
	-0.719548583847,-0.719809651878,-0.720070513986,-0.720331170306,-0.720591620973,
	-0.720851866120,-0.721111905881,-0.721371740392,-0.721631369785,-0.721890794196,
	-0.722150013757,-0.722409028603,-0.722667838868,-0.722926444686,-0.723184846190,
	-0.723443043513,-0.723701036790,-0.723958826155,-0.724216411739,-0.724473793677,
	-0.724730972103,-0.724987947148,-0.725244718948,-0.725501287634,-0.725757653339,
	-0.726013816197,-0.726269776341,-0.726525533904,-0.726781089017,-0.727036441815,
	-0.727291592429,-0.727546540992,-0.727801287638,-0.728055832497,-0.728310175703,
	-0.728564317388,-0.728818257684,-0.729071996723,-0.729325534638,-0.729578871560,
	-0.729832007622,-0.730084942955,-0.730337677692,-0.730590211964,-0.730842545902,
	-0.731094679640,-0.731346613307,-0.731598347036,-0.731849880958,-0.732101215205,
	-0.732352349907,-0.732603285197,-0.732854021205,-0.733104558062,-0.733354895900,
	-0.733605034850,-0.733854975042,-0.734104716608,-0.734354259677,-0.734603604382,
	-0.734852750852,-0.735101699219,-0.735350449612,-0.735599002163,-0.735847357001,
	-0.736095514257,-0.736343474062,-0.736591236545,-0.736838801836,-0.737086170067,
	-0.737333341366,-0.737580315864,-0.737827093691,-0.738073674976,-0.738320059849,
	-0.738566248440,-0.738812240879,-0.739058037295,-0.739303637817,-0.739549042576,
	-0.739794251700,-0.740039265318,-0.740284083561,-0.740528706556,-0.740773134434,
	-0.741017367323,-0.741261405352,-0.741505248650,-0.741748897346,-0.741992351569,
	-0.742235611447,-0.742478677110,-0.742721548685,-0.742964226301,-0.743206710086,
	-0.743449000170,-0.743691096680,-0.743932999744,-0.744174709492,-0.744416226050,
	-0.744657549546,-0.744898680110,-0.745139617869,-0.745380362950,-0.745620915482,
	-0.745861275592,-0.746101443407,-0.746341419056,-0.746581202667,-0.746820794365,
	-0.747060194279,-0.747299402537,-0.747538419265,-0.747777244590,-0.748015878641,
	-0.748254321543,-0.748492573424,-0.748730634410,-0.748968504630,-0.749206184208,
	-0.749443673273,-0.749680971951,-0.749918080369,-0.750154998652,-0.750391726928,
	-0.750628265323,-0.750864613963,-0.751100772975,-0.751336742485,-0.751572522618,
	-0.751808113502,-0.752043515262,-0.752278728024,-0.752513751913,-0.752748587057,
	-0.752983233580,-0.753217691608,-0.753451961268,-0.753686042683,-0.753919935981,
	-0.754153641286,-0.754387158724,-0.754620488419,-0.754853630499,-0.755086585086,
	-0.755319352308,-0.755551932288,-0.755784325151,-0.756016531024,-0.756248550029,
	-0.756480382293,-0.756712027940,-0.756943487094,-0.757174759881,-0.757405846424,
	-0.757636746849,-0.757867461279,-0.758097989839,-0.758328332653,-0.758558489846,
	-0.758788461541,-0.759018247863,-0.759247848935,-0.759477264882,-0.759706495828,
	-0.759935541896,-0.760164403209,-0.760393079893,-0.760621572070,-0.760849879863,
	-0.761078003397,-0.761305942795,-0.761533698180,-0.761761269676,-0.761988657405,
	-0.762215861491,-0.762442882057,-0.762669719226,-0.762896373121,-0.763122843864,
	-0.763349131580,-0.763575236390,-0.763801158417,-0.764026897784,-0.764252454614,
	-0.764477829029,-0.764703021151,-0.764928031102,-0.765152859006,-0.765377504985,
	-0.765601969160,-0.765826251653,-0.766050352588,-0.766274272085,-0.766498010267,
	-0.766721567256,-0.766944943173,-0.767168138141,-0.767391152280,-0.767613985712,
	-0.767836638560,-0.768059110944,-0.768281402987,-0.768503514808,-0.768725446530,
	-0.768947198274,-0.769168770161,-0.769390162312,-0.769611374848,-0.769832407890,
	-0.770053261560,-0.770273935977,-0.770494431263,-0.770714747538,-0.770934884923,
	-0.771154843539,-0.771374623506,-0.771594224944,-0.771813647974,-0.772032892717,
	-0.772251959292,-0.772470847820,-0.772689558421,-0.772908091215,-0.773126446322,
	-0.773344623862,-0.773562623955,-0.773780446720,-0.773998092278,-0.774215560748,
	-0.774432852249,-0.774649966902,-0.774866904825,-0.775083666139,-0.775300250962,
	-0.775516659415,-0.775732891615,-0.775948947682,-0.776164827736,-0.776380531896,
	-0.776596060279,-0.776811413006,-0.777026590196,-0.777241591966,-0.777456418436,
	-0.777671069725,-0.777885545950,-0.778099847231,-0.778313973686,-0.778527925434,
	-0.778741702592,-0.778955305279,-0.779168733614,-0.779381987713,-0.779595067697,
	-0.779807973682,-0.780020705786,-0.780233264128,-0.780445648825,-0.780657859996,
	-0.780869897756,-0.781081762226,-0.781293453521,-0.781504971759,-0.781716317059,
	-0.781927489537,-0.782138489310,-0.782349316497,-0.782559971213,-0.782770453577,
	-0.782980763705,-0.783190901715,-0.783400867722,-0.783610661845,-0.783820284200,
	-0.784029734904,-0.784239014073,-0.784448121824,-0.784657058274,-0.784865823538,
	-0.785074417735,-0.785282840979,-0.785491093388,-0.785699175077,-0.785907086162,
	-0.786114826761,-0.786322396989,-0.786529796961,-0.786737026794,-0.786944086604,
	-0.787150976506,-0.787357696616,-0.787564247051,-0.787770627925,-0.787976839354,
	-0.788182881453,-0.788388754339,-0.788594458126,-0.788799992929,-0.789005358865,
	-0.789210556047,-0.789415584592,-0.789620444614,-0.789825136228,-0.790029659549,
	-0.790234014692,-0.790438201772,-0.790642220904,-0.790846072202,-0.791049755780,
	-0.791253271754,-0.791456620238,-0.791659801346,-0.791862815193,-0.792065661893,
	-0.792268341560,-0.792470854308,-0.792673200251,-0.792875379504,-0.793077392181,
	-0.793279238394,-0.793480918259,-0.793682431889,-0.793883779398,-0.794084960899,
	-0.794285976507,-0.794486826333,-0.794687510493,-0.794888029099,-0.795088382265,
	-0.795288570105,-0.795488592730,-0.795688450255,-0.795888142793,-0.796087670456,
	-0.796287033358,-0.796486231611,-0.796685265329,-0.796884134623,-0.797082839608,
	-0.797281380396,-0.797479757098,-0.797677969829,-0.797876018699,-0.798073903822,
	-0.798271625310,-0.798469183275,-0.798666577830,-0.798863809087,-0.799060877157,
	-0.799257782153,-0.799454524187,-0.799651103371,-0.799847519816,-0.800043773634,
	-0.800239864938,-0.800435793838,-0.800631560447,-0.800827164876,-0.801022607236,
	-0.801217887639,-0.801413006196,-0.801607963018,-0.801802758218,-0.801997391905,
	-0.802191864191,-0.802386175187,-0.802580325005,-0.802774313754,-0.802968141546,
	-0.803161808492,-0.803355314702,-0.803548660287,-0.803741845358,-0.803934870025,
	-0.804127734399,-0.804320438590,-0.804512982709,-0.804705366865,-0.804897591170,
	-0.805089655733,-0.805281560664,-0.805473306073,-0.805664892072,-0.805856318768,
	-0.806047586273,-0.806238694695,-0.806429644146,-0.806620434734,-0.806811066570,
	-0.807001539762,-0.807191854420,-0.807382010654,-0.807572008573,-0.807761848286,
	-0.807951529903,-0.808141053533,-0.808330419285,-0.808519627268,-0.808708677591,
	-0.808897570363,-0.809086305693,-0.809274883690,-0.809463304462,-0.809651568119,
	-0.809839674768,-0.810027624519,-0.810215417480,-0.810403053759,-0.810590533465,
	-0.810777856707,-0.810965023592,-0.811152034228,-0.811338888725,-0.811525587189,
	-0.811712129729,-0.811898516454,-0.812084747470,-0.812270822886,-0.812456742809,
	-0.812642507348,-0.812828116610,-0.813013570702,-0.813198869732,-0.813384013808,
	-0.813569003037,-0.813753837526,-0.813938517383,-0.814123042715,-0.814307413629,
	-0.814491630232,-0.814675692632,-0.814859600934,-0.815043355247,-0.815226955677,
	-0.815410402331,-0.815593695316,-0.815776834738,-0.815959820704,-0.816142653321,
	-0.816325332695,-0.816507858932,-0.816690232139,-0.816872452423,-0.817054519889,
	-0.817236434643,-0.817418196793,-0.817599806444,-0.817781263702,-0.817962568673,
	-0.818143721462,-0.818324722177,-0.818505570922,-0.818686267803,-0.818866812927,
	-0.819047206398,-0.819227448322,-0.819407538804,-0.819587477951,-0.819767265867,
	-0.819946902658,-0.820126388429,-0.820305723285,-0.820484907331,-0.820663940672,
	-0.820842823414,-0.821021555661,-0.821200137519,-0.821378569091,-0.821556850483,
	-0.821734981799,-0.821912963145,-0.822090794624,-0.822268476342,-0.822446008402,
	-0.822623390910,-0.822800623969,-0.822977707683,-0.823154642158,-0.823331427496,
	-0.823508063803,-0.823684551182,-0.823860889738,-0.824037079573,-0.824213120793,
	-0.824389013500,-0.824564757800,-0.824740353794,-0.824915801587,-0.825091101283,
	-0.825266252985,-0.825441256797,-0.825616112821,-0.825790821161,-0.825965381921,
	-0.826139795204,-0.826314061112,-0.826488179749,-0.826662151218,-0.826835975622,
	-0.827009653064,-0.827183183647,-0.827356567473,-0.827529804645,-0.827702895267,
	-0.827875839439,-0.828048637266,-0.828221288849,-0.828393794292,-0.828566153695,
	-0.828738367163,-0.828910434796,-0.829082356698,-0.829254132970,-0.829425763714,
	-0.829597249033,-0.829768589028,-0.829939783801,-0.830110833455,-0.830281738090,
	-0.830452497809,-0.830623112714,-0.830793582905,-0.830963908485,-0.831134089555,
	-0.831304126216,-0.831474018570,-0.831643766718,-0.831813370762,-0.831982830802,
	-0.832152146940,-0.832321319276,-0.832490347913,-0.832659232950,-0.832827974489,
	-0.832996572631,-0.833165027475,-0.833333339124
	}
};

double always_inline copicatreplay2clip(double x) {
    double f = fabs(x);
    f = f * copicatreplay2_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicatreplay2_table.data[0];
    } else if (i >= copicatreplay2_table.size-1) {
        f = copicatreplay2_table.data[copicatreplay2_table.size-1];
    } else {
    f -= i;
    f = copicatreplay2_table.data[i]*(1-f) + copicatreplay2_table.data[i+1]*f;
    }
    return copysign(f, x);
}

