/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * OMAP54xx CM1 instance offset macros
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - https://www.ti.com
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CM1_54XX_H
#define __ARCH_ARM_MACH_OMAP2_CM1_54XX_H

/* CM1 base address */
#define OMAP54XX_CM_CORE_AON_BASE		0x4a004000

#define OMAP54XX_CM_CORE_AON_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(OMAP54XX_CM_CORE_AON_BASE + (inst) + (reg))

/* CM_CORE_AON instances */
#define OMAP54XX_CM_CORE_AON_OCP_SOCKET_INST	0x0000
#define OMAP54XX_CM_CORE_AON_CKGEN_INST		0x0100
#define OMAP54XX_CM_CORE_AON_MPU_INST		0x0300
#define OMAP54XX_CM_CORE_AON_DSP_INST		0x0400
#define OMAP54XX_CM_CORE_AON_ABE_INST		0x0500

/* CM_CORE_AON clockdomain register offsets (from instance start) */
#define OMAP54XX_CM_CORE_AON_MPU_MPU_CDOFFS	0x0000
#define OMAP54XX_CM_CORE_AON_DSP_DSP_CDOFFS	0x0000
#define OMAP54XX_CM_CORE_AON_ABE_ABE_CDOFFS	0x0000

#endif
