use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'Sendmail';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce', 'toxic'], [...]]
    '1001'  => [['5.1.1',   '550', 'suspend',         0, 1]],
    '1002'  => [['4.4.1',   '',    'blocked',         0, 0]],
    '1003'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1004'  => [['2.0.0',   '',    'delivered',       0, 0],
                ['5.1.1',   '550', 'userunknown',     1, 1]],
    '1005'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1006'  => [['4.4.3',   '',    'systemerror',     0, 0]],
    '1007'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1008'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1009'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1010'  => [['4.4.1',   '',    'blocked',         0, 0],
                ['4.4.1',   '',    'blocked',         0, 0]],
    '1011'  => [['4.7.1',   '450', 'blocked',         0, 0]],
    '1012'  => [['4.2.0',   '451', 'systemerror',     0, 0]],
    '1013'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1014'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1015'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1016'  => [['4.4.7',   '',    'networkerror',    0, 0]],
    '1017'  => [['4.4.7',   '',    'networkerror',    0, 0]],
    '1018'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1019'  => [['4.7.1',   '450', 'requireptr',      0, 0]],
    '1020'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1021'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1022'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1023'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1024'  => [['5.0.0',   '554', 'filtered',        0, 1]],
    '1025'  => [['5.0.0',   '534', 'mesgtoobig',      0, 0]],
    '1026'  => [['5.0.0',   '',    'blocked',         0, 0]],
    '1027'  => [['5.0.0',   '',    'rejected',        0, 0]],
    '1028'  => [['5.7.1',   '554', 'norelaying',      0, 1]],
    '1029'  => [['5.2.0',   '550', 'spamdetected',    0, 0]],
    '1030'  => [['5.0.0',   '554', 'suspend',         0, 1]],
    '1031'  => [['5.0.0',   '554', 'suspend',         0, 1]],
    '1032'  => [['5.3.0',   '554', 'mailererror',     0, 0]],
    '1033'  => [['5.3.0',   '554', 'mailererror',     0, 0]],
    '1034'  => [['5.3.0',   '554', 'mailererror',     0, 0]],
    '1035'  => [['5.1.1',   '503', 'userunknown',     1, 1]],
    '1036'  => [['5.0.0',   '554', 'filtered',        0, 1]],
    '1037'  => [['5.0.0',   '554', 'userunknown',     1, 1]],
    '1038'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1039'  => [['5.2.1',   '550', 'filtered',        0, 1],
                ['5.1.1',   '550', 'userunknown',     1, 1]],
    '1040'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1041'  => [['5.7.1',   '550', 'filtered',        0, 1]],
    '1042'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1043'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1044'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1045'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1046'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1047'  => [['5.1.1',   '550', 'requireptr',      0, 0]],
    '1048'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1049'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1050'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1051'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1052'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1053'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1054'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1055'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1056'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1057'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1058'  => [['5.1.1',   '550', 'norelaying',      0, 1]],
    '1059'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1060'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1061'  => [['5.1.1',   '550', 'blocked',         0, 0]],
    '1062'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1063'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1064'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1065'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1066'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1067'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1068'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1069'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1070'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1071'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1072'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1073'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1074'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1075'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1076'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1077'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1078'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1079'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1080'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1081'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1082'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1083'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1084'  => [['5.1.2',   '550', 'filtered',        0, 1]],
    '1085'  => [['5.1.2',   '550', 'filtered',        0, 1]],
    '1086'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1087'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1088'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1089'  => [['5.7.1',   '553', 'norelaying',      0, 1]],
    '1090'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1091'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1092'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1093'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1094'  => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1095'  => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1096'  => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1097'  => [['5.2.2',   '550', 'mailboxfull',     0, 1]],
    '1098'  => [['5.2.3',   '552', 'exceedlimit',     0, 0]],
    '1099'  => [['5.2.3',   '552', 'exceedlimit',     0, 0]],
    '1100'  => [['5.2.3',   '552', 'exceedlimit',     0, 0]],
    '1101'  => [['5.3.0',   '550', 'systemerror',     0, 0]],
    '1102'  => [['5.3.0',   '553', 'filtered',        0, 1]],
    '1103'  => [['5.3.0',   '553', 'filtered',        0, 1]],
    '1104'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1105'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1106'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1107'  => [['5.3.5',   '553', 'systemerror',     0, 0]],
    '1108'  => [['5.3.5',   '553', 'systemerror',     0, 0]],
    '1109'  => [['5.4.1',   '550', 'userunknown',     1, 1]],
    '1110'  => [['5.4.1',   '550', 'userunknown',     1, 1]],
    '1111'  => [['5.4.6',   '554', 'networkerror',    0, 0]],
    '1112'  => [['5.5.0',   '554', 'mailererror',     0, 0]],
    '1113'  => [['5.6.0',   '550', 'contenterror',    0, 0]],
    '1114'  => [['5.7.0',   '552', 'policyviolation', 0, 0]],
    '1115'  => [['5.7.0',   '554', 'policyviolation', 0, 0]],
    '1116'  => [['5.7.0',   '550', 'spamdetected',    0, 0]],
    '1117'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1118'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1119'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1120'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1121'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1122'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1124'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1125'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1127'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1129'  => [['5.1.6',   '551', 'hasmoved',        1, 1]],
    '1130'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1131'  => [['5.2.0',   '550', 'filtered',        0, 1],
                ['5.2.0',   '550', 'filtered',        0, 1],
                ['5.2.0',   '550', 'filtered',        0, 1]],
    '1132'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1133'  => [['5.3.0',   '553', 'filtered',        0, 1]],
    '1134'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1135'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1136'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1137'  => [['5.1.1',   '550', 'userunknown',     1, 1],
                ['5.2.2',   '550', 'mailboxfull',     0, 1]],
    '1138'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1139'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1140'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1141'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1142'  => [['5.7.0',   '552', 'policyviolation', 0, 0]],
    '1143'  => [['5.7.1',   '550', 'userunknown',     1, 1]],
    '1144'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1145'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1146'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1147'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1148'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1149'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1150'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1151'  => [['5.2.2',   '552', 'mailboxfull',     0, 1],
                ['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1152'  => [['5.3.0',   '550', 'systemerror',     0, 0]],
    '1153'  => [['5.3.0',   '554', 'mailererror',     0, 0]],
    '1154'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1155'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1156'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1158'  => [['4.5.0',   '',    'expired',         0, 0]],
    '1159'  => [['4.2.2',   '452', 'mailboxfull',     0, 0]],
    '1160'  => [['5.3.0',   '553', 'filtered',        0, 1]],
    '1161'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1162'  => [['5.1.1',   '550', 'userunknown',     1, 1],
                ['5.2.1',   '550', 'filtered',        0, 1]],
    '1163'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1164'  => [['5.1.8',   '553', 'rejected',        0, 0]],
    '1165'  => [['5.2.3',   '552', 'exceedlimit',     0, 0]],
    '1166'  => [['5.6.9',   '550', 'contenterror',    0, 0]],
    '1167'  => [['5.7.1',   '554', 'norelaying',      0, 1]],
    '1168'  => [['4.7.1',   '450', 'requireptr',      0, 0]],
    '1169'  => [['5.7.9',   '554', 'policyviolation', 0, 0]],
    '1170'  => [['4.7.1',   '450', 'blocked',         0, 0]],
    '1171'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1172'  => [['5.3.0',   '550', 'systemerror',     0, 0]],
    '1173'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1174'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1175'  => [['5.5.0',   '554', 'blocked',         0, 0]],
    '1176'  => [['5.1.6',   '551', 'hasmoved',        1, 1]],
    '1177'  => [['5.3.0',   '554', 'mailererror',     0, 0]],
    '1178'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1179'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1181'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1182'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1183'  => [['5.0.0',   '554', 'suspend',         0, 1]],
    '1184'  => [['5.0.0',   '554', 'filtered',        0, 1]],
    '1185'  => [['4.4.7',   '',    'networkerror',    0, 0]],
    '1186'  => [['5.7.0',   '552', 'policyviolation', 0, 0]],
    '1187'  => [['5.7.0',   '552', 'policyviolation', 0, 0]],
    '1188'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1189'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1190'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1191'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1192'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1193'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1194'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1195'  => [['5.7.0',   '552', 'policyviolation', 0, 0]],
    '1196'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1197'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1198'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1199'  => [['5.7.1',   '550', 'blocked',         0, 0]],
    '1200'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1201'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1202'  => [['4.4.5',   '452', 'systemfull',      0, 0]],
    '1203'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1204'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1205'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1206'  => [['5.3.5',   '553', 'systemerror',     0, 0]],
#   '1207'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1208'  => [['4.4.7',   '451', 'systemerror',     0, 0]],
    '1209'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1210'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1211'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1212'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1213'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1214'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1215'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1216'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1217'  => [['4.7.0',   '421', 'blocked',         0, 0]],
    '1218'  => [['4.7.0',   '421', 'blocked',         0, 0]],
    '1219'  => [['5.7.27',  '550', 'notaccept',       1, 1]],
    '1220'  => [['5.7.1',   '550', 'notcompliantrfc', 0, 0]],
    '1221'  => [['5.6.0',   '552', 'contenterror',    0, 0]],
    '1222'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1223'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1224'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1225'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1226'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1227'  => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '1228'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1230'  => [['5.2.0',   '550', 'filtered',        0, 1]],
    '1231'  => [['5.2.1',   '550', 'suspend',         0, 1]],
    '1232'  => [['5.3.0',   '550', 'systemerror',     0, 0]],
    '1233'  => [['5.7.606', '550', 'blocked',         0, 0]],
    '1234'  => [['5.7.1',   '554', 'authfailure',     0, 0]],
    '1235'  => [['5.7.509', '550', 'authfailure',     0, 0]],
    '1236'  => [['5.4.12',  '554', 'networkerror',    0, 0]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

