message("BEGIN - UNIX toolchain with $HOME/devel local PAPPSO libraries")
message("")

# The development should use the locally built libs.
set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "$ENV{HOME}/devel/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES "$ENV{HOME}/devel/pappsomspp/build-area/unix/src/pappsomspp/core/libpappsomspp-core.so.0")

if(NOT TARGET PappsoMSpp::Core)

    add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        PappsoMSpp::Core PROPERTIES IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                              ${PappsoMSpp_INCLUDE_DIRS}
    )

endif()

set(PappsoMSppGui_FOUND 1)
set(PappsoMSppGui_LIBRARIES
    "$ENV{HOME}/devel/pappsomspp/build-area/unix/src/pappsomspp/gui/libpappsomspp-gui.so.0"
)

if(NOT TARGET PappsoMSpp::Gui)

    add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        PappsoMSpp::Gui PROPERTIES IMPORTED_LOCATION ${PappsoMSppGui_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                                      ${PappsoMSpp_INCLUDE_DIRS}
    )

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS})

message("")
message("END - UNIX toolchain with $HOME/devel local PAPPSO libraries")
