#define XERR
#include "loop.ih"

// -> ORG/womanloop.cpp

void Loop::genCases(size_t iter, size_t nCases)
{
    CSVTable dataTable = headerData(iter);

    bool showAll = not d_options.specificAges() and d_options.lastCase() == 0;

                                        // perform 'nCases' simulations
    for (size_t caseIdx = 0; caseIdx != nCases; ++caseIdx)
    {
        //xerr("caseInit " << caseIdx << ' ' << nCases);
        caseInit();

        //xerr("preScreen");
        preScreen();        // no action unless screening rounds are specified

        //xerr("screening");
        screening();        // same

        //xerr("postScreen");
        postScreen();

        d_sumDeathAge += d_deathAge;
        d_totalCost += d_caseCost;

        //xerr("write data");
        if (dataTable.stream() and (showAll or caseIdx + 1 == nCases))
            writeData(dataTable, caseIdx);
    }

    dataTable << hline();
}

// In the original womanloop function a test is performed whether the
// woman has died or not. This test is superfluous because if the woman enters
// postScreen with status PRESENT then in postScreen the status either changes
// to LEFT_POST or TUMOR_POST.





