#define XERR
#include "loop.ih"

void Loop::preScreen()
{
    // see prescreen.txt

    if (d_nRounds == 0)         // no scenario rounds, no pre-screening
        return;
                                // using the complement of the prescreen 
    if (                        // in the original code
        d_naturalDeathAge >= d_screening.roundAge(0)
        and 
        (
            not d_tumor.selfDetectable() 
            or 
            d_tumor.selfDetectAge() >= d_screening.roundAge(0)
        )
    )
        return;
        
    if (                        // pre-screening is performed:
        not d_tumor.selfDetectable() or 
        (
            d_tumor.selfDetectable() 
            and 
            d_naturalDeathAge < d_tumor.selfDetectAge()
        )
    )
        preTumorDeath();    // natural death: no tumor or not self-detected
    else
        selfDetected(); // self detected the tumor before the screening   .ih
}







