/******************************************************************************
 * Copyright © 2012-2014 Institut für Nachrichtentechnik, Universität Rostock *
 * Copyright © 2006-2012 Quality & Usability Lab,                             *
 *                       Telekom Innovation Laboratories, TU Berlin           *
 *                                                                            *
 * This file is part of the SoundScape Renderer (SSR).                        *
 *                                                                            *
 * The SSR is free software:  you can redistribute it and/or modify it  under *
 * the terms of the  GNU  General  Public  License  as published by the  Free *
 * Software Foundation, either version 3 of the License,  or (at your option) *
 * any later version.                                                         *
 *                                                                            *
 * The SSR is distributed in the hope that it will be useful, but WITHOUT ANY *
 * WARRANTY;  without even the implied warranty of MERCHANTABILITY or FITNESS *
 * FOR A PARTICULAR PURPOSE.                                                  *
 * See the GNU General Public License for more details.                       *
 *                                                                            *
 * You should  have received a copy  of the GNU General Public License  along *
 * with this program.  If not, see <http://www.gnu.org/licenses/>.            *
 *                                                                            *
 * The SSR is a tool  for  real-time  spatial audio reproduction  providing a *
 * variety of rendering algorithms.                                           *
 *                                                                            *
 * http://spatialaudio.net/ssr                           ssr@spatialaudio.net *
 ******************************************************************************/

/// @file
/// CommandParser class (definition).

#ifndef SSR_COMMANDPARSER_H
#define SSR_COMMANDPARSER_H

#include <string>


namespace ssr
{

namespace api { struct Publisher; }

namespace legacy_network
{

/** Parses a XML string and maps to Controller.
 * This class is the bridge between the network interface and the Controller.
 * Incoming XML messages (in ASDF-format) are parsed and the appropriate
 * functions of Controller called.
 **/
class CommandParser
{
  public:
    CommandParser(api::Publisher& publisher);

    void parse_cmd(const std::string &cmd);

  private:
    api::Publisher& _publisher;
};

}  // namespace legacy_network

}  // namespace ssr

#endif
