## TFSA-2021-119: Integer overflow due to conversion to unsigned

### CVE Number
CVE-2021-37645

### Impact
The implementation of `tf.raw_ops.QuantizeAndDequantizeV4Grad` is vulnerable to
an integer overflow issue caused by converting a signed integer value to an
unsigned one and then allocating memory based on this value.

```python
import tensorflow as tf

tf.raw_ops.QuantizeAndDequantizeV4Grad(
  gradients=[1.0,2.0],
  input=[1.0,1.0],
  input_min=[0.0],
  input_max=[10.0],
  axis=-100)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/quantize_and_dequantize_op.cc#L126)
uses the `axis` value as the size argument to `absl::InlinedVector` constructor.
But, the constructor uses an unsigned type for the argument, so the implicit
conversion transforms the negative value to a large integer.

### Patches
We have patched the issue in GitHub commit
[96f364a1ca3009f98980021c4b32be5fdcca33a1](https://github.com/tensorflow/tensorflow/commit/96f364a1ca3009f98980021c4b32be5fdcca33a1).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, and TensorFlow 2.4.3, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
