/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-source-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLSourceElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute USVString src;
           [CEReactions, SetterThrows]
           attribute DOMString type;
};

partial interface HTMLSourceElement {
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute USVString srcset;
           [CEReactions, SetterThrows]
           attribute DOMString sizes;
           [CEReactions, SetterThrows]
           attribute DOMString media;
           [CEReactions, SetterThrows]
           attribute unsigned long width;
           [CEReactions, SetterThrows]
           attribute unsigned long height;
};
