// Generic note form.

#let form(data) = {
  set page(
    paper: "a4",
    margin: (left: 2cm, right: 2cm, top: 2cm, bottom: 2.5cm),
    footer: context [
      #grid(
        columns: (1fr, 1fr),
        align: (left, right),
        text(size: 8pt)[
        ],
        text(size: 8pt)[
          Page #here().page() of #counter(page).final().first()
        ]
      )
    ]
  )

  set text(font: "Liberation Sans", size: 10pt)
  set par(justify: false, leading: 0.65em)

  // Helper function to get value or empty string
  let get(key, default: "") = {
    data.at(key, default: default)
  }

  // Helper function for checkbox
  let checkbox(checked) = {
    box(
      width: 3mm,
      height: 3mm,
      stroke: 0.5pt + black,
      inset: 0.3mm,
      if checked == true or checked == "true" {
        place(center + horizon, text(size: 8pt, sym.checkmark))
      }
    )
  }

  // Header
  align(center, text(size: 11pt, weight: "bold")[CONFIDENTIAL])

  v(0.5em)

  grid(
    columns: (50%, 50%),
    gutter: 1em,
    image("taler-logo.svg", width: 80%),
    align(right)[
      #table(
        columns: (1fr, 1fr),
        stroke: 0.5pt + black,
        inset: 5pt,
        align: (left, left),
        [AMLA File No.],
        [#get("FILE_NUMBER")]
      )
    ]
  )

  v(1em)

  // Section 1: Note
  text(size: 11pt, weight: "bold")[Note:]

  v(0.5em)

  get("NOTE_TEXT")

  v(0.5em)
}

// Example usage:
#form((
  "GENERIC_NOTE": "This is a great customer.",
  "FILE_NUMBER": 42,
))