--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE FUNCTION alter_table_refresh4()
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  ALTER TABLE refresh
    ADD COLUMN revealed BOOLEAN NOT NULL DEFAULT(FALSE),
    ADD COLUMN transfer_pubs BYTEA[];
  COMMENT ON COLUMN refresh.revealed
    IS 'TRUE if the client has successfully revealed the secrets in the cut-and-choose step.';
  COMMENT ON COLUMN refresh.transfer_pubs
    IS 'The selected batch of transfer public keys, at noreveal_index';
END $$;

INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('refresh4'
    ,'exchange-0004'
    ,'alter'
    ,TRUE
    ,FALSE);
