/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { format, formatDuration, intervalToDuration } from "date-fns";

export const TIME_DATE_FORMAT = "dd MMM yyyy HH:mm:ss"

export function createDateToStringFunction(date: any) {
  return () => {
    if (!date) return "";
    return format(date.t_s * 1000, TIME_DATE_FORMAT);
  }
}

export function createDurationToStringFunction(duration: any) {
  return () => {
    if (!duration) return "";
    return formatDuration(intervalToDuration({ start: 0, end: duration.d_us }));
  }
}

export function createNonEmptyFunction(list: any) {
  return () => {
    if (!list) return false;
    return list.length > 0;
  }
}

