#include <kanalyzerwidget.h>
#include <kanalyzerwidget.moc>

#include <qlayout.h>

#include <kmsgbox.h>

#include <kanalyzer.h>

#include <xpm/background2.xpm>
#include <xpm/sine.xpm>
#include <xpm/wavein.xpm>
#include <xpm/goldammer.xpm>
#include <xpm/time.xpm>
#include <xpm/frequency.xpm>
#include <xpm/stop.xpm>
#include <xpm/redmarker.xpm>
#include <xpm/exchangemarker.xpm>
#include <xpm/yellowmarker.xpm>
#include <xpm/maxmarker.xpm>
#include <xpm/killmarker.xpm>

/* constants */
const int iMinWinWidth = 800;
const int iMinWinHeight = 600;
const int iMaxWinWidth = 800;
const int iMaxWinHeight = 600;
const int iToolboxWidth = 100;
const int iToolboxHeight = 100;
const int iPanelWidth = 100;
const int iPanelHeight = 100;
const int iStretch = 0;
const int iLowFreq = 100;
const int iHighFreq = 48000;

const char* chsine = "Sine";
const char* chwavein = "Soundblaster";
const char* chdsp56 = "Goldammer DSP56-3";
const char* chstop = "Stop";

const char* chtime = "Time Domain";
const char* chfrequency = "Frequency Domain";

const char* chmaxmarker = "Maximum value";
const char* chmarker1 = "Marker 1";
const char* chmarker2 = "Marker 2";
const char* chexmarker = "Exchange markers";
const char* chkillmarker = "Kill markers";

extern const char* chWarning;
const char* chSampleFrequencyError = "Sample Rate Error!";
const char* chDeviceError = "Device Error!";
extern const char* chAbort;

extern KConfig* config;

const char* chdomain = "Domain";

KAnalyzerWidget::KAnalyzerWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	int ret;
	KAnalyzer* pApp = (KAnalyzer*) parent;
	
	//setMinimumSize(iMinWinWidth, iMinWinHeight);	//setMaximumSize(iMmaxWinWidth, iMaxWinHeight);
	//setGeometry(100, 100, 900, 900);

	QBoxLayout* layout = new QVBoxLayout( this);
	QBoxLayout* vbox = new QVBoxLayout();
	QBoxLayout* hbox = new QHBoxLayout();
	
	layout->addLayout(hbox); 
	layout->addLayout(vbox);
	
	ptoolbox = new KToolbox(this);
	hbox->addWidget(ptoolbox, iStretch, AlignLeft);

	ptoolbox->setFrameStyle(QFrame::Panel | QFrame::Raised);
	ptoolbox->setMinimumWidth(iToolboxWidth);	ptoolbox->setMaximumWidth(iToolboxHeight);
	ptoolbox->setBackgroundPixmap(QPixmap((const char **)background2_xpm));
	
	pdisplay = new KDisplay(this);
	hbox->addWidget(pdisplay, iStretch, AlignRight);

	panel = new KPanel(this);
	vbox->addWidget(panel);

	panel->setFrameStyle(QFrame::Panel | QFrame::Raised); 
	panel->setMinimumHeight(iPanelWidth);		panel->setMaximumHeight(iPanelWidth);
	panel->setBackgroundPixmap(QPixmap((const char **)background2_xpm));
	
	psinedevice = new KSine();
	pwavein = new KWaveIn();
	pdsp56 = new KDSP56();

	/*				DeviceBar				*/
	deviceBar = new KToolBar(pApp);
	pApp->addToolBar(deviceBar);
	
	devicegroup = new QButtonGroup;
	devicegroup->setExclusive(true);
	
	sinebtn = new QToolButton(deviceBar);
	waveinbtn = new QToolButton(deviceBar);
	dsp56btn = new QToolButton(deviceBar);
	stopbtn = new QToolButton(deviceBar);

	sinebtn->setPixmap(QPixmap((const char **)sine_xpm));
	waveinbtn->setPixmap(QPixmap((const char **)wavein_xpm));
	dsp56btn->setPixmap(QPixmap((const char **)goldammer_xpm));
	stopbtn->setPixmap(QPixmap((const char **)stop_xpm));

	sinebtn->setTextLabel(chsine);
	waveinbtn->setTextLabel(chwavein);
	dsp56btn->setTextLabel(chdsp56);
	stopbtn->setTextLabel(chstop);

	deviceBar->insertWidget(25,25, sinebtn);
	deviceBar->insertWidget(25,25, waveinbtn);
	deviceBar->insertWidget(25,25, dsp56btn);
	deviceBar->insertWidget(25,25, stopbtn);

	devicegroup->insert(sinebtn, SINEGENERATOR);
	devicegroup->insert(waveinbtn, WAVEIN);
	devicegroup->insert(dsp56btn, DSP56);
	devicegroup->insert(stopbtn, PAUSE);

	/*				DisplayBar				*/
	displayBar = new KToolBar(pApp);
	pApp->addToolBar(displayBar);
	
	domaingroup = new QButtonGroup;
	domaingroup->setExclusive(true);

	markergroup = new QButtonGroup;

	timebtn = new QToolButton(displayBar);
	frequencybtn = new QToolButton(displayBar);

	maxmarkerbtn = new QToolButton(displayBar);
	marker1btn = new QToolButton(displayBar);
	marker2btn = new QToolButton(displayBar);
	exmarkerbtn = new QToolButton(displayBar);
	killmarkerbtn = new QToolButton(displayBar);

	timebtn->setPixmap(QPixmap((const char **)time_xpm));
	frequencybtn->setPixmap(QPixmap((const char **)frequency_xpm));

	timebtn->setTextLabel(chtime);
	frequencybtn->setTextLabel(chfrequency);

	maxmarkerbtn->setPixmap(QPixmap((const char **)maxmarker_xpm));
	marker1btn->setPixmap(QPixmap((const char **)redmarker_xpm));
	marker2btn->setPixmap(QPixmap((const char **)yellowmarker_xpm));
	exmarkerbtn->setPixmap(QPixmap((const char **)exchangemarker_xpm));
	killmarkerbtn->setPixmap(QPixmap((const char **)killmarker_xpm));

	maxmarkerbtn->setTextLabel(chmaxmarker);
	marker1btn->setTextLabel(chmarker1);
	marker2btn->setTextLabel(chmarker2);
	exmarkerbtn->setTextLabel(chexmarker);
	killmarkerbtn->setTextLabel(chkillmarker);
	
	maxmarkerbtn->setToggleButton(true);
	marker1btn->setToggleButton(true);
	marker2btn->setToggleButton(true);

	displayBar->insertWidget(25,25, timebtn);
	displayBar->insertWidget(25,25, frequencybtn);

	displayBar->insertSeparator();
	displayBar->insertSeparator();

	displayBar->insertWidget(25,25, maxmarkerbtn);
	displayBar->insertWidget(25,25, marker1btn);
	displayBar->insertWidget(25,25, marker2btn);
	displayBar->insertWidget(25,25, exmarkerbtn);
	displayBar->insertWidget(25,25, killmarkerbtn);

	domaingroup->insert(timebtn, TIMEDOMAIN);
	domaingroup->insert(frequencybtn, FREQUENCYDOMAIN);
		
	markergroup->insert(maxmarkerbtn, MAXMARKER);
	markergroup->insert(marker1btn, MARKER1);
	markergroup->insert(marker2btn, MARKER2);
	markergroup->insert(exmarkerbtn, EXMARKER);
	markergroup->insert(killmarkerbtn, KILLMARKER);

	deviceBar->setBarPos(KToolBar::Left);
	displayBar->setBarPos(KToolBar::Left);

	sinebtn->setToggleButton(true);
	waveinbtn->setToggleButton(true);
	stopbtn->setToggleButton(true);
	dsp56btn->setToggleButton(true);

	timebtn->setToggleButton(true);
	frequencybtn->setToggleButton(true);
	//ptoolbox->waveinbtn->setEnabled(false);
	//ptoolbox->dsp56btn->setEnabled(false);
	
	stopbtn->setOn(true);
	timebtn->setOn(true);
	
	WaveInfo.iDomain = TIMEDOMAIN;
	WaveInfo.iDevice = PAUSE;

	connect(devicegroup, SIGNAL(clicked(int)), this, SLOT(device(int)));
	connect(domaingroup, SIGNAL(clicked(int)), this, SLOT(domain(int)));
	connect(markergroup, SIGNAL(clicked(int)), this, SLOT(marker(int)));
	
	ret = config->readNumEntry(chdomain, (int)TIMEDOMAIN);
	domain(ret);
	domaingroup->setButton(ret);
}

KAnalyzerWidget::~KAnalyzerWidget()
{
}

void KAnalyzerWidget::device(int id)
{
	int ret;
	// stop running device
	if(WaveInfo.iDevice != PAUSE)
	{
		pdisplay->close();
		WaveInfo.iDevice = PAUSE;
	}
	
	ret = sscanf(ptoolbox->samplefrequencyctrl->text(), "%d", &WaveInfo.iSampleFrequency);
	if(ret != 1 || WaveInfo.iSampleFrequency < iLowFreq || WaveInfo.iSampleFrequency > iHighFreq)
	{
		KMsgBox::message(this,  chWarning, chSampleFrequencyError,
						KMsgBox::EXCLAMATION, chAbort);
		stopbtn->setOn(true);
		return;
	}
	switch(id)
	{
		case SINEGENERATOR:
			{
				WaveInfo.iDevice = SINEGENERATOR;
				if(pdisplay->open(psinedevice) < 0)
				{
					KMsgBox::message(this,  chWarning, chDeviceError,
								KMsgBox::EXCLAMATION, chAbort);
					stopbtn->setOn(true);
					return;
				}
			}
			break;
		case WAVEIN:
			{
				WaveInfo.iDevice = WAVEIN;
				if(pdisplay->open(pwavein) < 0)
				{
					KMsgBox::message(this,  chWarning, chDeviceError,
								KMsgBox::EXCLAMATION, chAbort);
					stopbtn->setOn(true);
					return;
				}
			}
			break;
		case DSP56:
			{
				WaveInfo.iDevice = DSP56;
				if(pdisplay->open(pdsp56) < 0)
				{
					KMsgBox::message(this,  chWarning, chDeviceError,
								KMsgBox::EXCLAMATION, chAbort);
					stopbtn->setOn(true);
					return;
				}
			}
			break;
		default:
			;
	}
}

void KAnalyzerWidget::domain(int id)
{
	int ret;
	WaveInfo.iDomain = id;	
	ret = sscanf(ptoolbox->samplefrequencyctrl->text(), "%d", &WaveInfo.iSampleFrequency);
	if(ret != 1 || WaveInfo.iSampleFrequency < iLowFreq || WaveInfo.iSampleFrequency > iHighFreq)
	{
		KMsgBox::message(this,  chWarning, chSampleFrequencyError,
						KMsgBox::EXCLAMATION, chAbort);
		return;
	}
	pdisplay->updateScales();
	config->writeEntry(chdomain, id);
}

void KAnalyzerWidget::marker(int id)
{
	if(id == KILLMARKER)
	{
		maxmarkerbtn->setOn(false);
		marker1btn->setOn(false);
		marker2btn->setOn(false);
	}
	pdisplay->marker(id, markergroup->find(id)->isOn());
}
