#ifndef KDEVICE_H 
#define KDEVICE_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

/* KWaveIn */
#include <sys/stat.h>  /* needed by open() */
#include <fcntl.h>     /* needed by open() */
#include <unistd.h>    /* needed by open(), read() */
#include <sys/types.h> /* needed by open(), read(), mmap() */

#include <sys/mman.h>  /* mmap() */

#include <sys/soundcard.h>
#include <sys/ioctl.h>
/***********/

#include <qwidget.h>

#define BUFFERSIZE	0x10000

#define	TIMEDOMAIN		1
#define	FREQUENCYDOMAIN	2

#define PAUSE			0
#define SINEGENERATOR	1
#define WAVEIN			2
#define DSP56			3

struct WaveInfoStruct
{
	int iSampleFrequency;
	int iDomain;
	int iDevice;
};

extern WaveInfoStruct WaveInfo;

/****************************************************************/
/*																*/
/*							KDevice								*/
/*																*/
/****************************************************************/

class KDevice : public QWidget
{
	Q_OBJECT
public:
	KDevice (QWidget *parent = 0, const char *name = 0);
	virtual ~KDevice ();

	virtual int open(void);
	virtual int close(void);
	virtual int read(void);
	
	short int* getbufadr(void);
	void setFrequency(int freq)					{ iFrequency = freq; };

public slots:	

public:
	bool bActive;
	int iFrequency;
	int iDataPtr, iTimePtr;
};

/****************************************************************/
/*																*/
/*							KSine								*/
/*																*/
/****************************************************************/

class KSine : public KDevice
{
	Q_OBJECT
public:
	KSine (QWidget *parent = 0, const char *name = 0);
	virtual ~KSine ();

	void timerEvent(QTimerEvent*);

public slots:	

public:
};

/****************************************************************/
/*																*/
/*							KWaveIn								*/
/*																*/
/****************************************************************/

class KWaveIn : public KDevice
{
	Q_OBJECT
public:
	KWaveIn (QWidget *parent = 0, const char *name = 0);
	virtual ~KWaveIn ();

	int open(void);
	int close(void);
	
	void timerEvent(QTimerEvent*);

public slots:	

public:
	int iwavein;
	int iChannels;
	int iBytesPerSample;
	int iFormat;
	int iCaps;
	int iBuffLen;
	caddr_t pBuffer;
	int iEnableInput;
    int iPrevPtr;
	int iCurrentPtr;
};

/****************************************************************/
/*																*/
/*							KDSP56								*/
/*																*/
/****************************************************************/

class KDSP56 : public KDevice
{
	Q_OBJECT
public:
	KDSP56 (QWidget *parent = 0, const char *name = 0);
	virtual ~KDSP56 ();

	int open(void);
	int close(void);

	void timerEvent(QTimerEvent*);

public slots:	

public:
	int idsp56;
};

#endif // KDEVICE_H 
