/*
   Copyright (C) 2008 by Sebastian Trueg <trueg at kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "searchhitview.h"
#include "searchhitmodel.h"
#include "../resource-visualization/resourcedelegate.h"
#include "../resource-visualization/abstractresourceguiitem.h"

#include <KCategoryDrawer>
#include <kcategorizedsortfilterproxymodel.h>
#include <KDialog>

#include <QtGui/QItemSelectionModel>


class Nepomuk::SearchHitView::Private
{
public:
    Private( SearchHitView* parent )
        : q( parent ) {
    }

    SearchHitModel* model;
    KCategorizedSortFilterProxyModel* searchProxyModel;

    void _k_itemActivated( const QModelIndex& index );

private:
    SearchHitView* q;
};


Nepomuk::SearchHitView::SearchHitView( QWidget* parent )
    : KCategorizedView( parent ),
      d( new Private(this) )
{
    d->model = new SearchHitModel( this );
    d->searchProxyModel = new KCategorizedSortFilterProxyModel( this );
    d->searchProxyModel->setSourceModel( d->model );
    d->searchProxyModel->setCategorizedModel( true );
    d->searchProxyModel->sort( 0 );

    setModel( d->searchProxyModel );

    Nepomuk::ResourceDelegate* delegate = new Nepomuk::ResourceDelegate( this );
    delegate->setDisplayMode( Nepomuk::AbstractResourceGuiItem::DisplayFull );
    setItemDelegateForColumn( 0, delegate );

    setViewMode( QListView::IconMode );
    setIconSize( QSize( 48, 48 ) );
    setCategoryDrawer( new KCategoryDrawer() );
    setResizeMode( QListView::Adjust );
    setSpacing( KDialog::spacingHint() );
    setFlow( QListView::TopToBottom );
}


Nepomuk::SearchHitView::~SearchHitView()
{
    delete categoryDrawer();
    delete d;
}


void Nepomuk::SearchHitView::clear()
{
    setResources( QList<Search::Result>() );
}


void Nepomuk::SearchHitView::setResources( const QList<Search::Result>& resources )
{
    d->model->setResources( resources );
}


void Nepomuk::SearchHitView::updateResource( const Search::Result& resource )
{
    d->model->updateResource( resource );
}


QList<QUrl> Nepomuk::SearchHitView::selectedResources() const
{
    QList<QUrl> rl;
    QModelIndexList il = selectionModel()->selectedIndexes();
    foreach( const QModelIndex& index, il ) {
        rl.append( d->model->resourceForIndex( index ) );
    }
    return rl;
}


void Nepomuk::SearchHitView::Private::_k_itemActivated( const QModelIndex& index )
{
    emit q->resourceActivated( model->resourceForIndex( searchProxyModel->mapToSource( index ) ) );
}

#include "searchhitview.moc"
