/***************************************************************************
                          mainconf.cpp  -  description
                             -------------------
    begin                : Sun Jan 23 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mainconf.h"

#define HTTP 0
#define FTP 1

MainConf::MainConf(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	addNumBak = 0;
	listshown = false;
	home = QDir::homeDirPath();
	QString tmp;
	tmp.sprintf("%s/KWebGetProjects/", (const char*)home);

	prot = "http://";
	QLabel *pnameLab = new QLabel (i18n("Project Name :"), this);
	pnameLab->setGeometry(30,8,130,20);
	pnameLab->setFont(QFont("helvetica",14, QFont::Bold));

	pnameLine = new QLineEdit(this);
	pnameLine->setGeometry(160,8,250,20);
	pnameLine->insert(i18n("New_Project"));

	outLab = new QLabel(i18n("Project Folder :"), this);
	outLab->setGeometry(30,33,130,20);
	outLab->setFont(QFont("helvetica",14, QFont::Bold));
	
	outLine = new QLineEdit(this);
	outLine->setGeometry(160,33,328,20);
	outLine->setText(tmp);

	outBut = new QPushButton(this);
	outBut->setPixmap(BarIcon("fileopen"));
	outBut->setGeometry(490,31,22,22);
	connect(outBut, SIGNAL(clicked()), this, SLOT(getProjFolder()));

	getBox = new QButtonGroup(i18n("What do you want to do ?"),this);
	getBox->setGeometry(8,60,553,120);

	htmlBut = new QRadioButton(i18n("Mirroring a whole site"),getBox);
	htmlBut->setGeometry(5,18,240,20);
	htmlBut->setChecked(true);
	connect(htmlBut, SIGNAL(clicked()), this, SLOT(activateHtmlLine()));
	QToolTip::add(htmlBut, i18n("...or just a tree of the site !!!"));
	urlLab = new QLabel(i18n("Starting URL :"), getBox);
	urlLab->setGeometry(10,65,75,20);

	htmlLine = new MyLineEdit(getBox);
	htmlLine->setGeometry(190,65,250,20);
	connect(htmlLine, SIGNAL(dropProt(QString)), this, SLOT(changeDropProt(QString)));
	connect(htmlLine, SIGNAL(multiUrl(QStrList)), this, SLOT(changeDropAction(QStrList)));
	QToolTip::add(htmlLine, i18n("Please enter the url here !"));

	protBox = new QComboBox(getBox);
	protBox->setGeometry(120,65,70,20);
	protBox->insertItem("http://",HTTP);
	protBox->insertItem("ftp://",FTP);
	QToolTip::add(protBox, i18n("Here you can select the protocol"));

	fileBut = new QRadioButton(i18n("Get only one File"),getBox);
	fileBut->setGeometry(5,38,240,20);
	QToolTip::add(fileBut, i18n("Click here, if you just\nwant to get one file"));
	connect(fileBut, SIGNAL(clicked()), this, SLOT(activateFileLine()));

	fnameLab = new QLabel(i18n("FileName :"), getBox);
	fnameLab->setGeometry(10,90,75,20);
	fnameLab->hide();
	QToolTip::add(fnameLab, i18n("Please enter the name of the file,\nyou want to get, here!"));

	urlLine = new QLineEdit(getBox);
	urlLine->setGeometry(120,90,190,20);
	urlLine->hide();
	QToolTip::add(urlLine, i18n("Please enter the name of the file,\nyou want to get, here!"));

	urllistBut = new QRadioButton(i18n("Get a list of pages or files"), getBox);
	urllistBut->setGeometry(270,18,250,20);
	QToolTip::add(urllistBut, i18n("Click here, if you want to enter some urls or files,\n"
					"KWebGet should download"));
	connect(urllistBut, SIGNAL(clicked()), this, SLOT(openListEnter()));

	identifyGroup = new QButtonGroup(i18n("Identify Agent as:"), this);
	identifyGroup->setGeometry(8,180,553,60);
	QToolTip::add(identifyGroup, i18n("Select or enter the User-Agent,\n"
					"you want KWebGet to be identified as."));

	wgetBut = new QRadioButton("wget", identifyGroup);
	wgetBut->setGeometry(10,13,50,20);
	wgetBut->setChecked(true);
	connect(wgetBut, SIGNAL(clicked()), this, SLOT(otherAgent()));

	mozilla47But = new QRadioButton("Mozilla/4.7", identifyGroup);
	mozilla47But->setGeometry(10,36,110,20);
	connect(mozilla47But, SIGNAL(clicked()), this, SLOT(otherAgent()));

	mozilla50But = new QRadioButton("Mozilla/5.0", identifyGroup);
	mozilla50But->setGeometry(120,36,110,20);
	connect(mozilla50But, SIGNAL(clicked()), this, SLOT(otherAgent()));

	msieBut = new QRadioButton("MSIE/5.1", identifyGroup);
	msieBut->setGeometry(120,13,110,20);
	connect(msieBut, SIGNAL(clicked()), this, SLOT(otherAgent()));

	konqBut = new QRadioButton("konqueror/1.1.1", identifyGroup);
	konqBut->setGeometry(230,13,110,20);
	connect(konqBut, SIGNAL(clicked()), this, SLOT(otherAgent()));
	
	lynxBut = new QRadioButton("Lynx/TextBrowser", identifyGroup);
	lynxBut->setGeometry(350,13,120,20);
	connect(lynxBut, SIGNAL(clicked()), this, SLOT(otherAgent()));
	
	otherBut = new QRadioButton(i18n("Other :"), identifyGroup);
	otherBut->setGeometry(230,36,110,20);
	connect(otherBut, SIGNAL(clicked()), this, SLOT(otherAgent()));
	
	otherLine = new QLineEdit(identifyGroup);
	otherLine->setGeometry(300,36,200,20);
	otherLine->setEnabled(false);
}

MainConf::~MainConf()
{
}

void MainConf::otherAgent()
{
	if ( otherBut->isChecked() ) {
		otherLine->setEnabled(true);
	} else {
		otherLine->setEnabled(false);
	}
}


void MainConf::activateHtmlLine()
{
	htmlLine->show();
	protBox->show();
	urlLab->show();
	urlLine->hide();
	fnameLab->hide();
}

void MainConf::activateFileLine()
{
	urlLab->show();
	htmlLine->show();
	protBox->show();
	urlLine->show();
	fnameLab->show();
}

void MainConf::getProjFolder()
{
	projFolder = dD->getExistingDirectory(home, this, 0);
	if ( !projFolder.isEmpty() ) {
		outLine->setText(projFolder);
	}
}

void MainConf::openListEnter()
{
	htmlLine->hide();
	protBox->hide();
	urlLab->hide();
	urlLine->hide();
	fnameLab->hide();
	if ( !listshown ) {
		QFile listFile ("/tmp/~urllist");
		if ( !listFile.remove() ) {
		}
		listWidg = new ListEnterDialog(this, "ListEnterDialog", true,0);
		listWidg->resize(500,300);
		listWidg->setMinimumSize(320,150);
		connect(listWidg->applyBut, SIGNAL(clicked()), this, SLOT(listApplyed()));
		connect(listWidg, SIGNAL(canceled()), this, SLOT(listCanceled()));
		listshown = true;
		listWidg->show();
	} else {
		backupList();
		listWidg->addSite();
		listWidg->rmLast();
		listWidg->show();
	}
}

void MainConf::listCanceled()
{
	htmlLine->show();
	protBox->show();
	urlLab->show();
	urllistBut->setChecked(false);
	htmlBut->setChecked(true);
	if ( listshown ) {
	listWidg->rmAllCancel();
	}
}

void MainConf::listApplyed()
{
	QString tmp, txt;
	bool emptStr = false;
	for ( int i=0; i <= listWidg->addNum ; i++) {
		tmp = listWidg->siteLine[i]->text();
		if ( !tmp.isEmpty() )
			emptStr = true;
	}
	if ( !emptStr ) {
		QMessageBox::warning( this, i18n("Empty Lines"),
			i18n("Please enter some sites, to download from !"));
		return;
	}

	listWidg->hide();
	listshown = true;
}

void MainConf::openListEnter2()
{
	QFile listFile ("/tmp/~urllist");
	if ( !listFile.remove() ) {
	}
	if (!listshown) {
		listWidg = new ListEnterDialog(this, "ListEnterDialog", true,0);
		listWidg->resize(500,300);
		listWidg->setMinimumSize(320,150);
		connect(listWidg->applyBut, SIGNAL(clicked()), this, SLOT(listApplyed()));
		connect(listWidg, SIGNAL(canceled()), this, SLOT(listCanceled()));
		listshown = true;
	}
}

void MainConf::backupList()
{
	for ( int i=0; i <= listWidg->addNum ; i++ ) {
		protbak[i] = listWidg->protChoose[i]->currentItem();
		anonbak[i] = listWidg->ftpBox[i]->isChecked();
		sitebak[i] = listWidg->siteLine[i]->text();
		addNumBak = listWidg->addNum;
	}
}

void MainConf::changeDropProt(QString dprot)
{
	firstUrl = dprot;
	if ( dprot == "http" ) {
		protBox->setCurrentItem(HTTP);
	} else {
		protBox->setCurrentItem(FTP);
	}
}

void MainConf::changeDropAction(QStrList urlList)
{
	firstUrl += "://";
	urllistBut->setChecked(true);
	openListEnter2();
	listWidg->getProt(firstUrl, listWidg->addNum);
	listWidg->siteLine[listWidg->addNum]->setText(htmlLine->text());
	htmlLine->clear();
	listWidg->getDropList(urlList);
	openListEnter();
}