/**
 * grouptoken.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_GROUPTOKEN_H
#define KONFIG_GROUPTOKEN_H

#include "token.h"

namespace KCfgCreator
{
    class ApplicationToken;
    class EntryToken;
    class GroupToken : public Token
    {
    public:
        typedef QPtrList<EntryToken> EntryList;

        ~GroupToken();

        ApplicationToken* parent() const;

        EntryList entryList() const;
        EntryToken* entry( const QString& key ) const;
        EntryToken* entryContaining( const QString& str ) const;

        /**
         * Add an entry with the specified name, value, label and choices to this group.
         */
        void addEntry( const QString& name, const QString& type,
                       const QString& key=QString::null, bool hidden=false );
        /**
         * Removes an entry with the specified name.
         */
        bool removeEntry( const QString& );

        /**
         * Like addEntry but returns the created EntryToken and does not create
         * an undo action for the addition of this token.
         */
        EntryToken* createEntry( const QString& name, const QString& type,
                                 const QString& key=QString::null, bool hidden=false );

        EntryToken* changeType( const QString& name, const QString& type );

        /**
         * Removes the given entry without creating the undo action for it
         */
        void deleteEntry( EntryToken* );

    protected:
        friend class ApplicationToken;
        GroupToken( ApplicationToken *parent, const QString& name, bool readOnly );
        void addGroupMemento();

    private:
        ApplicationToken *m_parent;
        EntryList m_entryList;
    };

}

#endif
