/**
 * kconfigparser.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef KONFIG_KCONFIGPARSER_H
#define KONFIG_KCONFIGPARSER_H

#include "parserinterface.h"

#include <qmap.h>
#include <qptrlist.h>
#include <qstring.h>

class KConfig;
class KURL;

namespace KCfgCreator
{
    class ApplicationToken;
    class GroupToken;
    class HostData;
    class FileData;
    class HostToken;

    class KConfigParser : public ParserInterface
    {
        Q_OBJECT
    public:
        KConfigParser( QObject* parent=0 );

        ApplicationToken* parseDataMerging( ApplicationToken*,
                                            FileData* );
        ApplicationToken* parseAndAddFile( HostToken* parent, FileData* fdata );
        ApplicationToken* parseFileUrl( const KURL& url,
                                        ApplicationToken* token=0  );
    public slots:
        void parseData( HostData* );

    protected:
        void parseGroup( ApplicationToken* parent, const KConfig& config,
                         const QString& group );
        void parseEntries( GroupToken* token, const KConfig& config,
                           const QMap<QString, QString>& en );

        /**
         * Few files are stored in the kconfig directory but are not
         * kconfig files like kdebug.areas, we want to skip them.
         */
        bool skipFile( const QString& fileName );
    };
}

#endif
