/**
 * mainwidget.cpp
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "mainwidget.h"

#include "manager.h"
#include "items.h"
#include "kcfgcoptions.h"
#include "kcfgcdialog.h"
#include "editorwidget.h"

#include "kcfgcreator.h"
#include "applicationtoken.h"

#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klistview.h>
#include <klocale.h>
#include <kurl.h>
#include <kdebug.h>

#include <qsplitter.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcstring.h>
#include <qfile.h>

namespace KCfgCreator
{

MainWidget::MainWidget( QWidget *parent )
    : QWidget( parent )
{

    initGUI();
    KCfgcOptions::self()->setListView( m_entryView );
    m_manager = new Manager( this );
    m_cfgCreator = new CreatorKCfg( this );
    connect( m_cfgCreator, SIGNAL(done(ApplicationToken*, const QCString&)),
             SLOT(slotDone(ApplicationToken*, const QCString&)) );
}

void MainWidget::initGUI()
{
    QHBoxLayout *box = new QHBoxLayout( this );
    QSplitter *split = new QSplitter( this );
    box->addWidget( split );
    m_entryView = new KListView( split );
    //box->addWidget( m_entryView );
    m_entryView->setRootIsDecorated( true );
    m_entryView->setResizeMode( QListView::AllColumns );
    m_entryView->addColumn( i18n( "Entries" ) );

    m_editWidget = new EditorWidget( split );
    //box->addWidget( m_editWidget );
}

void MainWidget::newConfig()
{
    if ( m_entryView->childCount() ) {
        KMessageBox::information( m_entryView, i18n( "You are already editing a config file." ),
                                  i18n( "Config Created" ) );
        return;
    }

    KCfgcDialog dlg( *KCfgcOptions::self(), this );

    dlg.exec();
}

void MainWidget::preferences()
{
    KCfgcDialog dlg( *KCfgcOptions::self(), this );

    dlg.exec();
}

void MainWidget::parseFile()
{
    QString kcfgc = KFileDialog::getOpenFileName( QString::null,
                                                  "*.kcfgc",
                                                  this,
                                                  i18n("Select kcfgc File") );
    if ( !kcfgc.isEmpty() ) {
        KCfgcOptions::self()->kcfgcFromFile( kcfgc );

        if ( KCfgcOptions::self()->kcfgFile().isEmpty() ) {
            QString kcfg = KFileDialog::getOpenFileName( QString::null,
                                                          "*.kcfg",
                                                          this,
                                                          i18n( "Select kcfg File" ) );
            KCfgcOptions::self()->kcfgFromFile( kcfg );
        }
    }
}

void MainWidget::fromRcFile()
{
    QString fileName = KFileDialog::getOpenFileName( QString::null,
                                                     QString::null,
                                                     this,
                                                     i18n("Select KConfig File") );
    if ( !fileName.isEmpty() ) {
        KCfgcOptions::self()->fromRcFile( fileName );
    }
}

void MainWidget::save()
{
    AppItem *item = dynamic_cast<AppItem*>( m_entryView->firstChild() );
    if ( item ) {
        m_cfgCreator->createConfig( item->app() );
    }
    KCfgcOptions::self()->save();
}

void MainWidget::addEntry()
{
    m_manager->addEntry();
}

void MainWidget::removeEntry()
{
    m_manager->removeEntry();
}

void MainWidget::slotDone( ApplicationToken* token, const QCString& contents )
{
    Q_UNUSED( token );
    kdDebug()<<"Writting kcfg file to "<< KCfgcOptions::self()->kcfgFile() << endl;
    QFile file( KCfgcOptions::self()->kcfgFile() );
    file.open( IO_WriteOnly );
    file.writeBlock( contents, contents.length() );
    file.close();
}

void MainWidget::openKCfgcFile( const KURL& kcfgc )
{
    if ( !kcfgc.path().isEmpty() ) {
        KCfgcOptions::self()->kcfgcFromFile( kcfgc.path() );

        if ( KCfgcOptions::self()->kcfgFile().isEmpty() ) {
            QString kcfg = KFileDialog::getOpenFileName( QString::null,
                                                          "*.kcfg",
                                                          this,
                                                         i18n( "Select kcfg File" ) );
            KCfgcOptions::self()->kcfgFromFile( kcfg );
        }
    }
}

void MainWidget::openKCfgFile( const KURL& kcfg )
{
    KCfgcOptions::self()->kcfgFromFile( kcfg.path() );
}

void MainWidget::openRCFile( const KURL& rc )
{
    if ( !rc.path().isEmpty() ) {
        KCfgcOptions::self()->fromRcFile( rc.path() );
    }
}

}

#include "mainwidget.moc"
