/**
 * undomanager.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "undomanager.h"
#include "memento.h"

#include <kstaticdeleter.h>

namespace KCfgCreator
{

static KStaticDeleter<UndoManager> sd;
UndoManager* UndoManager::s_self=0;

UndoManager*
UndoManager::Instance()
{
    if ( !s_self ) {
        sd.setObject( s_self, new UndoManager() );
    }
    return s_self;
}

UndoManager::UndoManager()
{
    m_mementoList.setAutoDelete( true );
}

bool UndoManager::canUndo() const
{
    return !m_mementoList.isEmpty();
}

bool UndoManager::undo( Memento* memento )
{
    if ( !memento )
        memento = m_mementoList.take( 0 );
    else {
        m_mementoList.setAutoDelete( false );
        m_mementoList.remove( memento );
        m_mementoList.setAutoDelete( true );
    }

    if ( memento ) {
        memento->restore();
        delete memento;
        emit tokenRestored( memento->m_token );
        if ( m_mementoList.isEmpty() )
            emit canUndo( false );
        return true;
    } else
        return false;
}

void UndoManager::addMemento( Memento* memento )
{
    m_mementoList.append( memento );

    //Signal all others that from now on we can undo
    if ( m_mementoList.count() == 1 )
        emit canUndo( true );
}

}//end namespace KCfgCreator

#include "undomanager.moc"
