/**
 * kernel.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KCONFIGEDITOR_KERNEL_H
#define KCONFIGEDITOR_KERNEL_H

#include <qobject.h>

#include <qguardedptr.h>

namespace KConfigEditor
{
#define kernel Kernel::self()

    class ConfigManager;
    class ProgressItem;
    class Kernel : public QObject
    {
        Q_OBJECT
    public:
        static Kernel *self();

    public:
        ConfigManager *manager() const { return m_manager; }

        ProgressItem *globalProgress() const;

    public slots:
        void emitStatusMsg( const QString &msg );

    signals:
        void statusMsg( const QString &msg );

    private slots:
        void startInitialization();

    private:
        Kernel( QObject *parent = 0 );
    private:
        ConfigManager *m_manager;
        mutable QGuardedPtr<ProgressItem> m_globalProgressItem;
    private:
        static Kernel *s_self;
    };
}

#endif
