/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qstring.h>
#include <qwidget.h>
#include <qobject.h>
#include <qvalidator.h>


#define ID_PREF_GROUP_GENERAL		"General"
#define ID_PREF_GEN_TOOLTIPS		"ToolTips"
#define PREF_GEN_TOOLTIPS				true

#define ID_PREF_GROUP_MODEM			"Modem"
#define ID_PREF_MOD_USB					"UseUSB"
#define PREF_MOD_USB		   			false
#define ID_PREF_MOD_SER_DEVICE	"SerialDevice"
#define PREF_MOD_SER_DEVICE  		0		// == /dev/modem
#define ID_PREF_MOD_SER_SPEED		"SerialSpeed"
#define PREF_MOD_SER_SPEED   		1		// == 38400 Bps
#define ID_PREF_MOD_USB_DEVICE	"USBDevice"
#define PREF_MOD_USB_DEVICE  		0		// == /dev/usb/ttyACM0


#define ID_HELP_CONTENTS         1002

#define ID_STATUS_MSG            1001


QString expandPath(const QString& fname);



class NumberValidator: public QValidator
{
	Q_OBJECT
public:
	NumberValidator(QWidget *parent, const char *name = 0);
	~NumberValidator();

	QValidator::State validate(QString &input, int &) const;
};



class FaxIDValidator: public QValidator
{
	Q_OBJECT
public:
	FaxIDValidator(QWidget *parent, const char *name = 0);
	~FaxIDValidator();

	QValidator::State validate(QString &input, int &) const;
};



#endif // GLOBAL_H
