/***************************************************************************
                          convert2text.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "convert2text.h"
#include <stdio.h>
#include "kaspasql.h"
#include <kprocess.h>
#include <kapp.h>
//#include <iostream.h>
//#include <alloc.h>
#include <kglobal.h>
#include <kconfig.h>
#include <qregexp.h>
Convert2Text::Convert2Text(){
//  tmpfiles.setAutoDelete(true);
}
Convert2Text::~Convert2Text(){
/*
  for(unsigned int i=0; i<tmpfiles.count(); i++) {
	  tmpfiles.at(i)->remove();
	}
*/
}


QString Convert2Text::buf2file(QByteArray b) {
	QString fname=tmpnam(0L);
//	debug("DataView::buf2file() - "+fname);
	QFile *f=new QFile(fname);
  if (!f->open(IO_WriteOnly) )
    throw KaspaErr("Kann kein temporres File ffnen!");
	f->writeBlock(b);
  f->close();
  tmpfiles.append(f);
  return fname;
}

void Convert2Text::slotReceivedStderr(KProcess* proc,char* buf,int len) {
  buf[len-1]=0;
//	cout << "StdErr:"<<buf<<"\n";
  emit output(QString(QCString(buf, len)));
}

void Convert2Text::slotReceivedStdout(KProcess* proc,char* buf,int len) {
  buf[len-1]=0;
//	cout << "Stdout:"<<buf<<"\n";
  emit output(QString(QCString(buf, len)));
}

QString Convert2Text::convert(QString cmd, QByteArray in) {
//  cout <<"Convert2Text()\n";

  if(cmd=="#direct#")
    return QString(in);

  QString infilename = buf2file(in);
	QString outfilename=tmpnam(0L);
  KShellProcess proc;
  char *c=new char[200];
  cmd.replace(QRegExp("#in#"), infilename);
  cmd.replace(QRegExp("#out#"), outfilename);

  connect(&proc, SIGNAL(receivedStderr (KProcess*,char*,int)),
          this, SLOT(slotReceivedStderr (KProcess*,char*,int)) );
  connect(&proc, SIGNAL(receivedStdout (KProcess*,char*,int)),
          this, SLOT(slotReceivedStdout (KProcess*,char*,int)) );

//  cout << "Executing \""<<cmd<<"\"\n";
  proc << cmd;
//  proc<<"html2text /tmp/test.html > /tmp/test.txt";
  if(!proc.start(KProcess::DontCare, KProcess::All))
    throw KaspaErr("Could not start process!");

  while(proc.isRunning()) {
     kapp->processEvents();
  }

//  cout<<"\nConvert2Text, exitstatus:"<<proc.exitStatus()<<"\n";

  if(!proc.normalExit())
    throw KaspaErr("Conversion process: Abnormal termination!");

  QFile f(outfilename);
//  QFile f("/tmp/test.txt");
  if(!f.open(IO_ReadOnly))
    throw KaspaErr("Can't open temporary file!");

  delete c;
  QByteArray b=f.readAll();
  f.close();
  unlink(outfilename);
  unlink(infilename);

  return QString(b);
}

QString Convert2Text::html2text(QByteArray a) {
  return QString(convert("cat %s | /usr/bin/html2text -o %s", a));
}

QString Convert2Text::pdf2text(QByteArray a) {
  return QString(convert("pdftohtml -o - %s | html2text -o %s", a));
}

QString Convert2Text::ps2text(QByteArray a) {
  return QString(convert("ps2ascii %s > %s", a));
}

bool Convert2Text::mime2text(QString mt, QByteArray in, QString &out) {
  KGlobal::config()->setGroup("Convert2Text");
  QString s=KGlobal::config()->readEntry( mt, "");
  KGlobal::config()->setGroup("");
  if(s=="") return false;
  out=QString(convert(s, in));
  return true;
}
