/***************************************************************************
                          convert2text.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONVERT2TEXT_H
#define CONVERT2TEXT_H

#include <qstring.h>
#include <qcstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qobject.h>
/**
  *@author Jan Mueller
  */

class KProcess;
class Convert2Text: public QObject {
  Q_OBJECT

	QList<QFile> tmpfiles;
public: 
	Convert2Text();
	~Convert2Text();

  QString buf2file(QByteArray b);
  QString convert(QString cmd, QByteArray in);

  QString html2text(QByteArray a);
  QString pdf2text(QByteArray a);
  QString ps2text(QByteArray a);
  bool mime2text(QString mt, QByteArray in, QString &out);
public slots:
  void slotReceivedStderr(KProcess* proc,char* buf,int len);
  void slotReceivedStdout(KProcess* proc,char* buf,int len);
signals:
  void output(QString);
};

#endif
