
CREATE SEQUENCE "kaspa_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

CREATE TABLE "author" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"lastname" text DEFAULT '',
	"firstname" text DEFAULT '',
	"pseudonym" text DEFAULT '',
	"born" text DEFAULT '',
	"died" text DEFAULT '',
	"country" text DEFAULT '',
	"memo" text DEFAULT '',
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE TABLE "part" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"publication_no" integer DEFAULT 0,
	"partno" smallint DEFAULT 1,
	"title" text DEFAULT '',
	"pages" text DEFAULT '',
	"memo" text DEFAULT '',
	"key" text DEFAULT '',
	"language" text DEFAULT '',
	"bibtex" text DEFAULT '',
	"intro_no" integer DEFAULT 0,
	"createbibtex" boolean DEFAULT 'f'::bool,
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE TABLE "partdata" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"part_no" integer DEFAULT 0,
	"file" text DEFAULT '',
	"astext" text DEFAULT '',
	"filename" text DEFAULT '',
	"type" text DEFAULT '',
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE TABLE "publisher" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"name" text DEFAULT '',
	"city" text DEFAULT '',
	"serie" text DEFAULT '',
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE TABLE "publication" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"title" text DEFAULT '',
	"subtitle" text DEFAULT '',
	"edition" smallint DEFAULT 0,
	"editor" text DEFAULT '',
	"howpublished" text DEFAULT '',
	"organization" text DEFAULT '',
	"publisher_no" integer DEFAULT 0,
	"year" text DEFAULT '',
	"pages" text DEFAULT '',
	"translator" text DEFAULT '',
	"volume" text DEFAULT '',
	"number" text DEFAULT '',
	"month" text DEFAULT '',
	"series" text DEFAULT '',
	"type" text DEFAULT '',
	"key" text DEFAULT '',
	"orgtitle" text DEFAULT '',
	"orgpublisher_no" integer DEFAULT 0,
	"orgyear" text DEFAULT '',
	"isbn_issn" text DEFAULT '',
	"hidingplace" text DEFAULT '',
	"bibtex" text DEFAULT '',
	"entrytype" smallint DEFAULT 0,
	"memo" text DEFAULT 0,
	"createbibtex" boolean DEFAULT 'f'::bool,
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE TABLE "publication_author" (
	"publication_no" integer DEFAULT 0,
	"author_no" integer DEFAULT 0,
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"author_order" integer DEFAULT 0
);


CREATE TABLE "part_author" (
	"part_no" integer DEFAULT 0,
	"author_no" integer DEFAULT 0,
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"author_order" integer DEFAULT 0
);


CREATE TABLE "note" (
	"no" integer DEFAULT nextval('kaspa_seq'::text),
	"title" text DEFAULT '',
	"memo" text DEFAULT 0,
	"type" smallint DEFAULT 0,
	"publication_no" integer DEFAULT 0,
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"parent" integer DEFAULT 0,
	"sibling" integer DEFAULT 0
);


CREATE TABLE "link" (
	"obj_1" integer DEFAULT 0,
	"obj_2" integer DEFAULT 0,
	"tbl" text DEFAULT '',
	"created" timestamp with time zone DEFAULT "timestamp"('now'::text),
	"modified" timestamp with time zone DEFAULT "timestamp"('now'::text)
);


CREATE INDEX part_publication_no_i ON part USING btree (publication_no);
CREATE INDEX partdata_part_no_i ON partdata USING btree (part_no);
CREATE INDEX publication_author_author_no_i ON publication_author USING btree (author_no);
CREATE INDEX publication_author_book_no_i ON publication_author USING btree (publication_no);
CREATE INDEX part_author_author_no_i ON part_author USING btree (author_no);
CREATE INDEX part_author_part_no_i ON part_author USING btree (part_no);
CREATE INDEX note_publication_no_i ON note USING btree (publication_no);

