/***************************************************************************
                          bibtexfactory.h  -  description                              
                             -------------------                                         
    begin                : Fri Jul 28 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BIBTEXFACTORY_H
#define BIBTEXFACTORY_H

#include <qstring.h>

/**
  *@author Jan Mueller
  */

class BibTexFactory {
private:
	BibTexFactory& operator=(const BibTexFactory&);
	BibTexFactory(const BibTexFactory&);

public:
	BibTexFactory();
	~BibTexFactory();
	QString &article(QString entry,
									 QString author,
									 QString title,
									 QString journal,
									 QString year,
									 QString volume,
									 QString number,
									 QString pages,
									 QString month,
									 QString note,
									 QString key="",
									 QString crossref="");

	QString &book(QString entry,
								QString author,
								QString editor,
								QString title,
								QString publisher,
								QString year,
								QString volume,
								QString number,
								QString series,
								QString address,
								QString edition,
								QString month,
								QString note);

	QString &booklet(QString entry,
									 QString title,
									 QString author,
									 QString howpublished,
									 QString address,
									 QString month,
									 QString year,
									 QString note);

	QString &inbook(QString entry,
									QString author,
									QString editor,
									QString title,
									QString chapter,
									QString pages,
									QString publisher,
									QString year,
									QString volume,
									QString number,
									QString series,
									QString type,
									QString address,
									QString edition,
									QString month,
									QString note,
									QString key="",
									QString crossref="");

	QString &incollection(QString entry,
									 			QString author,
												QString title,
												QString booktitle,
												QString publisher,
												QString year,
												QString editor,
												QString volume,
												QString number,
												QString series,
												QString type,
												QString chapter,
												QString pages,
												QString address,
												QString edition,
												QString month,
												QString note,
												QString key="",
												QString crossref="");

	QString &inproceedings(QString entry,
									 			 QString author,
												 QString title,
												 QString booktitle,
												 QString year,
												 QString editor,
												 QString volume,
												 QString number,
												 QString series,
												 QString pages,
												 QString address,
												 QString month,
  											 QString organization,
												 QString publisher,
												 QString note,
												 QString key="",
												 QString crossref="");

	QString &manual(QString entry,
									QString title,
									QString author,
									QString organization,
									QString address,
									QString edition,
									QString month,
									QString year,
									QString note);

	QString &masterthesis(QString entry,
									 			QString author,
											  QString title,
												QString school,
												QString year,
												QString type,
												QString address,
												QString month,
												QString note);

	QString &misc(QString entry,
								QString author,
							  QString title,
								QString howpublished,
								QString month,
								QString year,
								QString note);

	QString &phdthesis(QString entry,
									 	 QString author,
									   QString title,
										 QString school,
										 QString year,
										 QString type,
										 QString address,
										 QString month,
										 QString note);

	QString &proceedings(QString entry,
									 		 QString title,
											 QString year,
											 QString editor,
											 QString volume,
											 QString number,
											 QString series,
											 QString address,
											 QString month,
											 QString organization,
											 QString publisher,
											 QString note);

	QString &techreport(QString entry,
									 		QString author,
										  QString title,
											QString institution,
											QString year,
											QString address,
											QString type,
											QString number,
											QString month,
											QString note);

	QString &unpublished(QString entry,
									 		 QString author,
										   QString title,
											 QString note,
											 QString month,
											 QString year);
	QString &getEntry() { return bt; }

protected:
	QString bt;

  QString ascii2latex(QString &t);
    
	void addAddress(QString &s) { bt+=",\naddress=\""+ascii2latex(s)+"\""; }
	void addAuthor(QString &s) { bt+=",\nauthor=\""+ascii2latex(s)+"\""; }
	void addBooktitle(QString &s) { bt+=",\nbooktitle=\""+ascii2latex(s)+"\""; }
	void addChapter(QString &s) { bt+=",\nchapter=\""+ascii2latex(s)+"\""; }
	void addEdition(QString &s)  { bt+=",\nedition=\""+ascii2latex(s)+"\""; }
	void addEditor(QString &s) { bt+=",\neditor=\""+ascii2latex(s)+"\""; }
	void addHowpublished(QString &s) { bt+=",\nhowpublished=\""+ascii2latex(s)+"\""; }
	void addInstitution(QString &s)  { bt+=",\ninstitution=\""+ascii2latex(s)+"\""; }
	void addJournal(QString &s) { bt+=",\njournal=\""+ascii2latex(s)+"\""; }
	void addMonth(QString &s) { bt+=",\nmonth=\""+ascii2latex(s)+"\""; }
	void addNote(QString &s) { bt+=",\nnote=\""+ascii2latex(s)+"\""; }
	void addNumber(QString &s)  { bt+=",\nnumber="+s; }
	void addOrganization(QString &s)  { bt+=",\norganization=\""+ascii2latex(s)+"\""; }
	void addPages(QString &s)  { bt+=",\npages=\""+ascii2latex(s)+"\""; }
	void addPublisher(QString &s)  { bt+=",\npublisher=\""+ascii2latex(s)+"\""; }
	void addSchool(QString &s)  { bt+=",\nschool=\""+ascii2latex(s)+"\""; }
	void addSeries(QString &s)  { bt+=",\nseries=\""+ascii2latex(s)+"\""; }
	void addTitle(QString &s)  { bt+=",\ntitle=\""+ascii2latex(s)+"\""; }
	void addType(QString &s)  { bt+=",\ntype=\""+ascii2latex(s)+"\""; }
	void addVolume(QString &s)  { bt+=",\nvolume="+s; }
	void addYear(QString &s)  { bt+=",\nyear="+s; }
	void addKey(QString &s)  { bt+=",\nkey=\""+ascii2latex(s)+"\""; }
	void addCrossRef(QString &s)  { bt+=",\ncrossref=\""+ascii2latex(s)+"\""; }
};

#endif













