/***************************************************************************
                          notetreedlg.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "notetreedlg.h"
#include "kaspabase.h"
#include <kiconloader.h>

#define Inherited NoteTreeDlgData



NoteTreeDlg::NoteTreeDlg(NoteTitle *n, PublTitle *p, QWidget* parent,	const char* name):	
	Inherited( parent, name )
{
	notes=n;
	publs=p;
	PublTitle *nextpubl;

	linklist->addColumn("Notes");
	linklist->setRootIsDecorated(true);
	linklist->setItemsMovable(false);
	linklist->setDragEnabled(false);
	linklist->setItemsRenameable(false);
  linklist->setAcceptDrops(false);
  linklist->setSorting(-1);
  linklist->setDropHighlighter(false);
  linklist->setDropVisualizer(false);

	// For all publications
	for(nextpubl=publs; nextpubl; nextpubl=nextpubl->getNext()) {
		NoteTitle *nextnote;
		// Search first note which belongs to the publ.
		for(nextnote=notes; nextnote&&nextnote->getPublNo()!=nextpubl->getOid(); nextnote=nextnote->getNext());
		if(nextnote) {
			NoteTreeItem *knot=new NoteTreeItem(linklist, InvalidOid, nextpubl->getTitle(), BarIcon("showpubl.png"), false);
			linklist->insertItem(knot);
			// After inserting the title of the publication, insert the connected notes
			while(nextnote) {
				if(nextnote->getPublNo()==nextpubl->getOid()) {
					new NoteTreeItem(knot, nextnote->getOid(), nextnote->getTitle(), BarIcon("shownote.png"), false);
				}
				nextnote=nextnote->getNext();
			}	
		}
	}			

  addItem(notes, 0, 0L);
/*

	// Add global notes			
	NoteTitle *nextnote=notes;
	while(nextnote) {
		if(nextnote->getPublNo()==InvalidOid) {
			new NoteTreeItem(linklist, nextnote->getOid(), nextnote->getTitle());
			// linklist->insertItem(item);
		}
		nextnote=nextnote->getNext();
	}
*/

	linklist->geometry();
}


NoteTreeDlg::~NoteTreeDlg()
{
	delete publs;
	delete notes;
}

Oid NoteTreeDlg::getOid() {
	NoteTreeItem *item = dynamic_cast<NoteTreeItem *>(linklist->selectedItem());
	return item?item->oid:InvalidOid;
}



void NoteTreeDlg::addItem(NoteTitle *notes, Oid parentoid, NoteTreeItem *parentitem) {
  for(NoteTitle *nextnote=notes; nextnote; nextnote=nextnote->getNext())
  {
		if(nextnote->getPublNo()!=InvalidOid) continue;

    if(nextnote->getParent()==parentoid) {
      NoteTreeItem *knot;
      if(parentitem)
  		  knot=new NoteTreeItem(parentitem, nextnote->getOid(), nextnote->getTitle(), BarIcon("shownote.png"), false);
      else
  		  knot=new NoteTreeItem(linklist, nextnote->getOid(), nextnote->getTitle(), BarIcon("shownote.png"), false);
      addItem(notes, nextnote->getOid(), knot);
    }
  }
}
