/***************************************************************************
                          part.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: part.cpp
	Last generated: Sun Sep 26 13:50:53 1999

 *********************************************************************/


#include <kapp.h>
#include <qstring.h>
#include <kiconloader.h>
#include <qobjectlist.h>
#include <qlayout.h>
#include <kmessagebox.h>
#include <stdlib.h>
#include <kmdcodec.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>

#include "part.h"
#include "convert2text.h"
#include "kaspawidget.h"
#include "resource.h"
#include "selectiondlg.h"
#include "notetreedlg.h"
#include "qmessagebox.h"
#include <klocale.h>
#include "partdatabase.h"
#include <qprogressdialog.h>
#include <kmimemagic.h>
#include "kaspasql.h"
#include <kscan.h>
#include <qbuffer.h>
// #include <iostream.h>
#include "processfiledlg.h"
#define  Inherited PartData

CommandSetup partcs[] = {	{ID_PART_DELREC,  	RW},
													{ID_PART_FLUSH,  		RW},
													{ID_PART_RESET, 		RW+RO+INV},
													{ID_PART_INSLINK, 	RW+RO},
													{ID_PART_REMLINK, 	RW+RO},
													{ID_PART_SHOWPUBL, 	RW+RO},
													{ID_PART_SHOWMEMO, 	RW+RO},
													{ID_PART_SHOWINTRO, RW+RO},
										/*			{ID_PART_NEWAUTHOR, RW+RO},
													{ID_PART_INSAUTHOR, RW+RO},
													{ID_PART_REMAUTHOR, RW+RO}, */
													{ID_PART_SCAN,      RW+RO},
													{ID_PART_OCR,       RW+RO},
													{ID_PART_NEWLINK,		RW+RO} };

// PartBase-Constructor reads row matching WHERE-Clause.
Part::Part(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name), pt(0L), sql(conn)
{
	setTabOrder(number, title);
	setTabOrder(title, language);
	setTabOrder(language, key);
	setTabOrder(key, pages);
	setTabOrder(pages, bibtex);

//	debug("Part::Part(QString, QWidget, char*)");
  part = new PartBase(url.where(), conn);
  ASSERT(part);
	part->setCallBack(&idle);
	if(isValid())
		pt=part->getPartPubl();
	QString s("kaspa://part#where part.no="); s+=QString().setNum(part->id());
	_url=s;

  connect(notes,   SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));
	connect(authors, SIGNAL(open(Oid, bool)), this, SLOT(requestAuthor(Oid, bool)));
	connect(files, SIGNAL(open(Oid, bool)), this, SLOT(requestHTMLData(Oid, bool)));
	connect(files, SIGNAL(deleteFiles()), this, SLOT(slotDeleteFiles()));
	connect(files, SIGNAL(exportFiles()), this, SLOT(slotExportFiles()));
	connect(files, SIGNAL(importFiles(QStrList)), this, SLOT(slotImportFiles(QStrList)));
	connect(files, SIGNAL(createReferences(QStrList)), this, SLOT(slotCreateReferences(QStrList)));
	connect(files, SIGNAL(save()), this, SLOT(flush()));
	connect(files, SIGNAL(reset()), this, SLOT(reread()));
  connect(authors, SIGNAL(moveItemDown(Oid)), this, SLOT(moveAuthorDown(Oid)));
  connect(authors, SIGNAL(moveItemUp(Oid)), this, SLOT(moveAuthorUp(Oid)));


	notes->setTitle(i18n("Links"));
	authors->setTitle(i18n("Authors"));
	files->setTitle(i18n("Files"));
}

Part::~Part()
{
//	debug("Part::~Part()");
	delete part;
	delete pt;
}

bool Part::isValid() {
	try {
	  return part->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void Part::reread() {
	if(isValid())
		setWorkingGUI();
	try {
	  part->reset();
		if(isValid())
			pt=part->getPartPubl();
		else
			pt=0L;
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
  	setFields();
}

void Part::setFields() {
  if(isValid()) {
		setWorkingGUI();
    emit setCaption(part->getTitle());
	  title->setText(part->getTitle());
		havefirstfile=!(part->getFirstFile()==InvalidOid);

  	language->setText(part->getLanguage());
	  pages->setText(part->getPages());
		number->setText(QString().setNum(part->getNumber()));
		if(!pt) KMessageBox::error(this, "Part has no Publication!");
		publication->setText(pt->getTitle());
		authors->set(part->getPartAuthors());
	  bibtex->setText(part->getBibTex());
  	key->setText(part->getKey());
	  notes->set(part->getLinks());
		includebibtex->setChecked(part->getCreateBibTex());
		created->setText(QString("created: ")+part->getCreated());
		modified->setText(QString("modified: ")+part->getModified());


		files->set(part->getFiles());
		QObjectList *list = this->queryList( "QLayout", 0, true, false );
		QObjectListIt it( *list );
		QObject * obj;
		while ( (obj=it.current()) != 0 ) {
			++it;
			((QLayout*)obj)->activate();
		}
		delete list;
	}
	setupGUI();
}

void Part::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Part::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
      if(strcmp(title->text(), part->getTitle()))
     	  part->setTitle(title->text());
	    if(strcmp(bibtex->text(), part->getBibTex()))
	      part->setBibTex(bibtex->text());
  	  if(strcmp(language->text(), part->getLanguage()))
      	part->setLanguage(language->text());
	 	  if(strcmp(pages->text(), part->getPages()))
	       part->setPages(pages->text());
  	  if(strcmp(key->text(), part->getKey()))
    	   part->setKey(key->text());
    	if(strtol((const char*)number->text(), NULL, 10)!=part->getNumber())
	       part->setNumber(number->text());
    	if(includebibtex->isChecked()!=part->getCreateBibTex())
	       part->setCreateBibTex(includebibtex->isChecked());
  	  part->flush(block);
	  }
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Part::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&INV)==INV)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&INV)==INV));
	emit enableCommand(ID_PART_NEWAUTHOR, false);
	emit enableCommand(ID_PART_INSAUTHOR, false);
	emit enableCommand(ID_PART_REMAUTHOR, false);
}	

bool Part::isCollection() {
	if(!pt) { KMessageBox::error(this, "Part has no Publication!"); return false; }
	int e=pt->getEntryType();
	switch(e) {
		case BT_INCOLLECTION:
		case BT_JOURNAL:
		case BT_INBOOK:
		case BT_INPROCEEDING:
			return true;
		default:
			return false;
	}
}


void Part::unlockGUI(bool working) {
	publication->setEnabled(!isReadOnly());
	nolabel->setEnabled(!isReadOnly());
	number->setEnabled(!isReadOnly());
	titlelabel->setEnabled(!isReadOnly());
	title->setEnabled(!isReadOnly());
	pageslabel->setEnabled(!isReadOnly());
	pages->setEnabled(!isReadOnly());

	bool c=isCollection();
	files->setEnabled(!working);
  authors->setEnabled(!working&&c);
  notes->setEnabled(!working);

	emit enableCommand(ID_PART_NEWAUTHOR, !working && c);
	emit enableCommand(ID_PART_INSAUTHOR, !working && c);
	emit enableCommand(ID_PART_REMAUTHOR, !working && c);

	authors->setEnabled(!isReadOnly()&&c);
	bibtex->setEnabled(!isReadOnly()&&c);
	bibtexlabel->setEnabled(!isReadOnly()&&c);
	languagelabel->setEnabled(!isReadOnly()&&c);
	key->setEnabled(!isReadOnly()&&c);
	keylabel->setEnabled(!isReadOnly()&&c);
	includebibtex->setEnabled(!isReadOnly()&&c);
	generatebibtex->setEnabled(!isReadOnly()&&c);
}

void Part::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++) {
		switch(partcs[i].command) {
			case ID_PART_SHOWINTRO:
				emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&RW)==RW)&&havefirstfile) );
			break;
			default:
				emit enableCommand(partcs[i].command, ((partcs[i].setup&RW)==RW));
		}
	}
	unlockGUI(false);
}

void Part::setWorkingGUI() {
/*	if(isReadOnly() || !isValid())
		lockGUI();
	else */
	unlockGUI(true);
	Inherited::setWorkingGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&WORK)==WORK)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&WORK)==WORK));

}

void Part::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	unlockGUI(false);
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&RO)==RO)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&RO)==RO));
}


void Part::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking() && deleteDlg()) {
			setWorkingGUI();
	  	part->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Part::closeRequest() {
//	setWorkingGUI();
 	save(true);
	setupGUI();
 	return true;
}
	

void Part::newLink() {
	try {
		setWorkingGUI();
		Oid o=part->createNote();
		requestNote(o);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void Part::insLink() {
	try {
		SelectionDlg dlg(part->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			part->insertLink(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Part::remLink() {
	try {
		Oid o=notes->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		part->removeLink(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void Part::newAuthor() {
	try {
		setWorkingGUI();
		Oid o=part->createAuthor();
		save();
		requestAuthor(o, false);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Part::insAuthor() {
	try {
		SelectionDlg dlg(part->getAuthors(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			part->insertAuthor(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Part::remAuthor() {
	try {
		Oid o=authors->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		part->removeAuthor(o);
		save();
		setFields();	
   } catch(KaspaErr& err) {
    err.print();
    QMessageBox::warning(this, i18n("Error"), err.error());
  }
}

void Part::showPubl() {
	if(!pt) { KMessageBox::error(this, "Part has no Publication!"); return; }
	requestPublication(pt->getOid());
}

void Part::showPartMemo() {
	requestPartMemo(part->id());
}

void Part::showIntro() {
	requestHTMLData(part->getFirstFile());
}

KToolBar *Part::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("showmemo.png"), ID_PART_SHOWMEMO, SIGNAL(clicked()),
				this, SLOT(showPartMemo()), true, i18n("Show Memo") );
  toolbar->insertButton(BarIcon("showpubl.png"), ID_PART_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPubl()), true, i18n("Show Publication") );
  toolbar->insertButton(BarIcon("showintro.png"), ID_PART_SHOWINTRO, SIGNAL(clicked()),
				this, SLOT(showIntro()), true, i18n("Show Intro") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newnote.png"), ID_PART_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.png"), ID_PART_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.png"), ID_PART_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newauthor.png"), ID_PART_NEWAUTHOR, SIGNAL(clicked()),
				this, SLOT(newAuthor()), true, i18n("New Author") );
  toolbar->insertButton(BarIcon("insauthor.png"), ID_PART_INSAUTHOR, SIGNAL(clicked()),
				this, SLOT(insAuthor()), true, i18n("Insert Author") );
  toolbar->insertButton(BarIcon("delauthor.png"), ID_PART_REMAUTHOR, SIGNAL(clicked()),
				this, SLOT(remAuthor()), true, i18n("Remove Author") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("scanner.png"), ID_PART_SCAN, SIGNAL(clicked()),
				this, SLOT(slotScanImage()), true, i18n("Scan Image") );
  toolbar->insertButton(BarIcon("text.png"), ID_PART_OCR, SIGNAL(clicked()),
				this, SLOT(slotOcrText()), true, i18n("OCR") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filedel.png"), ID_PART_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filefloppy.png"), ID_PART_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.png"), ID_PART_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}


void Part::generateBibTex() {
	if(!bibtex->text().isEmpty()&&
     (KMessageBox::warningYesNo(this, i18n("Overwrite old entry?"), i18n("Generate BibTex") )==2)) return;
	
	save(true);

	PublTitle *p=part->getPartPubl();
	if(!p) { KMessageBox::error(this, "Part has no Publication!"); return; }
	QString crossref("Ref");
	crossref+=QString().setNum(p->getOid());

	AuthorName *a=part->getPartAuthors();
	QString entry;
	int publindex=0;

  QString author;
  AuthorName *b=0L;
  AuthorName *c=0L;
	for(b=a; b; b=b->getNext()) {
		author=b->getFirstName()+author;
		author=", "+author;
		author=b->getLastName()+author;
		if(b->getNext())
			author=" and "+author;
    c=b;
	}

	if(c)	{
		entry=c->getLastName();
		publindex=part->bibTexIndex(c->getOid(), p->getYear(), p->getOid());
	}
	else entry="NoName"+QString().setNum(part->id());
	entry+=p->getYear();
	if(publindex>0 && publindex <27)
		entry+=('a'+publindex-1);

	QString note;

	switch(p->getEntryType()) {
/* Crossref-Entrys for Part-BibTex-generation */
		case BT_JOURNAL:
				bt.article(entry,
								author, 					/* author		*/
								part->getTitle(),	/* title		*/
								"", 							/* journal	*/
								"", 							/* year			*/
								"", 							/* volume		*/
								"", 							/* number		*/
								part->getPages(),	/* pages		*/
								"", 							/* month		*/
								"", 							/* note			*/
								part->getKey(),
								crossref);
		break;

		case BT_INBOOK:
				bt.inbook(entry,
									author,							/* author 		*/
									"",									/* editor 		*/
									"",									/* title 			*/
									QString().setNum(part->getNumber()),	/* chapterno	*/
									part->getPages(),		/* pages 			*/
									"", 								/* publisher	*/
									"",									/* year 			*/
									"",									/* volume			*/
									"",									/* number			*/
									"",									/* series			*/
									"",									/* type				*/
									"",									/* address		*/
									"",									/* edition		*/
									"",									/* month			*/
									"",									/* note				*/
									part->getKey(),
								  crossref);
			break;

			case BT_INCOLLECTION:
					 bt.incollection(entry,
													 author,								/* author			*/
													 part->getTitle(),			/* title			*/
													 "", 										/* booktitle	*/
													 "",										/* publisher	*/
													 "",										/* year				*/
													 "",										/* editor 		*/
													 "",										/* volume			*/
													 "",										/* number			*/
													 "", 										/* series			*/
													 "", 										/* type				*/
													 QString().setNum(part->getNumber()),			/* chapterno	*/
													 part->getPages(),			/* pages			*/
													 "",										/* address		*/
													 "",										/* edition		*/
													 "",										/* month			*/
													 "",										/* note				*/
													 part->getKey(),
												 	 crossref);
			break;

			case BT_INPROCEEDING:
					 bt.inproceedings(entry,
													 author,									/* author			*/
													 part->getTitle(),				/* title			*/
													 "",											/* booktitle	*/
													 "",											/* year				*/
													 "",											/* editor			*/
													 "", 										/* volume			*/
													 "", 										/* number			*/
													 "",											/* series			*/
													 part->getPages(),				/* pages			*/
													 "",											/* address		*/
													 "", 										/* month			*/
  												 "",											/* organization	*/
													 "", 										/* publisher	*/
													 "",											/* note				*/
					 								 part->getKey(),
													 crossref);
			break;


	}
	bibtex->setText(bt.getEntry());
	delete p;
	delete a;
}


void Part::slotExportFiles() {
	try {
		// Any file marked?
		int count=0;
		for(uint i=0; i<files->count(); i++)
			if(files->isSelected(i)) count++;

		if(!count)
      return;

    // get target path
    QString dir=KFileDialog::getExistingDirectory();
    if(dir.isEmpty())
      return;


		QProgressDialog pd(i18n("Exporting Files"), i18n("Abort"), count, this);

		// export file...	
		int j=0;
		for(uint i=0; i<files->count(); i++)
			if(files->isSelected(i)) {

    	PartDataBase file(QString("where partdata.no=")+QString().setNum(files->getOid(i)), DB_NAME);
	    QString filename=file.getFilename();

      if(filename.left(8)!="kaspa://") {
 		    KMessageBox::error(this, i18n("Can't export references!"));
        continue;
      }

    	// Build path+filename
    	QString n(dir);
      n+=filename.right(filename.length()-filename.findRev("/")-1);
//    	debug("FileIODlg::exportItem() - file: %s", (const char *) n);

    	// Open file...
    	QFile f(n);
    	if(!f.open(IO_WriteOnly))
    		throw KaspaErr("Unable to open file for writing!");

    	// Write buffer...

/*
      QString q("where no=");
    	q+=QString().setNum(files->getOid(i));
*/
    	const char *buf=file.getData();
      QByteArray in = QByteArray().duplicate(buf, strlen(buf));
      QByteArray out;
      KCodecs::base64Decode(in, out);
    	f.writeBlock(out);

		  // Setup progressbar and internallist-widget...
  		pd.setProgress(i);

  		// cleanup...
			j++;
			pd.setProgress(j);
		}
		pd.setProgress(count);
  } catch(KaspaErr& err) {
		handleWarning(err);
  }
}	


void Part::slotDeleteFiles() {
	try {
		// Any file marked?
		int count=0;
		for(uint i=0; i<files->count(); i++)
			if(files->isSelected(i)) count++;

		if(! (count && (KMessageBox::questionYesNo(this, i18n("Delete Files?"), "Delete Rec") == KMessageBox::Yes)))
      return;

		QProgressDialog pd(i18n("Deleting Files"), i18n("Abort"), count, this, "delprogress", true);
    flush();

		// delete files...	
		int j=0;
		for(uint i=0; i<files->count(); i++)
			if(files->isSelected(i)) {
				j++;
				part->deleteFile(files->getOid(i));
				pd.setProgress(j);
			}
		pd.setProgress(count);
		reread();
  } catch(KaspaErr& err) {
		handleWarning(err);
  }
}

void Part::slotScanImage() {

  scanDialog = KScanDialog::getScanDialog( this, "scandialog", true );
  if ( !scanDialog ) {
		KMessageBox::error(this, "No support for scanning found!");
    return;
  }

   connect( scanDialog, SIGNAL( finalImage( const QImage&, int )),
            SLOT( slotScanned( const QImage&, int ) ));

   if ( scanDialog->setup() ) // only if scanner configured/available
       scanDialog->show();
   else
		KMessageBox::error(this, "Scanner not available!");
}


void Part::slotScanned(const QImage& img, int id) {

  QImageIO iio;
  QByteArray ba;
  QBuffer b(ba);
  b.open(IO_WriteOnly);
  iio.setImage(img);
  iio.setIODevice(&b);
  iio.setFormat("PNG");
  iio.write();
  b.close();
//  cout<<"Part::slotScanned(): bufsize="<<ba.size();

  // New PartData-record...
  PartDataBase file(part->id(), sql);
  file.setFilename("kaspa://scanned_image.png");
  file.setData(KCodecs::base64Encode(ba, false));
  file.setType("image/png");
  file.flush();
//  scanDialog->close();
  save();
  setFields();
}


void Part::slotOcrText() {

  ocrDialog = KOCRDialog::getOCRDialog( this, "ocrdialog" );
  if ( !ocrDialog ) {
		KMessageBox::error(this, "No support for OCR found!");
    return;
  }

   connect( ocrDialog, SIGNAL( textRecognized( const QString&, int )),
            SLOT( slotOcred( const QString&, int ) ));

   ocrDialog->show();

/*
   if ( ocrDialog->setup() ) // only if scanner configured/available
     ocrDialog->show();
   else
		 KMessageBox::error(this, "Scanner not available!");
*/
}


void Part::slotOcred(const QString& s, int id) {

//  cout<<"Part::slotOcred(): s="<<s;

  // New PartData-record...
  PartDataBase file(part->id(), sql);
  file.setFilename("kaspa://ocred.txt");
  file.setData(KCodecs::base64Encode(s.local8Bit(), false));
  file.setType("text/plain");
  file.flush();
  ocrDialog->close();
  save();
  setFields();
}


void Part::slotImportFiles(QStrList s) {
  try {
    ProcessFileDlg dlg(sql, this, "ProcessFilesDlg");
    dlg.show();
    dlg.slotImportFiles(s, part->id());
  } catch(KaspaErr& err) {
    handleWarning(err);
  }
}	

void Part::slotCreateReferences(QStrList s) {
  try {
    ProcessFileDlg dlg(sql, this, "ProcessFilesDlg");
    dlg.show();
    dlg.slotCreateReferences(s, part->id());
  } catch(KaspaErr& err) {
    handleWarning(err);
  }
}	

void Part::moveAuthorUp(Oid i) {
  part->moveAuthorUp(i);
	save();
	setFields();	

}

void Part::moveAuthorDown(Oid i) {
  part->moveAuthorDown(i);
	save();
	setFields();	
}


