//:ö
//:ä
//:ü
//: ß




#include "krsa.h"
extern int Prim[];
extern int Pram[];
extern int Faktor1, Faktor2;
extern int Schluessel_bekannt;
extern int AnzahlSchritte;
extern int g;
extern int Fehl;
extern int PrivaterSchluessel;
  
KStandardDirs *stdDirs = new KStandardDirs();
extern secretKey skey;

//Konstruktor der Klasse KRSA welcher zugleich auch die Checkbox auf false setzt
KRSA::KRSA(QWidget *parent, const char *name)
{

    CheckBox1->setChecked(false);
    Fehllabel->setText("");
    Lade_RSA_Beschreibung();

    textLabel1->setText("");
    
    startbilli *billi = new startbilli();

    //Erzeugen der Primzahl mit Fortschrittsdialog
    billi->show();
    billi->initialSlot();
    billi->close();

    delete billi;
    
    helpMenu = new KHelpMenu(this, KGlobal::instance()->aboutData(), false);
    KPushButton10->setPopup(helpMenu->menu());
                                                                                                                                                                                                      
}



KRSA::~KRSA()
{
  delete helpMenu;
}

void KRSA::keyPressEvent(QKeyEvent* e)
{

}  

//Modulo Berechnungsslot
void KRSA::modulSlot()
{
    int Zahl, Modul, Ergebnis;
    Zahl = ZahlSpin->value();
    Modul = ModulSpin->value();
    Ergebnis = mod(Zahl, Modul);
    LCD1->display(Ergebnis);
            
}





//About Slot, ber KRSA Dialog wird aufgerufen
void KRSA::aboutSlot()
{
  //Pixmap fr das KRSA Logo festlegen
  const QPixmap klogo(stdDirs->findResource("data","ueberKRSA.jpg"));
}



//Beenden des Programms
void KRSA::beendenSlot()
{
    kapp->quit();
}



//Kodieren Slot um die Funktion zur RSA Kodierung aufzurufen
void KRSA::kodierenSlot()
{
    int Plain, Modul, Key;

    Plain = PlainSpin->value();
    Modul = Modul1Spin->value();
    Key = SchluesselSpin->value();

    LCD2->display(EncodeRSA(Key, Modul, Plain));
}



//Slot zum Aufrufen der Faktorisierfunktion
void KRSA::faktorisierenSlot()
{

  if(IsPrimZahl(FaktorEingabeSpin->value()))
    {
      LCDF1->display(00);
      LCDF2->display(00);
      fin->display(00);
      Fehler(1);
      return;
    }

  else
    {
      faktorisiere(FaktorEingabeSpin->value());
      LCDF1->display(Faktor1);
      LCDF2->display(Faktor2);
      Fehllabel->setText("");
      fin->display(phi_von_n());
    }
    
  if(IsPrimZahl(Faktor2) == false)
  {
     Fehler(6);
  }
}



/** Prfen der Checkbox um festzustellen mit welcher Art von Schlssel gerechnet wird */
void KRSA::statusSchluesselSlot()
{

  if(CheckBox1->isChecked() == true)
  {
    LabelOFS->setText(i18n("Privater \nSchlüssel"));
    Schluessel_bekannt = 1;
  }

  else
  {
    LabelOFS->setText(i18n("öffentlicher \nSchlüssel"));
    Schluessel_bekannt = 0;
  }
}  



//Slot zum Dekodieren von RSA
void KRSA::dekodierenSlot()
{
   int Schluessel, Modul, Ciferwert;
   Fehllabel->setText("");
   QString Tempstring("");

   Schluessel = PrivaterSchluesselSpin->value();
   Modul = Modul3Spin->value();
   Ciferwert = CtextSpin->value();

   if(Modul == 0 && Schluessel == 0 && Ciferwert == 0)
    return;
   
   if(IsPrimZahl(Modul))
      Fehler(1);
    
   switch(Schluessel_bekannt)
   {
    case 0:
      //Zuerst wird der Modul faktorisiert
      faktorisiere(Modul);
      //Als nchstes wird Phi(n) gebildet
      phi_von_n();
      //Die Funktion zum Dekodieren wird aufgerufen
      DekodierenRSA(Schluessel, Modul, Ciferwert);
      //Es wird geprft ob beim Dekodieren ein Fehler aufgetreten ist oder nicht
      Fehler(Fehl);
      //Falls kein Fehler war, werden die Ergebnisse eingetragen
      if(Fehl == 0)
      {
        PrivaterSchluesselSpin->setValue(PrivaterSchluessel);
        CheckBox1->setChecked(true);
      }

      textLabel1->setNum(AnzahlSchritte);

                  
      switch(AnzahlSchritte)
       {
          case 0:
            
            break;

          case 1:
//            Tempstring = ("Privater Schluessel = %d * %d + 1", skey.a[0], skey.a[1]);
  //          textLabel1->setText(Tempstring);
            break;
          case 2:
    //        Tempstring = ("Privater Schluessel = %d * %d + 1", skey.a[0], skey.a[1]);
      //      cout << Tempstring << endl;
        //    textLabel1->setText(Tempstring);
            break;
          default:
            break;

       }
      
      break;

    case 1:
      LCDF3->display(EncodeRSA(Schluessel, Modul, Ciferwert));
      break;

    default:
      break;

   }

      Fehl = 0;      
}




//Fehlerbehandlung allgemein und speziell fr die Primfaktorzerlegung
int KRSA::Fehler(int FC)
{
 switch(FC)
 {

  case 1:
    Fehllabel->setText(i18n("Es handelt sich bei ihrer Zahl um eine Primzahl"));
    break;
  case 2:
    Fehllabel->setText(i18n("Es wurde kein gültiger Wert angegeben"));
    break;
  case 3:
    Fehllabel->setText(i18n("Sie sollten einen anderen Wert (evtl. grösser) wählen"));
    break;
  case 4:
    Fehllabel->setText(i18n("Es muss ein Phi(n) errechnet worden sein"));
    break;
  case 5:
    Fehllabel->setText(i18n("Bitte wählen sie einen anderern Schlüssel"));
    break;
  case 6:
    Fehllabel->setText(i18n("Einer der Faktoren ist keine Primzahl\n die zu Faktorisierende Zahl sollte nicht als Modul verwende werden"));
    break;
  case 7:
    Fehllabel->setText(i18n("Noch nicht möglich, wird überarbeitet"));
    break;
   default:
    break;
 }


return 0;
}


/** No descriptions */
void KRSA::bildeggtSlot()
{
  gLCD1->display(gcd(gZ1->value(), gZ2->value()));
}




//Laden der Textdatei, welche das RSA Verfahren erklrend Beschreiben soll
void KRSA::Lade_RSA_Beschreibung()
{

  QString Dateiname = stdDirs->findResource("data", "krsa/RSA-Beschreibung.html");
  //Datei ffnen
  QFile Datei(Dateiname);
  Datei.open( IO_ReadOnly );
  QTextStream Striem(&Datei);

  //Die HTML - Datei dem TextEdit zuweisen
  TextEdit1->setReadOnly(true);
  TextEdit1->setText(Striem.read());

  //Datei Schlieen
  Datei.close();

}



/** Ruft den Lerndialog auf */
void KRSA::lernSlot()
{
  KRSA_Lerndialog *lernt = new KRSA_Lerndialog();
  lernt->show();
}

/** No descriptions */
void KRSA::wechselSlot()
{
  Fehllabel->setText("");
  textLabel12->setText("");
}

/** No descriptions */
void KRSA::primtestSlot()
{
  int testwert = Primtestbox1->value();
  if(IsPrimZahl(testwert))
    textLabel12->setText(i18n("Zahl ist Primzahl"));
  else
    textLabel12->setText(i18n("Zahl ist keine Primzahl"));
}
