import imp
import sys
import SCons.Errors
import SCons.Defaults
class ToolSpec:
    def __init__(self, name):
        self.name=name
    def __call__(self, env, *args, **kw):
        env.Append(TOOLS=[ self.name ])
        apply(self.generate, ( env, ) + args, kw)
    def __str__(self):
        return self.name
def Tool(name, toolpath=[]):
    try:
        file, path, desc=imp.find_module(name, toolpath)
        try:
            module=imp.load_module(name, file, path, desc)
            spec=ToolSpec(name)
            spec.generate=module.generate
            spec.exists=module.exists
            return spec
        finally:
            if file:
                file.close()
    except ImportError, e:
        pass
    full_name='SCons.Tool.' + name
    if not sys.modules.has_key(full_name):
        try:
            file, path, desc=imp.find_module(name,
                                        sys.modules['SCons.Tool'].__path__)
            mod=imp.load_module(full_name, file, path, desc)
            setattr(SCons.Tool, name, mod)
        except ImportError, e:
            raise SCons.Errors.UserError, "No tool named '%s': %s" % (name, e)
        if file:
            file.close()
    spec=ToolSpec(name)
    spec.generate=sys.modules[full_name].generate
    spec.exists=sys.modules[full_name].exists
    return spec
def createProgBuilder(env):
    try:
        program=env['BUILDERS']['Program']
    except KeyError:
        program=SCons.Builder.Builder(action=SCons.Defaults.LinkAction,
                                        emitter='$PROGEMITTER',
                                        prefix='$PROGPREFIX',
                                        suffix='$PROGSUFFIX',
                                        src_suffix='$OBJSUFFIX',
                                        src_builder='Object',
                                        target_scanner=SCons.Defaults.ProgScan)
        env['BUILDERS']['Program']=program
    return program
def createStaticLibBuilder(env):
    try:
        static_lib=env['BUILDERS']['StaticLibrary']
    except KeyError:
        static_lib=SCons.Builder.Builder(action=SCons.Defaults.ArAction,
                                           emitter='$LIBEMITTER',
                                           prefix='$LIBPREFIX',
                                           suffix='$LIBSUFFIX',
                                           src_suffix='$OBJSUFFIX',
                                           src_builder='StaticObject')
        env['BUILDERS']['StaticLibrary']=static_lib
        env['BUILDERS']['Library']=static_lib
    return static_lib
def createSharedLibBuilder(env):
    try:
        shared_lib=env['BUILDERS']['SharedLibrary']
    except KeyError:
        action_list=[ SCons.Defaults.SharedCheck,
                        SCons.Defaults.ShLinkAction ]
        shared_lib=SCons.Builder.Builder(action=action_list,
                                           emitter="$SHLIBEMITTER",
                                           prefix='$SHLIBPREFIX',
                                           suffix='$SHLIBSUFFIX',
                                           target_scanner=SCons.Defaults.ProgScan,
                                           src_suffix='$SHOBJSUFFIX',
                                           src_builder='SharedObject')
        env['BUILDERS']['SharedLibrary']=shared_lib
    return shared_lib
def createObjBuilders(env):
    try:
        static_obj=env['BUILDERS']['StaticObject']
    except KeyError:
        static_obj=SCons.Builder.Builder(action={}, emitter={}, prefix='$OBJPREFIX', suffix='$OBJSUFFIX',
                                           src_builder=['CFile', 'CXXFile'],
                                           source_scanner=SCons.Defaults.ObjSourceScan, single_source=1)
        env['BUILDERS']['StaticObject']=static_obj
        env['BUILDERS']['Object']=static_obj
    try:
        shared_obj=env['BUILDERS']['SharedObject']
    except KeyError:
        shared_obj=SCons.Builder.Builder(action={}, emitter={}, prefix='$SHOBJPREFIX',
                                           suffix='$SHOBJSUFFIX', src_builder=['CFile', 'CXXFile'],
                                           source_scanner=SCons.Defaults.ObjSourceScan, single_source=1)
        env['BUILDERS']['SharedObject']=shared_obj
    return (static_obj, shared_obj)
def createCFileBuilders(env):
    try:
        c_file=env['BUILDERS']['CFile']
    except KeyError:
        c_file=SCons.Builder.Builder(action={}, emitter={}, suffix={None:'$CFILESUFFIX'})
        env['BUILDERS']['CFile']=c_file
        env['CFILESUFFIX']='.c'
    try:
        cxx_file=env['BUILDERS']['CXXFile']
    except KeyError:
        cxx_file=SCons.Builder.Builder(action={}, emitter={}, suffix={None:'$CXXFILESUFFIX'})
        env['BUILDERS']['CXXFile']=cxx_file
        env['CXXFILESUFFIX']='.cc'
    return (c_file, cxx_file)
def FindTool(tools, env):
    for tool in tools:
        t=Tool(tool)
        if t.exists(env):
            return tool
    return None
def FindAllTools(tools, env):
    def ToolExists(tool, env=env):
        return Tool(tool).exists(env)
    return filter (ToolExists, tools)
def tool_list(platform, env):
    linkers=['gnulink']
    c_compilers=['gcc', 'cc']
    cxx_compilers=['g++', 'c++']
    assemblers=['nasm', 'gas']
    ars=['ar']
    c_compiler=FindTool(c_compilers, env) or c_compilers[0]
    if c_compiler and c_compiler=='mingw':
        cxx_compiler=None
        linker=None
        assembler=None
        ar=None
    else:
        if c_compiler in ('msvc', 'icc'):
            cxx_compiler=None
        else:
            cxx_compiler=FindTool(cxx_compilers, env) or cxx_compilers[0]
        linker=FindTool(linkers, env) or linkers[0]
        assembler=FindTool(assemblers, env) or assemblers[0]
        ar=FindTool(ars, env) or ars[0]
    other_tools=FindAllTools(['lex', 'tar', 'yacc'], env)
    tools=([linker, c_compiler, cxx_compiler, assembler, ar] + other_tools)
    return filter(lambda x: x, tools)
