/* This file is part of KDevelop
    Copyright (C) 2004 Roberto Raggi <roberto@kdevelop.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef KDEVCUSTOMIMPORTER_H
#define KDEVCUSTOMIMPORTER_H

#include <kdevprojecteditor.h>
#include <qstringlist.h>

class QFileInfo;

class KDevCustomImporter: public KDevProjectEditor
{
    Q_OBJECT
public:
    KDevCustomImporter(QObject *parent = 0, const char *name = 0, 
            const QStringList &args = QStringList());
    virtual ~KDevCustomImporter();
    
//
// KDevProjectEditor interface
//
    virtual Features features() const 
    { return Features(Folders | Files); }
    
    virtual bool addFolder(ProjectFolderDom folder, ProjectFolderDom parent);
    virtual bool addTarget(ProjectTargetDom target, ProjectFolderDom parent);
    virtual bool addFile(ProjectFileDom file, ProjectFolderDom parent);
    virtual bool addFile(ProjectFileDom file, ProjectTargetDom parent);
    
    virtual bool removeFolder(ProjectFolderDom folder, ProjectFolderDom parent);
    virtual bool removeTarget(ProjectTargetDom target, ProjectFolderDom parent);
    virtual bool removeFile(ProjectFileDom file, ProjectFolderDom parent);
    virtual bool removeFile(ProjectFileDom file, ProjectTargetDom parent);
    bool createProjectFile( const QString &folder );
    bool configureFolder( ProjectFolderDom folder);
//
// KDevProjectImporter interface
//
    virtual KDevProject *project() const;
    
    virtual ProjectFolderList parse(ProjectFolderDom item);    
    virtual ProjectItemDom import(ProjectModel *model, const QString &fileName);
    virtual QString findMakefile(ProjectFolderDom dom) const;
    virtual QStringList findMakefiles(ProjectFolderDom dom) const;

private:
    bool isValid(const QFileInfo &fileName) const;
    
private:
    KDevProject *m_project;
    
    static const QString &customImporter;
    QStringList includes;
    QStringList excludes;
};

#endif // KDEVCUSTOMIMPORTER_H
