// -*- c++ -*-
/***************************************************************************
                           settingsdialog.h
                           ----------------
    begin                : Sun Sep 13 2003
    copyright            : (C) 2003 Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <kdialogbase.h>
#include <qptrlist.h>

class ConfigData;
class KConfig;
class Kdetv;
class SettingsDialogPage;

/**
 * @author Kevin Hessels
 */
class SettingsDialog : public KDialogBase
{
    Q_OBJECT

public:
    SettingsDialog(QWidget*, char*, bool, Kdetv*, QPtrList<SettingsDialogPage>*, WFlags fl = 0);
    ~SettingsDialog();
    

signals:
    void optionsModified();


protected slots:
    void slotApply();
    void slotDefault();
    void slotCancel();
    void slotOk();
    void slotHelp();


private:
    void doApply();
    void addDialogPage(SettingsDialogPage* page);

    Kdetv*                       _ktv;
    QPtrList<SettingsDialogPage> _pages;
    int                          _externalPageCount;
};

#endif

