/***************************************************************************
                          ktransferdetailswidgetimpl.cpp  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktransferdetailswidgetimpl.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kprogress.h>
#include <klocale.h>
#include <kmimetype.h>
#include "global.h"
#include "ksynkconnection.h"

KTransferDetailsWidgetImpl::KTransferDetailsWidgetImpl(QWidget *parent,
                                                       const char *name )
    : TransferDetailsWidget(parent,name)
{
    m_connection = 0L;
    GettingFilesKListView->setSorting(-1);
    TransferingTextLabel->setSizePolicy(
        QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Fixed ));
    setClearStatus();
    ProgressBar->setTotalSteps(100);
}

KTransferDetailsWidgetImpl::~KTransferDetailsWidgetImpl()
{
}

/** Updates list to reflect that we a getting specified files */
void KTransferDetailsWidgetImpl::slotGettingFile(const KURL::List & files)
{
    QValueListConstIterator<KURL> it;
    QString start = m_connection ?
                    m_connection->getRemoteURL().url() : QString::null;

    QListViewItem *after = 0L;
    for( it = files.begin(); it != files.end(); ++it )
    {
        KListViewItem* listitem= new KListViewItem(GettingFilesKListView,
                                                   after,
                                                   makeRelative(start, *it),
                                                   i18n("Pending"));
        listitem->setPixmap( 0, KMimeType::pixmapForURL( *it, 0,
                                                         KIcon::Desktop,
                                                         KIcon::SizeSmall ));
        listitems.insert( (*it).url(), listitem);
        after = listitem;
    }

    ProgressBar->setTotalSteps( 100 * files.count() );
}

/** Sets the value of the percentage bar */
void KTransferDetailsWidgetImpl::slotPercent(unsigned long percent,
                                             unsigned long filesLeft)
{
    unsigned long done = ProgressBar->totalSteps() - ((filesLeft +1) * 100);
    done += percent;
    ProgressBar->setProgress( done );
}

/** The transfer is complete */
void KTransferDetailsWidgetImpl::slotTransferComplete()
{
    setClearStatus();
    ProgressBar->setTotalSteps( 100 );
    ProgressBar->setProgress( 100 );
}

/** Clears the current transfer, sets everything back to defaults */
void KTransferDetailsWidgetImpl::clear()
{
    GettingFilesKListView->clear();
    ClosePushButton->setEnabled( false );
    ProgressBar->reset();
    ProgressBar->setValue( 0 );
    TransferingTextLabel->setText( i18n("Idle.") );
}

/** so the widget may be informed when files have been recieved */
void KTransferDetailsWidgetImpl::slotFilesDone(const KURL::List & files)
{
    setStatusText( files, i18n("Completed") );
}

void KTransferDetailsWidgetImpl::slotCanceled( const KURL::List& files )
{
    setStatusText( files, i18n("Canceled") );
}

void KTransferDetailsWidgetImpl::slotError( const KURL::List& files )
{
    setStatusText( files, i18n("Error") );
}

void KTransferDetailsWidgetImpl::setStatusText( const KURL::List& files,
                                                const QString& statusText )
{
    QValueListConstIterator<KURL> it;
    for( it = files.begin(); it != files.end(); ++it )	{
        KListViewItem* listitem= listitems[(*it).url()] ;
        listitem->setText(1, statusText ) ;
    }
}

/** Displays message sent by the transfer class */
void KTransferDetailsWidgetImpl::slotMessage(const QString & message)
{
    TransferingTextLabel->setText(message);
}

/** Cancels the current transfer */
void KTransferDetailsWidgetImpl::slotCancelTransfer()
{
    emit signalCancelTransfer();
    setClearStatus();
}

/** Sets the widget up for the start of a transfer */
void KTransferDetailsWidgetImpl::start( const KSynkConnection *connection )
{
    clear();
    ClosePushButton->setText(i18n("&Cancel"));
    ClosePushButton->setEnabled( true );
    disconnect(ClosePushButton,SIGNAL(clicked()),this,SLOT(clear()));
    connect(ClosePushButton,SIGNAL(clicked()),this,SLOT(slotCancelTransfer()));	
    m_connection = connection;
}

/** Resets the transfer  */
void KTransferDetailsWidgetImpl::setClearStatus()
{
    ClosePushButton->setText(i18n("Clear View"));
    disconnect(ClosePushButton,SIGNAL(clicked()),this,SLOT(slotCancelTransfer()));	
    connect(ClosePushButton,SIGNAL(clicked()),this,SLOT(clear()));	
    ClosePushButton->setEnabled( GettingFilesKListView->childCount() != 0 );
    TransferingTextLabel->setText( i18n("Idle.") );
}

QString KTransferDetailsWidgetImpl::makeRelative( const QString& start,
                                                  const KURL& end )
{
    QString url = end.url();
    if ( url.startsWith( start ) )
        return KURL::decode_string( url.mid( start.length() ) );
    return end.path();
}

#include "ktransferdetailswidgetimpl.moc"
