/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Aug 18 13:48:33 NZST 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kuniqueapplication.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <stdlib.h>

#include "synk.h"

#define SYNK_VERSION "0.3p"

static const char *description =
I18N_NOOP("SynK synchronises directories using the KIO subsystem.");
	
	
static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
    // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "synk", I18N_NOOP("SynK"),
                          SYNK_VERSION, description, KAboutData::License_GPL,
                          "(C) 2001, Jonathon Sim\n(C) 2002,2003, Carsten Pfeiffer", 
                          0, 
                          "http://devel-home.kde.org/~pfeiffer/synk",
                          "pfeiffer@kde.org");
    aboutData.addAuthor("Carsten Pfeiffer", I18N_NOOP("Maintainer"), "pfeiffer@kde.org");
    aboutData.addAuthor("Jonathon Sim", I18N_NOOP("Original Author"), "jonathonsim@iname.com");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KUniqueApplication::addCmdLineOptions();

    if ( !KUniqueApplication::start() )
    {
        qWarning("SynK is already running.");
        ::exit(0);
    }

    KUniqueApplication a;
    if (a.isRestored()) {	//Session Management
        RESTORE(SynK)
    }
    else {
        SynK *synk = new SynK;
        a.setMainWidget(synk);
        synk->show();
    }
    return a.exec();
}
