/***************************************************************************
                          kbudgeteditor.cpp  -  description
                             -------------------
    begin                : Sat Aug 31 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: kbudgeteditor.cpp,v 1.5 2002/09/04 07:57:54 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qdatetime.h>
#include <klocale.h>
#include <knuminput.h>
#include <kpushbutton.h>

#include <stdio.h>
 
#include "kbudgeteditor.h"
#include "kbudgeteditor.moc"
#include "kbudgetdoc.h"
#include "klocalizer.h"

KBudgetEditor::KBudgetEditor(QWidget* parent, KBudgetDoc* doc)
  : QFrame(parent, "budgetEditor"), m_doc(doc), account(-1)
{
  QGridLayout* grid = new QGridLayout(this);

  prevMonthLabel = new QLabel(i18n("Remaining from:"), this);
  grid->addWidget(prevMonthLabel, 0, 0);
  prevMonthValue = new QLabel(l10n.formatMoney(0), this);
  prevMonthValue->setAlignment(Qt::AlignRight);
  grid->addWidget(prevMonthValue, 0, 1);

  thisMonthLabel = new QLabel(i18n("Budgeted for"), this);
  grid->addWidget(thisMonthLabel, 1, 0);
  thisMonthValue = new KDoubleNumInput(this, "thisMonthValue");
  thisMonthValue->setPrecision(2);
  grid->addWidget(thisMonthValue, 1, 1);

  QLabel* totalLabel = new QLabel(i18n("Total:"), this);
  grid->addWidget(totalLabel, 2, 0);
  total = new QLabel(l10n.formatMoney(0), this);
  total->setAlignment(Qt::AlignRight);
  grid->addWidget(total, 2, 1);

  QSize gridSize = grid->sizeHint();
  setFixedHeight(gridSize.height());

  grid->setColStretch(1, 1);
  grid->setColStretch(2, 1);

  KPushButton* button = new KPushButton(this);
  button->setText("Close");
  grid->addMultiCellWidget(button, 0, 2, 3, 3);
  
  connect(button, SIGNAL(clicked()), SLOT(slotHide()));
  connect(thisMonthValue, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));

  hide();
}

KBudgetEditor::~KBudgetEditor()
{
}

void KBudgetEditor::selectMonth(QDate month, Account* acct)
{
  if ( acct ) {
    account = acct->id();
  } else if ( account != -1 ) {
    // select the account
  }

  QDate prevMonth = month.addMonths(-1);
  prevMonthLabel->setText(i18n("Remaining from %1:").arg(QDate::shortMonthName(prevMonth.month())));

  date = month;
  thisMonthLabel->setText(i18n("Budgeted for %1:").arg(QDate::shortMonthName(date.month())));

  if ( account != -1 ) {
    selectAccount(account);
  } else {
    prevMonthValue->setText(l10n.formatMoney(0));
    thisMonthValue->setValue(0);
    total->setText(l10n.formatMoney(0));
  }
}

void KBudgetEditor::selectAccount(int id)
{
  account = id;
  printf("Selecting account %i\n", id);

  if ( !date.isNull() ) {
    Account acct = m_doc->getAccount(account, date);
    float pmValue = acct.startingBudget();
    prevMonthValue->setText(l10n.formatMoney(pmValue));
    float cmValue = acct.budgeted();
    thisMonthValue->setValue(cmValue);
    total->setText(l10n.formatMoney(pmValue + cmValue));
  }
}

void KBudgetEditor::slotValueChanged(double value)
{
  if ( account != -1 && !date.isNull() ) {
    m_doc->getAccount(account).setBudgeted(date, (float)value);
    selectAccount(account);
    emit valueChanged(account);
  } else
    thisMonthValue->setValue(0);
}

void KBudgetEditor::slotHide()
{
  hide();
}
