/***************************************************************************
                          knewtransaction.cpp  -  description
                             -------------------
    begin                : Fri Aug 30 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: knewtransaction.cpp,v 1.5 2002/09/13 03:32:26 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <kmessagebox.h>
#include <kmainwindow.h>

#include "knewtransaction.h"
#include "kbudgetdoc.h"

KNewTransaction::KNewTransaction(KMainWindow* parent, KBudgetDoc* doc, int tx)
  : KDialogBase(parent, "knewtransaction", false, i18n("New Transaction"), Ok|Cancel), mainWin(parent),
  document(doc), id(tx)
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QGridLayout* grid = new QGridLayout(page);

  QLabel* lb = new QLabel(i18n("Date:"), page);
  grid->addWidget(lb, 0, 0);
  date = new KDateEdit(page);
  grid->addWidget(date, 0, 1);

  lb = new QLabel(i18n("From:"), page);
  grid->addWidget(lb, 1, 0);
  from = new KComboBox(page);
  grid->addWidget(from, 1, 1);

  lb = new QLabel(i18n("To:"), page);
  grid->addWidget(lb, 2, 0);
  to = new KComboBox(page);
  grid->addWidget(to, 2, 1);

  lb = new QLabel(i18n("Amount:"), page);
  grid->addWidget(lb, 3, 0);
  value = new KDoubleNumInput(page);
  value->setPrecision(2);
  grid->addWidget(value, 3, 1);

  lb = new QLabel(i18n("Description:"), page);
  grid->addWidget(lb, 4, 0);
  description = new KLineEdit(page);
  grid->addWidget(description, 4, 1);

  int f=-1, t=-1;
  if ( tx >= 0 ) {
    Transaction &tr = doc->getTransaction(id);
    date->setDate(tr.date());
    value->setValue(tr.value());
    description->setText(tr.description());
    f = tr.from();
    t = tr.to();
    id = tx;
    from->setEnabled(false);
    to->setEnabled(false);
    setCaption(i18n("Edit Transaction"));
  }
  
  accounts = doc->getAllAccounts();
  for ( unsigned int i = 0; i < accounts.size(); i++ ) {
    from->insertItem(accounts[i].name());
    if ( accounts[i].id() == f )
      from->setCurrentItem(i);
    to->insertItem(accounts[i].name());
    if ( accounts[i].id() == t )
      to->setCurrentItem(i);
  }
}

KNewTransaction::~KNewTransaction()
{
}

void KNewTransaction::slotOk()
{
  QDate when = date->getDate();
  int fromAcct = accounts[from->currentItem()].id();
  int toAcct = accounts[to->currentItem()].id();
  float amount = value->value();
  QString desc = description->text();

  // new transaction...
  if ( id < 0 ) {
    // TODO: check this before making the dialog!
    if ( !accounts.size() )
      KMessageBox::sorry(0, i18n("You can't enter a transaction when you have no accounts!"));
    else if ( fromAcct == toAcct )
      KMessageBox::sorry(0, i18n("The from account and to account must be different."));
    else {
      document->newTransaction(fromAcct, toAcct, amount, when, desc);
      KDialogBase::slotOk();
    }
  } else {
    // or modify existing
    document->beginUndoGroup();
    Transaction& tr = document->getTransaction(id);
    tr.setData(amount, when, desc);
    document->endUndoGroup();
    document->setModified(true);
    KDialogBase::slotOk();
  }
}
