/***************************************************************************
                          knewtransaction.h  -  description
                             -------------------
    begin                : Fri Aug 30 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: knewtransaction.h,v 1.3 2002/09/10 01:02:50 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNEWTRANSACTION_H
#define KNEWTRANSACTION_H

#include <kdialogbase.h>
#include <kdatepicker.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <qvaluelist.h>
#include <knuminput.h>
#include <kdateedit.h>

class KMainWindow;
class KBudgetDoc;
class Account;

/**Creates and handles a new transaction dialog box
  *@author Richard Garand
  */

class KNewTransaction : public KDialogBase  {
  public: 
	KNewTransaction(KMainWindow* parent, KBudgetDoc* doc, int transaction = -1);
	~KNewTransaction();
  private:
    /** OK button clicked */
    void slotOk();
  
    const KMainWindow* mainWin;
    KBudgetDoc* document;
    int id;
  
    KDateEdit* date;
    KComboBox* from;
    KComboBox* to;
    KDoubleNumInput* value;
    KLineEdit* description;
    QValueList<Account> accounts;
};

#endif
